/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.multiinstance;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import org.camunda.bpm.model.bpmn.instance.BpmnModelElementInstance;
import org.camunda.bpm.model.bpmn.instance.CallActivity;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaIn;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaOut;
import org.junit.Rule;
import org.junit.Test;

public class MultiInstanceVariablesTest {
    public static final String ALL = "all";
    public static final String SUB_PROCESS_ID = "testProcess";
    public static final String PROCESS_ID = "process";
    public static final String CALL_ACTIVITY = "callActivity";
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();

    @Test
    public void testMultiInstanceWithAllInOutMapping() {
        BpmnModelInstance modelInstance = this.getBpmnModelInstance();
        CallActivityBuilder callActivityBuilder = ((CallActivity)modelInstance.getModelElementById(CALL_ACTIVITY)).builder();
        this.addAllIn(modelInstance, callActivityBuilder);
        this.addAllOut(modelInstance, callActivityBuilder);
        BpmnModelInstance testProcess = this.getBpmnSubProcessModelInstance();
        this.deployAndStartProcess(modelInstance, testProcess);
        Assertions.assertThat((List)this.engineRule.getRuntimeService().createExecutionQuery().processDefinitionKey(SUB_PROCESS_ID).list()).hasSize(2);
        List tasks = this.engineRule.getTaskService().createTaskQuery().active().list();
        for (Task task : tasks) {
            this.engineRule.getTaskService().setVariable(task.getId(), "nrOfInstances", (Object)"3");
            this.engineRule.getTaskService().complete(task.getId());
        }
        Assertions.assertThat((List)this.engineRule.getRuntimeService().createExecutionQuery().processDefinitionKey(SUB_PROCESS_ID).list()).hasSize(0);
        Assertions.assertThat((List)this.engineRule.getRuntimeService().createExecutionQuery().activityId(CALL_ACTIVITY).list()).hasSize(0);
    }

    protected void addAllOut(BpmnModelInstance modelInstance, CallActivityBuilder callActivityBuilder) {
        CamundaOut camundaOut = (CamundaOut)modelInstance.newInstance(CamundaOut.class);
        camundaOut.setCamundaVariables(ALL);
        callActivityBuilder.addExtensionElement((BpmnModelElementInstance)camundaOut);
    }

    protected void addAllIn(BpmnModelInstance modelInstance, CallActivityBuilder callActivityBuilder) {
        CamundaIn camundaIn = (CamundaIn)modelInstance.newInstance(CamundaIn.class);
        camundaIn.setCamundaVariables(ALL);
        callActivityBuilder.addExtensionElement((BpmnModelElementInstance)camundaIn);
    }

    protected void deployAndStartProcess(BpmnModelInstance modelInstance, BpmnModelInstance testProcess) {
        this.engineRule.manageDeployment(this.engineRule.getRepositoryService().createDeployment().addModelInstance("process.bpmn", modelInstance).deploy());
        this.engineRule.manageDeployment(this.engineRule.getRepositoryService().createDeployment().addModelInstance("testProcess.bpmn", testProcess).deploy());
        this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_ID);
    }

    protected BpmnModelInstance getBpmnModelInstance() {
        return ((MultiInstanceLoopCharacteristicsBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().callActivity(CALL_ACTIVITY).calledElement(SUB_PROCESS_ID)).multiInstance().cardinality("2")).multiInstanceDone().endEvent().done();
    }

    protected BpmnModelInstance getBpmnSubProcessModelInstance() {
        return Bpmn.createExecutableProcess((String)SUB_PROCESS_ID).startEvent().userTask("userTask").endEvent().done();
    }
}

