/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.tasklistener;

import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class TaskListenerDelegateCompletionTest {
    protected static final String COMPLETE_LISTENER = "org.camunda.bpm.engine.test.bpmn.tasklistener.util.CompletingTaskListener";
    protected static final String TASK_LISTENER_PROCESS = "taskListenerProcess";
    protected static final String ACTIVITY_ID = "UT";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule).around((TestRule)this.testHelper);
    protected RuntimeService runtimeService;
    protected TaskService taskService;

    @Before
    public void setUp() {
        this.taskService = this.engineRule.getTaskService();
        this.runtimeService = this.engineRule.getRuntimeService();
    }

    @After
    public void cleanUp() {
        if (this.runtimeService.createProcessInstanceQuery().count() > 0L) {
            this.runtimeService.deleteProcessInstance(((ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult()).getId(), null, true);
        }
    }

    protected static BpmnModelInstance setupProcess(String eventName) {
        return ((UserTaskBuilder)Bpmn.createExecutableProcess((String)TASK_LISTENER_PROCESS).startEvent().userTask(ACTIVITY_ID).camundaTaskListenerClass(eventName, COMPLETE_LISTENER)).endEvent().done();
    }

    @Test
    public void testCompletionIsPossibleOnCreation() {
        this.createProcessWithListener("create");
        this.runtimeService.startProcessInstanceByKey(TASK_LISTENER_PROCESS);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assertions.assertThat((Object)task).isNull();
    }

    @Test
    public void testCompletionIsPossibleOnAssignment() {
        this.createProcessWithListener("assignment");
        this.runtimeService.startProcessInstanceByKey(TASK_LISTENER_PROCESS);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setAssignee(task.getId(), "test assignee");
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assertions.assertThat((Object)task).isNull();
    }

    @Test
    public void testCompletionIsPossibleAfterAssignmentUpdate() {
        this.createProcessWithListener("update");
        this.runtimeService.startProcessInstanceByKey(TASK_LISTENER_PROCESS);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setAssignee(task.getId(), "test assignee");
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assertions.assertThat((Object)task).isNull();
    }

    @Test
    public void testCompletionIsPossibleAfterPropertyUpdate() {
        this.createProcessWithListener("update");
        this.runtimeService.startProcessInstanceByKey(TASK_LISTENER_PROCESS);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setOwner(task.getId(), "ownerId");
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assertions.assertThat((Object)task).isNull();
    }

    @Test
    @Deployment
    public void testCompletionIsPossibleOnTimeout() {
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        this.runtimeService.startProcessInstanceByKey("process");
        Assertions.assertThat((long)taskQuery.count()).isEqualTo(1L);
        ClockUtil.offset((Long)TimeUnit.MINUTES.toMillis(70L));
        this.testHelper.waitForJobExecutorToProcessAllJobs(5000L);
        Assertions.assertThat((long)taskQuery.count()).isEqualTo(0L);
    }

    @Test
    public void testCompletionIsNotPossibleOnComplete() {
        this.createProcessWithListener("complete");
        this.runtimeService.startProcessInstanceByKey(TASK_LISTENER_PROCESS);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.complete(task.getId())).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("invalid task state");
    }

    @Test
    public void testCompletionIsNotPossibleOnDelete() {
        this.createProcessWithListener("delete");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(TASK_LISTENER_PROCESS);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.deleteProcessInstance(processInstance.getId(), "test reason")).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("invalid task state");
    }

    protected void createProcessWithListener(String eventName) {
        BpmnModelInstance bpmnModelInstance = TaskListenerDelegateCompletionTest.setupProcess(eventName);
        this.testHelper.deploy(bpmnModelInstance);
    }
}

