/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.usertask;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Test;

public class TaskDueDateExtensionsTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testDueDateExtension() throws Exception {
        Date date = new SimpleDateFormat("dd-MM-yyyy hh:mm:ss").parse("06-07-1986 12:10:00");
        HashMap<String, Date> variables = new HashMap<String, Date>();
        variables.put("dateVariable", date);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("dueDateExtension", variables);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)task.getDueDate());
        Assert.assertEquals((Object)date, (Object)task.getDueDate());
    }

    @Deployment
    @Test
    public void testDueDateStringExtension() throws Exception {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("dateVariable", "1986-07-06T12:10:00");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("dueDateExtension", variables);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)task.getDueDate());
        Date date = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").parse("06-07-1986 12:10:00");
        Assert.assertEquals((Object)date, (Object)task.getDueDate());
    }

    @Deployment
    @Test
    public void testRelativeDueDate() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("dateVariable", "P2DT2H30M");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("dueDateExtension", variables);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Date dueDate = task.getDueDate();
        Assert.assertNotNull((Object)dueDate);
        Period period = new Period(task.getCreateTime().getTime(), dueDate.getTime());
        Assert.assertEquals((long)period.getDays(), (long)2L);
        Assert.assertEquals((long)period.getHours(), (long)2L);
        Assert.assertEquals((long)period.getMinutes(), (long)30L);
    }
}

