/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.application.impl.EmbeddedProcessApplication;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.authorization.TaskPermissions;
import org.camunda.bpm.engine.repository.ProcessApplicationDeployment;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class CmmnDisabledTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule("org/camunda/bpm/application/impl/deployment/cmmn.disabled.camunda.cfg.xml");
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    public ProcessEngineTestRule engineTestRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.engineTestRule);
    protected RuntimeService runtimeService;
    protected RepositoryService repositoryService;
    protected TaskService taskService;
    protected IdentityService identityService;
    protected AuthorizationService authorizationService;
    protected EmbeddedProcessApplication processApplication;

    @Before
    public void setUp() throws Exception {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.taskService = this.engineRule.getTaskService();
        this.identityService = this.engineRule.getIdentityService();
        this.authorizationService = this.engineRule.getAuthorizationService();
        this.processApplication = new EmbeddedProcessApplication();
    }

    @After
    public void tearDown() {
        this.identityService.clearAuthentication();
        this.engineRule.getProcessEngineConfiguration().setAuthorizationEnabled(false);
        this.engineTestRule.deleteAllAuthorizations();
        this.engineTestRule.deleteAllStandaloneTasks();
    }

    @Test
    public void testCmmnDisabled() {
        ProcessApplicationDeployment deployment = this.repositoryService.createDeployment(this.processApplication.getReference()).addClasspathResource("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml").deploy();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        Assert.assertNotNull((Object)processDefinition);
        Assert.assertEquals((long)1L, (long)processDefinition.getVersion());
        List caseDefinitionList = this.repositoryService.createCaseDefinitionQuery().list();
        Assert.assertEquals((long)0L, (long)caseDefinitionList.size());
        long caseDefinitionCount = this.repositoryService.createCaseDefinitionQuery().count();
        Assert.assertEquals((long)0L, (long)caseDefinitionCount);
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Test
    public void testVariableInstanceQuery() {
        ProcessApplicationDeployment deployment = this.repositoryService.createDeployment(this.processApplication.getReference()).addClasspathResource("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml").deploy();
        VariableMap variables = Variables.createVariables().putValue("my-variable", (Object)"a-value");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)variables);
        List result = this.runtimeService.createVariableInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
        VariableInstance variableInstance = (VariableInstance)result.get(0);
        Assert.assertEquals((Object)"my-variable", (Object)variableInstance.getName());
        Assert.assertNotNull((Object)this.runtimeService.getVariable(processInstance.getId(), "my-variable"));
        Assert.assertNotNull((Object)this.runtimeService.getVariableLocal(processInstance.getId(), "my-variable"));
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Test
    public void testTaskQueryAuthorization() {
        this.engineTestRule.deploy("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml");
        this.engineTestRule.deploy("org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml");
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task processInstanceTask = (Task)this.taskService.createTaskQuery().processInstanceId(instance1.getId()).singleResult();
        this.engineTestRule.createGrantAuthorization("user", (Resource)Resources.PROCESS_DEFINITION, "oneTaskProcess", new Permission[]{ProcessDefinitionPermissions.READ_TASK});
        Task standaloneTask = this.taskService.newTask();
        this.taskService.saveTask(standaloneTask);
        this.engineTestRule.createGrantAuthorization("user", (Resource)Resources.TASK, standaloneTask.getId(), new Permission[]{TaskPermissions.READ});
        this.runtimeService.startProcessInstanceByKey("twoTasksProcess");
        this.identityService.setAuthenticatedUserId("user");
        this.engineRule.getProcessEngineConfiguration().setAuthorizationEnabled(true);
        List tasks = this.taskService.createTaskQuery().list();
        Assertions.assertThat((List)tasks).extracting("id").containsExactlyInAnyOrder(new Object[]{standaloneTask.getId(), processInstanceTask.getId()});
    }
}

