/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.activation;

import java.util.Collections;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class ManualActivationRuleTest
extends PluggableProcessEngineTest {
    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/activation/ManualActivationRuleTest.testVariableBasedRule.cmmn"})
    @Test
    public void testManualActivationRuleEvaluatesToTrue() {
        this.caseService.createCaseInstanceByKey("case", Collections.singletonMap("manualActivation", true));
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertNotNull((Object)taskExecution);
        Assert.assertTrue((boolean)taskExecution.isEnabled());
        Assert.assertFalse((boolean)taskExecution.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/activation/ManualActivationRuleTest.testVariableBasedRule.cmmn"})
    @Test
    public void testManualActivationRuleEvaluatesToFalse() {
        this.caseService.createCaseInstanceByKey("case", Collections.singletonMap("manualActivation", false));
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertNotNull((Object)taskExecution);
        Assert.assertFalse((boolean)taskExecution.isEnabled());
        Assert.assertTrue((boolean)taskExecution.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/activation/ManualActivationRuleTest.testDefaultVariableBasedRule.cmmn"})
    @Test
    public void testDefaultManualActivationRuleEvaluatesToTrue() {
        this.caseService.createCaseInstanceByKey("case", Collections.singletonMap("manualActivation", true));
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertNotNull((Object)taskExecution);
        Assert.assertTrue((boolean)taskExecution.isEnabled());
        Assert.assertFalse((boolean)taskExecution.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/activation/ManualActivationRuleTest.testDefaultVariableBasedRule.cmmn"})
    @Test
    public void testDefaultManualActivationRuleEvaluatesToFalse() {
        this.caseService.createCaseInstanceByKey("case", Collections.singletonMap("manualActivation", false));
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertNotNull((Object)taskExecution);
        Assert.assertFalse((boolean)taskExecution.isEnabled());
        Assert.assertTrue((boolean)taskExecution.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/activation/ManualActivationRuleTest.testActivationWithoutDefinition.cmmn"})
    @Test
    public void testActivationWithoutManualActivationDefined() {
        this.caseService.createCaseInstanceByKey("case");
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assertions.assertThat((Object)taskExecution).isNotNull();
        Assertions.assertThat((boolean)taskExecution.isEnabled()).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)taskExecution.isActive()).describedAs("Human Task is active, when ManualActivation is omitted", new Object[0])).isTrue();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/activation/ManualActivationRuleTest.testActivationWithoutManualActivationExpressionDefined.cmmn"})
    @Test
    public void testActivationWithoutManualActivationExpressionDefined() {
        this.caseService.createCaseInstanceByKey("case");
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assertions.assertThat((Object)taskExecution).isNotNull();
        Assertions.assertThat((boolean)taskExecution.isEnabled()).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)taskExecution.isActive()).describedAs("Human Task is not active, when ManualActivation's condition is empty", new Object[0])).isFalse();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/activation/ManualActivationRuleTest.testActivationWithoutManualActivationConditionDefined.cmmn"})
    @Test
    public void testActivationWithoutManualActivationConditionDefined() {
        this.caseService.createCaseInstanceByKey("case");
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assertions.assertThat((Object)taskExecution).isNotNull();
        Assertions.assertThat((boolean)taskExecution.isEnabled()).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)taskExecution.isActive()).describedAs("Human Task is not active, when ManualActivation's condition is empty", new Object[0])).isFalse();
    }
}

