/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.deployment;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.CaseDefinitionQuery;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.model.cmmn.Cmmn;
import org.camunda.bpm.model.cmmn.CmmnModelInstance;
import org.camunda.bpm.model.cmmn.instance.Case;
import org.camunda.bpm.model.cmmn.instance.CasePlanModel;
import org.camunda.bpm.model.cmmn.instance.Definitions;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.junit.Assert;
import org.junit.Test;

public class CmmnDeployerTest
extends PluggableProcessEngineTest {
    @Test
    public void testCmmnDeployment() {
        String deploymentId = this.processEngine.getRepositoryService().createDeployment().addClasspathResource("org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testSimpleDeployment.cmmn").deploy().getId();
        RepositoryService repositoryService = this.processEngine.getRepositoryService();
        DeploymentQuery deploymentQuery = repositoryService.createDeploymentQuery();
        Assert.assertEquals((long)1L, (long)deploymentQuery.count());
        CaseDefinitionQuery query = this.processEngine.getRepositoryService().createCaseDefinitionQuery();
        Assert.assertEquals((long)1L, (long)query.count());
        CaseDefinition caseDefinition = (CaseDefinition)query.singleResult();
        Assert.assertEquals((Object)"Case_1", (Object)caseDefinition.getKey());
        this.processEngine.getRepositoryService().deleteDeployment(deploymentId);
    }

    @Test
    public void testDeployTwoCasesWithDuplicateIdAtTheSameTime() {
        try {
            String cmmnResourceName1 = "org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testSimpleDeployment.cmmn";
            String cmmnResourceName2 = "org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testSimpleDeployment2.cmmn";
            this.repositoryService.createDeployment().addClasspathResource(cmmnResourceName1).addClasspathResource(cmmnResourceName2).name("duplicateAtTheSameTime").deploy();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((long)0L, (long)this.repositoryService.createDeploymentQuery().count());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testCaseDiagramResource.cmmn", "org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testCaseDiagramResource.png"})
    @Test
    public void testCaseDiagramResource() {
        String deploymentId = ((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        Assert.assertEquals((Object)"org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testCaseDiagramResource.cmmn", (Object)caseDefinition.getResourceName());
        Assert.assertEquals((Object)"Case_1", (Object)caseDefinition.getKey());
        String diagramResourceName = caseDefinition.getDiagramResourceName();
        Assert.assertEquals((Object)"org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testCaseDiagramResource.png", (Object)diagramResourceName);
        InputStream diagramStream = this.repositoryService.getResourceAsStream(deploymentId, "org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testCaseDiagramResource.png");
        byte[] diagramBytes = IoUtil.readInputStream((InputStream)diagramStream, (String)"diagram stream");
        Assert.assertEquals((long)2540L, (long)diagramBytes.length);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testMultipleDiagramResourcesProvided.cmmn", "org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testMultipleDiagramResourcesProvided.a.png", "org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testMultipleDiagramResourcesProvided.b.png", "org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testMultipleDiagramResourcesProvided.c.png"})
    @Test
    public void testMultipleDiagramResourcesProvided() {
        CaseDefinition caseA = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("a").singleResult();
        CaseDefinition caseB = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("b").singleResult();
        CaseDefinition caseC = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("c").singleResult();
        Assert.assertEquals((Object)"org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testMultipleDiagramResourcesProvided.a.png", (Object)caseA.getDiagramResourceName());
        Assert.assertEquals((Object)"org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testMultipleDiagramResourcesProvided.b.png", (Object)caseB.getDiagramResourceName());
        Assert.assertEquals((Object)"org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testMultipleDiagramResourcesProvided.c.png", (Object)caseC.getDiagramResourceName());
    }

    @Test
    public void testDeployCmmn10XmlFile() {
        this.verifyCmmnResourceDeployed("org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testDeployCmmn10XmlFile.cmmn10.xml");
    }

    @Test
    public void testDeployCmmn11XmlFile() {
        this.verifyCmmnResourceDeployed("org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testDeployCmmn11XmlFile.cmmn11.xml");
    }

    protected void verifyCmmnResourceDeployed(String resourcePath) {
        String deploymentId = this.processEngine.getRepositoryService().createDeployment().addClasspathResource(resourcePath).deploy().getId();
        RepositoryService repositoryService = this.processEngine.getRepositoryService();
        DeploymentQuery deploymentQuery = repositoryService.createDeploymentQuery();
        Assert.assertEquals((long)1L, (long)deploymentQuery.count());
        CaseDefinitionQuery query = this.processEngine.getRepositoryService().createCaseDefinitionQuery();
        Assert.assertEquals((long)1L, (long)query.count());
        CaseDefinition caseDefinition = (CaseDefinition)query.singleResult();
        Assert.assertEquals((Object)"Case_1", (Object)caseDefinition.getKey());
        this.processEngine.getRepositoryService().deleteDeployment(deploymentId);
    }

    @Test
    public void testDeployCmmnModelInstance() throws Exception {
        CmmnModelInstance modelInstance = CmmnDeployerTest.createCmmnModelInstance();
        this.testRule.deploy(this.repositoryService.createDeployment().addModelInstance("foo.cmmn", modelInstance));
        Assert.assertNotNull((Object)this.repositoryService.createCaseDefinitionQuery().caseDefinitionResourceName("foo.cmmn").singleResult());
    }

    protected static CmmnModelInstance createCmmnModelInstance() {
        CmmnModelInstance modelInstance = Cmmn.createEmptyModel();
        Definitions definitions = (Definitions)modelInstance.newInstance(Definitions.class);
        definitions.setTargetNamespace("http://camunda.org/examples");
        modelInstance.setDefinitions(definitions);
        Case caseElement = (Case)modelInstance.newInstance(Case.class);
        caseElement.setId("a-case");
        definitions.addChildElement((ModelElementInstance)caseElement);
        CasePlanModel casePlanModel = (CasePlanModel)modelInstance.newInstance(CasePlanModel.class);
        caseElement.setCasePlanModel(casePlanModel);
        Cmmn.writeModelToStream((OutputStream)System.out, (CmmnModelInstance)modelInstance);
        return modelInstance;
    }

    @Test
    public void testDeployAndGetCaseDefinition() throws Exception {
        CmmnModelInstance modelInstance = CmmnDeployerTest.createCmmnModelInstance();
        Object deployment = this.testRule.deploy(this.repositoryService.createDeployment().addModelInstance("foo.cmmn", modelInstance));
        List deployedCaseDefinitions = deployment.getDeployedCaseDefinitions();
        Assert.assertEquals((long)1L, (long)deployedCaseDefinitions.size());
        Assert.assertNull((Object)deployment.getDeployedProcessDefinitions());
        Assert.assertNull((Object)deployment.getDeployedDecisionDefinitions());
        Assert.assertNull((Object)deployment.getDeployedDecisionRequirementsDefinitions());
        CaseDefinition persistedCaseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionResourceName("foo.cmmn").singleResult();
        Assert.assertEquals((Object)persistedCaseDefinition.getId(), (Object)((CaseDefinition)deployedCaseDefinitions.get(0)).getId());
    }

    @Test
    public void testDeployEmptyCaseDefinition() throws Exception {
        CmmnModelInstance modelInstance = Cmmn.createEmptyModel();
        Definitions definitions = (Definitions)modelInstance.newInstance(Definitions.class);
        definitions.setTargetNamespace("http://camunda.org/examples");
        modelInstance.setDefinitions(definitions);
        Object deployment = this.testRule.deploy(this.repositoryService.createDeployment().addModelInstance("foo.cmmn", modelInstance));
        Assert.assertNull((Object)deployment.getDeployedCaseDefinitions());
        Assert.assertNull((Object)this.repositoryService.createCaseDefinitionQuery().caseDefinitionResourceName("foo.cmmn").singleResult());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testDeployCaseDefinitionWithIntegerHistoryTimeToLive.cmmn"})
    @Test
    public void testDeployCaseDefinitionWithIntegerHistoryTimeToLive() {
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        Integer historyTimeToLive = caseDefinition.getHistoryTimeToLive();
        Assert.assertNotNull((Object)historyTimeToLive);
        Assert.assertEquals((long)historyTimeToLive.intValue(), (long)5L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testDeployCaseDefinitionWithStringHistoryTimeToLive.cmmn"})
    @Test
    public void testDeployCaseDefinitionWithStringHistoryTimeToLive() {
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        Integer historyTimeToLive = caseDefinition.getHistoryTimeToLive();
        Assert.assertNotNull((Object)historyTimeToLive);
        Assert.assertEquals((long)historyTimeToLive.intValue(), (long)5L);
    }

    @Test
    public void testDeployCaseDefinitionWithMalformedHistoryTimeToLive() {
        try {
            this.testRule.deploy("org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testDeployCaseDefinitionWithMalformedHistoryTimeToLive.cmmn");
            Assert.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertTrue((boolean)e.getCause().getMessage().contains("Cannot parse historyTimeToLive"));
        }
    }
}

