/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmmn.cmd.CompleteCaseExecutionCmd;
import org.camunda.bpm.engine.impl.cmmn.cmd.ManualStartCaseExecutionCmd;
import org.camunda.bpm.engine.impl.cmmn.cmd.StateTransitionCaseExecutionCmd;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.concurrency.ControllableThread;
import org.camunda.bpm.engine.test.concurrency.ControlledCommand;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.slf4j.Logger;

public class CompetingSentrySatisfactionTest {
    private static Logger LOG = ProcessEngineLogger.TEST_LOGGER.getLogger();
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected CaseService caseService;
    protected static ControllableThread activeThread;

    @Before
    public void initializeServices() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.caseService = this.engineRule.getCaseService();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/CompetingSentrySatisfactionTest.testEntryCriteriaWithAndSentry.cmmn"})
    @Test
    public void testEntryCriteriaWithAndSentry() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String firstHumanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstanceId).activityId("PI_HumanTask_1").singleResult()).getId();
        String secondHumanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstanceId).activityId("PI_HumanTask_2").singleResult()).getId();
        LOG.debug("test thread starts thread one");
        ManualStartSingleThread threadOne = new ManualStartSingleThread(firstHumanTaskId);
        threadOne.startAndWaitUntilControlIsReturned();
        LOG.debug("test thread continues to start thread two");
        CompletionSingleThread threadTwo = new CompletionSingleThread(secondHumanTaskId);
        threadTwo.startAndWaitUntilControlIsReturned();
        LOG.debug("test thread notifies thread 1");
        threadOne.proceedAndWaitTillDone();
        Assert.assertNull((Object)((Object)threadOne.exception));
        LOG.debug("test thread notifies thread 2");
        threadTwo.proceedAndWaitTillDone();
        Assert.assertNotNull((Object)((Object)threadTwo.exception));
        String message = threadTwo.exception.getMessage();
        this.testRule.assertTextPresent("CaseSentryPartEntity", message);
        this.testRule.assertTextPresent("was updated by another transaction concurrently", message);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/CompetingSentrySatisfactionTest.testExitCriteriaWithAndSentry.cmmn"})
    @Test
    public void testExitCriteriaWithAndSentry() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String firstHumanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstanceId).activityId("PI_HumanTask_1").singleResult()).getId();
        String secondHumanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstanceId).activityId("PI_HumanTask_2").singleResult()).getId();
        LOG.debug("test thread starts thread one");
        ManualStartSingleThread threadOne = new ManualStartSingleThread(firstHumanTaskId);
        threadOne.startAndWaitUntilControlIsReturned();
        LOG.debug("test thread continues to start thread two");
        CompletionSingleThread threadTwo = new CompletionSingleThread(secondHumanTaskId);
        threadTwo.startAndWaitUntilControlIsReturned();
        LOG.debug("test thread notifies thread 1");
        threadOne.proceedAndWaitTillDone();
        Assert.assertNull((Object)((Object)threadOne.exception));
        LOG.debug("test thread notifies thread 2");
        threadTwo.proceedAndWaitTillDone();
        Assert.assertNotNull((Object)((Object)threadTwo.exception));
        String message = threadTwo.exception.getMessage();
        this.testRule.assertTextPresent("CaseSentryPartEntity", message);
        this.testRule.assertTextPresent("was updated by another transaction concurrently", message);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/CompetingSentrySatisfactionTest.testEntryCriteriaWithOrSentry.cmmn"})
    @Test
    public void testEntryCriteriaWithOrSentry() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String firstHumanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstanceId).activityId("PI_HumanTask_1").singleResult()).getId();
        String secondHumanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstanceId).activityId("PI_HumanTask_2").singleResult()).getId();
        LOG.debug("test thread starts thread one");
        ManualStartSingleThread threadOne = new ManualStartSingleThread(firstHumanTaskId);
        threadOne.startAndWaitUntilControlIsReturned();
        LOG.debug("test thread continues to start thread two");
        CompletionSingleThread threadTwo = new CompletionSingleThread(secondHumanTaskId);
        threadTwo.startAndWaitUntilControlIsReturned();
        LOG.debug("test thread notifies thread 1");
        threadOne.proceedAndWaitTillDone();
        Assert.assertNull((Object)((Object)threadOne.exception));
        LOG.debug("test thread notifies thread 2");
        threadTwo.proceedAndWaitTillDone();
        Assert.assertNotNull((Object)((Object)threadTwo.exception));
        String message = threadTwo.exception.getMessage();
        this.testRule.assertTextPresent("CaseExecutionEntity", message);
        this.testRule.assertTextPresent("was updated by another transaction concurrently", message);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/CompetingSentrySatisfactionTest.testExitCriteriaWithOrSentry.cmmn", "org/camunda/bpm/engine/test/concurrency/CompetingSentrySatisfactionTest.oneTaskProcess.bpmn20.xml"})
    @Test
    public void testExitCriteriaWithOrSentry() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String firstHumanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstanceId).activityId("PI_HumanTask_1").singleResult()).getId();
        String secondHumanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstanceId).activityId("PI_HumanTask_2").singleResult()).getId();
        CaseExecution thirdTask = (CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstanceId).activityId("ProcessTask_3").singleResult();
        this.caseService.manuallyStartCaseExecution(thirdTask.getId());
        LOG.debug("test thread starts thread one");
        ManualStartSingleThread threadOne = new ManualStartSingleThread(firstHumanTaskId);
        threadOne.startAndWaitUntilControlIsReturned();
        LOG.debug("test thread continues to start thread two");
        CompletionSingleThread threadTwo = new CompletionSingleThread(secondHumanTaskId);
        threadTwo.startAndWaitUntilControlIsReturned();
        LOG.debug("test thread notifies thread 1");
        threadOne.proceedAndWaitTillDone();
        Assert.assertNull((Object)((Object)threadOne.exception));
        LOG.debug("test thread notifies thread 2");
        threadTwo.proceedAndWaitTillDone();
        Assert.assertNotNull((Object)((Object)threadTwo.exception));
        String message = threadTwo.exception.getMessage();
        this.testRule.assertTextPresent("CaseExecutionEntity", message);
        this.testRule.assertTextPresent("was updated by another transaction concurrently", message);
    }

    public class ManualStartSingleThread
    extends SingleThread {
        public ManualStartSingleThread(String caseExecutionId) {
            super(caseExecutionId, (StateTransitionCaseExecutionCmd)new ManualStartCaseExecutionCmd(caseExecutionId, null, null, null, null));
        }
    }

    public abstract class SingleThread
    extends ControllableThread {
        String caseExecutionId;
        OptimisticLockingException exception;
        protected StateTransitionCaseExecutionCmd cmd;

        public SingleThread(String caseExecutionId, StateTransitionCaseExecutionCmd cmd) {
            this.caseExecutionId = caseExecutionId;
            this.cmd = cmd;
        }

        @Override
        public synchronized void startAndWaitUntilControlIsReturned() {
            activeThread = this;
            super.startAndWaitUntilControlIsReturned();
        }

        @Override
        public void run() {
            try {
                CompetingSentrySatisfactionTest.this.processEngineConfiguration.getCommandExecutorTxRequired().execute(new ControlledCommand(activeThread, this.cmd));
            }
            catch (OptimisticLockingException e) {
                this.exception = e;
            }
            LOG.debug(this.getName() + " ends");
        }
    }

    public class CompletionSingleThread
    extends SingleThread {
        public CompletionSingleThread(String caseExecutionId) {
            super(caseExecutionId, (StateTransitionCaseExecutionCmd)new CompleteCaseExecutionCmd(caseExecutionId, null, null, null, null));
        }
    }
}

