/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.junit.After;
import org.junit.Test;

public class DeleteProcessDefinitionTest
extends ConcurrencyTestCase {
    @After
    public void tearDown() {
        this.repositoryService.createDeploymentQuery().list().forEach(deployment -> this.repositoryService.deleteDeployment(deployment.getId(), true));
        this.processEngineConfiguration.getDeploymentCache().purgeCache();
    }

    @Test
    public void testDeploymentOfProcessDefinitionWithOrphanMessageEvent() {
        String resource = "org/camunda/bpm/engine/test/api/repository/processWithNewInvoiceMessage.bpmn20.xml";
        List<ProcessDefinition> processDefinitions = this.deployProcessDefinitionTwice(resource);
        Assertions.assertThat((int)processDefinitions.size()).isEqualTo(2);
        this.deleteProcessDefinitionsSimultaneously(processDefinitions.get(0).getId(), processDefinitions.get(1).getId());
        Assertions.assertThat((List)this.repositoryService.createProcessDefinitionQuery().list()).isEmpty();
        Assertions.assertThat((long)this.runtimeService.createEventSubscriptionQuery().count()).isEqualTo(1L);
        this.repositoryService.createDeployment().addClasspathResource(resource).deploy();
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().count()).isEqualTo(1L);
        Assertions.assertThat((long)this.runtimeService.createEventSubscriptionQuery().count()).isEqualTo(1L);
    }

    @Test
    public void testDeploymentOfProcessDefinitionWithOrphanJob() {
        String resource = "org/camunda/bpm/engine/test/bpmn/event/timer/StartTimerEventTest.testTimeCycle.bpmn20.xml";
        List<ProcessDefinition> processDefinitions = this.deployProcessDefinitionTwice(resource);
        Assertions.assertThat((int)processDefinitions.size()).isEqualTo(2);
        this.deleteProcessDefinitionsSimultaneously(processDefinitions.get(0).getId(), processDefinitions.get(1).getId());
        Assertions.assertThat((List)this.repositoryService.createProcessDefinitionQuery().list()).isEmpty();
        Assertions.assertThat((long)this.managementService.createJobQuery().count()).isEqualTo(1L);
        this.repositoryService.createDeployment().addClasspathResource(resource).deploy();
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().count()).isEqualTo(1L);
        Assertions.assertThat((long)this.managementService.createJobQuery().count()).isEqualTo(1L);
    }

    @Test
    public void testDeploymentOfProcessDefinitionWithOrphanSignalEvent() {
        String resource = "org/camunda/bpm/engine/test/api/repository/processWithStartSignalEvent.bpmn20.xml";
        List<ProcessDefinition> processDefinitions = this.deployProcessDefinitionTwice(resource);
        Assertions.assertThat((int)processDefinitions.size()).isEqualTo(2);
        this.deleteProcessDefinitionsSimultaneously(processDefinitions.get(0).getId(), processDefinitions.get(1).getId());
        Assertions.assertThat((List)this.repositoryService.createProcessDefinitionQuery().list()).isEmpty();
        Assertions.assertThat((long)this.runtimeService.createEventSubscriptionQuery().count()).isEqualTo(1L);
        this.repositoryService.createDeployment().addClasspathResource(resource).deploy();
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().count()).isEqualTo(1L);
        Assertions.assertThat((long)this.runtimeService.createEventSubscriptionQuery().count()).isEqualTo(1L);
    }

    @Test
    public void testDeploymentOfProcessDefinitionWithOrphanEventAndPreviousVersion() {
        String resource = "org/camunda/bpm/engine/test/api/repository/processWithNewInvoiceMessage.bpmn20.xml";
        this.repositoryService.createDeployment().addClasspathResource(resource).deploy();
        this.repositoryService.createDeployment().addClasspathResource(resource).deploy();
        this.repositoryService.createDeployment().addClasspathResource(resource).deploy();
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("otherMessageProcess").list();
        Assertions.assertThat((int)processDefinitions.size()).isEqualTo(3);
        this.deleteProcessDefinitionsSimultaneously(((ProcessDefinition)processDefinitions.get(1)).getId(), ((ProcessDefinition)processDefinitions.get(2)).getId());
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().count()).isEqualTo(1L);
        Assertions.assertThat((long)this.runtimeService.createEventSubscriptionQuery().count()).isEqualTo(1L);
        this.repositoryService.createDeployment().addClasspathResource(resource).deploy();
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().count()).isEqualTo(2L);
        Assertions.assertThat((long)this.runtimeService.createEventSubscriptionQuery().count()).isEqualTo(1L);
    }

    @Test
    public void testDeploymentOfProcessDefinitionWithOrphanConditionalEvent() {
        String resource = "org/camunda/bpm/engine/test/api/repository/processWithConditionalStartEvent.bpmn20.xml";
        List<ProcessDefinition> definitions = this.deployProcessDefinitionTwice(resource);
        this.deleteProcessDefinitionsSimultaneously(definitions.get(0).getId(), definitions.get(1).getId());
        this.repositoryService.createDeployment().addClasspathResource(resource).deploy();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        EventSubscription subscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        Assertions.assertThat((String)((EventSubscriptionEntity)subscription).getConfiguration()).isEqualTo((Object)processDefinition.getId());
    }

    protected void deleteProcessDefinitionsSimultaneously(String id1, String id2) {
        ConcurrencyTestHelper.ThreadControl thread1 = this.executeControllableCommand(new ControllableDeleteProcessDefinitionCommand(id1));
        thread1.reportInterrupts();
        thread1.waitForSync();
        ConcurrencyTestHelper.ThreadControl thread2 = this.executeControllableCommand(new ControllableDeleteProcessDefinitionCommand(id2));
        thread2.reportInterrupts();
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        thread2.makeContinue();
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitUntilDone();
        thread2.makeContinue();
        thread2.waitUntilDone();
    }

    protected List<ProcessDefinition> deployProcessDefinitionTwice(String resource) {
        this.repositoryService.createDeployment().addClasspathResource(resource).deploy();
        this.repositoryService.createDeployment().addClasspathResource(resource).deploy();
        return this.repositoryService.createProcessDefinitionQuery().list();
    }

    protected static class ControllableDeleteProcessDefinitionCommand
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        protected String processDefinitionId;
        protected Exception exception;

        public ControllableDeleteProcessDefinitionCommand(String processDefinitionId) {
            this.processDefinitionId = processDefinitionId;
        }

        public Void execute(CommandContext commandContext) {
            this.monitor.sync();
            commandContext.getProcessEngineConfiguration().getRepositoryService().deleteProcessDefinition(this.processDefinitionId);
            this.monitor.sync();
            return null;
        }
    }
}

