/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.dmn.deployment;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.DecisionService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.dmn.Dmn;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.camunda.bpm.model.dmn.HitPolicy;
import org.camunda.bpm.model.dmn.instance.Decision;
import org.camunda.bpm.model.dmn.instance.DecisionTable;
import org.camunda.bpm.model.dmn.instance.Definitions;
import org.camunda.bpm.model.dmn.instance.Input;
import org.camunda.bpm.model.dmn.instance.InputExpression;
import org.camunda.bpm.model.dmn.instance.Output;
import org.camunda.bpm.model.dmn.instance.Text;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class DecisionDefinitionTest {
    @ClassRule
    public static ProcessEngineBootstrapRule BOOTSTRAP_RULE = new ProcessEngineBootstrapRule(configuration -> configuration.setHistoryTimeToLive("P30D"));
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(BOOTSTRAP_RULE);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RepositoryService repositoryService;
    protected DecisionService decisionService;
    protected HistoryService historyService;

    @Before
    public void init() throws ParseException {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.decisionService = this.engineRule.getDecisionService();
        this.historyService = this.engineRule.getHistoryService();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");
        Date fixedDate = sdf.parse("01/01/2001 01:01:01.000");
        ClockUtil.setCurrentTime((Date)fixedDate);
    }

    @After
    public void tearDown() {
        ClockUtil.reset();
    }

    @Test
    public void shouldUseHistoryTTLOnDecisionDefinitions() {
        DmnModelInstance model = this.createDmnModelInstance(null);
        DeploymentBuilder builder = this.repositoryService.createDeployment().addModelInstance("foo.dmn", model);
        Object deployment = this.testRule.deploy(builder);
        Assertions.assertThat((int)deployment.getDeployedDecisionDefinitions().size()).isEqualTo(1);
        Assertions.assertThat((Integer)((DecisionDefinition)deployment.getDeployedDecisionDefinitions().get(0)).getHistoryTimeToLive()).isEqualTo(30);
    }

    @Test
    public void shouldNotOverrideWithGlobalConfigOnDecisionHistoryTTLPresence() {
        DmnModelInstance model = this.createDmnModelInstance("P10D");
        DeploymentBuilder builder = this.repositoryService.createDeployment().addModelInstance("foo.dmn", model);
        Object deployment = this.testRule.deploy(builder);
        Assertions.assertThat((int)deployment.getDeployedDecisionDefinitions().size()).isEqualTo(1);
        Assertions.assertThat((Integer)((DecisionDefinition)deployment.getDeployedDecisionDefinitions().get(0)).getHistoryTimeToLive()).isEqualTo(10);
    }

    @RequiredHistoryLevel(value="full")
    @Test
    public void shouldApplyHistoryTTLOnRemovalTimeOfDecisionInstanceLocal() {
        DmnModelInstance model = this.createDmnModelInstance("P10D");
        DeploymentBuilder builder = this.repositoryService.createDeployment().addModelInstance("foo.dmn", model);
        this.testRule.deploy(builder);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("input", "single entry");
        this.decisionService.evaluateDecisionByKey("Decision-1").variables(variables).evaluate();
        HistoricDecisionInstance result = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Date expectedRemovalDate = Date.from(ClockUtil.now().toInstant().plus(10L, ChronoUnit.DAYS));
        Assertions.assertThat((Date)result.getRemovalTime()).isInSameDayAs(expectedRemovalDate);
    }

    @RequiredHistoryLevel(value="full")
    @Test
    public void shouldApplyHistoryTTLOnRemovalTimeOfDecisionInstanceGlobal() {
        DmnModelInstance model = this.createDmnModelInstance(null);
        DeploymentBuilder builder = this.repositoryService.createDeployment().addModelInstance("foo.dmn", model);
        this.testRule.deploy(builder);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("input", "single entry");
        this.decisionService.evaluateDecisionByKey("Decision-1").variables(variables).evaluate();
        HistoricDecisionInstance result = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Date expectedRemovalDate = Date.from(ClockUtil.now().toInstant().plus(30L, ChronoUnit.DAYS));
        Assertions.assertThat((Date)result.getRemovalTime()).isInSameDayAs(expectedRemovalDate);
    }

    protected DmnModelInstance createDmnModelInstance(String historyTTL) {
        DmnModelInstance modelInstance = Dmn.createEmptyModel();
        Definitions definitions = (Definitions)modelInstance.newInstance(Definitions.class);
        definitions.setId("definitions");
        definitions.setName("definitions");
        definitions.setNamespace("http://camunda.org/schema/1.0/dmn");
        modelInstance.setDefinitions(definitions);
        Decision decision = (Decision)modelInstance.newInstance(Decision.class);
        decision.setId("Decision-1");
        decision.setName("foo");
        decision.setCamundaHistoryTimeToLiveString(historyTTL);
        modelInstance.getDefinitions().addChildElement((ModelElementInstance)decision);
        DecisionTable decisionTable = (DecisionTable)modelInstance.newInstance(DecisionTable.class);
        decisionTable.setId("decisionTable");
        decisionTable.setHitPolicy(HitPolicy.FIRST);
        decision.addChildElement((ModelElementInstance)decisionTable);
        Input input = (Input)modelInstance.newInstance(Input.class);
        input.setId("Input-1");
        input.setLabel("Input");
        decisionTable.addChildElement((ModelElementInstance)input);
        InputExpression inputExpression = (InputExpression)modelInstance.newInstance(InputExpression.class);
        inputExpression.setId("InputExpression-1");
        Text inputExpressionText = (Text)modelInstance.newInstance(Text.class);
        inputExpressionText.setTextContent("input");
        inputExpression.setText(inputExpressionText);
        inputExpression.setTypeRef("string");
        input.setInputExpression(inputExpression);
        Output output = (Output)modelInstance.newInstance(Output.class);
        output.setName("output");
        output.setLabel("Output");
        output.setTypeRef("string");
        decisionTable.addChildElement((ModelElementInstance)output);
        return modelInstance;
    }
}

