/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.form.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.repository.CamundaFormDefinition;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.CamundaFormUtils;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;

public class CamundaFormDefinitionDeploymentTest {
    protected static final String SIMPLE_FORM = "org/camunda/bpm/engine/test/form/deployment/CamundaFormDefinitionDeploymentTest.simple_form.form";
    protected static final String SIMPLE_FORM_DUPLICATE = "org/camunda/bpm/engine/test/form/deployment/CamundaFormDefinitionDeploymentTest.simple_form_duplicate.form";
    protected static final String COMPLEX_FORM = "org/camunda/bpm/engine/test/form/deployment/CamundaFormDefinitionDeploymentTest.complex_form.form";
    protected static final String SIMPLE_BPMN = "org/camunda/bpm/engine/test/form/deployment/CamundaFormDefinitionDeploymentTest.simpleBPMN.bpmn";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected TemporaryFolder tempFolder = new TemporaryFolder();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule).around((TestRule)this.tempFolder);
    RepositoryService repositoryService;
    ProcessEngineConfigurationImpl processEngineConfiguration;

    @Before
    public void init() {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
    }

    @After
    public void tearDown() {
        List deployments = this.repositoryService.createDeploymentQuery().list();
        for (Deployment deployment : deployments) {
            this.repositoryService.deleteDeployment(deployment.getId());
        }
    }

    @Test
    public void shouldDeployTheSameFormTwiceWithoutDuplicateFiltering() {
        this.createDeploymentBuilder(false).addClasspathResource(SIMPLE_FORM).deploy();
        this.createDeploymentBuilder(false).addClasspathResource(SIMPLE_FORM).deploy();
        List deployments = this.repositoryService.createDeploymentQuery().list();
        Assertions.assertThat((List)deployments).hasSize(2);
        List<CamundaFormDefinition> definitions = CamundaFormUtils.findAllCamundaFormDefinitionEntities(this.processEngineConfiguration);
        Assertions.assertThat(definitions).hasSize(2);
        Assertions.assertThat(definitions).extracting("version").containsExactlyInAnyOrder(new Object[]{1, 2});
        Assertions.assertThat(definitions).extracting("deploymentId").containsExactlyInAnyOrder(deployments.stream().map(Deployment::getId).toArray());
        Assertions.assertThat(definitions).extracting("resourceName").containsExactly(new Object[]{SIMPLE_FORM, SIMPLE_FORM});
    }

    @Test
    public void shouldNotDeployTheSameFormTwiceWithDuplicateFiltering() {
        this.createDeploymentBuilder(true).addClasspathResource(SIMPLE_FORM).deploy();
        this.createDeploymentBuilder(true).addClasspathResource(SIMPLE_FORM).deploy();
        List deployments = this.repositoryService.createDeploymentQuery().list();
        Assertions.assertThat((List)deployments).hasSize(1);
        List<CamundaFormDefinition> definitions = CamundaFormUtils.findAllCamundaFormDefinitionEntities(this.processEngineConfiguration);
        Assertions.assertThat(definitions).hasSize(1);
        CamundaFormDefinition definition = definitions.get(0);
        Assertions.assertThat((int)definition.getVersion()).isEqualTo(1);
        Assertions.assertThat((String)definition.getDeploymentId()).isEqualTo((Object)((Deployment)deployments.get(0)).getId());
        Assertions.assertThat((String)definition.getResourceName()).isEqualTo((Object)SIMPLE_FORM);
    }

    @Test
    public void shouldNotDeployTheSameFormTwiceWithDuplicateFilteringAndAdditionalResources() {
        Deployment firstDeployment = this.createDeploymentBuilder(true).addClasspathResource(SIMPLE_FORM).deploy();
        this.createDeploymentBuilder(true).addClasspathResource(SIMPLE_FORM).addClasspathResource(SIMPLE_BPMN).deploy();
        List deployments = this.repositoryService.createDeploymentQuery().list();
        Assertions.assertThat((List)deployments).hasSize(2);
        List<CamundaFormDefinition> definitions = CamundaFormUtils.findAllCamundaFormDefinitionEntities(this.processEngineConfiguration);
        Assertions.assertThat(definitions).hasSize(1);
        CamundaFormDefinition definition = definitions.get(0);
        Assertions.assertThat((int)definition.getVersion()).isEqualTo(1);
        Assertions.assertThat((String)definition.getDeploymentId()).isEqualTo((Object)firstDeployment.getId());
        Assertions.assertThat((String)definition.getResourceName()).isEqualTo((Object)SIMPLE_FORM);
    }

    @Test
    public void shouldDeployDifferentFormsFromDifferentDeployments() {
        this.createDeploymentBuilder(true).addClasspathResource(SIMPLE_FORM).deploy();
        this.createDeploymentBuilder(true).addClasspathResource(COMPLEX_FORM).deploy();
        List deployments = this.repositoryService.createDeploymentQuery().list();
        Assertions.assertThat((List)deployments).hasSize(2);
        List<CamundaFormDefinition> definitions = CamundaFormUtils.findAllCamundaFormDefinitionEntities(this.processEngineConfiguration);
        Assertions.assertThat(definitions).hasSize(2);
        Assertions.assertThat(definitions).extracting("version").containsExactly(new Object[]{1, 1});
        Assertions.assertThat(definitions).extracting("deploymentId").containsExactlyInAnyOrder(deployments.stream().map(Deployment::getId).toArray());
        Assertions.assertThat(definitions).extracting("resourceName").containsExactlyInAnyOrder(new Object[]{SIMPLE_FORM, COMPLEX_FORM});
    }

    @Test
    public void shouldDeployDifferentFormsFromOneDeployment() {
        this.createDeploymentBuilder(true).addClasspathResource(SIMPLE_FORM).addClasspathResource(COMPLEX_FORM).deploy();
        List deployments = this.repositoryService.createDeploymentQuery().list();
        Assertions.assertThat((List)deployments).hasSize(1);
        String deploymentId = ((Deployment)deployments.get(0)).getId();
        List<CamundaFormDefinition> definitions = CamundaFormUtils.findAllCamundaFormDefinitionEntities(this.processEngineConfiguration);
        Assertions.assertThat(definitions).hasSize(2);
        Assertions.assertThat(definitions).extracting("version").containsExactly(new Object[]{1, 1});
        Assertions.assertThat(definitions).extracting("deploymentId").containsExactly(new Object[]{deploymentId, deploymentId});
        Assertions.assertThat(definitions).extracting("resourceName").containsExactlyInAnyOrder(new Object[]{SIMPLE_FORM, COMPLEX_FORM});
    }

    @Test
    public void shouldFailDeploymentWithMultipleFormsDuplicateId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.createDeploymentBuilder(true).addClasspathResource(SIMPLE_FORM).addClasspathResource(SIMPLE_FORM_DUPLICATE).deploy()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("The deployment contains definitions with the same key 'simpleForm' (id attribute), this is not allowed");
    }

    @Test
    public void shouldDeleteFormDefinitionWhenDeletingDeployment() {
        Deployment deployment = this.createDeploymentBuilder(true).addClasspathResource(SIMPLE_FORM).addClasspathResource(COMPLEX_FORM).deploy();
        List<CamundaFormDefinition> formDefinitions = CamundaFormUtils.findAllCamundaFormDefinitionEntities(this.processEngineConfiguration);
        List deployments = this.repositoryService.createDeploymentQuery().list();
        this.repositoryService.deleteDeployment(deployment.getId());
        Assertions.assertThat(formDefinitions).hasSize(2);
        Assertions.assertThat((List)deployments).hasSize(1);
        Assertions.assertThat(CamundaFormUtils.findAllCamundaFormDefinitionEntities(this.processEngineConfiguration)).hasSize(0);
        Assertions.assertThat((List)this.repositoryService.createDeploymentQuery().list()).hasSize(0);
    }

    @Test
    public void shouldUpdateVersionForChangedFormResource() throws IOException {
        String fileName = "myForm.form";
        String formContent1 = "{\"id\"=\"myForm\",\"type\": \"default\",\"components\":[{\"key\": \"button3\",\"label\": \"Button\",\"type\": \"button\"}]}";
        String formContent2 = "{\"id\"=\"myForm\",\"type\": \"default\",\"components\": []}";
        this.createDeploymentBuilder(true).addInputStream(fileName, (InputStream)CamundaFormUtils.writeTempFormFile(fileName, formContent1, this.tempFolder)).deploy();
        this.createDeploymentBuilder(true).addInputStream(fileName, (InputStream)CamundaFormUtils.writeTempFormFile(fileName, formContent2, this.tempFolder)).deploy();
        List deployments = this.repositoryService.createDeploymentQuery().list();
        Assertions.assertThat((List)deployments).hasSize(2);
        Assertions.assertThat((List)deployments).extracting("tenantId").containsExactly(new Object[]{null, null});
        List<CamundaFormDefinition> formDefinitions = CamundaFormUtils.findAllCamundaFormDefinitionEntities(this.processEngineConfiguration);
        Assertions.assertThat(formDefinitions).extracting("version").containsExactlyInAnyOrder(new Object[]{1, 2});
        Assertions.assertThat(formDefinitions).extracting("resourceName").containsExactly(new Object[]{fileName, fileName});
        Assertions.assertThat(formDefinitions).extracting("deploymentId").containsExactlyInAnyOrder(deployments.stream().map(Deployment::getId).toArray());
    }

    @Test
    public void shouldUpdateVersionForChangedFormResourceWithTenant() throws IOException {
        String fileName = "myForm.form";
        String formContent1 = "{\"id\"=\"myForm\",\"type\": \"default\",\"components\":[{\"key\": \"button3\",\"label\": \"Button\",\"type\": \"button\"}]}";
        String formContent2 = "{\"id\"=\"myForm\",\"type\": \"default\",\"components\": []}";
        this.createDeploymentBuilder(true).tenantId("tenant1").addInputStream(fileName, (InputStream)CamundaFormUtils.writeTempFormFile(fileName, formContent1, this.tempFolder)).deploy();
        this.createDeploymentBuilder(true).tenantId("tenant1").addInputStream(fileName, (InputStream)CamundaFormUtils.writeTempFormFile(fileName, formContent2, this.tempFolder)).deploy();
        List deployments = this.repositoryService.createDeploymentQuery().list();
        Assertions.assertThat((List)deployments).hasSize(2);
        Assertions.assertThat((List)deployments).extracting("tenantId").containsExactly(new Object[]{"tenant1", "tenant1"});
        List<CamundaFormDefinition> formDefinitions = CamundaFormUtils.findAllCamundaFormDefinitionEntities(this.processEngineConfiguration);
        Assertions.assertThat(formDefinitions).extracting("version").containsExactlyInAnyOrder(new Object[]{1, 2});
        Assertions.assertThat(formDefinitions).extracting("resourceName").containsExactly(new Object[]{fileName, fileName});
        Assertions.assertThat(formDefinitions).extracting("deploymentId").containsExactlyInAnyOrder(deployments.stream().map(Deployment::getId).toArray());
    }

    private DeploymentBuilder createDeploymentBuilder(boolean filterDuplicates) {
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment().name(this.getClass().getSimpleName());
        if (filterDuplicates) {
            deploymentBuilder.enableDuplicateFiltering(filterDuplicates);
        }
        return deploymentBuilder;
    }
}

