/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.history.HistoricExternalTaskLog;
import org.camunda.bpm.engine.history.HistoricExternalTaskLogQuery;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.camunda.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.camunda.bpm.engine.test.api.runtime.migration.models.builder.DefaultExternalTaskModelBuilder;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class HistoricExternalTaskLogQuerySortingTest {
    protected final String WORKER_ID = "aWorkerId";
    protected final long LOCK_DURATION = 300000L;
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule).around((TestRule)this.testHelper);
    protected ProcessInstance processInstance;
    protected RuntimeService runtimeService;
    protected HistoryService historyService;
    protected ExternalTaskService externalTaskService;

    @Before
    public void setUp() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
        this.externalTaskService = this.engineRule.getExternalTaskService();
    }

    @Test
    public void testQuerySortingByTimestampAsc() {
        int taskCount = 10;
        this.startProcesses(taskCount);
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        query.orderByTimestamp().asc();
        this.verifyQueryWithOrdering(query, taskCount, TestOrderingUtil.historicExternalTaskByTimestamp());
    }

    @Test
    public void testQuerySortingByTimestampDsc() {
        int taskCount = 10;
        this.startProcesses(taskCount);
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        query.orderByTimestamp().desc();
        this.verifyQueryWithOrdering(query, taskCount, TestOrderingUtil.inverted(TestOrderingUtil.historicExternalTaskByTimestamp()));
    }

    @Test
    public void testQuerySortingByTaskIdAsc() {
        int taskCount = 10;
        this.startProcesses(taskCount);
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        query.orderByExternalTaskId().asc();
        this.verifyQueryWithOrdering(query, taskCount, TestOrderingUtil.historicExternalTaskLogByExternalTaskId());
    }

    @Test
    public void testQuerySortingByTaskIdDsc() {
        int taskCount = 10;
        this.startProcesses(taskCount);
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        query.orderByExternalTaskId().desc();
        this.verifyQueryWithOrdering(query, taskCount, TestOrderingUtil.inverted(TestOrderingUtil.historicExternalTaskLogByExternalTaskId()));
    }

    @Test
    public void testQuerySortingByRetriesAsc() {
        int taskCount = 10;
        List<ExternalTask> list = this.startProcesses(taskCount);
        this.reportExternalTaskFailure(list);
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        query.failureLog().orderByRetries().asc();
        this.verifyQueryWithOrdering(query, taskCount, TestOrderingUtil.historicExternalTaskLogByRetries());
    }

    @Test
    public void testQuerySortingByRetriesDsc() {
        int taskCount = 10;
        List<ExternalTask> list = this.startProcesses(taskCount);
        this.reportExternalTaskFailure(list);
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        query.failureLog().orderByRetries().desc();
        this.verifyQueryWithOrdering(query, taskCount, TestOrderingUtil.inverted(TestOrderingUtil.historicExternalTaskLogByRetries()));
    }

    @Test
    public void testQuerySortingByPriorityAsc() {
        int taskCount = 10;
        this.startProcesses(taskCount);
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        query.orderByPriority().asc();
        this.verifyQueryWithOrdering(query, taskCount, TestOrderingUtil.historicExternalTaskLogByPriority());
    }

    @Test
    public void testQuerySortingByPriorityDsc() {
        int taskCount = 10;
        this.startProcesses(taskCount);
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        query.orderByPriority().desc();
        this.verifyQueryWithOrdering(query, taskCount, TestOrderingUtil.inverted(TestOrderingUtil.historicExternalTaskLogByPriority()));
    }

    @Test
    public void testQuerySortingByTopicNameAsc() {
        int taskCount = 10;
        this.startProcessesByTopicName(taskCount);
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        query.orderByTopicName().asc();
        this.verifyQueryWithOrdering(query, taskCount, TestOrderingUtil.historicExternalTaskLogByTopicName());
    }

    @Test
    public void testQuerySortingByTopicNameDsc() {
        int taskCount = 10;
        this.startProcessesByTopicName(taskCount);
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        query.orderByTopicName().desc();
        this.verifyQueryWithOrdering(query, taskCount, TestOrderingUtil.inverted(TestOrderingUtil.historicExternalTaskLogByTopicName()));
    }

    @Test
    public void testQuerySortingByWorkerIdAsc() {
        int taskCount = 10;
        List<ExternalTask> list = this.startProcesses(taskCount);
        this.completeExternalTasksWithWorkers(list);
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        query.successLog().orderByWorkerId().asc();
        this.verifyQueryWithOrdering(query, taskCount, TestOrderingUtil.historicExternalTaskLogByWorkerId());
    }

    @Test
    public void testQuerySortingByWorkerIdDsc() {
        int taskCount = 10;
        List<ExternalTask> list = this.startProcesses(taskCount);
        this.completeExternalTasksWithWorkers(list);
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        query.successLog().orderByWorkerId().desc();
        this.verifyQueryWithOrdering(query, taskCount, TestOrderingUtil.inverted(TestOrderingUtil.historicExternalTaskLogByWorkerId()));
    }

    @Test
    public void testQuerySortingByActivityIdAsc() {
        int taskCount = 10;
        this.startProcessesByActivityId(taskCount);
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        query.orderByActivityId().asc();
        this.verifyQueryWithOrdering(query, taskCount, TestOrderingUtil.historicExternalTaskLogByActivityId());
    }

    @Test
    public void testQuerySortingByActivityIdDsc() {
        int taskCount = 10;
        this.startProcessesByActivityId(taskCount);
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        query.orderByActivityId().desc();
        this.verifyQueryWithOrdering(query, taskCount, TestOrderingUtil.inverted(TestOrderingUtil.historicExternalTaskLogByActivityId()));
    }

    @Test
    public void testQuerySortingByActivityInstanceIdAsc() {
        int taskCount = 10;
        this.startProcesses(taskCount);
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        query.orderByActivityInstanceId().asc();
        this.verifyQueryWithOrdering(query, taskCount, TestOrderingUtil.historicExternalTaskLogByActivityInstanceId());
    }

    @Test
    public void testQuerySortingByActivityInstanceIdDsc() {
        int taskCount = 10;
        this.startProcesses(taskCount);
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        query.orderByActivityInstanceId().desc();
        this.verifyQueryWithOrdering(query, taskCount, TestOrderingUtil.inverted(TestOrderingUtil.historicExternalTaskLogByActivityInstanceId()));
    }

    @Test
    public void testQuerySortingByExecutionIdAsc() {
        int taskCount = 10;
        this.startProcesses(taskCount);
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        query.orderByExecutionId().asc();
        this.verifyQueryWithOrdering(query, taskCount, TestOrderingUtil.historicExternalTaskLogByExecutionId());
    }

    @Test
    public void testQuerySortingByExecutionIdDsc() {
        int taskCount = 10;
        this.startProcesses(taskCount);
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        query.orderByExecutionId().desc();
        this.verifyQueryWithOrdering(query, taskCount, TestOrderingUtil.inverted(TestOrderingUtil.historicExternalTaskLogByExecutionId()));
    }

    @Test
    public void testQuerySortingByProcessInstanceIdAsc() {
        int taskCount = 10;
        this.startProcesses(taskCount);
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        query.orderByProcessInstanceId().asc();
        this.verifyQueryWithOrdering(query, taskCount, TestOrderingUtil.historicExternalTaskLogByProcessInstanceId());
    }

    @Test
    public void testQuerySortingByProcessInstanceIdDsc() {
        int taskCount = 10;
        this.startProcesses(taskCount);
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        query.orderByProcessInstanceId().desc();
        this.verifyQueryWithOrdering(query, taskCount, TestOrderingUtil.inverted(TestOrderingUtil.historicExternalTaskLogByProcessInstanceId()));
    }

    @Test
    public void testQuerySortingByProcessDefinitionIdAsc() {
        int taskCount = 8;
        this.startProcesses(taskCount);
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        query.orderByProcessDefinitionId().asc();
        this.verifyQueryWithOrdering(query, taskCount, TestOrderingUtil.historicExternalTaskLogByProcessDefinitionId());
    }

    @Test
    public void testQuerySortingByProcessDefinitionIdDsc() {
        int taskCount = 8;
        this.startProcesses(taskCount);
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        query.orderByProcessDefinitionId().desc();
        this.verifyQueryWithOrdering(query, taskCount, TestOrderingUtil.inverted(TestOrderingUtil.historicExternalTaskLogByProcessDefinitionId()));
    }

    @Test
    public void testQuerySortingByProcessDefinitionKeyAsc() {
        int taskCount = 10;
        this.startProcessesByProcessDefinitionKey(taskCount);
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        query.orderByProcessDefinitionKey().asc();
        this.verifyQueryWithOrdering(query, taskCount, TestOrderingUtil.historicExternalTaskLogByProcessDefinitionKey(this.engineRule.getProcessEngine()));
    }

    @Test
    public void testQuerySortingByProcessDefinitionKeyDsc() {
        int taskCount = 10;
        this.startProcessesByProcessDefinitionKey(taskCount);
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        query.orderByProcessDefinitionKey().desc();
        this.verifyQueryWithOrdering(query, taskCount, TestOrderingUtil.inverted(TestOrderingUtil.historicExternalTaskLogByProcessDefinitionKey(this.engineRule.getProcessEngine())));
    }

    protected void completeExternalTasksWithWorkers(List<ExternalTask> taskLIst) {
        Integer i = 0;
        while (i < taskLIst.size()) {
            this.completeExternalTaskWithWorker(taskLIst.get(i).getId(), i.toString());
            Integer n = i;
            i = i + 1;
        }
    }

    protected void completeExternalTaskWithWorker(String externalTaskId, String workerId) {
        this.completeExternalTask(externalTaskId, "foo", workerId, false);
    }

    protected void completeExternalTask(String externalTaskId, String topic, String workerId, boolean usePriority) {
        List list = this.externalTaskService.fetchAndLock(100, workerId, usePriority).topic(topic, 300000L).execute();
        this.externalTaskService.complete(externalTaskId, workerId);
        for (LockedExternalTask lockedExternalTask : list) {
            if (lockedExternalTask.getId().equals(externalTaskId)) continue;
            this.externalTaskService.unlock(lockedExternalTask.getId());
        }
    }

    protected void reportExternalTaskFailure(List<ExternalTask> taskLIst) {
        Integer i = 0;
        while (i < taskLIst.size()) {
            this.reportExternalTaskFailure(taskLIst.get(i).getId(), "foo", "aWorkerId", i + 1, false, "foo");
            Integer n = i;
            i = i + 1;
        }
    }

    protected void reportExternalTaskFailure(String externalTaskId, String topic, String workerId, Integer retries, boolean usePriority, String errorMessage) {
        List list = this.externalTaskService.fetchAndLock(100, workerId, usePriority).topic(topic, 300000L).execute();
        this.externalTaskService.handleFailure(externalTaskId, workerId, errorMessage, retries.intValue(), 0L);
        for (LockedExternalTask lockedExternalTask : list) {
            this.externalTaskService.unlock(lockedExternalTask.getId());
        }
    }

    protected List<ExternalTask> startProcesses(int count) {
        LinkedList<ExternalTask> list = new LinkedList<ExternalTask>();
        for (int ithPrio = 0; ithPrio < count; ++ithPrio) {
            list.add(this.startExternalTaskProcessGivenPriority(ithPrio));
            this.ensureEnoughTimePassedByForTimestampOrdering();
        }
        return list;
    }

    protected List<ExternalTask> startProcessesByTopicName(int count) {
        LinkedList<ExternalTask> list = new LinkedList<ExternalTask>();
        Integer ithTopic = 0;
        while (ithTopic < count) {
            list.add(this.startExternalTaskProcessGivenTopicName(ithTopic.toString()));
            Integer n = ithTopic;
            ithTopic = ithTopic + 1;
        }
        return list;
    }

    protected List<ExternalTask> startProcessesByActivityId(int count) {
        LinkedList<ExternalTask> list = new LinkedList<ExternalTask>();
        Integer ithTopic = 0;
        while (ithTopic < count) {
            list.add(this.startExternalTaskProcessGivenActivityId("Activity" + ithTopic.toString()));
            Integer n = ithTopic;
            ithTopic = ithTopic + 1;
        }
        return list;
    }

    protected List<ExternalTask> startProcessesByProcessDefinitionKey(int count) {
        LinkedList<ExternalTask> list = new LinkedList<ExternalTask>();
        Integer ithTopic = 0;
        while (ithTopic < count) {
            list.add(this.startExternalTaskProcessGivenProcessDefinitionKey("ProcessKey" + ithTopic.toString()));
            Integer n = ithTopic;
            ithTopic = ithTopic + 1;
        }
        return list;
    }

    protected ExternalTask startExternalTaskProcessGivenTopicName(String topicName) {
        BpmnModelInstance processModelWithCustomTopic = DefaultExternalTaskModelBuilder.createDefaultExternalTaskModel().topic(topicName).build();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(processModelWithCustomTopic);
        ProcessInstance pi = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        return (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(pi.getId()).singleResult();
    }

    protected ExternalTask startExternalTaskProcessGivenActivityId(String activityId) {
        BpmnModelInstance processModelWithCustomActivityId = DefaultExternalTaskModelBuilder.createDefaultExternalTaskModel().externalTaskName(activityId).build();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(processModelWithCustomActivityId);
        ProcessInstance pi = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        return (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(pi.getId()).singleResult();
    }

    protected ExternalTask startExternalTaskProcessGivenProcessDefinitionKey(String processDefinitionKey) {
        BpmnModelInstance processModelWithCustomKey = DefaultExternalTaskModelBuilder.createDefaultExternalTaskModel().processKey(processDefinitionKey).build();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(processModelWithCustomKey);
        ProcessInstance pi = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        return (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(pi.getId()).singleResult();
    }

    protected ExternalTask startExternalTaskProcessGivenPriority(int priority) {
        BpmnModelInstance processModelWithCustomPriority = DefaultExternalTaskModelBuilder.createDefaultExternalTaskModel().priority(priority).build();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(processModelWithCustomPriority);
        ProcessInstance pi = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        return (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(pi.getId()).singleResult();
    }

    protected void verifyQueryWithOrdering(HistoricExternalTaskLogQuery query, int countExpected, TestOrderingUtil.NullTolerantComparator<HistoricExternalTaskLog> expectedOrdering) {
        Assertions.assertThat((List)query.list()).hasSize(countExpected);
        Assertions.assertThat((long)query.count()).isEqualTo((long)countExpected);
        TestOrderingUtil.verifySorting(query.list(), expectedOrdering);
    }

    protected void ensureEnoughTimePassedByForTimestampOrdering() {
        long timeToAddInSeconds = 5000L;
        Date nowPlus5Seconds = new Date(ClockUtil.getCurrentTime().getTime() + timeToAddInSeconds);
        ClockUtil.setCurrentTime((Date)nowPlus5Seconds);
    }
}

