/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.history.DurationReportResult;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.query.PeriodUnit;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class HistoricTaskDurationReportTest {
    public ProcessEngineRule processEngineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule processEngineTestRule = new ProcessEngineTestRule(this.processEngineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.processEngineTestRule).around((TestRule)this.processEngineRule);
    protected ProcessEngineConfiguration processEngineConfiguration;
    protected HistoryService historyService;
    protected static final String PROCESS_DEFINITION_KEY = "HISTORIC_TASK_INST_REPORT";
    protected static final String ANOTHER_PROCESS_DEFINITION_KEY = "ANOTHER_HISTORIC_TASK_INST_REPORT";

    @Before
    public void setUp() {
        this.historyService = this.processEngineRule.getHistoryService();
        this.processEngineConfiguration = this.processEngineRule.getProcessEngineConfiguration();
        this.processEngineTestRule.deploy(this.createProcessWithUserTask(PROCESS_DEFINITION_KEY));
        this.processEngineTestRule.deploy(this.createProcessWithUserTask(ANOTHER_PROCESS_DEFINITION_KEY));
    }

    @After
    public void cleanUp() {
        List list = this.processEngineRule.getTaskService().createTaskQuery().list();
        for (Task task : list) {
            this.processEngineRule.getTaskService().deleteTask(task.getId(), true);
        }
    }

    @Test
    public void testHistoricTaskInstanceDurationReportQuery() {
        this.startAndCompleteProcessInstance(PROCESS_DEFINITION_KEY, 2016, 6, 14, 11, 43);
        this.startAndCompleteProcessInstance(PROCESS_DEFINITION_KEY, 2016, 7, 14, 11, 43);
        this.startAndCompleteProcessInstance(ANOTHER_PROCESS_DEFINITION_KEY, 2016, 8, 14, 11, 43);
        List taskReportResults = this.historyService.createHistoricTaskInstanceReport().duration(PeriodUnit.MONTH);
        Assert.assertEquals((long)3L, (long)taskReportResults.size());
    }

    @Test
    public void testHistoricTaskInstanceDurationReportWithCompletedAfterDate() {
        this.startAndCompleteProcessInstance(PROCESS_DEFINITION_KEY, 2016, 7, 14, 11, 43);
        this.startAndCompleteProcessInstance(PROCESS_DEFINITION_KEY, 2016, 8, 14, 11, 43);
        this.startAndCompleteProcessInstance(ANOTHER_PROCESS_DEFINITION_KEY, 2016, 7, 14, 11, 43);
        Calendar calendar = Calendar.getInstance();
        calendar.set(2016, 11, 14, 12, 5);
        List taskReportResults = this.historyService.createHistoricTaskInstanceReport().completedAfter(calendar.getTime()).duration(PeriodUnit.MONTH);
        Assert.assertEquals((long)1L, (long)taskReportResults.size());
    }

    @Test
    public void testHistoricTaskInstanceDurationReportWithCompletedBeforeDate() {
        this.startAndCompleteProcessInstance(PROCESS_DEFINITION_KEY, 2016, 7, 14, 11, 43);
        this.startAndCompleteProcessInstance(PROCESS_DEFINITION_KEY, 2016, 8, 14, 11, 43);
        this.startAndCompleteProcessInstance(ANOTHER_PROCESS_DEFINITION_KEY, 2016, 6, 14, 11, 43);
        Calendar calendar = Calendar.getInstance();
        calendar.set(2016, 11, 14, 12, 5);
        List taskReportResults = this.historyService.createHistoricTaskInstanceReport().completedBefore(calendar.getTime()).duration(PeriodUnit.MONTH);
        Assert.assertEquals((long)2L, (long)taskReportResults.size());
    }

    @Test
    public void testHistoricTaskInstanceDurationReportResults() {
        this.startAndCompleteProcessInstance(PROCESS_DEFINITION_KEY, 2016, 7, 14, 11, 43);
        this.startAndCompleteProcessInstance(PROCESS_DEFINITION_KEY, 2016, 7, 14, 11, 43);
        DurationReportResult taskReportResult = (DurationReportResult)this.historyService.createHistoricTaskInstanceReport().duration(PeriodUnit.MONTH).get(0);
        List historicTaskInstances = this.historyService.createHistoricTaskInstanceQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).list();
        long min = 0L;
        long max = 0L;
        long sum = 0L;
        for (int i = 0; i < historicTaskInstances.size(); ++i) {
            HistoricTaskInstance historicProcessInstance = (HistoricTaskInstance)historicTaskInstances.get(i);
            Long duration = historicProcessInstance.getDurationInMillis();
            sum += duration.longValue();
            max = i > 0 ? Math.max(max, duration) : duration;
            min = i > 0 ? Math.min(min, duration) : duration;
        }
        long avg = sum / (long)historicTaskInstances.size();
        Assert.assertEquals((String)"maximum", (long)max, (long)taskReportResult.getMaximum());
        Assert.assertEquals((String)"minimum", (long)min, (long)taskReportResult.getMinimum());
        Assert.assertEquals((String)"average", (float)avg, (float)taskReportResult.getAverage(), (float)0.0f);
    }

    @Test
    public void testCompletedAfterWithNullValue() {
        try {
            this.historyService.createHistoricTaskInstanceReport().completedAfter(null).duration(PeriodUnit.MONTH);
            Assert.fail((String)"Expected NotValidException");
        }
        catch (NotValidException nve) {
            Assert.assertTrue((boolean)nve.getMessage().contains("completedAfter"));
        }
    }

    @Test
    public void testCompletedBeforeWithNullValue() {
        try {
            this.historyService.createHistoricTaskInstanceReport().completedBefore(null).duration(PeriodUnit.MONTH);
            Assert.fail((String)"Expected NotValidException");
        }
        catch (NotValidException nve) {
            Assert.assertTrue((boolean)nve.getMessage().contains("completedBefore"));
        }
    }

    protected BpmnModelInstance createProcessWithUserTask(String key) {
        return ((UserTaskBuilder)Bpmn.createExecutableProcess((String)key).startEvent().userTask(key + "_task1").name(key + " Task 1")).endEvent().done();
    }

    protected void completeTask(String pid) {
        Task task = (Task)this.processEngineRule.getTaskService().createTaskQuery().processInstanceId(pid).singleResult();
        this.processEngineRule.getTaskService().complete(task.getId());
    }

    protected void setCurrentTime(int year, int month, int dayOfMonth, int hourOfDay, int minute) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, dayOfMonth, hourOfDay, minute);
        ClockUtil.setCurrentTime((Date)calendar.getTime());
    }

    protected void addToCalendar(int field, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(ClockUtil.getCurrentTime());
        calendar.add(field, month);
        ClockUtil.setCurrentTime((Date)calendar.getTime());
    }

    protected void startAndCompleteProcessInstance(String key, int year, int month, int dayOfMonth, int hourOfDay, int minute) {
        this.setCurrentTime(year, month, dayOfMonth, hourOfDay, minute);
        ProcessInstance pi = this.processEngineRule.getRuntimeService().startProcessInstanceByKey(key);
        this.addToCalendar(2, 5);
        this.completeTask(pi.getId());
        ClockUtil.reset();
    }
}

