/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history.useroperationlog;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.junit.After;
import org.junit.Test;

public class SyncApiUserOperationLogLimitConfigurationTest {
    ProcessEngine engine;

    @After
    public void tearDown() {
        if (this.engine != null) {
            this.engine.close();
        }
    }

    @Test
    public void shouldConfigureDefault() {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"camunda.cfg.xml");
        this.startEngineManaged((ProcessEngineConfiguration)processEngineConfiguration);
        Assertions.assertThat((long)processEngineConfiguration.getLogEntriesPerSyncOperationLimit()).isEqualTo(1L);
    }

    @Test
    public void shouldAllowToConfigureNegativeOne() {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"/org/camunda/bpm/engine/test/history/useroperationlog/SyncApiUserOperationLogLimitConfigurationTest.shouldAllowToConfigureNegativeOne.cfg.xml");
        this.startEngineManaged((ProcessEngineConfiguration)processEngineConfiguration);
        Assertions.assertThat((long)processEngineConfiguration.getLogEntriesPerSyncOperationLimit()).isEqualTo(-1L);
    }

    @Test
    public void shouldAllowToConfigurePositiveValue() {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"/org/camunda/bpm/engine/test/history/useroperationlog/SyncApiUserOperationLogLimitConfigurationTest.shouldAllowToConfigurePositiveValue.cfg.xml");
        this.startEngineManaged((ProcessEngineConfiguration)processEngineConfiguration);
        Assertions.assertThat((long)processEngineConfiguration.getLogEntriesPerSyncOperationLimit()).isEqualTo(17000L);
    }

    @Test
    public void shouldThrowExceptionWhenConfigureZero() {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"/org/camunda/bpm/engine/test/history/useroperationlog/SyncApiUserOperationLogLimitConfigurationTest.shouldThrowExceptionWhenConfigureZero.cfg.xml");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.startEngineManaged((ProcessEngineConfiguration)processEngineConfiguration)).isInstanceOf(ProcessEngineException.class)).hasMessage("Invalid configuration for logEntriesPerSyncOperationLimit. Configured value needs to be either -1 or greater than 0 but was 0.");
    }

    @Test
    public void shouldThrowExceptionWhenConfigureLowNegativeValue() {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"/org/camunda/bpm/engine/test/history/useroperationlog/SyncApiUserOperationLogLimitConfigurationTest.shouldThrowExceptionWhenConfigureLowNegativeValue.cfg.xml");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.startEngineManaged((ProcessEngineConfiguration)processEngineConfiguration)).isInstanceOf(ProcessEngineException.class)).hasMessage("Invalid configuration for logEntriesPerSyncOperationLimit. Configured value needs to be either -1 or greater than 0 but was -10.");
    }

    private ProcessEngine startEngineManaged(ProcessEngineConfiguration config) {
        this.engine = config.buildProcessEngine();
        return this.engine;
    }
}

