/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history.useroperationlog;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class UserOperationLogAnnotationTest {
    protected static final String USER_ID = "demo";
    protected static final String TASK_ID = "aTaskId";
    protected static final String ANNOTATION = "anAnnotation";
    protected static final String TASK_NAME = "aTaskName";
    protected static final String OPERATION_ID = "operationId";
    protected final Date CREATE_TIME = new GregorianCalendar(2013, 2, 18, 13, 0, 0).getTime();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule engineTestRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.engineTestRule);
    protected HistoryService historyService;
    protected TaskService taskService;

    @Before
    public void assignServices() {
        this.historyService = this.engineRule.getHistoryService();
        this.taskService = this.engineRule.getTaskService();
    }

    @After
    public void clearDatabase() {
        this.taskService.deleteTask(TASK_ID, true);
    }

    @After
    public void resetClock() {
        ClockUtil.reset();
    }

    @Before
    public void setAuthentication() {
        this.engineRule.getIdentityService().setAuthenticatedUserId(USER_ID);
    }

    @After
    public void clearAuthentication() {
        this.engineRule.getIdentityService().clearAuthentication();
    }

    @Test
    public void shouldSetAnnotation() {
        this.createTask();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((Object)userOperationLogEntry).isNotNull();
        this.historyService.setAnnotationForOperationLogById(userOperationLogEntry.getOperationId(), ANNOTATION);
        userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        Assertions.assertThat((String)userOperationLogEntry.getAnnotation()).isEqualTo((Object)ANNOTATION);
    }

    @Test
    public void shouldSetAnnotation_WithPreservedTimeStamp() {
        ClockUtil.setCurrentTime((Date)this.CREATE_TIME);
        this.createTask();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((Object)userOperationLogEntry).isNotNull();
        this.historyService.setAnnotationForOperationLogById(userOperationLogEntry.getOperationId(), ANNOTATION);
        userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        Assertions.assertThat((String)userOperationLogEntry.getAnnotation()).isEqualTo((Object)ANNOTATION);
        Assertions.assertThat((Date)userOperationLogEntry.getTimestamp()).isEqualTo((Object)this.CREATE_TIME);
    }

    @Test
    public void shouldSetAnnotationForAllEntries() {
        Task task = this.createTask();
        this.updateMultiplePropertiesOfTask(task);
        List userOperationLogEntries = this.historyService.createUserOperationLogQuery().operationType("Update").list();
        Assertions.assertThat((int)userOperationLogEntries.size()).isEqualTo(2);
        String operationId = ((UserOperationLogEntry)userOperationLogEntries.get(0)).getOperationId();
        this.historyService.setAnnotationForOperationLogById(operationId, ANNOTATION);
        userOperationLogEntries = this.historyService.createUserOperationLogQuery().operationType("Update").list();
        Assertions.assertThat((String)((UserOperationLogEntry)userOperationLogEntries.get(0)).getAnnotation()).isEqualTo((Object)ANNOTATION);
        Assertions.assertThat((String)((UserOperationLogEntry)userOperationLogEntries.get(1)).getAnnotation()).isEqualTo((Object)ANNOTATION);
    }

    @Test
    public void shouldClearAnnotation() {
        this.createTask();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((Object)userOperationLogEntry).isNotNull();
        this.historyService.setAnnotationForOperationLogById(userOperationLogEntry.getOperationId(), ANNOTATION);
        userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().operationType("Create").singleResult();
        Assertions.assertThat((String)userOperationLogEntry.getAnnotation()).isEqualTo((Object)ANNOTATION);
        this.historyService.clearAnnotationForOperationLogById(userOperationLogEntry.getOperationId());
        userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().operationType("Create").singleResult();
        Assertions.assertThat((String)userOperationLogEntry.getAnnotation()).isNull();
    }

    @Test
    public void shouldClearAnnotationForAllEntries() {
        Task task = this.createTask();
        this.updateMultiplePropertiesOfTask(task);
        List userOperationLogEntries = this.historyService.createUserOperationLogQuery().operationType("Update").list();
        Assertions.assertThat((int)userOperationLogEntries.size()).isEqualTo(2);
        String operationId = ((UserOperationLogEntry)userOperationLogEntries.get(0)).getOperationId();
        this.historyService.setAnnotationForOperationLogById(operationId, ANNOTATION);
        userOperationLogEntries = this.historyService.createUserOperationLogQuery().operationType("Update").list();
        Assertions.assertThat((String)((UserOperationLogEntry)userOperationLogEntries.get(0)).getAnnotation()).isEqualTo((Object)ANNOTATION);
        Assertions.assertThat((String)((UserOperationLogEntry)userOperationLogEntries.get(1)).getAnnotation()).isEqualTo((Object)ANNOTATION);
        this.historyService.clearAnnotationForOperationLogById(operationId);
        userOperationLogEntries = this.historyService.createUserOperationLogQuery().operationType("Update").list();
        Assertions.assertThat((String)((UserOperationLogEntry)userOperationLogEntries.get(0)).getAnnotation()).isNull();
        Assertions.assertThat((String)((UserOperationLogEntry)userOperationLogEntries.get(1)).getAnnotation()).isNull();
    }

    @Test
    public void shouldWriteOperationLogOnClearAnnotation() {
        this.createTask();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        String operationId = userOperationLogEntry.getOperationId();
        Assertions.assertThat((Object)userOperationLogEntry).isNotNull();
        this.historyService.setAnnotationForOperationLogById(userOperationLogEntry.getOperationId(), ANNOTATION);
        userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        Assertions.assertThat((String)userOperationLogEntry.getAnnotation()).isEqualTo((Object)ANNOTATION);
        this.historyService.clearAnnotationForOperationLogById(userOperationLogEntry.getOperationId());
        userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().operationType("ClearAnnotation").singleResult();
        Assertions.assertThat((String)userOperationLogEntry.getEntityType()).isEqualTo((Object)"OperationLog");
        Assertions.assertThat((String)userOperationLogEntry.getOperationType()).isEqualTo((Object)"ClearAnnotation");
        Assertions.assertThat((String)userOperationLogEntry.getProperty()).isEqualTo((Object)OPERATION_ID);
        Assertions.assertThat((String)userOperationLogEntry.getNewValue()).isEqualTo((Object)operationId);
        Assertions.assertThat((String)userOperationLogEntry.getUserId()).isEqualTo((Object)USER_ID);
    }

    @Test
    public void shouldWriteOperationLogOnSetAnnotation() {
        this.createTask();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((Object)userOperationLogEntry).isNotNull();
        this.historyService.setAnnotationForOperationLogById(userOperationLogEntry.getOperationId(), OPERATION_ID);
        String operationId = userOperationLogEntry.getOperationId();
        userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("OperationLog").singleResult();
        Assertions.assertThat((String)userOperationLogEntry.getEntityType()).isEqualTo((Object)"OperationLog");
        Assertions.assertThat((String)userOperationLogEntry.getOperationType()).isEqualTo((Object)"SetAnnotation");
        Assertions.assertThat((String)userOperationLogEntry.getProperty()).isEqualTo((Object)OPERATION_ID);
        Assertions.assertThat((String)userOperationLogEntry.getNewValue()).isEqualTo((Object)operationId);
        Assertions.assertThat((String)userOperationLogEntry.getUserId()).isEqualTo((Object)USER_ID);
    }

    @Test
    public void shouldThrowExceptionWhenOperationIdNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.setAnnotationForOperationLogById(null, ANNOTATION)).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("operation id is null");
    }

    @Test
    public void shouldThrowExceptionWhenOperationNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.setAnnotationForOperationLogById("anOperationId", ANNOTATION)).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("operation is null");
    }

    protected void updateMultiplePropertiesOfTask(Task task) {
        task.setDueDate(new Date());
        task.setName(TASK_NAME);
        this.taskService.saveTask(task);
    }

    protected Task createTask() {
        Task task = this.taskService.newTask(TASK_ID);
        this.taskService.saveTask(task);
        return task;
    }
}

