/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.DateUtils;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.DefaultJobRetryCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.DefaultFailedJobCommandFactory;
import org.camunda.bpm.engine.impl.jobexecutor.FailedJobCommandFactory;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FailedJobListenerWithRetriesTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule();
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RuntimeService runtimeService;
    @Parameterized.Parameter(value=0)
    public int failedRetriesNumber;
    @Parameterized.Parameter(value=1)
    public int jobRetries;
    @Parameterized.Parameter(value=2)
    public boolean jobLocked;

    @Before
    public void init() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.processEngineConfiguration.setFailedJobCommandFactory((FailedJobCommandFactory)new OLEFailedJobCommandFactory());
        this.processEngineConfiguration.setFailedJobListenerMaxRetries(5);
        this.runtimeService = this.engineRule.getRuntimeService();
    }

    @Parameterized.Parameters
    public static Collection<Object[]> scenarios() {
        return Arrays.asList({4, 0, false}, {5, 1, true});
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/IncidentTest.testShouldCreateOneIncident.bpmn"})
    public void testFailedJobListenerRetries() {
        this.runtimeService.startProcessInstanceByKey("failingProcess");
        Job job = this.getJob();
        while (job.getRetries() > 0 && ((JobEntity)job).getLockOwner() == null) {
            try {
                this.lockTheJob(job.getId());
                this.engineRule.getManagementService().executeJob(job.getId());
            }
            catch (Exception exception) {
                // empty catch block
            }
            job = this.getJob();
        }
        JobEntity jobFinalState = (JobEntity)this.engineRule.getManagementService().createJobQuery().jobId(job.getId()).list().get(0);
        Assert.assertEquals((long)this.jobRetries, (long)jobFinalState.getRetries());
        if (this.jobLocked) {
            Assert.assertNotNull((Object)jobFinalState.getLockOwner());
            Assert.assertNotNull((Object)jobFinalState.getLockExpirationTime());
        } else {
            Assert.assertNull((Object)jobFinalState.getLockOwner());
            Assert.assertNull((Object)jobFinalState.getLockExpirationTime());
        }
    }

    void lockTheJob(final String jobId) {
        this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequiresNew().execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                JobEntity job = commandContext.getJobManager().findJobById(jobId);
                job.setLockOwner("someLockOwner");
                job.setLockExpirationTime(DateUtils.addHours((Date)ClockUtil.getCurrentTime(), (int)1));
                return null;
            }
        });
    }

    private Job getJob() {
        List jobs = this.engineRule.getManagementService().createJobQuery().list();
        Assert.assertEquals((long)1L, (long)jobs.size());
        return (Job)jobs.get(0);
    }

    public class OLEFailedJobCommandFactory
    extends DefaultFailedJobCommandFactory {
        private Map<String, OLEFoxJobRetryCmd> oleFoxJobRetryCmds = new HashMap<String, OLEFoxJobRetryCmd>();

        public Command<Object> getCommand(String jobId, Throwable exception) {
            return this.getOleFoxJobRetryCmds(jobId, exception);
        }

        public OLEFoxJobRetryCmd getOleFoxJobRetryCmds(String jobId, Throwable exception) {
            if (!this.oleFoxJobRetryCmds.containsKey(jobId)) {
                this.oleFoxJobRetryCmds.put(jobId, new OLEFoxJobRetryCmd(jobId, exception));
            }
            return this.oleFoxJobRetryCmds.get(jobId);
        }
    }

    public class OLEFoxJobRetryCmd
    extends DefaultJobRetryCmd {
        private int countRuns;

        public OLEFoxJobRetryCmd(String jobId, Throwable exception) {
            super(jobId, exception);
            this.countRuns = 0;
        }

        public Object execute(CommandContext commandContext) {
            JobEntity job = this.getJob();
            if (job.getRetries() == 1) {
                ++this.countRuns;
                if (this.countRuns <= FailedJobListenerWithRetriesTest.this.failedRetriesNumber) {
                    super.execute(commandContext);
                    throw new OptimisticLockingException("OLE");
                }
            }
            return super.execute(commandContext);
        }
    }
}

