/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.List;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.impl.cmd.DeleteJobCmd;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.jobexecutor.FailingTransactionListenerDelegate;
import org.camunda.bpm.engine.test.jobexecutor.TweetExceptionHandler;
import org.camunda.bpm.engine.test.jobexecutor.TweetNestedCommandExceptionHandler;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JobExecutorCmdExceptionTest
extends PluggableProcessEngineTest {
    protected TweetExceptionHandler tweetExceptionHandler = new TweetExceptionHandler();
    protected TweetNestedCommandExceptionHandler nestedCommandExceptionHandler = new TweetNestedCommandExceptionHandler();

    @Before
    public void setUp() throws Exception {
        this.processEngineConfiguration.getJobHandlers().put(this.tweetExceptionHandler.getType(), this.tweetExceptionHandler);
        this.processEngineConfiguration.getJobHandlers().put(this.nestedCommandExceptionHandler.getType(), this.nestedCommandExceptionHandler);
    }

    @After
    public void tearDown() throws Exception {
        this.processEngineConfiguration.getJobHandlers().remove(this.tweetExceptionHandler.getType());
        this.processEngineConfiguration.getJobHandlers().remove(this.nestedCommandExceptionHandler.getType());
        this.clearDatabase();
    }

    @Test
    public void testJobCommandsWith2Exceptions() {
        this.createJob("tweet-exception");
        this.testRule.executeAvailableJobs();
        JobQuery query = this.managementService.createJobQuery().noRetriesLeft();
        Assert.assertEquals((long)0L, (long)query.count());
    }

    @Test
    public void testJobCommandsWith3Exceptions() {
        this.tweetExceptionHandler.setExceptionsRemaining(3);
        this.createJob("tweet-exception");
        this.testRule.executeAvailableJobs();
        Job job = (Job)this.managementService.createJobQuery().noRetriesLeft().singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((long)0L, (long)job.getRetries());
    }

    @Test
    public void testMultipleFailingJobs() {
        this.tweetExceptionHandler.setExceptionsRemaining(600);
        for (int i = 0; i < 40; ++i) {
            this.createJob("tweet-exception");
        }
        this.testRule.executeAvailableJobs();
        List jobList = this.managementService.createJobQuery().list();
        Assert.assertEquals((long)40L, (long)jobList.size());
        for (Job job : jobList) {
            Assert.assertEquals((long)0L, (long)job.getRetries());
        }
    }

    @Test
    public void testJobCommandsWithNestedFailingCommand() {
        this.createJob("tweet-exception-nested");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)3L, (long)job.getRetries());
        try {
            this.managementService.executeJob(job.getId());
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)2L, (long)job.getRetries());
        this.testRule.executeAvailableJobs();
        job = (Job)this.managementService.createJobQuery().noRetriesLeft().singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((long)0L, (long)job.getRetries());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/jobFailingOnFlush.bpmn20.xml"})
    @Test
    public void testJobRetriesDecrementedOnFailedFlush() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((long)3L, (long)job.getRetries());
        this.testRule.waitForJobExecutorToProcessAllJobs(6000L);
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((long)0L, (long)job.getRetries());
    }

    @Test
    public void testFailingTransactionListener() {
        this.testRule.deploy(((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().serviceTask().camundaClass(FailingTransactionListenerDelegate.class.getName())).camundaAsyncBefore()).endEvent().done());
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((long)3L, (long)job.getRetries());
        this.testRule.waitForJobExecutorToProcessAllJobs(6000L);
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((long)0L, (long)job.getRetries());
        Assert.assertEquals((Object)"exception in transaction listener", (Object)job.getExceptionMessage());
        String stacktrace = this.managementService.getJobExceptionStacktrace(job.getId());
        Assert.assertNotNull((Object)stacktrace);
        Assert.assertTrue((String)("unexpected stacktrace, was <" + stacktrace + ">"), (boolean)stacktrace.contains("java.lang.RuntimeException: exception in transaction listener"));
    }

    protected void createJob(final String handlerType) {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<String>(){

            public String execute(CommandContext commandContext) {
                MessageEntity message = JobExecutorCmdExceptionTest.this.createMessage(handlerType);
                commandContext.getJobManager().send(message);
                return message.getId();
            }
        });
    }

    protected MessageEntity createMessage(String handlerType) {
        MessageEntity message = new MessageEntity();
        message.setJobHandlerType(handlerType);
        return message;
    }

    protected void clearDatabase() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                List jobs = JobExecutorCmdExceptionTest.this.processEngineConfiguration.getManagementService().createJobQuery().list();
                for (Object job : jobs) {
                    new DeleteJobCmd(job.getId()).execute(commandContext);
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(job.getId());
                }
                List historicIncidents = JobExecutorCmdExceptionTest.this.processEngineConfiguration.getHistoryService().createHistoricIncidentQuery().list();
                for (HistoricIncident historicIncident : historicIncidents) {
                    commandContext.getDbEntityManager().delete((DbEntity)historicIncident);
                }
                List historicJobLogs = JobExecutorCmdExceptionTest.this.processEngineConfiguration.getHistoryService().createHistoricJobLogQuery().list();
                for (HistoricJobLog historicJobLog : historicJobLogs) {
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogById(historicJobLog.getId());
                }
                return null;
            }
        });
    }
}

