/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.ArrayList;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionManager;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.camunda.bpm.engine.test.jobexecutor.ControllableJobExecutor;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class ReuseEntityCacheTest {
    public static final String ENTITY_ID1 = "Execution1";
    public static final String ENTITY_ID2 = "Execution2";
    protected ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> configuration.setJobExecutor((JobExecutor)new ControllableJobExecutor()));
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule(this.bootstrapRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.bootstrapRule).around((TestRule)this.engineRule);
    protected boolean defaultSetting;
    protected ControllableJobExecutor jobExecutor;
    protected static ConcurrencyTestHelper.ThreadControl executionThreadControl;
    protected ConcurrencyTestHelper.ThreadControl acquisitionThreadControl;
    protected static final BpmnModelInstance PROCESS;

    @Before
    public void setUp() {
        this.defaultSetting = this.getEngineConfig().isDbEntityCacheReuseEnabled();
        this.getEngineConfig().setDbEntityCacheReuseEnabled(true);
        this.jobExecutor = (ControllableJobExecutor)this.getEngineConfig().getJobExecutor();
        executionThreadControl = this.jobExecutor.getExecutionThreadControl();
        this.acquisitionThreadControl = this.jobExecutor.getAcquisitionThreadControl();
    }

    @After
    public void resetEngineConfiguration() {
        this.getEngineConfig().setDbEntityCacheReuseEnabled(this.defaultSetting);
    }

    @After
    public void shutdownJobExecutor() {
        this.jobExecutor.shutdown();
    }

    @Test
    public void testFlushOrderWithEntityCacheReuse() {
        Deployment deployment = this.engineRule.getRepositoryService().createDeployment().addModelInstance("foo.bpmn", PROCESS).deploy();
        this.engineRule.manageDeployment(deployment);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.jobExecutor.start();
        this.acquisitionThreadControl.waitForSync();
        this.acquisitionThreadControl.makeContinueAndWaitForSync();
        this.acquisitionThreadControl.makeContinue();
        executionThreadControl.waitForSync();
        executionThreadControl.makeContinueAndWaitForSync();
        executionThreadControl.makeContinueAndWaitForSync();
        executionThreadControl.makeContinue();
        this.acquisitionThreadControl.waitForSync();
        Assert.assertEquals((long)0L, (long)this.engineRule.getManagementService().createJobQuery().count());
    }

    protected ProcessEngineConfigurationImpl getEngineConfig() {
        return (ProcessEngineConfigurationImpl)this.engineRule.getProcessEngine().getProcessEngineConfiguration();
    }

    static {
        PROCESS = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask().camundaClass(CreateEntitiesDelegate.class.getName())).camundaAsyncBefore()).camundaExclusive(true)).serviceTask().camundaClass(UpdateEntitiesDelegate.class.getName())).camundaAsyncBefore()).camundaExclusive(true)).serviceTask().camundaClass(RemoveEntitiesDelegate.class.getName())).camundaAsyncBefore()).camundaExclusive(true)).endEvent().done();
    }

    public static class CreateEntitiesDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            ExecutionEntity execution1 = new ExecutionEntity();
            execution1.setId(ReuseEntityCacheTest.ENTITY_ID1);
            execution1.setExecutions(new ArrayList());
            ExecutionEntity execution2 = new ExecutionEntity();
            execution2.setId(ReuseEntityCacheTest.ENTITY_ID2);
            execution2.setExecutions(new ArrayList());
            execution2.setParent((PvmExecutionImpl)execution1);
            ExecutionManager executionManager = Context.getCommandContext().getExecutionManager();
            executionManager.insert((DbEntity)execution1);
            executionManager.insert((DbEntity)execution2);
            executionThreadControl.sync();
        }
    }

    public static class UpdateEntitiesDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            ExecutionManager executionManager = Context.getCommandContext().getExecutionManager();
            ExecutionEntity execution1 = executionManager.findExecutionById(ReuseEntityCacheTest.ENTITY_ID1);
            ExecutionEntity execution2 = executionManager.findExecutionById(ReuseEntityCacheTest.ENTITY_ID2);
            execution2.setParent(null);
            execution1.setParent((PvmExecutionImpl)execution2);
            executionThreadControl.sync();
        }
    }

    public static class RemoveEntitiesDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            ExecutionManager executionManager = Context.getCommandContext().getExecutionManager();
            ExecutionEntity execution1 = executionManager.findExecutionById(ReuseEntityCacheTest.ENTITY_ID1);
            ExecutionEntity execution2 = executionManager.findExecutionById(ReuseEntityCacheTest.ENTITY_ID2);
            executionManager.delete((DbEntity)execution1);
            executionManager.delete((DbEntity)execution2);
            executionThreadControl.sync();
        }
    }
}

