/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.history;

import java.util.Arrays;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class AuditHistoryTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule("org/camunda/bpm/engine/test/standalone/history/audithistory.camunda.cfg.xml");
    @Rule
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected RuntimeService runtimeService;
    protected HistoryService historyService;

    @Before
    public void setUp() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testReceivesNoHistoricVariableUpdatesAsDetails() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String value = "a Variable Value";
        this.runtimeService.setVariable(instance.getId(), "aStringVariable", (Object)value);
        this.runtimeService.setVariable(instance.getId(), "aBytesVariable", (Object)value.getBytes());
        String newValue = "a new Variable Value";
        this.runtimeService.setVariable(instance.getId(), "aStringVariable", (Object)newValue);
        this.runtimeService.setVariable(instance.getId(), "aBytesVariable", (Object)newValue.getBytes());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        HistoricVariableInstance historicStringVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("aStringVariable").singleResult();
        Assert.assertNotNull((Object)historicStringVariable);
        Assert.assertEquals((Object)newValue, (Object)historicStringVariable.getValue());
        HistoricVariableInstance historicBytesVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("aBytesVariable").singleResult();
        Assert.assertNotNull((Object)historicBytesVariable);
        Assert.assertTrue((boolean)Arrays.equals(newValue.getBytes(), (byte[])historicBytesVariable.getValue()));
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().count());
    }
}

