/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.initialization;

import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class ProcessEngineInitializationTest {
    @Test
    public void testNoTables() {
        try {
            ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"org/camunda/bpm/engine/test/standalone/initialization/notables.camunda.cfg.xml").buildProcessEngine();
            Assert.fail((String)"expected exception");
        }
        catch (Exception e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"ENGINE-03057 There are no Camunda tables in the database. Hint: Set <property name=\"databaseSchemaUpdate\" to value=\"true\" or value=\"create-drop\" (use create-drop for testing only!) in bean processEngineConfiguration in camunda.cfg.xml for automatic schema creation"});
        }
    }

    @Test
    public void testDefaultRetries() {
        ProcessEngineConfiguration configuration = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"org/camunda/bpm/engine/test/standalone/initialization/defaultretries.camunda.cfg.xml");
        Assert.assertEquals((long)3L, (long)configuration.getDefaultNumberOfRetries());
    }

    @Test
    public void testCustomDefaultRetries() {
        ProcessEngineConfiguration configuration = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"org/camunda/bpm/engine/test/standalone/initialization/customdefaultretries.camunda.cfg.xml");
        Assert.assertEquals((long)5L, (long)configuration.getDefaultNumberOfRetries());
    }
}

