/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.variablescope;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class VariableScopeTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testVariableNamesScope() {
        HashMap<String, String> varMap = new HashMap<String, String>();
        varMap.put("test", "test");
        varMap.put("helloWorld", "helloWorld");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("simpleSubProcess", varMap);
        Task subProcessTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        this.runtimeService.setVariableLocal(pi.getProcessInstanceId(), "mainProcessLocalVariable", (Object)"Hello World");
        Assert.assertEquals((Object)"Task in subprocess", (Object)subProcessTask.getName());
        this.runtimeService.setVariableLocal(subProcessTask.getExecutionId(), "subProcessLocalVariable", (Object)"Hello SubProcess");
        List result = (List)this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new GetVariableNamesCommand(pi.getProcessInstanceId(), true));
        Assert.assertTrue((boolean)result.contains("test"));
        Assert.assertTrue((boolean)result.contains("helloWorld"));
        Assert.assertTrue((boolean)result.contains("mainProcessLocalVariable"));
        Assert.assertFalse((boolean)result.contains("subProcessLocalVariable"));
        result = (List)this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new GetVariableNamesCommand(pi.getProcessInstanceId(), false));
        Assert.assertTrue((boolean)result.contains("test"));
        Assert.assertTrue((boolean)result.contains("mainProcessLocalVariable"));
        Assert.assertTrue((boolean)result.contains("helloWorld"));
        Assert.assertFalse((boolean)result.contains("subProcessLocalVariable"));
        result = (List)this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new GetVariableNamesCommand(subProcessTask.getExecutionId(), true));
        Assert.assertTrue((boolean)result.contains("test"));
        Assert.assertTrue((boolean)result.contains("subProcessLocalVariable"));
        Assert.assertFalse((boolean)result.contains("helloWorld"));
        Assert.assertFalse((boolean)result.contains("mainProcessLocalVariable"));
        result = (List)this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new GetVariableNamesCommand(subProcessTask.getExecutionId(), false));
        Assert.assertTrue((boolean)result.contains("test"));
        Assert.assertTrue((boolean)result.contains("subProcessLocalVariable"));
        Assert.assertTrue((boolean)result.contains("helloWorld"));
        Assert.assertTrue((boolean)result.contains("mainProcessLocalVariable"));
        this.taskService.complete(subProcessTask.getId());
    }

    private class GetVariableNamesCommand
    implements Command<List<String>> {
        private String executionId;
        private boolean isLocal;

        public GetVariableNamesCommand(String executionId, boolean isLocal) {
            this.executionId = executionId;
            this.isLocal = isLocal;
        }

        public List<String> execute(CommandContext commandContext) {
            EnsureUtil.ensureNotNull((String)"executionId", (Object)this.executionId);
            ExecutionEntity execution = commandContext.getExecutionManager().findExecutionById(this.executionId);
            EnsureUtil.ensureNotNull((String)("execution " + this.executionId + " doesn't exist"), (String)"execution", (Object)execution);
            ArrayList<String> executionVariables = this.isLocal ? new ArrayList<String>(execution.getVariableNamesLocal()) : new ArrayList(execution.getVariableNames());
            return executionVariables;
        }
    }
}

