/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.impl.migration.MigrationInstructionImpl;
import org.camunda.bpm.engine.migration.MigrationInstruction;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.variable.impl.value.UntypedValueImpl;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.junit.Assert;

public class MigrationPlanAssert {
    protected MigrationPlan actual;

    public MigrationPlanAssert(MigrationPlan actual) {
        this.actual = actual;
    }

    public MigrationPlanAssert isNotNull() {
        Assert.assertNotNull((String)"The migration plan is null", (Object)this.actual);
        return this;
    }

    public MigrationPlanAssert hasSourceProcessDefinition(ProcessDefinition sourceProcessDefinition) {
        return this.hasSourceProcessDefinitionId(sourceProcessDefinition.getId());
    }

    public MigrationPlanAssert hasSourceProcessDefinitionId(String sourceProcessDefinitionId) {
        this.isNotNull();
        Assert.assertEquals((String)"The source process definition id does not match", (Object)sourceProcessDefinitionId, (Object)this.actual.getSourceProcessDefinitionId());
        return this;
    }

    public MigrationPlanAssert hasTargetProcessDefinition(ProcessDefinition targetProcessDefinition) {
        return this.hasTargetProcessDefinitionId(targetProcessDefinition.getId());
    }

    public MigrationPlanAssert hasTargetProcessDefinitionId(String targetProcessDefinitionId) {
        this.isNotNull();
        Assert.assertEquals((String)"The target process definition id does not match", (Object)targetProcessDefinitionId, (Object)this.actual.getTargetProcessDefinitionId());
        return this;
    }

    public MigrationPlanAssert variablesNull() {
        this.isNotNull();
        Assert.assertNull((Object)this.actual.getVariables());
        return this;
    }

    public MigrationPlanAssert variablesEmpty() {
        this.isNotNull();
        Assert.assertTrue((this.actual.getVariables() != null && this.actual.getVariables().isEmpty() ? 1 : 0) != 0);
        return this;
    }

    public MigrationPlanAssert hasVariables(MigrationVariableAssert ... variableAsserts) {
        this.isNotNull();
        HashMap notExpected = new HashMap(this.actual.getVariables());
        ArrayList notFound = new ArrayList();
        Collections.addAll(notFound, variableAsserts);
        Arrays.stream(variableAsserts).forEachOrdered(variableAssert -> this.actual.getVariables().keySet().stream().filter(name -> variableAssert.name.equals(name)).forEachOrdered(name -> {
            notFound.remove(variableAssert);
            notExpected.remove(name);
            ((AbstractCharSequenceAssert)Assertions.assertThat((String)name).as("Variable name does not match for variable %s", new Object[]{name})).isEqualTo((Object)variableAssert.name);
            TypedValue typedValue = this.actual.getVariables().getValueTyped(name);
            Assertions.assertThat((Object)typedValue.getValue()).as("Variable value does not match for variable %s", new Object[]{name}).isEqualTo(variableAssert.value);
            ((AbstractCharSequenceAssert)Assertions.assertThat((String)(variableAssert.typed ? "typed" : "untyped")).as("Variable %s: value typed/untyped does not match", new Object[]{name})).isEqualTo((Object)(typedValue instanceof UntypedValueImpl ? "untyped" : "typed"));
        }));
        if (!notExpected.isEmpty() || !notFound.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            builder.append("\nActual migration variables:\n\t").append(this.actual.getVariables()).append("\n");
            if (!notExpected.isEmpty()) {
                builder.append("Unexpected migration variables:\n\t").append(notExpected).append("\n");
            }
            if (!notFound.isEmpty()) {
                builder.append("Migration variables missing:\n\t").append(notFound);
            }
            Assert.fail((String)builder.toString());
        }
        return this;
    }

    public MigrationPlanAssert hasInstructions(MigrationInstructionAssert ... instructionAsserts) {
        this.isNotNull();
        ArrayList notExpected = new ArrayList(this.actual.getInstructions());
        ArrayList notFound = new ArrayList();
        Collections.addAll(notFound, instructionAsserts);
        for (MigrationInstructionAssert instructionAssert : instructionAsserts) {
            for (MigrationInstruction instruction : this.actual.getInstructions()) {
                if (!instructionAssert.sourceActivityId.equals(instruction.getSourceActivityId())) continue;
                notFound.remove(instructionAssert);
                notExpected.remove(instruction);
                Assert.assertEquals((String)("Target activity ids do not match for instruction " + instruction), (Object)instructionAssert.targetActivityId, (Object)instruction.getTargetActivityId());
                if (instructionAssert.updateEventTrigger == null) continue;
                Assert.assertEquals((String)("Expected instruction to update event trigger: " + instructionAssert.updateEventTrigger + " but is: " + instruction.isUpdateEventTrigger()), (Object)instructionAssert.updateEventTrigger, (Object)instruction.isUpdateEventTrigger());
            }
        }
        if (!notExpected.isEmpty() || !notFound.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            builder.append("\nActual migration instructions:\n\t").append(this.actual.getInstructions()).append("\n");
            if (!notExpected.isEmpty()) {
                builder.append("Unexpected migration instructions:\n\t").append(notExpected).append("\n");
            }
            if (!notFound.isEmpty()) {
                builder.append("Migration instructions missing:\n\t").append(notFound);
            }
            Assert.fail((String)builder.toString());
        }
        return this;
    }

    public MigrationPlanAssert hasEmptyInstructions() {
        this.isNotNull();
        List instructions = this.actual.getInstructions();
        Assert.assertTrue((String)("Expected migration plan has no instructions but has: " + instructions), (boolean)instructions.isEmpty());
        return this;
    }

    public static MigrationPlanAssert assertThat(MigrationPlan migrationPlan) {
        return new MigrationPlanAssert(migrationPlan);
    }

    public static MigrationInstructionAssert migrate(String sourceActivityId) {
        return new MigrationInstructionAssert().from(sourceActivityId);
    }

    public static MigrationVariableAssert variable() {
        return new MigrationVariableAssert();
    }

    public static class MigrationInstructionAssert {
        protected String sourceActivityId;
        protected String targetActivityId;
        protected Boolean updateEventTrigger;

        public MigrationInstructionAssert from(String sourceActivityId) {
            this.sourceActivityId = sourceActivityId;
            return this;
        }

        public MigrationInstructionAssert to(String targetActivityId) {
            this.targetActivityId = targetActivityId;
            return this;
        }

        public MigrationInstructionAssert updateEventTrigger(boolean updateEventTrigger) {
            this.updateEventTrigger = updateEventTrigger;
            return this;
        }

        public String toString() {
            return new MigrationInstructionImpl(this.sourceActivityId, this.targetActivityId).toString();
        }
    }

    public static class MigrationVariableAssert {
        protected String name;
        protected Object value;
        protected boolean typed;

        public MigrationVariableAssert name(String name) {
            this.name = name;
            return this;
        }

        public MigrationVariableAssert value(Object value) {
            this.value = value;
            return this;
        }

        public MigrationVariableAssert typed() {
            this.typed = true;
            return this;
        }
    }
}

