/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.camunda.bpm.engine.exception.NotAllowedException;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.exception.cmmn.CaseDefinitionNotFoundException;
import org.camunda.bpm.engine.exception.cmmn.CaseExecutionNotFoundException;
import org.camunda.bpm.engine.exception.cmmn.CaseIllegalStateTransitionException;
import org.camunda.bpm.engine.impl.cmmn.cmd.CaseExecutionVariableCmd;
import org.camunda.bpm.engine.impl.cmmn.cmd.CloseCaseInstanceCmd;
import org.camunda.bpm.engine.impl.cmmn.cmd.CompleteCaseExecutionCmd;
import org.camunda.bpm.engine.impl.cmmn.cmd.DisableCaseExecutionCmd;
import org.camunda.bpm.engine.impl.cmmn.cmd.ManualStartCaseExecutionCmd;
import org.camunda.bpm.engine.impl.cmmn.cmd.ReenableCaseExecutionCmd;
import org.camunda.bpm.engine.impl.cmmn.cmd.TerminateCaseExecutionCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.CaseExecutionCommandBuilder;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.impl.VariableMapImpl;

public class CaseExecutionCommandBuilderImpl
implements CaseExecutionCommandBuilder {
    protected CommandExecutor commandExecutor;
    protected CommandContext commandContext;
    protected String caseExecutionId;
    protected VariableMapImpl variables;
    protected VariableMapImpl variablesLocal;
    protected Collection<String> variableDeletions;
    protected Collection<String> variableLocalDeletions;

    public CaseExecutionCommandBuilderImpl(CommandExecutor commandExecutor, String caseExecutionId) {
        this(caseExecutionId);
        EnsureUtil.ensureNotNull("commandExecutor", (Object)commandExecutor);
        this.commandExecutor = commandExecutor;
    }

    public CaseExecutionCommandBuilderImpl(CommandContext commandContext, String caseExecutionId) {
        this(caseExecutionId);
        EnsureUtil.ensureNotNull("commandContext", (Object)commandContext);
        this.commandContext = commandContext;
    }

    private CaseExecutionCommandBuilderImpl(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
    }

    @Override
    public CaseExecutionCommandBuilder setVariable(String variableName, Object variableValue) {
        EnsureUtil.ensureNotNull(NotValidException.class, "variableName", (Object)variableName);
        this.ensureVariableShouldNotBeRemoved(variableName);
        this.ensureVariablesInitialized();
        this.variables.put(variableName, variableValue);
        return this;
    }

    @Override
    public CaseExecutionCommandBuilder setVariables(Map<String, Object> variables) {
        if (variables != null) {
            this.ensureVariablesShouldNotBeRemoved(variables.keySet());
            this.ensureVariablesInitialized();
            this.variables.putAll(variables);
        }
        return this;
    }

    @Override
    public CaseExecutionCommandBuilder setVariableLocal(String localVariableName, Object localVariableValue) {
        EnsureUtil.ensureNotNull(NotValidException.class, "localVariableName", (Object)localVariableName);
        this.ensureVariableShouldNotBeRemoved(localVariableName);
        this.ensureVariablesLocalInitialized();
        this.variablesLocal.put(localVariableName, localVariableValue);
        return this;
    }

    @Override
    public CaseExecutionCommandBuilder setVariablesLocal(Map<String, Object> variablesLocal) {
        if (variablesLocal != null) {
            this.ensureVariablesShouldNotBeRemoved(variablesLocal.keySet());
            this.ensureVariablesLocalInitialized();
            this.variablesLocal.putAll(variablesLocal);
        }
        return this;
    }

    @Override
    public CaseExecutionCommandBuilder removeVariable(String variableName) {
        EnsureUtil.ensureNotNull(NotValidException.class, "variableName", (Object)variableName);
        this.ensureVariableShouldNotBeSet(variableName);
        this.ensureVariableDeletionsInitialized();
        this.variableDeletions.add(variableName);
        return this;
    }

    @Override
    public CaseExecutionCommandBuilder removeVariables(Collection<String> variableNames) {
        if (variableNames != null) {
            this.ensureVariablesShouldNotBeSet(variableNames);
            this.ensureVariableDeletionsInitialized();
            this.variableDeletions.addAll(variableNames);
        }
        return this;
    }

    @Override
    public CaseExecutionCommandBuilder removeVariableLocal(String variableName) {
        EnsureUtil.ensureNotNull(NotValidException.class, "localVariableName", (Object)variableName);
        this.ensureVariableShouldNotBeSet(variableName);
        this.ensureVariableDeletionsLocalInitialized();
        this.variableLocalDeletions.add(variableName);
        return this;
    }

    @Override
    public CaseExecutionCommandBuilder removeVariablesLocal(Collection<String> variableNames) {
        if (variableNames != null) {
            this.ensureVariablesShouldNotBeSet(variableNames);
            this.ensureVariableDeletionsLocalInitialized();
            this.variableLocalDeletions.addAll(variableNames);
        }
        return this;
    }

    protected void ensureVariablesShouldNotBeRemoved(Collection<String> variableNames) {
        for (String variableName : variableNames) {
            this.ensureVariableShouldNotBeRemoved(variableName);
        }
    }

    protected void ensureVariableShouldNotBeRemoved(String variableName) {
        if (this.variableDeletions != null && this.variableDeletions.contains(variableName) || this.variableLocalDeletions != null && this.variableLocalDeletions.contains(variableName)) {
            throw new NotValidException("Cannot set and remove a variable with the same variable name: '" + variableName + "' within a command.");
        }
    }

    protected void ensureVariablesShouldNotBeSet(Collection<String> variableNames) {
        for (String variableName : variableNames) {
            this.ensureVariableShouldNotBeSet(variableName);
        }
    }

    protected void ensureVariableShouldNotBeSet(String variableName) {
        if (this.variables != null && this.variables.keySet().contains(variableName) || this.variablesLocal != null && this.variablesLocal.keySet().contains(variableName)) {
            throw new NotValidException("Cannot set and remove a variable with the same variable name: '" + variableName + "' within a command.");
        }
    }

    protected void ensureVariablesInitialized() {
        if (this.variables == null) {
            this.variables = new VariableMapImpl();
        }
    }

    protected void ensureVariablesLocalInitialized() {
        if (this.variablesLocal == null) {
            this.variablesLocal = new VariableMapImpl();
        }
    }

    protected void ensureVariableDeletionsInitialized() {
        if (this.variableDeletions == null) {
            this.variableDeletions = new ArrayList<String>();
        }
    }

    protected void ensureVariableDeletionsLocalInitialized() {
        if (this.variableLocalDeletions == null) {
            this.variableLocalDeletions = new ArrayList<String>();
        }
    }

    @Override
    public void execute() {
        CaseExecutionVariableCmd command = new CaseExecutionVariableCmd(this);
        this.executeCommand(command);
    }

    @Override
    public void manualStart() {
        ManualStartCaseExecutionCmd command = new ManualStartCaseExecutionCmd(this);
        this.executeCommand(command);
    }

    @Override
    public void disable() {
        DisableCaseExecutionCmd command = new DisableCaseExecutionCmd(this);
        this.executeCommand(command);
    }

    @Override
    public void reenable() {
        ReenableCaseExecutionCmd command = new ReenableCaseExecutionCmd(this);
        this.executeCommand(command);
    }

    @Override
    public void complete() {
        CompleteCaseExecutionCmd command = new CompleteCaseExecutionCmd(this);
        this.executeCommand(command);
    }

    @Override
    public void close() {
        CloseCaseInstanceCmd command = new CloseCaseInstanceCmd(this);
        this.executeCommand(command);
    }

    @Override
    public void terminate() {
        TerminateCaseExecutionCmd command = new TerminateCaseExecutionCmd(this);
        this.executeCommand(command);
    }

    protected void executeCommand(Command<?> command) {
        try {
            if (this.commandExecutor != null) {
                this.commandExecutor.execute(command);
            } else {
                command.execute(this.commandContext);
            }
        }
        catch (NullValueException e) {
            throw new NotValidException(e.getMessage(), e);
        }
        catch (CaseExecutionNotFoundException e) {
            throw new NotFoundException(e.getMessage(), e);
        }
        catch (CaseDefinitionNotFoundException e) {
            throw new NotFoundException(e.getMessage(), e);
        }
        catch (CaseIllegalStateTransitionException e) {
            throw new NotAllowedException(e.getMessage(), e);
        }
    }

    public String getCaseExecutionId() {
        return this.caseExecutionId;
    }

    public VariableMap getVariables() {
        return this.variables;
    }

    public VariableMap getVariablesLocal() {
        return this.variablesLocal;
    }

    public Collection<String> getVariableDeletions() {
        return this.variableDeletions;
    }

    public Collection<String> getVariableLocalDeletions() {
        return this.variableLocalDeletions;
    }
}

