/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt.telemetry;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.telemetry.dto.LicenseKeyDataImpl;
import org.camunda.bpm.engine.impl.test.RequiredDatabase;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.commons.testing.ProcessEngineLoggingRule;
import org.camunda.commons.testing.WatchLogger;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class TelemetryConfigurationTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule);
    @Rule
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule();
    protected ProcessEngineConfigurationImpl configuration;
    protected ManagementService managementService;
    protected IdentityService identityService;
    protected ProcessEngineConfigurationImpl inMemoryConfiguration;

    @Before
    public void init() {
        this.configuration = this.engineRule.getProcessEngineConfiguration();
        this.managementService = this.configuration.getManagementService();
        this.identityService = this.configuration.getIdentityService();
    }

    @After
    public void tearDown() {
        this.identityService.clearAuthentication();
        if (this.inMemoryConfiguration != null) {
            this.inMemoryConfiguration.setDatabaseSchemaUpdate("create-drop");
            ProcessEngineImpl processEngineImpl = this.inMemoryConfiguration.getProcessEngine();
            processEngineImpl.close();
            Object var1_1 = null;
        }
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldNotRecordUserOperationLog() {
        this.configuration.getIdentityService().setAuthenticatedUserId("admin");
        this.managementService.toggleTelemetry(true);
        Assertions.assertThat((List)this.configuration.getHistoryService().createUserOperationLogQuery().list()).isEmpty();
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.persistence"}, level="DEBUG")
    public void shouldNotLogDefaultTelemetryValue() {
        Assertions.assertThat((int)this.loggingRule.getFilteredLog(" telemetry ").size()).isZero();
    }

    @Test
    @RequiredDatabase(includes={"h2"})
    public void shouldStartEngineWithLicenseKeyAlreadyPresent() {
        String testLicenseKey = "signature=;my company;unlimited";
        this.inMemoryConfiguration = new StandaloneInMemProcessEngineConfiguration();
        this.inMemoryConfiguration.setJdbcUrl("jdbc:h2:mem:camunda-test" + this.getClass().getSimpleName()).setDatabaseSchemaUpdate("create").setDbMetricsReporterActivate(false);
        ProcessEngine processEngine = this.inMemoryConfiguration.buildProcessEngine();
        processEngine.getManagementService().setLicenseKey(testLicenseKey);
        processEngine.close();
        this.inMemoryConfiguration.buildProcessEngine();
        Assertions.assertThat((Object)this.inMemoryConfiguration.getDiagnosticsRegistry().getLicenseKey()).isEqualToComparingFieldByField((Object)new LicenseKeyDataImpl(null, null, null, null, null, "my company;unlimited"));
    }
}

