/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.suspensionstate;

import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyJobSuspensionStateTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String PROCESS_DEFINITION_KEY = "testProcess";
    protected static final BpmnModelInstance PROCESS = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().camundaAsyncBefore()).endEvent().done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void setUp() throws Exception {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, PROCESS);
        this.testRule.deploy(PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_TWO).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().execute();
    }

    @Test
    public void suspendAndActivateJobsForAllTenants() {
        JobQuery query = this.engineRule.getManagementService().createJobQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getManagementService().updateJobSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        this.engineRule.getManagementService().updateJobSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).activate();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
    }

    @Test
    public void suspendJobForTenant() {
        JobQuery query = this.engineRule.getManagementService().createJobQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getManagementService().updateJobSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void suspendJobsForNonTenant() {
        JobQuery query = this.engineRule.getManagementService().createJobQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getManagementService().updateJobSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void activateJobsForTenant() {
        this.engineRule.getManagementService().updateJobSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        JobQuery query = this.engineRule.getManagementService().createJobQuery();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        this.engineRule.getManagementService().updateJobSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).activate();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.active().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void activateJobsForNonTenant() {
        this.engineRule.getManagementService().updateJobSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        JobQuery query = this.engineRule.getManagementService().createJobQuery();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        this.engineRule.getManagementService().updateJobSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().activate();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.active().withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void suspendJobNoAuthenticatedTenants() {
        JobQuery query = this.engineRule.getManagementService().createJobQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getIdentityService().setAuthentication("user", null, null);
        this.engineRule.getManagementService().updateJobSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        this.engineRule.getIdentityService().clearAuthentication();
        Assertions.assertThat((long)query.active().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void suspendJobWithAuthenticatedTenant() {
        JobQuery query = this.engineRule.getManagementService().createJobQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getIdentityService().setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.engineRule.getManagementService().updateJobSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        this.engineRule.getIdentityService().clearAuthentication();
        Assertions.assertThat((long)query.active().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.active().tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().withoutTenantId().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void suspendJobDisabledTenantCheck() {
        JobQuery query = this.engineRule.getManagementService().createJobQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.engineRule.getIdentityService().setAuthentication("user", null, null);
        this.engineRule.getManagementService().updateJobSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeJobsWithoutTenantId().count()).isEqualTo(3L);
    }
}

