/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.variables;

import java.nio.charset.Charset;
import java.util.Map;
import java.util.Scanner;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.FileValue;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Assert;
import org.junit.Test;

public class FileValueProcessSerializationTest
extends PluggableProcessEngineTest {
    protected static final String ONE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/variables/oneTaskProcess.bpmn20.xml";

    @Test
    public void testSerializeFileVariable() {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"process").startEvent().userTask().endEvent().done();
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addModelInstance("process.bpmn", modelInstance).deploy();
        VariableMap variables = Variables.createVariables();
        String filename = "test.txt";
        String type = "text/plain";
        FileValue fileValue = (FileValue)Variables.fileValue((String)filename).file("ABC".getBytes()).encoding("UTF-8").mimeType(type).create();
        variables.put((Object)"file", (Object)fileValue);
        this.runtimeService.startProcessInstanceByKey("process", (Map)variables);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        VariableInstance result = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{task.getProcessInstanceId()}).singleResult();
        FileValue value = (FileValue)result.getTypedValue();
        Assertions.assertThat((String)value.getFilename()).isEqualTo((Object)filename);
        Assertions.assertThat((String)value.getMimeType()).isEqualTo((Object)type);
        Assertions.assertThat((String)value.getEncoding()).isEqualTo((Object)"UTF-8");
        Assertions.assertThat((Comparable)value.getEncodingAsCharset()).isEqualTo((Object)Charset.forName("UTF-8"));
        try (Scanner scanner = new Scanner(value.getValue());){
            Assertions.assertThat((String)scanner.nextLine()).isEqualTo((Object)"ABC");
        }
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/oneTaskProcess.bpmn20.xml"})
    public void testSerializeNullMimeType() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("fileVar", (Object)Variables.fileValue((String)"test.txt").file("ABC".getBytes()).encoding("UTF-8").create()));
        FileValue fileVar = (FileValue)this.runtimeService.getVariableTyped(pi.getId(), "fileVar");
        Assert.assertNull((Object)fileVar.getMimeType());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/oneTaskProcess.bpmn20.xml"})
    public void testSerializeNullMimeTypeAndNullEncoding() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("fileVar", (Object)Variables.fileValue((String)"test.txt").file("ABC".getBytes()).create()));
        FileValue fileVar = (FileValue)this.runtimeService.getVariableTyped(pi.getId(), "fileVar");
        Assert.assertNull((Object)fileVar.getMimeType());
        Assert.assertNull((Object)fileVar.getEncoding());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/oneTaskProcess.bpmn20.xml"})
    public void testSerializeNullEncoding() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("fileVar", (Object)Variables.fileValue((String)"test.txt").mimeType("some mimetype").file("ABC".getBytes()).create()));
        FileValue fileVar = (FileValue)this.runtimeService.getVariableTyped(pi.getId(), "fileVar");
        Assert.assertNull((Object)fileVar.getEncoding());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/oneTaskProcess.bpmn20.xml"})
    public void testSerializeNullValue() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("fileVar", (Object)Variables.fileValue((String)"test.txt").create()));
        FileValue fileVar = (FileValue)this.runtimeService.getVariableTyped(pi.getId(), "fileVar");
        Assert.assertNull((Object)fileVar.getMimeType());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/oneTaskProcess.bpmn20.xml"})
    public void testSerializeEmptyFileName() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("fileVar", (Object)Variables.fileValue((String)"").create()));
        FileValue fileVar = (FileValue)this.runtimeService.getVariableTyped(pi.getId(), "fileVar");
        Assert.assertEquals((Object)"", (Object)fileVar.getFilename());
    }
}

