/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.error;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.event.error.ThrowErrorDelegate;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.Assert;
import org.junit.Test;

public class ErrorEventSubProcessTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testEventSubprocessTakesPrecedence() {
        String procId = this.runtimeService.startProcessInstanceByKey("CatchErrorInEmbeddedSubProcess").getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment
    @Test
    public void testErrorCodeTakesPrecedence() {
        String procId = this.runtimeService.startProcessInstanceByKey("CatchErrorInEmbeddedSubProcess").getId();
        Assert.assertEquals((String)"No tasks found in task list.", (long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterErrorCatch2").count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"Escalated Task", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment
    @Test
    public void testCatchErrorInEmbeddedSubProcess() {
        String procId = this.runtimeService.startProcessInstanceByKey("CatchErrorInEmbeddedSubProcess").getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment
    @Test
    public void testCatchErrorThrownByScriptTaskInEmbeddedSubProcess() {
        String procId = this.runtimeService.startProcessInstanceByKey("CatchErrorThrownByScriptTaskInEmbeddedSubProcess").getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment
    @Test
    public void testCatchErrorThrownByScriptTaskInEmbeddedSubProcessWithErrorCode() {
        String procId = this.runtimeService.startProcessInstanceByKey("CatchErrorThrownByScriptTaskInEmbeddedSubProcessWithErrorCode").getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment
    @Test
    public void testCatchErrorThrownByScriptTaskInTopLevelProcess() {
        String procId = this.runtimeService.startProcessInstanceByKey("CatchErrorThrownByScriptTaskInTopLevelProcess").getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment
    @Test
    public void testCatchErrorThrownByScriptTaskInsideSubProcessInTopLevelProcess() {
        String procId = this.runtimeService.startProcessInstanceByKey("CatchErrorThrownByScriptTaskInsideSubProcessInTopLevelProcess").getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ErrorEventSubProcessTest.testThrowErrorInScriptTaskInsideCallActivitiCatchInTopLevelProcess.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByJavaDelegateOnCallActivity-child.bpmn20.xml"})
    @Test
    public void testThrowErrorInScriptTaskInsideCallActivitiCatchInTopLevelProcess() {
        String procId = this.runtimeService.startProcessInstanceByKey("testThrowErrorInScriptTaskInsideCallActivitiCatchInTopLevelProcess").getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ErrorEventSubProcessTest.testCatchErrorThrownByAbstractBpmnActivityBehavior.bpmn20.xml"})
    @Test
    public void testCatchExceptionThrownByExecuteOfAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", ThrowErrorDelegate.throwException()).getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskException", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ErrorEventSubProcessTest.testCatchErrorThrownByAbstractBpmnActivityBehavior.bpmn20.xml"})
    @Test
    public void testCatchErrorThrownByExecuteOfAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", ThrowErrorDelegate.throwError()).getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskError", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ErrorEventSubProcessTest.testCatchErrorThrownByAbstractBpmnActivityBehavior.bpmn20.xml"})
    @Test
    public void testCatchExceptionThrownBySignalOfAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess").getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult();
        Assert.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwException());
        this.runtimeService.signal(serviceTask.getId());
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskException", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ErrorEventSubProcessTest.testCatchErrorThrownByAbstractBpmnActivityBehavior.bpmn20.xml"})
    @Test
    public void testCatchErrorThrownBySignalOfAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess").getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult();
        Assert.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwError());
        this.runtimeService.signal(serviceTask.getId());
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskError", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ErrorEventSubProcessTest.testCatchErrorThrownByDelegateExpression.bpmn20.xml"})
    @Test
    public void testCatchExceptionThrownByExecuteOfDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        variables.putAll(ThrowErrorDelegate.throwException());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskException", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ErrorEventSubProcessTest.testCatchErrorThrownByDelegateExpression.bpmn20.xml"})
    @Test
    public void testCatchErrorThrownByExecuteOfDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        variables.putAll(ThrowErrorDelegate.throwError());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskError", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ErrorEventSubProcessTest.testCatchErrorThrownByDelegateExpression.bpmn20.xml"})
    @Test
    public void testCatchExceptionThrownBySignalOfDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult();
        Assert.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwException());
        this.runtimeService.signal(serviceTask.getId());
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskException", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ErrorEventSubProcessTest.testCatchErrorThrownByDelegateExpression.bpmn20.xml"})
    @Test
    public void testCatchErrorThrownBySignalOfDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult();
        Assert.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwError());
        this.runtimeService.signal(serviceTask.getId());
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)"userTaskError", (Object)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    private void assertThatErrorHasBeenCaught(String procId) {
        Assert.assertEquals((String)"No tasks found in task list.", (long)1L, (long)this.taskService.createTaskQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"Escalated Task", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(procId);
    }

    @Deployment
    @Test
    public void testCatchErrorEventSubprocessSetErrorVariables() {
        this.runtimeService.startProcessInstanceByKey("Process_1");
        String variableName = "errorCode";
        VariableInstance errorVariable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName(variableName).singleResult();
        Assertions.assertThat((Object)errorVariable).isNotNull();
        String errorCode = "error";
        Assertions.assertThat((Object)errorVariable.getValue()).isEqualTo((Object)errorCode);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ThrowErrorProcess.bpmn", "org/camunda/bpm/engine/test/bpmn/event/error/ErrorEventSubProcessTest.testCatchErrorFromCallActivitySetsErrorVariables.bpmn"})
    @Test
    public void testCatchErrorFromCallActivitySetsErrorVariable() {
        this.runtimeService.startProcessInstanceByKey("Process_1");
        String variableName = "errorCode";
        VariableInstance errorVariable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName(variableName).singleResult();
        Assertions.assertThat((Object)errorVariable).isNotNull();
        String errorCode = "error";
        Assertions.assertThat((Object)errorVariable.getValue()).isEqualTo((Object)errorCode);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ErrorEventSubProcessTest.testCatchBpmnErrorFromJavaDelegateInsideCallActivitySetsErrorVariable.bpmn", "org/camunda/bpm/engine/test/bpmn/callactivity/subProcessWithThrownError.bpmn"})
    @Test
    public void testCatchBpmnErrorFromJavaDelegateInsideCallActivitySetsErrorVariable() {
        this.runtimeService.startProcessInstanceByKey("Process_1");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        String variableName = "errorCode";
        String errorCode = "errorCode";
        VariableInstance errorVariable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName(variableName).singleResult();
        Assertions.assertThat((Object)errorVariable.getValue()).isEqualTo((Object)errorCode);
        errorVariable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("errorMessageVariable").singleResult();
        Assertions.assertThat((Object)errorVariable.getValue()).isEqualTo((Object)"ouch!");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ErrorEventSubProcessTest.testThrowErrorInLoop.bpmn20.xml"})
    @Test
    public void testShouldNotThrowErrorInLoop() {
        this.runtimeService.startProcessInstanceByKey("looping-error");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"WaitState", (Object)task.getName());
        this.taskService.complete(task.getId());
        Assert.assertEquals((Object)"ErrorHandlingUserTask", (Object)((Task)this.taskService.createTaskQuery().singleResult()).getName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ErrorEventSubProcessTest.testThrowErrorInLoopWithCallActivity.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/error/ThrowErrorToCallActivity.bpmn20.xml"})
    @Test
    public void testShouldNotThrowErrorInLoopWithCallActivity() {
        this.runtimeService.startProcessInstanceByKey("CallActivityErrorInLoop");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"ErrorLog", (Object)task.getName());
        this.taskService.complete(task.getId());
        Assert.assertEquals((Object)"ErrorHandlingUserTask", (Object)((Task)this.taskService.createTaskQuery().singleResult()).getName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ErrorEventSubProcessTest.testThrowErrorInLoopWithMultipleSubProcess.bpmn20.xml"})
    @Test
    public void testShouldNotThrowErrorInLoopForMultipleSubProcess() {
        this.runtimeService.startProcessInstanceByKey("looping-error");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"LoggerTask", (Object)task.getName());
        this.taskService.complete(task.getId());
        Assert.assertEquals((Object)"ErrorHandlingTask", (Object)((Task)this.taskService.createTaskQuery().singleResult()).getName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ErrorEventSubProcessTest.testThrowErrorInLoopFromCallActivityToEventSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/error/ThrowErrorToCallActivity.bpmn20.xml"})
    public void FAILING_testShouldNotThrowErrorInLoopFromCallActivityToEventSubProcess() {
        this.runtimeService.startProcessInstanceByKey("Process_1");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"userTask", (Object)task.getName());
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"ErrorLog", (Object)task.getName());
        this.taskService.complete(task.getId());
        Assert.assertEquals((Object)"BoundaryEventTask", (Object)((Task)this.taskService.createTaskQuery().singleResult()).getName());
    }

    @Deployment
    @Test
    public void testThrownAnErrorInEventSubprocessInSubprocessDifferentTransaction() {
        this.runtimeService.startProcessInstanceByKey("eventSubProcess");
        Task taskBefore = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)taskBefore);
        Assert.assertEquals((Object)"inside subprocess", (Object)taskBefore.getName());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        Task taskDuring = (Task)this.taskService.createTaskQuery().taskName("inside event sub").singleResult();
        Assert.assertNotNull((Object)taskDuring);
        this.taskService.complete(taskDuring.getId());
        Task taskAfter = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)taskAfter);
        Assert.assertEquals((Object)"after catch", (Object)taskAfter.getName());
        Job jobAfter = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNull((Object)jobAfter);
    }

    @Deployment
    @Test
    public void testThrownAnErrorInEventSubprocessInSubprocess() {
        this.runtimeService.startProcessInstanceByKey("eventSubProcess");
        Task taskBefore = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)taskBefore);
        Assert.assertEquals((Object)"inside subprocess", (Object)taskBefore.getName());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        Task taskAfter = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)taskAfter);
        Assert.assertEquals((Object)"after catch", (Object)taskAfter.getName());
        Job jobAfter = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNull((Object)jobAfter);
    }
}

