/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.interceptor;

import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.camunda.bpm.engine.test.standalone.interceptor.StartProcessInstanceOnEngineDelegate;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MultiEngineCommandContextTest {
    protected ProcessEngine engine1;
    protected ProcessEngine engine2;

    @Before
    public void startEngines() {
        this.engine1 = this.createProcessEngine("engine1");
        this.engine2 = this.createProcessEngine("engine2");
        StartProcessInstanceOnEngineDelegate.ENGINES.put("engine1", this.engine1);
        StartProcessInstanceOnEngineDelegate.ENGINES.put("engine2", this.engine2);
    }

    @After
    public void closeEngine1() {
        try {
            this.engine1.close();
        }
        finally {
            this.engine1 = null;
        }
    }

    @After
    public void closeEngine2() {
        try {
            this.engine2.close();
        }
        finally {
            this.engine2 = null;
        }
    }

    @After
    public void removeEngines() {
        StartProcessInstanceOnEngineDelegate.ENGINES.clear();
    }

    @Test
    public void shouldOpenNewCommandContextWhenInteractingAccrossEngines() {
        BpmnModelInstance process1 = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process1").startEvent().serviceTask().camundaInputParameter("engineName", "engine2")).camundaInputParameter("processKey", "process2")).camundaClass(StartProcessInstanceOnEngineDelegate.class.getName())).endEvent().done();
        BpmnModelInstance process2 = Bpmn.createExecutableProcess((String)"process2").startEvent().endEvent().done();
        this.engine1.getRepositoryService().createDeployment().addModelInstance("process1.bpmn", process1).deploy();
        this.engine2.getRepositoryService().createDeployment().addModelInstance("process2.bpmn", process2).deploy();
        this.engine1.getRuntimeService().startProcessInstanceByKey("process1");
    }

    @Test
    public void shouldOpenNewCommandContextWhenInteractingWithOtherEngineAndBack() {
        BpmnModelInstance process1 = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process1").startEvent().serviceTask().camundaInputParameter("engineName", "engine2")).camundaInputParameter("processKey", "process2")).camundaClass(StartProcessInstanceOnEngineDelegate.class.getName())).endEvent().done();
        BpmnModelInstance process2 = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process2").startEvent().serviceTask().camundaInputParameter("engineName", "engine1")).camundaInputParameter("processKey", "process3")).camundaClass(StartProcessInstanceOnEngineDelegate.class.getName())).done();
        BpmnModelInstance process3 = Bpmn.createExecutableProcess((String)"process3").startEvent().endEvent().done();
        this.engine1.getRepositoryService().createDeployment().addModelInstance("process1.bpmn", process1).deploy();
        this.engine2.getRepositoryService().createDeployment().addModelInstance("process2.bpmn", process2).deploy();
        this.engine1.getRepositoryService().createDeployment().addModelInstance("process3.bpmn", process3).deploy();
        this.engine1.getRuntimeService().startProcessInstanceByKey("process1");
    }

    private ProcessEngine createProcessEngine(String name) {
        StandaloneInMemProcessEngineConfiguration processEngineConfiguration = new StandaloneInMemProcessEngineConfiguration();
        processEngineConfiguration.setProcessEngineName(name);
        processEngineConfiguration.setJdbcUrl(String.format("jdbc:h2:mem:%s", name));
        processEngineConfiguration.setEnforceHistoryTimeToLive(false);
        return processEngineConfiguration.buildProcessEngine();
    }
}

