/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.compensate;

import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@RequiredHistoryLevel(value="audit")
public class CompensateEventHistoryTest
extends PluggableProcessEngineTest {
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventHistoryTest.testBoundaryCompensationHandlerHistory.bpmn20.xml"})
    @Test
    public void testBoundaryCompensationHandlerHistoryActivityInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("boundaryHandlerProcess");
        Task beforeCompensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeCompensationTask.getId());
        String compensationHandlerActivityInstanceId = this.runtimeService.getActivityInstance(processInstance.getId()).getActivityInstances("compensationHandler")[0].getId();
        Task compensationHandler = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(compensationHandler.getId());
        HistoricActivityInstance historicCompensationHandlerInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("compensationHandler").singleResult();
        Assert.assertNotNull((Object)historicCompensationHandlerInstance);
        Assert.assertEquals((Object)compensationHandlerActivityInstanceId, (Object)historicCompensationHandlerInstance.getId());
        Assert.assertEquals((Object)processInstance.getId(), (Object)historicCompensationHandlerInstance.getParentActivityInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventHistoryTest.testBoundaryCompensationHandlerHistory.bpmn20.xml"})
    @Ignore(value="Fix CAM-4351")
    @Test
    public void testBoundaryCompensationHandlerHistoryVariableInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("boundaryHandlerProcess");
        Task beforeCompensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeCompensationTask.getId());
        String compensationHandlerActivityInstanceId = this.runtimeService.getActivityInstance(processInstance.getId()).getActivityInstances("compensationHandler")[0].getId();
        Task compensationHandler = (Task)this.taskService.createTaskQuery().singleResult();
        this.runtimeService.setVariableLocal(compensationHandler.getExecutionId(), "apiVariable", (Object)"someValue");
        this.taskService.complete(compensationHandler.getId());
        HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)historicVariableInstance);
        Assert.assertEquals((Object)compensationHandlerActivityInstanceId, (Object)historicVariableInstance.getActivityInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventHistoryTest.testDefaultCompensationHandlerHistory.bpmn20.xml"})
    @Test
    public void testDefaultCompensationHandlerHistoryActivityInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("defaultHandlerProcess");
        Task beforeCompensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeCompensationTask.getId());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        String compensationHandlerActivityInstanceId = tree.getActivityInstances("compensationHandler")[0].getId();
        String subProcessActivityInstanceId = tree.getActivityInstances("subProcess")[0].getId();
        Task compensationHandler = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(compensationHandler.getId());
        HistoricActivityInstance historicCompensationHandlerInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("compensationHandler").singleResult();
        Assert.assertNotNull((Object)historicCompensationHandlerInstance);
        Assert.assertEquals((Object)compensationHandlerActivityInstanceId, (Object)historicCompensationHandlerInstance.getId());
        Assert.assertEquals((Object)subProcessActivityInstanceId, (Object)historicCompensationHandlerInstance.getParentActivityInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventHistoryTest.testDefaultCompensationHandlerHistory.bpmn20.xml"})
    @Ignore(value="Fix CAM-4351")
    @Test
    public void testDefaultCompensationHandlerHistoryVariableInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("defaultHandlerProcess");
        Task beforeCompensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeCompensationTask.getId());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        String compensationHandlerActivityInstanceId = tree.getActivityInstances("compensationHandler")[0].getId();
        Task compensationHandler = (Task)this.taskService.createTaskQuery().singleResult();
        this.runtimeService.setVariableLocal(compensationHandler.getExecutionId(), "apiVariable", (Object)"someValue");
        this.taskService.complete(compensationHandler.getId());
        HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)historicVariableInstance);
        Assert.assertEquals((Object)compensationHandlerActivityInstanceId, (Object)historicVariableInstance.getActivityInstanceId());
    }
}

