/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history.removaltime.cleanup;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import org.apache.commons.lang3.time.DateUtils;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.history.removaltime.cleanup.AbstractHistoryCleanupSchedulerTest;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BusinessRuleTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class HistoryCleanupSchedulerDecisionsTest
extends AbstractHistoryCleanupSchedulerTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> HistoryCleanupSchedulerDecisionsTest.configure(configuration, HistoryEventTypes.DMN_DECISION_EVALUATE));
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected final String CALLING_PROCESS_CALLS_DMN_KEY = "callingProcessCallsDmn";
    protected final BpmnModelInstance CALLING_PROCESS_CALLS_DMN = ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((BusinessRuleTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"callingProcessCallsDmn").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().businessRuleTask().camundaDecisionRef("dish-decision")).multiInstance().sequential()).cardinality("5")).multiInstanceDone().endEvent().done();
    protected final Date END_DATE = new GregorianCalendar(2013, 2, 18, 13, 0, 0).getTime();

    @Before
    public void init() {
        engineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.initEngineConfiguration(engineConfiguration);
        this.historyService = this.engineRule.getHistoryService();
        this.managementService = this.engineRule.getManagementService();
        this.runtimeService = this.engineRule.getRuntimeService();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldScheduleToNowByDecisionInputs() {
        this.testRule.deploy(this.CALLING_PROCESS_CALLS_DMN);
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcessCallsDmn", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        engineConfiguration.setHistoryCleanupBatchSize(20);
        engineConfiguration.initHistoryCleanup();
        Date removalTime = DateUtils.addDays((Date)this.END_DATE, (int)5);
        ClockUtil.setCurrentTime((Date)removalTime);
        this.runHistoryCleanup();
        Job job = (Job)this.historyService.findHistoryCleanupJobs().get(0);
        Assertions.assertThat((Date)job.getDuedate()).isEqualTo((Object)removalTime);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldScheduleToLaterByDecisionInputs() {
        this.testRule.deploy(this.CALLING_PROCESS_CALLS_DMN);
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcessCallsDmn", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        engineConfiguration.setHistoryCleanupBatchSize(21);
        engineConfiguration.initHistoryCleanup();
        Date removalTime = DateUtils.addDays((Date)this.END_DATE, (int)5);
        ClockUtil.setCurrentTime((Date)removalTime);
        this.runHistoryCleanup();
        Job job = (Job)this.historyService.findHistoryCleanupJobs().get(0);
        Assertions.assertThat((Date)job.getDuedate()).isEqualTo((Object)DateUtils.addSeconds((Date)removalTime, (int)10));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/history/removaltime/cleanup/decisonWithThreeOutputs.dmn11.xml"})
    public void shouldScheduleToNowByDecisionOutputs() {
        this.testRule.deploy(this.CALLING_PROCESS_CALLS_DMN);
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcessCallsDmn", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        engineConfiguration.setHistoryCleanupBatchSize(25);
        engineConfiguration.initHistoryCleanup();
        Date removalTime = DateUtils.addDays((Date)this.END_DATE, (int)5);
        ClockUtil.setCurrentTime((Date)removalTime);
        this.runHistoryCleanup();
        Job job = (Job)this.historyService.findHistoryCleanupJobs().get(0);
        Assertions.assertThat((Date)job.getDuedate()).isEqualTo((Object)removalTime);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/history/removaltime/cleanup/decisonWithThreeOutputs.dmn11.xml"})
    public void shouldScheduleToLaterByDecisionOutputs() {
        this.testRule.deploy(this.CALLING_PROCESS_CALLS_DMN);
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcessCallsDmn", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        engineConfiguration.setHistoryCleanupBatchSize(26);
        engineConfiguration.initHistoryCleanup();
        Date removalTime = DateUtils.addDays((Date)this.END_DATE, (int)5);
        ClockUtil.setCurrentTime((Date)removalTime);
        this.runHistoryCleanup();
        Job job = (Job)this.historyService.findHistoryCleanupJobs().get(0);
        Assertions.assertThat((Date)job.getDuedate()).isEqualTo((Object)DateUtils.addSeconds((Date)removalTime, (int)10));
    }
}

