/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.runtime.ExecutionQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.BatchHelper;
import org.camunda.bpm.engine.test.util.BatchRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.SerializationDataFormat;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class CorrelateAllMessageBatchTest {
    protected static final String PROCESS_ONE_KEY = "process";
    protected static final String PROCESS_TWO_KEY = "process-two";
    protected static final String PROCESS_THREE_KEY = "process-three";
    protected static final String MESSAGE_ONE_REF = "message";
    protected static final String MESSAGE_TWO_REF = "message-two";
    protected static final Date TEST_DATE = new Date(1457326800000L);
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule engineTestRule = new ProcessEngineTestRule(this.engineRule);
    protected BatchRule rule = new BatchRule(this.engineRule, this.engineTestRule);
    protected BatchHelper helper = new BatchHelper(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.engineTestRule).around((TestRule)this.rule);
    protected RuntimeService runtimeService;
    protected HistoryService historyService;
    protected ManagementService managementService;

    @Before
    public void assignServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
        this.managementService = this.engineRule.getManagementService();
    }

    @Before
    public void deployProcessIntermediateMessageOne() {
        BpmnModelInstance process = ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ONE_KEY).startEvent().intermediateCatchEvent("messageCatch").message(MESSAGE_ONE_REF)).userTask("task").endEvent().done();
        this.engineTestRule.deploy(process);
    }

    @After
    public void clearAuthentication() {
        this.engineRule.getIdentityService().setAuthenticatedUserId(null);
    }

    @After
    public void resetConfiguration() {
        ClockUtil.reset();
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(1);
    }

    @Test
    public void shouldCorrelateAllWithInstanceIds() {
        this.deployProcessIntermediateMessageTwo();
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey(PROCESS_ONE_KEY).getId();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey(PROCESS_ONE_KEY).getId();
        String processInstanceIdThree = this.runtimeService.startProcessInstanceByKey(PROCESS_TWO_KEY).getId();
        List<String> processInstances = Arrays.asList(processInstanceIdOne, processInstanceIdThree);
        Batch batch = this.runtimeService.createMessageCorrelationAsync(MESSAGE_ONE_REF).processInstanceIds(processInstances).correlateAllAsync();
        ExecutionQuery taskExecutionQueryInstanceOne = this.runtimeService.createExecutionQuery().activityId("task").processInstanceId(processInstanceIdOne);
        ExecutionQuery taskExecutionQueryInstanceTwo = this.runtimeService.createExecutionQuery().activityId("task").processInstanceId(processInstanceIdTwo);
        ExecutionQuery taskExecutionQueryInstanceThree = this.runtimeService.createExecutionQuery().activityId("task").processInstanceId(processInstanceIdThree);
        Assertions.assertThat((long)taskExecutionQueryInstanceOne.count()).isEqualTo(0L);
        Assertions.assertThat((long)taskExecutionQueryInstanceTwo.count()).isEqualTo(0L);
        Assertions.assertThat((long)taskExecutionQueryInstanceThree.count()).isEqualTo(0L);
        this.rule.syncExec(batch);
        Assertions.assertThat((long)taskExecutionQueryInstanceOne.count()).isEqualTo(1L);
        Assertions.assertThat((long)taskExecutionQueryInstanceTwo.count()).isEqualTo(0L);
        Assertions.assertThat((long)taskExecutionQueryInstanceThree.count()).isEqualTo(0L);
    }

    @Test
    public void shouldCorrelateAllWithInstanceQuery() {
        this.deployProcessIntermediateMessageTwo();
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey(PROCESS_ONE_KEY).getId();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey(PROCESS_ONE_KEY).getId();
        String processInstanceIdThree = this.runtimeService.startProcessInstanceByKey(PROCESS_TWO_KEY).getId();
        ProcessInstanceQuery runtimeQuery = this.runtimeService.createProcessInstanceQuery().processInstanceIds(Stream.of(processInstanceIdOne, processInstanceIdThree).collect(Collectors.toSet()));
        Batch batch = this.runtimeService.createMessageCorrelationAsync(MESSAGE_ONE_REF).processInstanceQuery(runtimeQuery).correlateAllAsync();
        ExecutionQuery taskExecutionQueryInstanceOne = this.runtimeService.createExecutionQuery().activityId("task").processInstanceId(processInstanceIdOne);
        ExecutionQuery taskExecutionQueryInstanceTwo = this.runtimeService.createExecutionQuery().activityId("task").processInstanceId(processInstanceIdTwo);
        ExecutionQuery taskExecutionQueryInstanceThree = this.runtimeService.createExecutionQuery().activityId("task").processInstanceId(processInstanceIdThree);
        Assertions.assertThat((long)taskExecutionQueryInstanceOne.count()).isEqualTo(0L);
        Assertions.assertThat((long)taskExecutionQueryInstanceTwo.count()).isEqualTo(0L);
        Assertions.assertThat((long)taskExecutionQueryInstanceThree.count()).isEqualTo(0L);
        this.rule.syncExec(batch);
        Assertions.assertThat((long)taskExecutionQueryInstanceOne.count()).isEqualTo(1L);
        Assertions.assertThat((long)taskExecutionQueryInstanceTwo.count()).isEqualTo(0L);
        Assertions.assertThat((long)taskExecutionQueryInstanceThree.count()).isEqualTo(0L);
    }

    @Test
    public void shouldCorrelateAllWithHistoricInstanceQuery() {
        this.deployProcessIntermediateMessageTwo();
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey(PROCESS_ONE_KEY).getId();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey(PROCESS_ONE_KEY).getId();
        String processInstanceIdThree = this.runtimeService.startProcessInstanceByKey(PROCESS_TWO_KEY).getId();
        HistoricProcessInstanceQuery historyQuery = this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(Stream.of(processInstanceIdOne, processInstanceIdThree).collect(Collectors.toSet()));
        Batch batch = this.runtimeService.createMessageCorrelationAsync(MESSAGE_ONE_REF).historicProcessInstanceQuery(historyQuery).correlateAllAsync();
        ExecutionQuery taskExecutionQueryInstanceOne = this.runtimeService.createExecutionQuery().activityId("task").processInstanceId(processInstanceIdOne);
        ExecutionQuery taskExecutionQueryInstanceTwo = this.runtimeService.createExecutionQuery().activityId("task").processInstanceId(processInstanceIdTwo);
        ExecutionQuery taskExecutionQueryInstanceThree = this.runtimeService.createExecutionQuery().activityId("task").processInstanceId(processInstanceIdThree);
        Assertions.assertThat((long)taskExecutionQueryInstanceOne.count()).isEqualTo(0L);
        Assertions.assertThat((long)taskExecutionQueryInstanceTwo.count()).isEqualTo(0L);
        Assertions.assertThat((long)taskExecutionQueryInstanceThree.count()).isEqualTo(0L);
        this.rule.syncExec(batch);
        Assertions.assertThat((long)taskExecutionQueryInstanceOne.count()).isEqualTo(1L);
        Assertions.assertThat((long)taskExecutionQueryInstanceTwo.count()).isEqualTo(0L);
        Assertions.assertThat((long)taskExecutionQueryInstanceThree.count()).isEqualTo(0L);
    }

    @Test
    public void shouldCorrelateAllWithoutMessage() {
        this.deployProcessIntermediateMessageTwo();
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey(PROCESS_ONE_KEY).getId();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey(PROCESS_ONE_KEY).getId();
        String processInstanceIdThree = this.runtimeService.startProcessInstanceByKey(PROCESS_TWO_KEY).getId();
        List<String> processInstances = Arrays.asList(processInstanceIdOne, processInstanceIdThree);
        Batch batch = this.runtimeService.createMessageCorrelationAsync(null).processInstanceIds(processInstances).correlateAllAsync();
        ExecutionQuery taskExecutionQueryInstanceOne = this.runtimeService.createExecutionQuery().activityId("task").processInstanceId(processInstanceIdOne);
        ExecutionQuery taskExecutionQueryInstanceTwo = this.runtimeService.createExecutionQuery().activityId("task").processInstanceId(processInstanceIdTwo);
        ExecutionQuery taskExecutionQueryInstanceThree = this.runtimeService.createExecutionQuery().activityId("task").processInstanceId(processInstanceIdThree);
        Assertions.assertThat((long)taskExecutionQueryInstanceOne.count()).isEqualTo(0L);
        Assertions.assertThat((long)taskExecutionQueryInstanceTwo.count()).isEqualTo(0L);
        Assertions.assertThat((long)taskExecutionQueryInstanceThree.count()).isEqualTo(0L);
        this.rule.syncExec(batch);
        Assertions.assertThat((long)taskExecutionQueryInstanceOne.count()).isEqualTo(1L);
        Assertions.assertThat((long)taskExecutionQueryInstanceTwo.count()).isEqualTo(0L);
        Assertions.assertThat((long)taskExecutionQueryInstanceThree.count()).isEqualTo(1L);
    }

    @Test
    public void shouldNotCorrelateStartMessageEvent() {
        this.deployProcessStartMessageOne();
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey(PROCESS_ONE_KEY).getId();
        List<String> processInstances = Arrays.asList(processInstanceIdOne);
        Batch batch = this.runtimeService.createMessageCorrelationAsync(MESSAGE_ONE_REF).processInstanceIds(processInstances).correlateAllAsync();
        ExecutionQuery taskExecutionQueryInstanceOne = this.runtimeService.createExecutionQuery().activityId("task").processInstanceId(processInstanceIdOne);
        ExecutionQuery taskExecutionQueryInstanceThree = this.runtimeService.createExecutionQuery().activityId("task").processDefinitionKey(PROCESS_THREE_KEY);
        Assertions.assertThat((long)taskExecutionQueryInstanceOne.count()).isEqualTo(0L);
        Assertions.assertThat((long)taskExecutionQueryInstanceThree.count()).isEqualTo(0L);
        this.rule.syncExec(batch);
        Assertions.assertThat((long)taskExecutionQueryInstanceOne.count()).isEqualTo(1L);
        Assertions.assertThat((long)taskExecutionQueryInstanceThree.count()).isEqualTo(0L);
    }

    @Test
    public void shouldSetVariablesOnCorrelation() {
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey(PROCESS_ONE_KEY).getId();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey(PROCESS_ONE_KEY).getId();
        List<String> processInstances = Arrays.asList(processInstanceIdOne, processInstanceIdTwo);
        Batch batch = this.runtimeService.createMessageCorrelationAsync(MESSAGE_ONE_REF).processInstanceIds(processInstances).setVariable("foo", (Object)"bar").correlateAllAsync();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting(new String[]{"processInstanceId", "name", "value", "batchId"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{null, "foo", "bar", batch.getId()})});
        this.rule.syncExec(batch);
        Assertions.assertThat((List)query.list()).extracting(new String[]{"processInstanceId", "name", "value"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processInstanceIdOne, "foo", "bar"}), Assertions.tuple((Object[])new Object[]{processInstanceIdTwo, "foo", "bar"})});
    }

    @Test
    public void shouldThrowException_NoProcessInstancesFound() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.createMessageCorrelationAsync(MESSAGE_ONE_REF).processInstanceIds(Collections.emptyList()).correlateAllAsync()).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("process instance ids is empty");
    }

    @Test
    public void shouldThrowException_QueriesAndIdsNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.createMessageCorrelationAsync(MESSAGE_ONE_REF).correlateAllAsync()).isInstanceOf(NullValueException.class)).hasMessageContaining("No process instances found");
    }

    @Test
    public void shouldThrowException_NullProcessInstanceIds() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.createMessageCorrelationAsync(MESSAGE_ONE_REF).processInstanceIds(null).correlateAllAsync()).isInstanceOf(NullValueException.class)).hasMessageContaining("processInstanceIds");
    }

    @Test
    public void shouldThrowException_NullProcessInstanceQuery() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.createMessageCorrelationAsync(MESSAGE_ONE_REF).processInstanceQuery(null).correlateAllAsync()).isInstanceOf(NullValueException.class)).hasMessageContaining("processInstanceQuery");
    }

    @Test
    public void shouldThrowException_NullHistoricProcessInstanceQuery() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.createMessageCorrelationAsync(MESSAGE_ONE_REF).historicProcessInstanceQuery(null).correlateAllAsync()).isInstanceOf(NullValueException.class)).hasMessageContaining("historicProcessInstanceQuery");
    }

    @Test
    public void shouldThrowException_NullVariableName() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.createMessageCorrelationAsync(MESSAGE_ONE_REF).setVariable(null, (Object)"bar").correlateAllAsync()).isInstanceOf(NullValueException.class)).hasMessageContaining("variableName");
    }

    @Test
    public void shouldThrowException_JavaSerializationForbidden() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_ONE_KEY);
        ProcessInstanceQuery runtimeQuery = this.runtimeService.createProcessInstanceQuery();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.createMessageCorrelationAsync(MESSAGE_ONE_REF).processInstanceQuery(runtimeQuery).setVariables((Map)Variables.putValue((String)"foo", (Object)Variables.serializedObjectValue().serializedValue("foo").serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).create())).correlateAllAsync()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("ENGINE-17007 Cannot set variable with name foo. Java serialization format is prohibited");
    }

    @Test
    public void shouldCreateDeploymentAwareBatchJobs_ByIds() {
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(2);
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey(PROCESS_ONE_KEY).getId();
        this.deployProcessIntermediateMessageOne();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey(PROCESS_ONE_KEY).getId();
        List list = this.engineRule.getRepositoryService().createDeploymentQuery().list();
        String deploymentIdOne = ((Deployment)list.get(0)).getId();
        String deploymentIdTwo = ((Deployment)list.get(1)).getId();
        List<String> processInstances = Arrays.asList(processInstanceIdOne, processInstanceIdTwo);
        Batch batch = this.runtimeService.createMessageCorrelationAsync(MESSAGE_ONE_REF).processInstanceIds(processInstances).correlateAllAsync();
        this.rule.executeSeedJobs(batch);
        List<Job> executionJobs = this.rule.getExecutionJobs(batch);
        Assertions.assertThat(executionJobs).extracting("deploymentId").containsExactlyInAnyOrder(new Object[]{deploymentIdOne, deploymentIdTwo});
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Test
    public void shouldCreateDeploymentAwareBatchJobs_ByRuntimeQuery() {
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(2);
        this.runtimeService.startProcessInstanceByKey(PROCESS_ONE_KEY);
        this.deployProcessIntermediateMessageOne();
        this.runtimeService.startProcessInstanceByKey(PROCESS_ONE_KEY);
        List list = this.engineRule.getRepositoryService().createDeploymentQuery().list();
        String deploymentIdOne = ((Deployment)list.get(0)).getId();
        String deploymentIdTwo = ((Deployment)list.get(1)).getId();
        ProcessInstanceQuery runtimeQuery = this.runtimeService.createProcessInstanceQuery();
        Batch batch = this.runtimeService.createMessageCorrelationAsync(MESSAGE_ONE_REF).processInstanceQuery(runtimeQuery).correlateAllAsync();
        this.rule.executeSeedJobs(batch);
        List<Job> executionJobs = this.rule.getExecutionJobs(batch);
        Assertions.assertThat(executionJobs).extracting("deploymentId").containsExactlyInAnyOrder(new Object[]{deploymentIdOne, deploymentIdTwo});
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Test
    @RequiredHistoryLevel(value="activity")
    public void shouldCreateDeploymentAwareBatchJobs_ByHistoryQuery() {
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(2);
        this.runtimeService.startProcessInstanceByKey(PROCESS_ONE_KEY);
        this.deployProcessIntermediateMessageOne();
        this.runtimeService.startProcessInstanceByKey(PROCESS_ONE_KEY);
        List list = this.engineRule.getRepositoryService().createDeploymentQuery().list();
        String deploymentIdOne = ((Deployment)list.get(0)).getId();
        String deploymentIdTwo = ((Deployment)list.get(1)).getId();
        HistoricProcessInstanceQuery historyQuery = this.historyService.createHistoricProcessInstanceQuery();
        Batch batch = this.runtimeService.createMessageCorrelationAsync(MESSAGE_ONE_REF).historicProcessInstanceQuery(historyQuery).correlateAllAsync();
        this.rule.executeSeedJobs(batch);
        List<Job> executionJobs = this.rule.getExecutionJobs(batch);
        Assertions.assertThat(executionJobs).extracting("deploymentId").containsExactlyInAnyOrder(new Object[]{deploymentIdOne, deploymentIdTwo});
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldLogOperation() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_ONE_KEY);
        this.engineRule.getIdentityService().setAuthenticatedUserId("demo");
        ProcessInstanceQuery runtimeQuery = this.runtimeService.createProcessInstanceQuery();
        Batch batch = this.runtimeService.createMessageCorrelationAsync(MESSAGE_ONE_REF).processInstanceQuery(runtimeQuery).setVariable("foo", (Object)"bar").correlateAllAsync();
        List logs = this.historyService.createUserOperationLogQuery().list();
        Assertions.assertThat((List)logs).extracting(new String[]{"property", "orgValue", "newValue", "operationType", "entityType", "category", "userId"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"messageName", null, MESSAGE_ONE_REF, "CorrelateMessage", "ProcessInstance", "Operator", "demo"}), Assertions.tuple((Object[])new Object[]{"nrOfInstances", null, "1", "CorrelateMessage", "ProcessInstance", "Operator", "demo"}), Assertions.tuple((Object[])new Object[]{"nrOfVariables", null, "1", "CorrelateMessage", "ProcessInstance", "Operator", "demo"}), Assertions.tuple((Object[])new Object[]{"async", null, "true", "CorrelateMessage", "ProcessInstance", "Operator", "demo"})});
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldNotLogInstanceOperation() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_ONE_KEY);
        ProcessInstanceQuery runtimeQuery = this.runtimeService.createProcessInstanceQuery();
        Batch batch = this.runtimeService.createMessageCorrelationAsync(MESSAGE_ONE_REF).processInstanceQuery(runtimeQuery).setVariable("foo", (Object)"bar").correlateAllAsync();
        List logs = this.historyService.createUserOperationLogQuery().operationType("SetVariable").list();
        Assertions.assertThat((int)logs.size()).isEqualTo(0);
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Test
    public void shouldCreateProcessInstanceRelatedBatchJobsForSingleInvocations() {
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey(PROCESS_ONE_KEY).getId();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey(PROCESS_ONE_KEY).getId();
        List<String> processInstanceIds = Arrays.asList(processInstanceIdOne, processInstanceIdTwo);
        Batch batch = this.runtimeService.createMessageCorrelationAsync(MESSAGE_ONE_REF).processInstanceIds(processInstanceIds).correlateAllAsync();
        this.rule.executeSeedJobs(batch);
        List<Job> executionJobs = this.rule.getExecutionJobs(batch);
        Assertions.assertThat(executionJobs).extracting("processInstanceId").containsExactlyInAnyOrder(new Object[]{processInstanceIdOne, processInstanceIdTwo});
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Test
    public void shouldNotCreateProcessInstanceRelatedBatchJobsForMultipleInvocations() {
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(2);
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey(PROCESS_ONE_KEY).getId();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey(PROCESS_ONE_KEY).getId();
        List<String> processInstanceIds = Arrays.asList(processInstanceIdOne, processInstanceIdTwo);
        Batch batch = this.runtimeService.createMessageCorrelationAsync(MESSAGE_ONE_REF).processInstanceIds(processInstanceIds).correlateAllAsync();
        this.rule.executeSeedJobs(batch);
        List<Job> executionJobs = this.rule.getExecutionJobs(batch);
        Assertions.assertThat(executionJobs).extracting("processInstanceId").containsOnlyNulls();
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldSetExecutionStartTimeInBatchAndHistory() {
        ClockUtil.setCurrentTime((Date)TEST_DATE);
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey(PROCESS_ONE_KEY).getId();
        Batch batch = this.runtimeService.createMessageCorrelationAsync(MESSAGE_ONE_REF).processInstanceIds(Collections.singletonList(processInstanceIdOne)).correlateAllAsync();
        this.helper.executeSeedJob(batch);
        List<Job> executionJobs = this.helper.getExecutionJobs(batch, "correlate-message");
        this.helper.executeJob(executionJobs.get(0));
        HistoricBatch historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().singleResult();
        batch = (Batch)this.managementService.createBatchQuery().singleResult();
        Assertions.assertThat((Date)batch.getExecutionStartTime()).isEqualToIgnoringMillis(TEST_DATE);
        Assertions.assertThat((Date)historicBatch.getExecutionStartTime()).isEqualToIgnoringMillis(TEST_DATE);
        this.managementService.deleteBatch(batch.getId(), true);
    }

    protected void deployProcessIntermediateMessageTwo() {
        BpmnModelInstance process = ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_TWO_KEY).startEvent().intermediateCatchEvent().message(MESSAGE_TWO_REF)).userTask("task").endEvent().done();
        this.engineTestRule.deploy(process);
    }

    protected void deployProcessStartMessageOne() {
        BpmnModelInstance process = ((StartEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_THREE_KEY).startEvent().message(MESSAGE_ONE_REF)).userTask("task").endEvent().done();
        this.engineTestRule.deploy(process);
    }
}

