/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.management.ActivityStatistics;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.migration.MigratingProcessInstanceValidationException;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.api.runtime.migration.util.AccessModelInstanceTaskListener;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ClockTestUtil;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.engine.test.util.MigratingProcessInstanceValidationReportAssert;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.bpm.model.bpmn.instance.BpmnModelElementInstance;
import org.camunda.bpm.model.bpmn.instance.UserTask;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaTaskListener;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationUserTaskTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Test
    public void testUserTaskMigrationInProcessDefinitionScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree("userTask").scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).done());
        Task task = this.testHelper.snapshotBeforeMigration.getTaskForKey("userTask");
        Task migratedTask = this.testHelper.snapshotAfterMigration.getTaskForKey("userTask");
        Assert.assertEquals((Object)task.getId(), (Object)migratedTask.getId());
        this.rule.getTaskService().complete(migratedTask.getId());
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testUserTaskMigrationInSubProcessScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("userTask")).done());
        Task task = this.testHelper.snapshotBeforeMigration.getTaskForKey("userTask");
        Task migratedTask = this.testHelper.snapshotAfterMigration.getTaskForKey("userTask");
        Assert.assertEquals((Object)task.getId(), (Object)migratedTask.getId());
        Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)migratedTask.getProcessDefinitionId());
        this.rule.getTaskService().complete(migratedTask.getId());
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testConcurrentUserTaskMigration() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask1").concurrent().noScope().up().child("userTask2").concurrent().noScope().done());
        List<Task> migratedTasks = this.testHelper.snapshotAfterMigration.getTasks();
        Assert.assertEquals((long)2L, (long)migratedTasks.size());
        for (Task migratedTask : migratedTasks) {
            Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)migratedTask.getProcessDefinitionId());
        }
        for (Task migratedTask : migratedTasks) {
            this.rule.getTaskService().complete(migratedTask.getId());
        }
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testCannotMigrateWhenNotAllActivityInstancesAreMapped() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").build();
        try {
            this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
            Assert.fail((String)"should not succeed because the userTask2 instance is not mapped");
        }
        catch (MigratingProcessInstanceValidationException e) {
            MigratingProcessInstanceValidationReportAssert.assertThat(e.getValidationReport()).hasActivityInstanceFailures("userTask2", "There is no migration instruction for this instance's activity");
        }
    }

    @Test
    public void testCannotMigrateWhenNotAllTransitionInstancesAreMapped() {
        BpmnModelInstance model = ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).activityBuilder("userTask1").camundaAsyncBefore().moveToActivity("userTask2").camundaAsyncBefore().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").build();
        try {
            this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
            Assert.fail((String)"should not succeed because the userTask2 instance is not mapped");
        }
        catch (MigratingProcessInstanceValidationException e) {
            MigratingProcessInstanceValidationReportAssert.assertThat(e.getValidationReport()).hasTransitionInstanceFailures("userTask2", "There is no migration instruction for this instance's activity");
        }
    }

    @Test
    public void testChangeActivityId() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask2").build();
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)this.rule.getRuntimeService().createProcessInstanceById(sourceProcessDefinition.getId()).startBeforeActivity("userTask1")).execute();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree("userTask2").scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask2", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask1").getId()).done());
        Task migratedTask = this.testHelper.snapshotAfterMigration.getTaskForKey("userTask2");
        Assert.assertNotNull((Object)migratedTask);
        Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)migratedTask.getProcessDefinitionId());
        Assert.assertEquals((Object)"userTask2", (Object)migratedTask.getTaskDefinitionKey());
        this.rule.getTaskService().complete(migratedTask.getId());
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateWithSubTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        Task task = (Task)this.rule.getTaskService().createTaskQuery().singleResult();
        Task subTask = this.rule.getTaskService().newTask();
        subTask.setParentTaskId(task.getId());
        this.rule.getTaskService().saveTask(subTask);
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Task subTaskAfterMigration = (Task)this.rule.getTaskService().createTaskQuery().taskId(subTask.getId()).singleResult();
        Assert.assertNull((Object)subTaskAfterMigration.getProcessDefinitionId());
        Assert.assertNull((Object)subTaskAfterMigration.getProcessInstanceId());
        Assert.assertNull((Object)subTaskAfterMigration.getTaskDefinitionKey());
        this.rule.getTaskService().complete(subTask.getId());
        this.rule.getTaskService().complete(task.getId());
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
        if (!this.rule.getProcessEngineConfiguration().getHistoryLevel().equals(HistoryLevel.HISTORY_LEVEL_NONE)) {
            this.rule.getHistoryService().deleteHistoricTaskInstance(subTaskAfterMigration.getId());
        }
    }

    @Test
    public void testAccessModelInNewAssignmentTaskListenerAfterMigration() {
        ModifiableBpmnModelInstance targetModel = ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).changeElementId("userTask", "newUserTask");
        MigrationUserTaskTest.addTaskListener(targetModel, "newUserTask", "assignment", AccessModelInstanceTaskListener.class.getName());
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetModel);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "newUserTask").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        Task task = (Task)this.rule.getTaskService().createTaskQuery().singleResult();
        this.rule.getTaskService().setAssignee(task.getId(), "foo");
        String variableValue = (String)this.rule.getRuntimeService().getVariable(processInstance.getId(), "userTaskId");
        Assert.assertEquals((Object)"newUserTask", (Object)variableValue);
    }

    @Test
    public void testAccessModelInNewTimeoutTaskListenerAfterMigration() {
        String sourceProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.noTimeoutTaskListener.bpmn20.xml").getId();
        String targetProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.oneTimeoutTaskListener.bpmn20.xml").getId();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinitionId, targetProcessDefinitionId).mapEqualActivities().build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertTaskListenerTimerJobCreated("userTask");
        this.testTimeoutListenerCanBeTriggered(processInstance, "userTask");
    }

    @Test
    public void testTimeoutTaskListenerRemovedAfterMigration() {
        String sourceProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.oneTimeoutTaskListener.bpmn20.xml").getId();
        String targetProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.noTimeoutTaskListener.bpmn20.xml").getId();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinitionId, targetProcessDefinitionId).mapEqualActivities().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertTaskListenerTimerJobRemoved("userTask");
    }

    @Test
    public void testTimeoutTaskListenerMigratedAfterMigration() {
        String sourceProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.oneTimeoutTaskListener.bpmn20.xml").getId();
        String targetProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.changedTimeoutTaskListener.bpmn20.xml").getId();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinitionId, targetProcessDefinitionId).mapEqualActivities().build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertTaskListenerTimerJobMigrated("userTask", "userTask");
        this.testTimeoutListenerCanBeTriggered(processInstance, "userTask");
    }

    @Test
    public void testTimeoutTaskListenerMigratedAndUpdatedAfterMigration() {
        ClockTestUtil.setClockToDateWithoutMilliseconds();
        String sourceProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.oneTimeoutTaskListener.bpmn20.xml").getId();
        String targetProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.changedTimeoutTaskListener.bpmn20.xml").getId();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinitionId, targetProcessDefinitionId).mapEqualActivities().updateEventTriggers().build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        Date newDueDate = new DateTime((Object)ClockUtil.getCurrentTime()).plusHours(3).toDate();
        this.testHelper.assertJobMigrated(this.testHelper.snapshotBeforeMigration.getJobs().get(0), "userTask", newDueDate);
        this.testTimeoutListenerCanBeTriggered(processInstance, "userTask");
    }

    @Test
    public void testAccessModelInNewTimeoutTaskListenerAfterMigrationToDifferentUserTask() {
        String sourceProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.noTimeoutTaskListener.bpmn20.xml").getId();
        String targetProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.oneTimeoutTaskListenerDifferentTask.bpmn20.xml").getId();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinitionId, targetProcessDefinitionId).mapActivities("userTask", "userTask2").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertTaskListenerTimerJobCreated("userTask2");
        Assertions.assertThat((int)this.testHelper.snapshotBeforeMigration.getJobs().size()).isEqualTo(0);
        Assertions.assertThat((int)this.testHelper.snapshotAfterMigration.getJobs().size()).isEqualTo(1);
        this.testTimeoutListenerCanBeTriggered(processInstance, "userTask2");
    }

    @Test
    public void testTimeoutTaskListenerRemovedAfterMigrationToDifferentUserTask() {
        String sourceProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.oneTimeoutTaskListenerDifferentTask.bpmn20.xml").getId();
        String targetProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.noTimeoutTaskListener.bpmn20.xml").getId();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinitionId, targetProcessDefinitionId).mapActivities("userTask2", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertTaskListenerTimerJobRemoved("userTask2");
        Assertions.assertThat((int)this.testHelper.snapshotBeforeMigration.getJobs().size()).isEqualTo(1);
        Assertions.assertThat((int)this.testHelper.snapshotAfterMigration.getJobs().size()).isEqualTo(0);
    }

    @Test
    public void testTimeoutTaskListenerMigratedAfterMigrationToDifferentUserTask() {
        String sourceProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.oneTimeoutTaskListenerDifferentTask.bpmn20.xml").getId();
        String targetProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.changedTimeoutTaskListener.bpmn20.xml").getId();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinitionId, targetProcessDefinitionId).mapActivities("userTask2", "userTask").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertTaskListenerTimerJobMigrated("userTask2", "userTask");
        Assertions.assertThat((int)this.testHelper.snapshotBeforeMigration.getJobs().size()).isEqualTo(1);
        Assertions.assertThat((int)this.testHelper.snapshotAfterMigration.getJobs().size()).isEqualTo(1);
        this.testTimeoutListenerCanBeTriggered(processInstance, "userTask");
    }

    @Test
    public void testTimeoutTaskListenerMigratedAndUpdatedAfterMigrationToDifferentUserTask() {
        ClockTestUtil.setClockToDateWithoutMilliseconds();
        String sourceProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.oneTimeoutTaskListenerDifferentTask.bpmn20.xml").getId();
        String targetProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.changedTimeoutTaskListener.bpmn20.xml").getId();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinitionId, targetProcessDefinitionId).mapActivities("userTask2", "userTask").updateEventTrigger().build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        Date newDueDate = new DateTime((Object)ClockUtil.getCurrentTime()).plusHours(3).toDate();
        this.testHelper.assertTaskListenerTimerJobMigrated("userTask2", "userTask", newDueDate);
        Assertions.assertThat((int)this.testHelper.snapshotBeforeMigration.getJobs().size()).isEqualTo(1);
        Assertions.assertThat((int)this.testHelper.snapshotAfterMigration.getJobs().size()).isEqualTo(1);
        this.testTimeoutListenerCanBeTriggered(processInstance, "userTask");
    }

    @Test
    public void testAccessModelInNewTimeoutTaskListenerAfterMultipleListenerMigration() {
        String sourceProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.noTimeoutTaskListener.bpmn20.xml").getId();
        String targetProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.twoTimeoutTaskListeners.bpmn20.xml").getId();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinitionId, targetProcessDefinitionId).mapEqualActivities().build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertTaskListenerTimerJobsCreated("userTask", 2);
        ClockUtil.offset((Long)TimeUnit.MINUTES.toMillis(70L));
        this.testHelper.waitForJobExecutorToProcessAllJobs(5000L);
        String variableValue = (String)this.rule.getRuntimeService().getVariable(processInstance.getId(), "userTaskId");
        Assert.assertEquals((Object)"userTask", (Object)variableValue);
    }

    @Test
    public void testOneTimeoutTaskListenerRemovedAfterMigration() {
        String sourceProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.twoTimeoutTaskListeners.bpmn20.xml").getId();
        String targetProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.oneTimeoutTaskListener.bpmn20.xml").getId();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinitionId, targetProcessDefinitionId).mapEqualActivities().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        Assertions.assertThat((int)this.testHelper.snapshotBeforeMigration.getJobs().size()).isEqualTo(2);
        Assertions.assertThat((int)this.testHelper.snapshotAfterMigration.getJobs().size()).isEqualTo(1);
        JobEntity job = (JobEntity)this.testHelper.snapshotAfterMigration.getJobs().get(0);
        String jobHandlerConfiguration = job.getJobHandlerConfigurationRaw();
        Assertions.assertThat((String)jobHandlerConfiguration).contains(new CharSequence[]{"timeout-friendly"});
    }

    @Test
    public void testOneTimeoutTaskListenerAddedAfterMigration() {
        String sourceProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.oneTimeoutTaskListener.bpmn20.xml").getId();
        String targetProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.twoTimeoutTaskListeners.bpmn20.xml").getId();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinitionId, targetProcessDefinitionId).mapEqualActivities().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        Assertions.assertThat((int)this.testHelper.snapshotBeforeMigration.getJobs().size()).isEqualTo(1);
        JobEntity job = (JobEntity)this.testHelper.snapshotBeforeMigration.getJobs().get(0);
        String jobHandlerConfiguration = job.getJobHandlerConfigurationRaw();
        Assertions.assertThat((String)jobHandlerConfiguration).contains(new CharSequence[]{"timeout-friendly"});
        Assertions.assertThat((int)this.testHelper.snapshotAfterMigration.getJobs().size()).isEqualTo(2);
        job = (JobEntity)this.testHelper.snapshotAfterMigration.getJobs().get(1);
        jobHandlerConfiguration = job.getJobHandlerConfigurationRaw();
        Assertions.assertThat((String)jobHandlerConfiguration).contains(new CharSequence[]{"timeout-hard"});
    }

    @Test
    public void testTriggeredTimeoutTaskListenerNotStartedAgainAfterMigration() {
        String sourceProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.twoTimeoutTaskListenersPastDate.bpmn20.xml").getId();
        String targetProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.twoTimeoutTaskListenersPastDate.bpmn20.xml").getId();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinitionId, targetProcessDefinitionId).mapEqualActivities().build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinitionId);
        Assertions.assertThat((long)this.rule.getManagementService().createJobQuery().count()).isEqualTo(2L);
        Assertions.assertThat((long)this.rule.getManagementService().createJobQuery().executable().count()).isEqualTo(1L);
        this.testHelper.waitForJobExecutorToProcessAllJobs(5000L);
        Assertions.assertThat((long)this.rule.getManagementService().createJobQuery().count()).isEqualTo(1L);
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assertions.assertThat((long)this.rule.getManagementService().createJobQuery().count()).isEqualTo(1L);
    }

    @Test
    public void testTimeoutTaskListenerMigratedAfterMultipleListenerMigration() {
        String sourceProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.oneTimeoutTaskListener.bpmn20.xml").getId();
        String targetProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.changedTimeoutTaskListener.bpmn20.xml").getId();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinitionId, targetProcessDefinitionId).mapEqualActivities().build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertTaskListenerTimerJobMigrated("userTask", "userTask");
        this.testTimeoutListenerCanBeTriggered(processInstance, "userTask");
    }

    @Test
    public void testTimeoutTaskListenerMigratedAndUpdatedAfterMultipleListenerMigration() {
        ClockTestUtil.setClockToDateWithoutMilliseconds();
        String sourceProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.oneTimeoutTaskListener.bpmn20.xml").getId();
        String targetProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.changedTimeoutTaskListener.bpmn20.xml").getId();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinitionId, targetProcessDefinitionId).mapEqualActivities().updateEventTriggers().build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        Date newDueDate = new DateTime((Object)ClockUtil.getCurrentTime()).plusHours(3).toDate();
        this.testHelper.assertJobMigrated(this.testHelper.snapshotBeforeMigration.getJobs().get(0), "userTask", newDueDate);
        this.testTimeoutListenerCanBeTriggered(processInstance, "userTask");
    }

    @Test
    public void testAccessModelInMigratedTimeoutTaskListenerAfterMigrationToDifferentUserTask() {
        String sourceProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.noTimeoutTaskListener.bpmn20.xml").getId();
        String targetProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.oneTimeoutTaskListener.bpmn20.xml").getId();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinitionId, targetProcessDefinitionId).mapEqualActivities().build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertTaskListenerTimerJobCreated("userTask");
        this.testTimeoutListenerCanBeTriggered(processInstance, "userTask");
    }

    @Test
    public void testAccessModelInNewTimeoutTaskListenerAfterMigrationWithBoundaryEvent() {
        String sourceProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.noTimeoutTaskListenerWithBoundaryEvent.bpmn20.xml").getId();
        String targetProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.oneTimeoutTaskListenerWithBoundaryEvent.bpmn20.xml").getId();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinitionId, targetProcessDefinitionId).mapEqualActivities().build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertTaskListenerTimerJobCreated("userTask");
        this.testTimeoutListenerCanBeTriggered(processInstance, "userTask");
    }

    @Test
    public void testTimeoutTaskListenerRemovedAfterMigrationWithBoundaryEvent() {
        String sourceProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.oneTimeoutTaskListenerWithBoundaryEvent.bpmn20.xml").getId();
        String targetProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.noTimeoutTaskListenerWithBoundaryEvent.bpmn20.xml").getId();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinitionId, targetProcessDefinitionId).mapEqualActivities().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertTaskListenerTimerJobRemoved("userTask");
    }

    @Test
    public void testTimeoutTaskListenerMigratedAfterMigrationWithBoundaryEvent() {
        String sourceProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.oneTimeoutTaskListenerWithBoundaryEvent.bpmn20.xml").getId();
        String targetProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.changedTimeoutTaskListenerWithBoundaryEvent.bpmn20.xml").getId();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinitionId, targetProcessDefinitionId).mapEqualActivities().build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertTaskListenerTimerJobMigrated("userTask", "userTask");
        this.testTimeoutListenerCanBeTriggered(processInstance, "userTask");
    }

    @Test
    public void testTimeoutTaskListenerMigratedAndUpdatedAfterMigrationWithBoundaryEvent() {
        ClockTestUtil.setClockToDateWithoutMilliseconds();
        String sourceProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.oneTimeoutTaskListenerWithBoundaryEvent.bpmn20.xml").getId();
        String targetProcessDefinitionId = this.testHelper.deployAndGetDefinition("org/camunda/bpm/engine/test/api/runtime/migration/MigrationUserTaskTest.changedTimeoutTaskListenerWithBoundaryEvent.bpmn20.xml").getId();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinitionId, targetProcessDefinitionId).mapEqualActivities().updateEventTriggers().build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        Date newDueDate = new DateTime((Object)ClockUtil.getCurrentTime()).plusHours(3).toDate();
        Job taskListenerJob = this.testHelper.snapshotBeforeMigration.getJobForDefinitionId(this.testHelper.snapshotBeforeMigration.getJobDefinitionForActivityIdAndType("userTask", "timer-task-listener").getId());
        this.testHelper.assertJobMigrated(taskListenerJob, "userTask", newDueDate);
        this.testTimeoutListenerCanBeTriggered(processInstance, "userTask");
    }

    @Test
    public void shouldRemainActiveAfterBecomingNoneScope() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"source").startEvent().userTask("user-task").boundaryEvent().condition("${true == false}")).endEvent().done();
        String sourceProcessDefinitionId = this.testHelper.deployAndGetDefinition(sourceProcess).getId();
        BpmnModelInstance targetProcess = Bpmn.createExecutableProcess((String)"target").startEvent().userTask("user-task").endEvent().done();
        String targetProcessDefinitionId = this.testHelper.deployAndGetDefinition(targetProcess).getId();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinitionId, targetProcessDefinitionId).mapEqualActivities().build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceByKey("source");
        String definitionId = ((ProcessDefinition)this.rule.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey("source").singleResult()).getId();
        ActivityStatistics activityStatistics = (ActivityStatistics)this.rule.getManagementService().createActivityStatisticsQuery(definitionId).singleResult();
        Assertions.assertThat((String)activityStatistics.getId()).isEqualTo((Object)"user-task");
        Assertions.assertThat((int)activityStatistics.getInstances()).isEqualTo(1);
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        definitionId = ((ProcessDefinition)this.rule.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey("target").singleResult()).getId();
        activityStatistics = (ActivityStatistics)this.rule.getManagementService().createActivityStatisticsQuery(definitionId).singleResult();
        Assertions.assertThat((String)activityStatistics.getId()).isEqualTo((Object)"user-task");
        Assertions.assertThat((int)activityStatistics.getInstances()).isEqualTo(1);
    }

    @Test
    public void shouldRemainActiveAfterBecomingScope() {
        BpmnModelInstance sourceProcess = Bpmn.createExecutableProcess((String)"source").startEvent().userTask("user-task").endEvent().done();
        String sourceProcessDefinitionId = this.testHelper.deployAndGetDefinition(sourceProcess).getId();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"target").startEvent().userTask("user-task").boundaryEvent().condition("${true == false}")).endEvent().done();
        String targetProcessDefinitionId = this.testHelper.deployAndGetDefinition(targetProcess).getId();
        String definitionId = ((ProcessDefinition)this.rule.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey("source").singleResult()).getId();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceByKey("source");
        ActivityStatistics activityStatistics = (ActivityStatistics)this.rule.getManagementService().createActivityStatisticsQuery(definitionId).singleResult();
        Assertions.assertThat((String)activityStatistics.getId()).isEqualTo((Object)"user-task");
        Assertions.assertThat((int)activityStatistics.getInstances()).isEqualTo(1);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinitionId, targetProcessDefinitionId).mapEqualActivities().updateEventTriggers().build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        definitionId = ((ProcessDefinition)this.rule.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey("target").singleResult()).getId();
        activityStatistics = (ActivityStatistics)this.rule.getManagementService().createActivityStatisticsQuery(definitionId).singleResult();
        Assertions.assertThat((String)activityStatistics.getId()).isEqualTo((Object)"user-task");
        Assertions.assertThat((int)activityStatistics.getInstances()).isEqualTo(1);
    }

    protected static void addTaskListener(BpmnModelInstance targetModel, String activityId, String event, String className) {
        CamundaTaskListener taskListener = (CamundaTaskListener)targetModel.newInstance(CamundaTaskListener.class);
        taskListener.setCamundaClass(className);
        taskListener.setCamundaEvent(event);
        UserTask task = (UserTask)targetModel.getModelElementById(activityId);
        task.builder().addExtensionElement((BpmnModelElementInstance)taskListener);
    }

    protected void testTimeoutListenerCanBeTriggered(ProcessInstance processInstance, String activityId) {
        JobDefinition jobDefinition = this.testHelper.snapshotAfterMigration.getJobDefinitionForActivityIdAndType(activityId, "timer-task-listener");
        this.rule.getManagementService().executeJob(this.testHelper.snapshotAfterMigration.getJobForDefinitionId(jobDefinition.getId()).getId());
        String variableValue = (String)this.rule.getRuntimeService().getVariable(processInstance.getId(), "userTaskId");
        Assert.assertEquals((Object)activityId, (Object)variableValue);
    }
}

