/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.DecisionService;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.camunda.bpm.engine.runtime.RestartProcessInstanceBuilder;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.history.removaltime.batch.helper.BatchSetRemovalTimeRule;
import org.camunda.bpm.engine.test.util.BatchRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class JobEntityAndJobLogBatchIdTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected BatchRule batchRule = new BatchRule(this.engineRule, this.testRule);
    protected BatchSetRemovalTimeRule batchRemovalTimeRule = new BatchSetRemovalTimeRule(this.engineRule, this.testRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule).around((TestRule)this.batchRule).around((TestRule)this.batchRemovalTimeRule);
    protected RuntimeService runtimeService;
    protected HistoryService historyService;
    protected ManagementService managementService;
    protected DecisionService decisionService;
    protected ExternalTaskService externalTaskService;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
        this.managementService = this.engineRule.getManagementService();
        this.decisionService = this.engineRule.getDecisionService();
        this.externalTaskService = this.engineRule.getExternalTaskService();
    }

    private BpmnModelInstance getUserTaskProcess() {
        return Bpmn.createExecutableProcess((String)"process").startEvent().userTask("task1").endEvent().done();
    }

    private BpmnModelInstance getTwoUserTasksProcess() {
        return Bpmn.createExecutableProcess((String)"process").startEvent().userTask("task1").userTask("task2").endEvent().done();
    }

    private BpmnModelInstance getTimerProcess() {
        return ((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().timerWithDuration("PT5H")).endEvent().done();
    }

    @Test
    public void shouldSetBatchIdOnJobAndJobLog_SetHistoricBatchRemovalTime() {
        this.testRule.deploy(this.getUserTaskProcess());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Batch setVariablesBatch = this.runtimeService.setVariablesAsync(List.of(processInstance.getId()), (Map)Variables.createVariables().putValue("foo", (Object)"bar"));
        this.batchRule.syncExec(setVariablesBatch);
        Batch setRemovalTimeBatch = this.historyService.setRemovalTimeToHistoricBatches().absoluteRemovalTime(this.batchRemovalTimeRule.REMOVAL_TIME).byQuery(this.historyService.createHistoricBatchQuery()).executeAsync();
        Map<String, List<Job>> processedJobs = this.batchRule.syncExec(setRemovalTimeBatch);
        this.assertProcessedJobs(setRemovalTimeBatch, processedJobs);
        Assertions.assertThat((String)setVariablesBatch.getId()).isNotNull();
        Assertions.assertThat((String)setRemovalTimeBatch.getId()).isNotNull();
        List batchSeedJobLogs = this.historyService.createHistoricJobLogQuery().successLog().jobDefinitionType("batch-seed-job").list();
        Assertions.assertThat((List)batchSeedJobLogs).extracting("batchId").containsExactlyInAnyOrder(new Object[]{setVariablesBatch.getId(), setRemovalTimeBatch.getId()});
        List batchMonitorJobLogs = this.historyService.createHistoricJobLogQuery().successLog().jobDefinitionType("batch-monitor-job").list();
        Assertions.assertThat((List)batchMonitorJobLogs).extracting("batchId").containsExactlyInAnyOrder(new Object[]{setVariablesBatch.getId(), setRemovalTimeBatch.getId()});
        List batchExecutionJobLogs = this.historyService.createHistoricJobLogQuery().successLog().jobDefinitionType("batch-set-removal-time").list();
        Assertions.assertThat((List)batchExecutionJobLogs).extracting("batchId").containsOnly(new Object[]{setRemovalTimeBatch.getId()});
    }

    @Test
    public void shouldSetBatchIdOnJobAndJobLog_SetVariables() {
        this.testRule.deploy(this.getUserTaskProcess());
        ProcessInstance process = this.runtimeService.startProcessInstanceByKey("process");
        Batch batch = this.runtimeService.setVariablesAsync(List.of(process.getId()), (Map)Variables.createVariables().putValue("foo", (Object)"bar"));
        Map<String, List<Job>> processedJobs = this.batchRule.syncExec(batch);
        this.assertProcessedJobs(batch, processedJobs);
        this.assertHistoricJobLogs(batch, "set-variables");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetBatchIdOnJobAndJobLog_DecisionSetRemovalTime() {
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        Batch batch = this.historyService.setRemovalTimeToHistoricDecisionInstances().absoluteRemovalTime(this.batchRemovalTimeRule.REMOVAL_TIME).byQuery(this.historyService.createHistoricDecisionInstanceQuery()).executeAsync();
        Map<String, List<Job>> processedJobs = this.batchRule.syncExec(batch);
        this.assertProcessedJobs(batch, processedJobs);
        this.assertHistoricJobLogs(batch, "decision-set-removal-time");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetBatchIdOnJobAndJobLog_DeleteHistoricDecisionInstances() {
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey("dish-decision");
        Batch batch = this.historyService.deleteHistoricDecisionInstancesAsync(query, null);
        Map<String, List<Job>> processedJobs = this.batchRule.syncExec(batch);
        this.assertProcessedJobs(batch, processedJobs);
        this.assertHistoricJobLogs(batch, "historic-decision-instance-deletion");
    }

    @Test
    public void shouldSetBatchIdOnJobAndJobLog_DeleteHistoricProcessInstances() {
        this.testRule.deploy(Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done());
        this.runtimeService.startProcessInstanceByKey("process");
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("process");
        Batch batch = this.historyService.deleteHistoricProcessInstancesAsync(query, null);
        Map<String, List<Job>> processedJobs = this.batchRule.syncExec(batch);
        this.assertProcessedJobs(batch, processedJobs);
        this.assertHistoricJobLogs(batch, "historic-instance-deletion");
    }

    @Test
    public void shouldSetBatchIdOnJobAndJobLog_DeleteProcessInstances() {
        this.testRule.deploy(this.getUserTaskProcess());
        ProcessInstance process = this.runtimeService.startProcessInstanceByKey("process");
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(List.of(process.getId()), null);
        Map<String, List<Job>> processedJobs = this.batchRule.syncExec(batch);
        this.assertProcessedJobs(batch, processedJobs);
        this.assertHistoricJobLogs(batch, "instance-deletion");
    }

    @Test
    public void shouldSetBatchIdOnJobAndJobLog_MessageCorrelation() {
        this.testRule.deploy(((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().intermediateCatchEvent().message("message")).userTask().endEvent().done());
        ProcessInstance process = this.runtimeService.startProcessInstanceByKey("process");
        Batch batch = this.runtimeService.createMessageCorrelationAsync("message").processInstanceIds(List.of(process.getId())).correlateAllAsync();
        Map<String, List<Job>> processedJobs = this.batchRule.syncExec(batch);
        this.assertProcessedJobs(batch, processedJobs);
        this.assertHistoricJobLogs(batch, "correlate-message");
    }

    @Test
    public void shouldSetBatchIdOnJobAndJobLog_Migration() {
        ProcessDefinition sourceProcessDefinition = this.testRule.deployAndGetDefinition(this.getUserTaskProcess());
        ProcessInstance process = this.runtimeService.startProcessInstanceByKey("process");
        ProcessDefinition targetProcessDefinition = this.testRule.deployAndGetDefinition(this.getTwoUserTasksProcess());
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        Batch batch = this.runtimeService.newMigration(migrationPlan).processInstanceIds(List.of(process.getId())).executeAsync();
        Map<String, List<Job>> processedJobs = this.batchRule.syncExec(batch);
        this.assertProcessedJobs(batch, processedJobs);
        this.assertHistoricJobLogs(batch, "instance-migration");
    }

    @Test
    public void shouldSetBatchIdOnJobAndJobLog_Modification() {
        this.testRule.deploy(this.getTwoUserTasksProcess());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        Batch batch = ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(tree.getActivityInstances("task1")[0].getId()).startBeforeActivity("task2")).executeAsync();
        Map<String, List<Job>> processedJobs = this.batchRule.syncExec(batch);
        this.assertProcessedJobs(batch, processedJobs);
        this.assertHistoricJobLogs(batch, "instance-modification");
    }

    @Test
    public void shouldSetBatchIdOnJobAndJobLog_ProcessSetRemovalTime() {
        this.testRule.deploy(this.getTwoUserTasksProcess());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Batch batch = this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.batchRemovalTimeRule.REMOVAL_TIME).byIds(new String[]{processInstance.getId()}).executeAsync();
        Map<String, List<Job>> processedJobs = this.batchRule.syncExec(batch);
        this.assertProcessedJobs(batch, processedJobs);
        this.assertHistoricJobLogs(batch, "process-set-removal-time");
    }

    @Test
    public void shouldSetBatchIdOnJobAndJobLog_RestartProcessInstance() {
        this.testRule.deploy(this.getUserTaskProcess());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processInstance.getProcessDefinitionId()).processInstanceIds(new String[]{processInstance.getId()}).startBeforeActivity("task1")).executeAsync();
        Map<String, List<Job>> processedJobs = this.batchRule.syncExec(batch);
        this.assertProcessedJobs(batch, processedJobs);
        this.assertHistoricJobLogs(batch, "instance-restart");
    }

    @Test
    public void shouldSetBatchIdOnJobAndJobLog_SetExternalTaskRetries() {
        this.testRule.deploy(((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask().camundaExternalTask("topic")).endEvent().done());
        this.runtimeService.startProcessInstanceByKey("process");
        ExternalTask externalTask = (ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult();
        Batch batch = this.externalTaskService.setRetriesAsync(List.of(externalTask.getId()), null, 5);
        Map<String, List<Job>> processedJobs = this.batchRule.syncExec(batch);
        this.assertProcessedJobs(batch, processedJobs);
        this.assertHistoricJobLogs(batch, "set-external-task-retries");
    }

    @Test
    public void shouldSetBatchIdOnJobAndJobLog_SetJobRetries() {
        this.testRule.deploy(this.getTimerProcess());
        this.runtimeService.startProcessInstanceByKey("process");
        Job timerJob = (Job)this.managementService.createJobQuery().singleResult();
        Batch batch = this.managementService.setJobRetriesAsync(List.of(timerJob.getId()), 5);
        Map<String, List<Job>> processedJobs = this.batchRule.syncExec(batch);
        this.assertProcessedJobs(batch, processedJobs);
        this.assertHistoricJobLogs(batch, "set-job-retries");
    }

    @Test
    public void shouldSetBatchIdOnJobAndJobLog_UpdateProcessInstancesSuspendState() {
        this.testRule.deploy(this.getUserTaskProcess());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Batch batch = this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceIds(List.of(processInstance.getId())).suspendAsync();
        Map<String, List<Job>> processedJobs = this.batchRule.syncExec(batch);
        this.assertProcessedJobs(batch, processedJobs);
        this.assertHistoricJobLogs(batch, "instance-update-suspension-state");
    }

    @Test
    public void shouldNotSetBatchIdOnJobOrJobLog_nonBatchJob() {
        this.testRule.deploy(this.getTimerProcess());
        this.runtimeService.startProcessInstanceByKey("process");
        Job timerJob = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timerJob.getId());
        List historicJobLogs = this.historyService.createHistoricJobLogQuery().list();
        Assertions.assertThat((List)historicJobLogs).hasSize(2);
        Assertions.assertThat((List)historicJobLogs).extracting("batchId").containsOnlyNulls();
    }

    private void assertProcessedJobs(Batch batch, Map<String, List<Job>> processedJobs) {
        Assertions.assertThat(processedJobs.get("seed-job")).extracting("batchId").containsOnly(new Object[]{batch.getId()});
        Assertions.assertThat(processedJobs.get("execution-job")).extracting("batchId").containsOnly(new Object[]{batch.getId()});
        Assertions.assertThat(processedJobs.get("monitor-job")).extracting("batchId").containsOnly(new Object[]{batch.getId()});
    }

    private void assertHistoricJobLogs(Batch batch, String expectedBatchType) {
        Assertions.assertThat((String)batch.getId()).isNotNull();
        List batchSeedJobLogs = this.historyService.createHistoricJobLogQuery().successLog().jobDefinitionType("batch-seed-job").list();
        Assertions.assertThat((List)batchSeedJobLogs).extracting("batchId").containsOnly(new Object[]{batch.getId()});
        List batchMonitorJobLogs = this.historyService.createHistoricJobLogQuery().successLog().jobDefinitionType("batch-monitor-job").list();
        Assertions.assertThat((List)batchMonitorJobLogs).extracting("batchId").containsOnly(new Object[]{batch.getId()});
        List batchExecutionJobLogs = this.historyService.createHistoricJobLogQuery().successLog().jobDefinitionType(expectedBatchType).list();
        Assertions.assertThat((List)batchExecutionJobLogs).extracting("batchId").containsOnly(new Object[]{batch.getId()});
    }
}

