/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MetricsManagerForCleanupTest {
    private static final BpmnModelInstance PROCESS = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("start").userTask("userTask1").sequenceFlowId("seq")).userTask("userTask2").endEvent("end").done();
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> configuration.setTaskMetricsEnabled(true));
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected ManagementService managementService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    @Parameterized.Parameter(value=0)
    public int taskMetricHistoryTTL;
    @Parameterized.Parameter(value=1)
    public int metric1DaysInThePast;
    @Parameterized.Parameter(value=2)
    public int metric2DaysInThePast;
    @Parameterized.Parameter(value=3)
    public int batchSize;
    @Parameterized.Parameter(value=4)
    public int resultCount;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.taskService = this.engineRule.getTaskService();
    }

    @After
    public void clearDatabase() {
        this.testRule.deleteHistoryCleanupJobs();
        this.managementService.deleteTaskMetrics(null);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> scenarios() {
        return Arrays.asList({5, -6, -7, 50, 2}, {5, -3, -7, 50, 1}, {5, -3, -4, 50, 0}, {5, -6, -7, 1, 1});
    }

    @Test
    public void testFindHistoricBatchIdsForCleanup() {
        this.prepareTaskMetrics();
        this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired().execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                List taskMetricIdsForCleanup = commandContext.getMeterLogManager().findTaskMetricsForCleanup(MetricsManagerForCleanupTest.this.batchSize, Integer.valueOf(MetricsManagerForCleanupTest.this.taskMetricHistoryTTL), 0, 59);
                Assertions.assertThat((int)taskMetricIdsForCleanup.size()).isEqualTo(MetricsManagerForCleanupTest.this.resultCount);
                return null;
            }
        });
    }

    private void prepareTaskMetrics() {
        this.testRule.deploy(PROCESS);
        this.runtimeService.startProcessInstanceByKey("process");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        ClockUtil.offset((Long)TimeUnit.DAYS.toMillis(this.metric1DaysInThePast));
        this.taskService.setAssignee(taskId, "kermit");
        ClockUtil.offset((Long)TimeUnit.DAYS.toMillis(this.metric2DaysInThePast));
        this.taskService.setAssignee(taskId, "gonzo");
        ClockUtil.reset();
    }
}

