/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.persistence;

import java.sql.SQLException;
import java.util.Properties;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.apache.ibatis.exceptions.PersistenceException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.test.RequiredDatabase;
import org.camunda.bpm.engine.impl.util.PropertiesUtil;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@RequiredDatabase(excludes={"h2", "oracle"})
public class ConnectionPersistenceExceptionTest {
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected IdentityService identityService;
    protected ProcessEngineConfigurationImpl engineConfig;
    protected String resetUrl;

    @Before
    public void assignServices() {
        this.identityService = this.engineRule.getIdentityService();
        this.engineConfig = this.engineRule.getProcessEngineConfiguration();
        this.resetUrl = ((PooledDataSource)this.engineConfig.getDataSource()).getUrl();
    }

    @After
    public void resetEngine() {
        ((PooledDataSource)this.engineConfig.getDataSource()).setUrl(this.resetUrl);
        this.engineRule.getIdentityService().deleteUser("foo");
    }

    @Test
    public void shouldFailWithConnectionError() {
        User user = this.identityService.newUser("foo");
        this.identityService.saveUser(user);
        SQLException sqlException = this.provokePersistenceConnectionError();
        Assertions.assertThat((String)sqlException.getSQLState()).startsWith((CharSequence)"08");
    }

    protected SQLException provokePersistenceConnectionError() {
        Properties properties = PropertiesUtil.getProperties((String)"/database.properties");
        String host = (String)properties.get("database.host");
        String port = (String)properties.get("database.port");
        String jdbcUrl = this.resetUrl.replace(host + ":" + port, "not-existing-server:123");
        ((PooledDataSource)this.engineConfig.getDataSource()).setUrl(jdbcUrl);
        Throwable result = ThrowableAssert.catchThrowable(() -> this.identityService.deleteUser("foo"));
        Assertions.assertThat((Throwable)result).isInstanceOf(ProcessEngineException.class);
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)result.getCause()).isInstanceOf(PersistenceException.class)).hasCauseInstanceOf(SQLException.class);
        return (SQLException)result.getCause().getCause();
    }
}

