/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.form;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.form.FormProperty;
import org.camunda.bpm.engine.form.StartFormData;
import org.camunda.bpm.engine.form.TaskFormData;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class FormPropertyDefaultValueTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testDefaultValue() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("FormPropertyDefaultValueTest.testDefaultValue");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        TaskFormData formData = this.formService.getTaskFormData(task.getId());
        List formProperties = formData.getFormProperties();
        Assert.assertEquals((long)4L, (long)formProperties.size());
        for (FormProperty prop : formProperties) {
            if ("booleanProperty".equals(prop.getId())) {
                Assert.assertEquals((Object)"true", (Object)prop.getValue());
                continue;
            }
            if ("stringProperty".equals(prop.getId())) {
                Assert.assertEquals((Object)"someString", (Object)prop.getValue());
                continue;
            }
            if ("longProperty".equals(prop.getId())) {
                Assert.assertEquals((Object)"42", (Object)prop.getValue());
                continue;
            }
            if ("longExpressionProperty".equals(prop.getId())) {
                Assert.assertEquals((Object)"23", (Object)prop.getValue());
                continue;
            }
            Assert.assertTrue((String)("Invalid form property: " + prop.getId()), (boolean)false);
        }
        HashMap<String, String> formDataUpdate = new HashMap<String, String>();
        formDataUpdate.put("longExpressionProperty", "1");
        formDataUpdate.put("booleanProperty", "false");
        this.formService.submitTaskFormData(task.getId(), formDataUpdate);
        Assert.assertEquals((Object)false, (Object)this.runtimeService.getVariable(processInstance.getId(), "booleanProperty"));
        Assert.assertEquals((Object)"someString", (Object)this.runtimeService.getVariable(processInstance.getId(), "stringProperty"));
        Assert.assertEquals((Object)42L, (Object)this.runtimeService.getVariable(processInstance.getId(), "longProperty"));
        Assert.assertEquals((Object)1L, (Object)this.runtimeService.getVariable(processInstance.getId(), "longExpressionProperty"));
    }

    @Deployment
    @Test
    public void testStartFormDefaultValue() throws Exception {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("FormPropertyDefaultValueTest.testDefaultValue").latestVersion().singleResult()).getId();
        StartFormData startForm = this.formService.getStartFormData(processDefinitionId);
        List formProperties = startForm.getFormProperties();
        Assert.assertEquals((long)4L, (long)formProperties.size());
        for (FormProperty prop : formProperties) {
            if ("booleanProperty".equals(prop.getId())) {
                Assert.assertEquals((Object)"true", (Object)prop.getValue());
                continue;
            }
            if ("stringProperty".equals(prop.getId())) {
                Assert.assertEquals((Object)"someString", (Object)prop.getValue());
                continue;
            }
            if ("longProperty".equals(prop.getId())) {
                Assert.assertEquals((Object)"42", (Object)prop.getValue());
                continue;
            }
            if ("longExpressionProperty".equals(prop.getId())) {
                Assert.assertEquals((Object)"23", (Object)prop.getValue());
                continue;
            }
            Assert.assertTrue((String)("Invalid form property: " + prop.getId()), (boolean)false);
        }
        HashMap<String, String> formDataUpdate = new HashMap<String, String>();
        formDataUpdate.put("longExpressionProperty", "1");
        formDataUpdate.put("booleanProperty", "false");
        ProcessInstance processInstance = this.formService.submitStartFormData(processDefinitionId, formDataUpdate);
        Assert.assertEquals((Object)false, (Object)this.runtimeService.getVariable(processInstance.getId(), "booleanProperty"));
        Assert.assertEquals((Object)"someString", (Object)this.runtimeService.getVariable(processInstance.getId(), "stringProperty"));
        Assert.assertEquals((Object)42L, (Object)this.runtimeService.getVariable(processInstance.getId(), "longProperty"));
        Assert.assertEquals((Object)1L, (Object)this.runtimeService.getVariable(processInstance.getId(), "longExpressionProperty"));
    }
}

