/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.task;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.exception.NotAllowedException;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class StandaloneTasksDisabledTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(p -> p.setStandaloneTasksEnabled(false));
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    public ProcessEngineTestRule engineTestRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.engineTestRule);
    private RuntimeService runtimeService;
    private TaskService taskService;
    private IdentityService identityService;
    private CaseService caseService;

    @Before
    public void setUp() throws Exception {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        this.identityService = this.engineRule.getIdentityService();
        this.caseService = this.engineRule.getCaseService();
    }

    @After
    public void tearDown() {
        this.identityService.clearAuthentication();
        this.engineRule.getProcessEngineConfiguration().setAuthorizationEnabled(false);
        this.engineTestRule.deleteAllAuthorizations();
        this.engineTestRule.deleteAllStandaloneTasks();
    }

    @Test
    public void shouldNotCreateStandaloneTask() {
        Task task = this.taskService.newTask();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.saveTask(task)).isInstanceOf(NotAllowedException.class)).hasMessageContaining("Cannot save standalone task. They are disabled in the process engine configuration.");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldAllowToUpdateProcessInstanceTask() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        task.setAssignee("newAssignee");
        this.taskService.saveTask(task);
        Task updatedTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assertions.assertThat((String)updatedTask.getAssignee()).isEqualTo((Object)"newAssignee");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void shouldAllowToUpdateCaseInstanceTask() {
        this.caseService.createCaseInstanceByKey("oneTaskCase").getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        task.setAssignee("newAssignee");
        this.taskService.saveTask(task);
        Task updatedTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assertions.assertThat((String)updatedTask.getAssignee()).isEqualTo((Object)"newAssignee");
    }
}

