/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.List;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.camunda.bpm.engine.test.jobexecutor.ControllableJobExecutor;
import org.camunda.bpm.engine.test.jobexecutor.JobAcquisitionTestHelper;
import org.camunda.bpm.engine.test.jobexecutor.RecordingAcquireJobsRunnable;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class JobAcquisitionBackoffTest {
    protected static final int BASE_BACKOFF_TIME = 1000;
    protected static final int MAX_BACKOFF_TIME = 5000;
    protected static final int BACKOFF_FACTOR = 2;
    protected static final int BACKOFF_DECREASE_THRESHOLD = 2;
    protected static final int DEFAULT_NUM_JOBS_TO_ACQUIRE = 3;
    @Rule
    public ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> configuration.setJobExecutor((JobExecutor)new ControllableJobExecutor()));
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule(this.bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected ControllableJobExecutor jobExecutor1;
    protected ControllableJobExecutor jobExecutor2;
    protected ConcurrencyTestHelper.ThreadControl acquisitionThread1;
    protected ConcurrencyTestHelper.ThreadControl acquisitionThread2;

    @Before
    public void setUp() throws Exception {
        this.jobExecutor1 = (ControllableJobExecutor)((ProcessEngineConfigurationImpl)this.engineRule.getProcessEngine().getProcessEngineConfiguration()).getJobExecutor();
        this.jobExecutor1.setMaxJobsPerAcquisition(3);
        this.jobExecutor1.setBackoffTimeInMillis(1000);
        this.jobExecutor1.setMaxBackoff(5000L);
        this.jobExecutor1.setBackoffDecreaseThreshold(2);
        this.acquisitionThread1 = this.jobExecutor1.getAcquisitionThreadControl();
        this.jobExecutor2 = new ControllableJobExecutor((ProcessEngineImpl)this.engineRule.getProcessEngine());
        this.jobExecutor2.setMaxJobsPerAcquisition(3);
        this.jobExecutor2.setBackoffTimeInMillis(1000);
        this.jobExecutor2.setMaxBackoff(5000L);
        this.jobExecutor2.setBackoffDecreaseThreshold(2);
        this.acquisitionThread2 = this.jobExecutor2.getAcquisitionThreadControl();
    }

    @After
    public void tearDown() throws Exception {
        this.jobExecutor1.shutdown();
        this.jobExecutor2.shutdown();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    public void testBackoffOnOptimisticLocking() {
        for (int i = 0; i < 9; ++i) {
            this.engineRule.getRuntimeService().startProcessInstanceByKey("simpleAsyncProcess").getId();
        }
        JobAcquisitionTestHelper.suspendInstances(this.engineRule.getProcessEngine(), 6);
        this.jobExecutor1.start();
        this.acquisitionThread1.waitForSync();
        this.jobExecutor2.start();
        this.acquisitionThread2.waitForSync();
        this.acquisitionThread1.makeContinueAndWaitForSync();
        this.acquisitionThread2.makeContinueAndWaitForSync();
        this.acquisitionThread1.makeContinueAndWaitForSync();
        List<RecordingAcquireJobsRunnable.RecordedWaitEvent> jobExecutor1WaitEvents = this.jobExecutor1.getAcquireJobsRunnable().getWaitEvents();
        Assert.assertEquals((long)1L, (long)jobExecutor1WaitEvents.size());
        Assert.assertEquals((long)0L, (long)jobExecutor1WaitEvents.get(0).getTimeBetweenAcquisitions());
        this.acquisitionThread2.makeContinueAndWaitForSync();
        List<RecordingAcquireJobsRunnable.RecordedWaitEvent> jobExecutor2WaitEvents = this.jobExecutor2.getAcquireJobsRunnable().getWaitEvents();
        Assert.assertEquals((long)1L, (long)jobExecutor2WaitEvents.size());
        RecordingAcquireJobsRunnable.RecordedWaitEvent waitEvent = jobExecutor2WaitEvents.get(0);
        JobAcquisitionTestHelper.assertInBetween(1000L, 1500L, waitEvent.getTimeBetweenAcquisitions());
        JobAcquisitionTestHelper.activateInstances(this.engineRule.getProcessEngine(), 6);
        this.acquisitionThread1.makeContinueAndWaitForSync();
        this.acquisitionThread2.makeContinueAndWaitForSync();
        this.acquisitionThread1.makeContinueAndWaitForSync();
        this.acquisitionThread2.makeContinueAndWaitForSync();
        List<RecordingAcquireJobsRunnable.RecordedAcquisitionEvent> jobExecutor1AcquisitionEvents = this.jobExecutor1.getAcquireJobsRunnable().getAcquisitionEvents();
        RecordingAcquireJobsRunnable.RecordedAcquisitionEvent secondAcquisitionAttempt = jobExecutor1AcquisitionEvents.get(1);
        Assert.assertEquals((long)3L, (long)secondAcquisitionAttempt.getNumJobsToAcquire());
        jobExecutor1WaitEvents = this.jobExecutor1.getAcquireJobsRunnable().getWaitEvents();
        Assert.assertEquals((long)2L, (long)jobExecutor1WaitEvents.size());
        Assert.assertEquals((long)0L, (long)jobExecutor1WaitEvents.get(1).getTimeBetweenAcquisitions());
        List<RecordingAcquireJobsRunnable.RecordedAcquisitionEvent> jobExecutor2AcquisitionEvents = this.jobExecutor2.getAcquireJobsRunnable().getAcquisitionEvents();
        secondAcquisitionAttempt = jobExecutor2AcquisitionEvents.get(1);
        jobExecutor2WaitEvents = this.jobExecutor2.getAcquireJobsRunnable().getWaitEvents();
        RecordingAcquireJobsRunnable.RecordedWaitEvent secondWaitEvent = jobExecutor2WaitEvents.get(1);
        long expectedBackoffTime = 2000L;
        Assert.assertEquals((long)6L, (long)secondAcquisitionAttempt.getNumJobsToAcquire());
        Assert.assertEquals((long)2L, (long)jobExecutor2WaitEvents.size());
        JobAcquisitionTestHelper.assertInBetween(expectedBackoffTime, expectedBackoffTime + expectedBackoffTime / 2L, secondWaitEvent.getTimeBetweenAcquisitions());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    public void testBackoffDecrease() {
        for (int i = 0; i < 15; ++i) {
            this.engineRule.getRuntimeService().startProcessInstanceByKey("simpleAsyncProcess").getId();
        }
        JobAcquisitionTestHelper.suspendInstances(this.engineRule.getProcessEngine(), 12);
        this.jobExecutor1.start();
        this.acquisitionThread1.waitForSync();
        this.jobExecutor2.start();
        this.acquisitionThread2.waitForSync();
        this.acquisitionThread1.makeContinueAndWaitForSync();
        this.acquisitionThread2.makeContinueAndWaitForSync();
        this.jobExecutor1.shutdown();
        this.acquisitionThread1.waitUntilDone();
        this.acquisitionThread2.makeContinueAndWaitForSync();
        List<RecordingAcquireJobsRunnable.RecordedWaitEvent> jobExecutor2WaitEvents = this.jobExecutor2.getAcquireJobsRunnable().getWaitEvents();
        Assert.assertEquals((long)1L, (long)jobExecutor2WaitEvents.size());
        JobAcquisitionTestHelper.activateInstances(this.engineRule.getProcessEngine(), 12);
        Assert.assertTrue((jobExecutor2WaitEvents.get(0).getTimeBetweenAcquisitions() > 0L ? 1 : 0) != 0);
        this.acquisitionThread2.makeContinueAndWaitForSync();
        this.acquisitionThread2.makeContinueAndWaitForSync();
        for (int i = 1; i < 2; ++i) {
            Assert.assertTrue((jobExecutor2WaitEvents.get(i).getTimeBetweenAcquisitions() > 0L ? 1 : 0) != 0);
            this.acquisitionThread2.makeContinueAndWaitForSync();
            this.acquisitionThread2.makeContinueAndWaitForSync();
        }
        long lastBackoff = jobExecutor2WaitEvents.get(2).getTimeBetweenAcquisitions();
        Assert.assertEquals((long)0L, (long)lastBackoff);
    }
}

