/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.cmmn;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.exception.NotAllowedException;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseExecutionQuery;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class CaseServiceStageTest
extends PluggableProcessEngineTest {
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    @Test
    public void testStartAutomated() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_Stage_1").singleResult()).getId();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        Assert.assertTrue((boolean)caseExecution.isActive());
        Assert.assertFalse((boolean)caseExecution.isEnabled());
        this.verifyTasksState(caseExecutionQuery);
    }

    protected void verifyTasksState(CaseExecutionQuery caseExecutionQuery) {
        CaseExecution firstHumanTask = (CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult();
        Assert.assertNotNull((Object)firstHumanTask);
        Assert.assertTrue((boolean)firstHumanTask.isActive());
        Assert.assertFalse((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = (CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_2").singleResult();
        Assert.assertNotNull((Object)secondHumanTask);
        Assert.assertTrue((boolean)secondHumanTask.isActive());
        Assert.assertFalse((boolean)secondHumanTask.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCaseWithManualActivation.cmmn"})
    @Test
    public void testManualStart() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        Assert.assertTrue((boolean)caseExecution.isActive());
        Assert.assertFalse((boolean)caseExecution.isEnabled());
        this.verifyTasksState(caseExecutionQuery);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCaseWithManualActivation.cmmn"})
    @Test
    public void testManualStartWithVariable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).manualStart();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        Assert.assertTrue((boolean)caseExecution.isActive());
        Assert.assertFalse((boolean)caseExecution.isEnabled());
        this.verifyTasksState(caseExecutionQuery);
        List result = this.runtimeService.createVariableInstanceQuery().list();
        this.verifyVariables(caseInstanceId, caseInstanceId, result);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCaseWithManualActivation.cmmn"})
    @Test
    public void testManualWithVariables() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_Stage_1").singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(caseExecutionId).setVariables(variables).manualStart();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        Assert.assertTrue((boolean)caseExecution.isActive());
        Assert.assertFalse((boolean)caseExecution.isEnabled());
        this.verifyTasksState(caseExecutionQuery);
        List result = this.runtimeService.createVariableInstanceQuery().list();
        this.verifyVariables(caseInstanceId, caseInstanceId, result);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCaseWithManualActivation.cmmn"})
    @Test
    public void testManualStartWithLocalVariable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).manualStart();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        Assert.assertTrue((boolean)caseExecution.isActive());
        Assert.assertFalse((boolean)caseExecution.isEnabled());
        this.verifyTasksState(caseExecutionQuery);
        List result = this.runtimeService.createVariableInstanceQuery().list();
        this.verifyVariables(caseInstanceId, caseExecutionId, result);
    }

    protected void verifyVariables(String caseInstanceId, String caseExecutionId, List<VariableInstance> result) {
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        for (VariableInstance variable : result) {
            Assert.assertEquals((Object)caseExecutionId, (Object)variable.getCaseExecutionId());
            Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                Assert.assertEquals((Object)"aVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                Assert.assertEquals((Object)"anotherVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            Assert.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCaseWithManualActivation.cmmn"})
    @Test
    public void testManualStartWithLocalVariables() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_Stage_1").singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(caseExecutionId).setVariablesLocal(variables).manualStart();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        Assert.assertTrue((boolean)caseExecution.isActive());
        Assert.assertFalse((boolean)caseExecution.isEnabled());
        this.verifyTasksState(caseExecutionQuery);
        List result = this.runtimeService.createVariableInstanceQuery().list();
        this.verifyVariables(caseInstanceId, caseExecutionId, result);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    @Test
    public void testReenableAnEnabledStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseExecutionId).reenable();
            Assert.fail((String)"It should not be possible to re-enable an enabled stage.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskAndOneStageWithManualActivationCase.cmmn"})
    @Test
    public void testReenableAnDisabledStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        this.caseService.withCaseExecution(caseExecutionId).reenable();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        Assert.assertFalse((boolean)caseExecution.isDisabled());
        Assert.assertFalse((boolean)caseExecution.isActive());
        Assert.assertTrue((boolean)caseExecution.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    @Test
    public void testReenableAnActiveStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseExecutionId).reenable();
            Assert.fail((String)"It should not be possible to re-enable an active human task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskAndOneStageWithManualActivationCase.cmmn"})
    @Test
    public void testDisableAnEnabledStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        Assert.assertTrue((boolean)caseExecution.isDisabled());
        Assert.assertFalse((boolean)caseExecution.isActive());
        Assert.assertFalse((boolean)caseExecution.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskAndOneStageWithManualActivationCase.cmmn"})
    @Test
    public void testDisableADisabledStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        try {
            this.caseService.withCaseExecution(caseExecutionId).disable();
            Assert.fail((String)"It should not be possible to disable a already disabled human task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    @Test
    public void testDisableAnActiveStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseExecutionId).disable();
            Assert.fail((String)"It should not be possible to disable an active human task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskAndOneStageWithManualActivationCase.cmmn"})
    @Test
    public void testManualStartOfADisabledStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        try {
            this.caseService.withCaseExecution(caseExecutionId).manualStart();
            Assert.fail((String)"It should not be possible to start a disabled human task manually.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    @Test
    public void testManualStartOfAnActiveStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseExecutionId).manualStart();
            Assert.fail((String)"It should not be possible to start an already active human task manually.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCaseWithManualActivation.cmmn"})
    @Test
    public void testDisableShouldCompleteCaseInstance() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult();
        Assert.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().completed().singleResult();
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    @Test
    public void testCompleteShouldCompleteCaseInstance() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId()).complete();
        this.caseService.withCaseExecution(this.queryCaseExecutionByActivityId("PI_HumanTask_2").getId()).complete();
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().completed().singleResult();
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskAndOneStageCase.cmmn"})
    @Test
    public void testComplete() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(this.queryCaseExecutionByActivityId("PI_HumanTask_11").getId()).complete();
        this.caseService.withCaseExecution(this.queryCaseExecutionByActivityId("PI_HumanTask_2").getId()).complete();
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult();
        Assert.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().active().singleResult();
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertTrue((boolean)caseInstance.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    @Test
    public void testCompleteEnabledStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseExecutionId).complete();
            Assert.fail((String)"Should not be able to complete stage.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskAndOneStageWithManualActivationCase.cmmn"})
    @Test
    public void testCompleteDisabledStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        try {
            this.caseService.withCaseExecution(caseExecutionId).complete();
            Assert.fail((String)"Should not be able to complete stage.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/emptyStageCase.cmmn"})
    @Test
    public void testAutoCompletionOfEmptyStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult();
        Assert.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().completed().singleResult();
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    @Test
    public void testClose() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseExecutionId).close();
            Assert.fail((String)"It should not be possible to close a stage.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    @Test
    public void testTerminate() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseExecution stageExecution = this.queryCaseExecutionByActivityId("PI_Stage_1");
        CaseExecution humanTaskExecution1 = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        Assert.assertTrue((boolean)humanTaskExecution1.isActive());
        CaseExecution humanTaskExecution2 = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        Assert.assertTrue((boolean)humanTaskExecution2.isActive());
        this.caseService.withCaseExecution(stageExecution.getId()).terminate();
        stageExecution = this.queryCaseExecutionByActivityId("PI_Stage_1");
        Assert.assertNull((Object)stageExecution);
        humanTaskExecution1 = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        Assert.assertNull((Object)humanTaskExecution1);
        humanTaskExecution2 = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        Assert.assertNull((Object)humanTaskExecution2);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    @Test
    public void testTerminateNonFluent() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseExecution stageExecution = this.queryCaseExecutionByActivityId("PI_Stage_1");
        this.caseService.terminateCaseExecution(stageExecution.getId());
        stageExecution = this.queryCaseExecutionByActivityId("PI_Stage_1");
        Assert.assertNull((Object)stageExecution);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCaseWithManualActivation.cmmn"})
    @Test
    public void testTerminateWithNonActiveState() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseExecution stageExecution = this.queryCaseExecutionByActivityId("PI_Stage_1");
        try {
            this.caseService.terminateCaseExecution(stageExecution.getId());
            Assert.fail((String)"It should not be possible to terminate a task.");
        }
        catch (NotAllowedException e) {
            boolean result = e.getMessage().contains("The case execution must be in state 'active' to terminate");
            Assert.assertTrue((boolean)result);
        }
    }

    protected CaseExecution queryCaseExecutionByActivityId(String activityId) {
        return (CaseExecution)this.caseService.createCaseExecutionQuery().activityId(activityId).singleResult();
    }
}

