/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.async;

import java.util.List;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class AsyncEndEventTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testAsyncEndEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("asyncEndEvent");
        long count = this.runtimeService.createProcessInstanceQuery().processInstanceId(pi.getId()).active().count();
        Assert.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().activityId("endEvent").count());
        Assert.assertEquals((long)1L, (long)count);
        this.testRule.executeAvailableJobs();
        count = this.runtimeService.createProcessInstanceQuery().processInstanceId(pi.getId()).count();
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().activityId("endEvent").active().count());
        Assert.assertEquals((long)0L, (long)count);
    }

    @Deployment
    @Test
    public void testAsyncEndEventListeners() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("asyncEndEvent");
        long count = this.runtimeService.createProcessInstanceQuery().processInstanceId(pi.getId()).active().count();
        Assert.assertNull((Object)this.runtimeService.getVariable(pi.getId(), "listener"));
        Assert.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().activityId("endEvent").count());
        Assert.assertEquals((long)1L, (long)count);
        this.testRule.executeAvailableJobs();
        count = this.runtimeService.createProcessInstanceQuery().processInstanceId(pi.getId()).active().count();
        Assert.assertEquals((long)0L, (long)count);
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            HistoricVariableInstanceQuery name = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(pi.getId()).variableName("listener");
            Assert.assertNotNull((Object)name);
            Assert.assertEquals((Object)"listener invoked", (Object)((HistoricVariableInstance)name.singleResult()).getValue());
        }
    }

    @Deployment
    @Test
    public void testMultipleAsyncEndEvents() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("multipleAsyncEndEvent");
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        List jobs = this.managementService.createJobQuery().withRetriesLeft().list();
        Assert.assertEquals((long)2L, (long)jobs.size());
        this.managementService.executeJob(((Job)jobs.get(0)).getId());
        jobs = this.managementService.createJobQuery().withRetriesLeft().list();
        Assert.assertEquals((long)1L, (long)jobs.size());
        this.managementService.executeJob(((Job)jobs.get(0)).getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            HistoricVariableInstanceQuery name = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(pi.getId()).variableName("message");
            Assert.assertNotNull((Object)name);
            Assert.assertEquals((Object)true, (Object)((HistoricVariableInstance)name.singleResult()).getValue());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/AsyncEndEventTest.testCallActivity-super.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/async/AsyncEndEventTest.testCallActivity-sub.bpmn20.xml"})
    @Test
    public void testCallActivity() {
        this.runtimeService.startProcessInstanceByKey("super");
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("sub").singleResult();
        Assert.assertTrue((boolean)(pi instanceof ExecutionEntity));
        Assert.assertEquals((Object)"theSubEnd", (Object)((ExecutionEntity)pi).getActivityId());
    }
}

