/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.bpmn.iomapping.VariableLogDelegate;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ConditionalEventDefinitionBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@RequiredHistoryLevel(value="audit")
public class BoundaryEventInputOutputTest
extends PluggableProcessEngineTest {
    protected static final BpmnModelInstance EVENT_GATEWAY_PROCESS = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ConditionalEventDefinitionBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().manualTask("manualTask").boundaryEvent().conditionalEventDefinition().condition("${moveOn}")).conditionalEventDefinitionDone().serviceTask("inputParameterTask").camundaInputParameter("variable1", "testValue")).camundaClass(VariableLogDelegate.class)).endEvent().moveToActivity("manualTask").endEvent().done();
    protected boolean skipOutputMappingVal;

    @Before
    public void setUp() {
        this.skipOutputMappingVal = this.processEngineConfiguration.isSkipOutputMappingOnCanceledActivities();
        this.processEngineConfiguration.setSkipOutputMappingOnCanceledActivities(true);
        VariableLogDelegate.reset();
    }

    @After
    public void tearDown() {
        this.processEngineConfiguration.setSkipOutputMappingOnCanceledActivities(this.skipOutputMappingVal);
        VariableLogDelegate.reset();
    }

    @Test
    public void shouldProcessInputOutputParametersAfterEventGateway() {
        this.testRule.deploy(EVENT_GATEWAY_PROCESS);
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.putValue((String)"moveOn", (Object)true));
        List vars = this.historyService.createHistoricVariableInstanceQuery().variableName("variable1").list();
        Assertions.assertThat((List)vars).hasSize(1);
        Assertions.assertThat((Object)((HistoricVariableInstance)vars.get(0)).getValue()).isEqualTo((Object)"testValue");
    }
}

