/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@RequiredHistoryLevel(value="full")
public class LicenseUserOperationLogTest {
    private static final String LICENSE_KEY = "testLicenseKey";
    private static final String USER_ID = "testUserId";
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    ProcessEngine processEngine;
    ManagementService managementService;
    HistoryService historyService;
    IdentityService identityService;

    @Before
    public void init() {
        this.processEngine = this.engineRule.getProcessEngine();
        this.managementService = this.processEngine.getManagementService();
        this.historyService = this.processEngine.getHistoryService();
        this.identityService = this.processEngine.getIdentityService();
    }

    @After
    public void tearDown() {
        this.identityService.clearAuthentication();
        this.managementService.deleteLicenseKey();
    }

    @Test
    public void shouldUpdateOperationLogWhenSetLicense() {
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.managementService.setLicenseKey(LICENSE_KEY);
        UserOperationLogEntry entry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        this.assertOperationLogEntry(entry, "Create", "camunda-license-key-id");
    }

    @Test
    public void shouldUpdateOperationLogWhenUpdateLicense() {
        this.managementService.setLicenseKey("oldLicense");
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.managementService.setLicenseKey(LICENSE_KEY);
        UserOperationLogEntry entry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        this.assertOperationLogEntry(entry, "Update", "camunda-license-key-id");
    }

    @Test
    public void shouldUpdateOperationLogWhenUpdateLegacyLicense() {
        this.managementService.setProperty("camunda-license-key", "oldLicense");
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.managementService.setLicenseKey(LICENSE_KEY);
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().count()).isEqualTo(2L);
        UserOperationLogEntry createEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().operationType("Create").singleResult();
        UserOperationLogEntry deleteEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().operationType("Delete").singleResult();
        this.assertOperationLogEntry(createEntry, "Create", "camunda-license-key-id");
        this.assertOperationLogEntry(deleteEntry, "Delete", "camunda-license-key");
    }

    @Test
    public void shouldUpdateOperationLogWhenUpdateLicenseDuplicate() {
        this.managementService.setLicenseKey(LICENSE_KEY);
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.managementService.setLicenseKey(LICENSE_KEY);
        UserOperationLogEntry entry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        this.assertOperationLogEntry(entry, "Update", "camunda-license-key-id");
    }

    @Test
    public void shouldUpdateOperationLogWhenDeleteLicense() {
        this.managementService.setLicenseKey(LICENSE_KEY);
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.managementService.deleteLicenseKey();
        UserOperationLogEntry entry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        this.assertOperationLogEntry(entry, "Delete", "camunda-license-key-id");
    }

    @Test
    public void shouldNotUpdateOperationLogWhenDeleteNonExistingLicense() {
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.managementService.deleteLicenseKey();
        UserOperationLogEntry entry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((Object)entry).isNull();
    }

    private void assertOperationLogEntry(UserOperationLogEntry entry, String expectedOperationType, String expectedNewValue) {
        Assertions.assertThat((String)entry.getEntityType()).isEqualTo((Object)"Property");
        Assertions.assertThat((String)entry.getCategory()).isEqualTo((Object)"Admin");
        Assertions.assertThat((String)entry.getOperationType()).isEqualTo((Object)expectedOperationType);
        Assertions.assertThat((String)entry.getProperty()).isEqualTo((Object)"name");
        Assertions.assertThat((String)entry.getOrgValue()).isNull();
        Assertions.assertThat((String)entry.getNewValue()).isEqualTo((Object)expectedNewValue);
    }
}

