/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DiagramLayout;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyProcessDefinitionCmdsTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String BPMN_PROCESS_MODEL = "org/camunda/bpm/engine/test/api/multitenancy/testProcess.bpmn";
    protected static final String BPMN_PROCESS_DIAGRAM = "org/camunda/bpm/engine/test/api/multitenancy/testProcess.png";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected HistoryService historyService;
    protected RepositoryService repositoryService;
    protected IdentityService identityService;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected String processDefinitionId;

    @Before
    public void setUp() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.identityService = this.engineRule.getIdentityService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
        this.testRule.deployForTenant(TENANT_ONE, BPMN_PROCESS_MODEL, BPMN_PROCESS_DIAGRAM);
        this.processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
    }

    @Test
    public void failToGetProcessModelNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.getProcessModel(this.processDefinitionId)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot get the process definition");
    }

    @Test
    public void getProcessModelWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        InputStream inputStream = this.repositoryService.getProcessModel(this.processDefinitionId);
        Assertions.assertThat((InputStream)inputStream).isNotNull();
    }

    @Test
    public void getProcessModelDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        InputStream inputStream = this.repositoryService.getProcessModel(this.processDefinitionId);
        Assertions.assertThat((InputStream)inputStream).isNotNull();
    }

    @Test
    public void failToGetProcessDiagramNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.getProcessDiagram(this.processDefinitionId)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot get the process definition");
    }

    @Test
    public void getProcessDiagramWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        InputStream inputStream = this.repositoryService.getProcessDiagram(this.processDefinitionId);
        Assertions.assertThat((InputStream)inputStream).isNotNull();
    }

    @Test
    public void getProcessDiagramDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        InputStream inputStream = this.repositoryService.getProcessDiagram(this.processDefinitionId);
        Assertions.assertThat((InputStream)inputStream).isNotNull();
    }

    @Test
    public void failToGetProcessDiagramLayoutNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.getProcessDiagramLayout(this.processDefinitionId)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot get the process definition");
    }

    @Test
    public void getProcessDiagramLayoutWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        DiagramLayout diagramLayout = this.repositoryService.getProcessDiagramLayout(this.processDefinitionId);
        Assertions.assertThat((Object)diagramLayout).isNotNull();
    }

    @Test
    public void getProcessDiagramLayoutDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        DiagramLayout diagramLayout = this.repositoryService.getProcessDiagramLayout(this.processDefinitionId);
        Assertions.assertThat((Object)diagramLayout).isNotNull();
    }

    @Test
    public void failToGetProcessDefinitionNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.getProcessDefinition(this.processDefinitionId)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot get the process definition");
    }

    @Test
    public void getProcessDefinitionWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        ProcessDefinition definition = this.repositoryService.getProcessDefinition(this.processDefinitionId);
        Assertions.assertThat((String)definition.getTenantId()).isEqualTo((Object)TENANT_ONE);
    }

    @Test
    public void getProcessDefinitionDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        ProcessDefinition definition = this.repositoryService.getProcessDefinition(this.processDefinitionId);
        Assertions.assertThat((String)definition.getTenantId()).isEqualTo((Object)TENANT_ONE);
    }

    @Test
    public void failToGetBpmnModelInstanceNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.getBpmnModelInstance(this.processDefinitionId)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot get the process definition");
    }

    @Test
    public void getBpmnModelInstanceWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        BpmnModelInstance modelInstance = this.repositoryService.getBpmnModelInstance(this.processDefinitionId);
        Assertions.assertThat((Object)modelInstance).isNotNull();
    }

    @Test
    public void getBpmnModelInstanceDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        BpmnModelInstance modelInstance = this.repositoryService.getBpmnModelInstance(this.processDefinitionId);
        Assertions.assertThat((Object)modelInstance).isNotNull();
    }

    @Test
    public void failToDeleteProcessDefinitionNoAuthenticatedTenant() {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.deleteProcessDefinition(((ProcessDefinition)processDefinitions.get(0)).getId())).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot delete the process definition");
    }

    @Test
    public void testDeleteProcessDefinitionWithAuthenticatedTenant() {
        Deployment deployment = this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/repository/twoProcesses.bpmn20.xml");
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId());
        List processDefinitions = processDefinitionQuery.list();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.repositoryService.deleteProcessDefinition(((ProcessDefinition)processDefinitions.get(0)).getId());
        this.identityService.clearAuthentication();
        Assertions.assertThat((long)processDefinitionQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)processDefinitionQuery.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void testDeleteCascadeProcessDefinitionWithAuthenticatedTenant() {
        BpmnModelInstance bpmnModel = Bpmn.createExecutableProcess((String)"process").startEvent().userTask().endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, bpmnModel);
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery();
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitionQuery.processDefinitionKey("process").singleResult();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("process").executeWithVariablesInReturn();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.repositoryService.deleteProcessDefinition(processDefinition.getId(), true);
        this.identityService.clearAuthentication();
        Assert.assertEquals((long)0L, (long)this.engineRule.getRuntimeService().createProcessInstanceQuery().count());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= HistoryLevel.HISTORY_LEVEL_ACTIVITY.getId()) {
            Assert.assertEquals((long)0L, (long)this.engineRule.getHistoryService().createHistoricActivityInstanceQuery().count());
        }
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().count()).isEqualTo(1L);
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void testDeleteProcessDefinitionDisabledTenantCheck() {
        Deployment deployment = this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/repository/twoProcesses.bpmn20.xml");
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId());
        List processDefinitions = processDefinitionQuery.list();
        this.identityService.setAuthentication("user", null, null);
        this.repositoryService.deleteProcessDefinition(((ProcessDefinition)processDefinitions.get(0)).getId());
        this.identityService.clearAuthentication();
        Assertions.assertThat((long)processDefinitionQuery.count()).isEqualTo(1L);
        Assertions.assertThat((long)processDefinitionQuery.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void testDeleteCascadeProcessDefinitionDisabledTenantCheck() {
        BpmnModelInstance bpmnModel = Bpmn.createExecutableProcess((String)"process").startEvent().userTask().endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, bpmnModel);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery();
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitionQuery.processDefinitionKey("process").singleResult();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("process").executeWithVariablesInReturn();
        this.identityService.setAuthentication("user", null, null);
        this.repositoryService.deleteProcessDefinition(processDefinition.getId(), true);
        this.identityService.clearAuthentication();
        Assert.assertEquals((long)0L, (long)this.engineRule.getRuntimeService().createProcessInstanceQuery().count());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= HistoryLevel.HISTORY_LEVEL_ACTIVITY.getId()) {
            Assert.assertEquals((long)0L, (long)this.engineRule.getHistoryService().createHistoricActivityInstanceQuery().count());
        }
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().count()).isEqualTo(1L);
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void failToDeleteProcessDefinitionsByKeyNoAuthenticatedTenant() {
        for (int i = 0; i < 3; ++i) {
            this.deployProcessDefinitionWithTenant();
        }
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.deleteProcessDefinitions().byKey("process").withoutTenantId().delete()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("No process definition found");
    }

    @Test
    public void testDeleteProcessDefinitionsByKeyForAllTenants() {
        for (int i = 0; i < 3; ++i) {
            this.deployProcessDefinitionWithTenant();
            this.deployProcessDefinitionWithoutTenant();
        }
        this.repositoryService.deleteProcessDefinitions().byKey("process").delete();
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().count()).isEqualTo(1L);
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void testDeleteProcessDefinitionsByKeyWithAuthenticatedTenant() {
        for (int i = 0; i < 3; ++i) {
            this.deployProcessDefinitionWithTenant();
        }
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.repositoryService.deleteProcessDefinitions().byKey("process").withTenantId(TENANT_ONE).delete();
        this.identityService.clearAuthentication();
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().count()).isEqualTo(1L);
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void testDeleteCascadeProcessDefinitionsByKeyWithAuthenticatedTenant() {
        for (int i = 0; i < 3; ++i) {
            this.deployProcessDefinitionWithTenant();
        }
        this.runtimeService.startProcessInstanceByKey("process");
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.repositoryService.deleteProcessDefinitions().byKey("process").withTenantId(TENANT_ONE).cascade().delete();
        this.identityService.clearAuthentication();
        Assertions.assertThat((long)this.historyService.createHistoricProcessInstanceQuery().count()).isEqualTo(0L);
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().count()).isEqualTo(1L);
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void testDeleteProcessDefinitionsByKeyDisabledTenantCheck() {
        for (int i = 0; i < 3; ++i) {
            this.deployProcessDefinitionWithTenant();
        }
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        this.repositoryService.deleteProcessDefinitions().byKey("process").withTenantId(TENANT_ONE).delete();
        this.identityService.clearAuthentication();
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().count()).isEqualTo(1L);
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void testDeleteCascadeProcessDefinitionsByKeyDisabledTenantCheck() {
        for (int i = 0; i < 3; ++i) {
            this.deployProcessDefinitionWithTenant();
        }
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        this.runtimeService.startProcessInstanceByKey("process");
        this.repositoryService.deleteProcessDefinitions().byKey("process").withTenantId(TENANT_ONE).cascade().delete();
        this.identityService.clearAuthentication();
        Assertions.assertThat((long)this.historyService.createHistoricProcessInstanceQuery().count()).isEqualTo(0L);
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().count()).isEqualTo(1L);
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void failToDeleteProcessDefinitionsByIdsNoAuthenticatedTenant() {
        for (int i = 0; i < 3; ++i) {
            this.deployProcessDefinitionWithTenant();
        }
        String[] processDefinitionIds = this.findProcessDefinitionIdsByKey("process");
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.deleteProcessDefinitions().byIds(processDefinitionIds).delete()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot delete the process definition");
    }

    @Test
    public void testDeleteProcessDefinitionsByIdsWithAuthenticatedTenant() {
        for (int i = 0; i < 3; ++i) {
            this.deployProcessDefinitionWithTenant();
        }
        String[] processDefinitionIds = this.findProcessDefinitionIdsByKey("process");
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.repositoryService.deleteProcessDefinitions().byIds(processDefinitionIds).delete();
        this.identityService.clearAuthentication();
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().count()).isEqualTo(1L);
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void testDeleteCascadeProcessDefinitionsByIdsWithAuthenticatedTenant() {
        for (int i = 0; i < 3; ++i) {
            this.deployProcessDefinitionWithTenant();
        }
        String[] processDefinitionIds = this.findProcessDefinitionIdsByKey("process");
        this.runtimeService.startProcessInstanceByKey("process");
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.repositoryService.deleteProcessDefinitions().byIds(processDefinitionIds).cascade().delete();
        this.identityService.clearAuthentication();
        Assertions.assertThat((long)this.historyService.createHistoricProcessInstanceQuery().count()).isEqualTo(0L);
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().count()).isEqualTo(1L);
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void testDeleteProcessDefinitionsByIdsDisabledTenantCheck() {
        for (int i = 0; i < 3; ++i) {
            this.deployProcessDefinitionWithTenant();
        }
        String[] processDefinitionIds = this.findProcessDefinitionIdsByKey("process");
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        this.repositoryService.deleteProcessDefinitions().byIds(processDefinitionIds).delete();
        this.identityService.clearAuthentication();
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().count()).isEqualTo(1L);
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void testDeleteCascadeProcessDefinitionsByIdsDisabledTenantCheck() {
        for (int i = 0; i < 3; ++i) {
            this.deployProcessDefinitionWithTenant();
        }
        String[] processDefinitionIds = this.findProcessDefinitionIdsByKey("process");
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        this.runtimeService.startProcessInstanceByKey("process");
        this.repositoryService.deleteProcessDefinitions().byIds(processDefinitionIds).cascade().delete();
        this.identityService.clearAuthentication();
        Assertions.assertThat((long)this.historyService.createHistoricProcessInstanceQuery().count()).isEqualTo(0L);
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().count()).isEqualTo(1L);
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void updateHistoryTimeToLiveWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.repositoryService.updateProcessDefinitionHistoryTimeToLive(this.processDefinitionId, Integer.valueOf(6));
        ProcessDefinition definition = this.repositoryService.getProcessDefinition(this.processDefinitionId);
        Assertions.assertThat((String)definition.getTenantId()).isEqualTo((Object)TENANT_ONE);
        Assertions.assertThat((Integer)definition.getHistoryTimeToLive()).isEqualTo(6);
    }

    @Test
    public void updateHistoryTimeToLiveDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        this.repositoryService.updateProcessDefinitionHistoryTimeToLive(this.processDefinitionId, Integer.valueOf(6));
        ProcessDefinition definition = this.repositoryService.getProcessDefinition(this.processDefinitionId);
        Assertions.assertThat((String)definition.getTenantId()).isEqualTo((Object)TENANT_ONE);
        Assertions.assertThat((Integer)definition.getHistoryTimeToLive()).isEqualTo(6);
    }

    @Test
    public void updateHistoryTimeToLiveNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.updateProcessDefinitionHistoryTimeToLive(this.processDefinitionId, Integer.valueOf(6))).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot update the process definition");
    }

    private String[] findProcessDefinitionIdsByKey(String processDefinitionKey) {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).list();
        ArrayList<String> processDefinitionIds = new ArrayList<String>();
        for (ProcessDefinition processDefinition : processDefinitions) {
            processDefinitionIds.add(processDefinition.getId());
        }
        return processDefinitionIds.toArray(new String[0]);
    }

    private void deployProcessDefinitionWithTenant() {
        this.testRule.deployForTenant(TENANT_ONE, Bpmn.createExecutableProcess((String)"process").startEvent().userTask().endEvent().done());
    }

    private void deployProcessDefinitionWithoutTenant() {
        this.testRule.deploy(Bpmn.createExecutableProcess((String)"process").startEvent().userTask().endEvent().done());
    }
}

