/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.optimize;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.OptimizeService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class GetCompletedHistoricTaskInstancesForOptimizeTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    private OptimizeService optimizeService;
    protected String userId = "test";
    private IdentityService identityService;
    private RuntimeService runtimeService;
    private AuthorizationService authorizationService;
    private TaskService taskService;
    private HistoryService historyService;

    @Before
    public void init() {
        ProcessEngineConfigurationImpl config = this.engineRule.getProcessEngineConfiguration();
        this.optimizeService = config.getOptimizeService();
        this.identityService = this.engineRule.getIdentityService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.authorizationService = this.engineRule.getAuthorizationService();
        this.taskService = this.engineRule.getTaskService();
        this.historyService = this.engineRule.getHistoryService();
        this.createUser(this.userId);
    }

    @After
    public void cleanUp() {
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Group group : this.identityService.createGroupQuery().list()) {
            this.identityService.deleteGroup(group.getId());
        }
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
        for (HistoricTaskInstance task : this.historyService.createHistoricTaskInstanceQuery().list()) {
            this.historyService.deleteHistoricTaskInstance(task.getId());
        }
        ClockUtil.reset();
    }

    @Test
    public void getCompletedHistoricTaskInstances() {
        BpmnModelInstance simpleDefinition = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").userTask("userTask").name("task")).endEvent("endEvent").done();
        this.testHelper.deploy(simpleDefinition);
        this.runtimeService.startProcessInstanceByKey("process");
        this.completeAllUserTasks();
        List completedHistoricTaskInstances = this.optimizeService.getCompletedHistoricTaskInstances(null, null, 10);
        MatcherAssert.assertThat((Object)completedHistoricTaskInstances.size(), (Matcher)CoreMatchers.is((Object)1));
        this.assertThatTasksHaveAllImportantInformation((HistoricTaskInstance)completedHistoricTaskInstances.get(0));
    }

    @Test
    public void fishedAfterParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().userTask("userTask1").userTask("userTask2").userTask("userTask3").endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.completeAllUserTasks();
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.completeAllUserTasks();
        Date nowPlus4Seconds = new Date(now.getTime() + 4000L);
        ClockUtil.setCurrentTime((Date)nowPlus4Seconds);
        this.completeAllUserTasks();
        List completedHistoricTaskInstances = this.optimizeService.getCompletedHistoricTaskInstances(now, null, 10);
        HashSet<String> allowedTaskIds = new HashSet<String>(Arrays.asList("userTask2", "userTask3"));
        MatcherAssert.assertThat((Object)completedHistoricTaskInstances.size(), (Matcher)CoreMatchers.is((Object)2));
        TestCase.assertTrue((boolean)allowedTaskIds.contains(((HistoricTaskInstance)completedHistoricTaskInstances.get(0)).getTaskDefinitionKey()));
        TestCase.assertTrue((boolean)allowedTaskIds.contains(((HistoricTaskInstance)completedHistoricTaskInstances.get(1)).getTaskDefinitionKey()));
    }

    @Test
    public void fishedAtParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").userTask("userTask1").userTask("userTask2").endEvent("endEvent").done();
        this.testHelper.deploy(simpleDefinition);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.completeAllUserTasks();
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.completeAllUserTasks();
        List completedHistoricTaskInstances = this.optimizeService.getCompletedHistoricTaskInstances(null, now, 10);
        MatcherAssert.assertThat((Object)completedHistoricTaskInstances.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((HistoricTaskInstance)completedHistoricTaskInstances.get(0)).getTaskDefinitionKey(), (Matcher)CoreMatchers.is((Object)"userTask1"));
    }

    @Test
    public void fishedAfterAndFinishedAtParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").userTask("userTask1").userTask("userTask2").endEvent("endEvent").done();
        this.testHelper.deploy(simpleDefinition);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.completeAllUserTasks();
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.completeAllUserTasks();
        List completedHistoricTaskInstances = this.optimizeService.getCompletedHistoricTaskInstances(now, now, 10);
        MatcherAssert.assertThat((Object)completedHistoricTaskInstances.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void maxResultsParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().userTask().userTask().userTask().userTask().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.completeAllUserTasks();
        this.completeAllUserTasks();
        this.completeAllUserTasks();
        this.completeAllUserTasks();
        List completedHistoricTaskInstances = this.optimizeService.getCompletedHistoricTaskInstances(this.pastDate(), null, 3);
        MatcherAssert.assertThat((Object)completedHistoricTaskInstances.size(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void resultIsSortedByEndTime() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().userTask("userTask1").userTask("userTask2").userTask("userTask3").endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.completeAllUserTasks();
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.completeAllUserTasks();
        Date nowPlus4Seconds = new Date(now.getTime() + 4000L);
        ClockUtil.setCurrentTime((Date)nowPlus4Seconds);
        this.completeAllUserTasks();
        List completedHistoricTaskInstances = this.optimizeService.getCompletedHistoricTaskInstances(this.pastDate(), null, 4);
        MatcherAssert.assertThat((Object)completedHistoricTaskInstances.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)((HistoricTaskInstance)completedHistoricTaskInstances.get(0)).getTaskDefinitionKey(), (Matcher)CoreMatchers.is((Object)"userTask1"));
        MatcherAssert.assertThat((Object)((HistoricTaskInstance)completedHistoricTaskInstances.get(1)).getTaskDefinitionKey(), (Matcher)CoreMatchers.is((Object)"userTask2"));
        MatcherAssert.assertThat((Object)((HistoricTaskInstance)completedHistoricTaskInstances.get(2)).getTaskDefinitionKey(), (Matcher)CoreMatchers.is((Object)"userTask3"));
    }

    @Test
    public void fetchOnlyCompletedTasks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").userTask("userTask1").userTask("userTask2").endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.completeAllUserTasks();
        List completedHistoricTaskInstances = this.optimizeService.getCompletedHistoricTaskInstances(this.pastDate(), null, 10);
        MatcherAssert.assertThat((Object)completedHistoricTaskInstances.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((HistoricTaskInstance)completedHistoricTaskInstances.get(0)).getTaskDefinitionKey(), (Matcher)CoreMatchers.is((Object)"userTask1"));
    }

    @Test
    public void doNotReturnCompletedStandaloneTasks() {
        Task task = this.taskService.newTask("standaloneTaskId");
        this.taskService.saveTask(task);
        this.completeAllUserTasks();
        List completedHistoricTaskInstances = this.optimizeService.getCompletedHistoricTaskInstances(null, null, 10);
        TestCase.assertTrue((boolean)completedHistoricTaskInstances.isEmpty());
    }

    private Date pastDate() {
        return new Date(2L);
    }

    private void completeAllUserTasks() {
        List list = this.taskService.createTaskQuery().list();
        for (Task task : list) {
            this.taskService.claim(task.getId(), this.userId);
            this.taskService.complete(task.getId());
        }
    }

    protected void createUser(String userId) {
        User user = this.identityService.newUser(userId);
        this.identityService.saveUser(user);
    }

    private void assertThatTasksHaveAllImportantInformation(HistoricTaskInstance completedHistoricTaskInstance) {
        MatcherAssert.assertThat((Object)completedHistoricTaskInstance, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)completedHistoricTaskInstance.getId(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)completedHistoricTaskInstance.getTaskDefinitionKey(), (Matcher)CoreMatchers.is((Object)"userTask"));
        MatcherAssert.assertThat((Object)completedHistoricTaskInstance.getName(), (Matcher)CoreMatchers.is((Object)"task"));
        MatcherAssert.assertThat((Object)completedHistoricTaskInstance.getStartTime(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)completedHistoricTaskInstance.getEndTime(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)completedHistoricTaskInstance.getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)"process"));
        MatcherAssert.assertThat((Object)completedHistoricTaskInstance.getProcessDefinitionId(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)completedHistoricTaskInstance.getAssignee(), (Matcher)CoreMatchers.is((Object)this.userId));
    }
}

