/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.scripttask.MySerializable;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.SerializationDataFormat;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ScriptTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.junit.After;
import org.junit.Test;

public class VariableInstanceTest
extends PluggableProcessEngineTest {
    private final List<String> deploymentIds = new ArrayList<String>();

    @After
    public void tearDown() throws Exception {
        this.deploymentIds.forEach(deploymentId -> this.repositoryService.deleteDeployment(deploymentId, true));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void shouldUpdateVariableStateOnVariableTypeChangeObjectToLong() {
        ProcessInstance processInstance = this.startProcessInstanceWithObjectVariable("oneTaskProcess", "variableA", "43");
        VariableInstanceEntity variable = (VariableInstanceEntity)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()}).singleResult();
        Assertions.assertThat((byte[])variable.getByteArrayValue()).isNotNull();
        Assertions.assertThat((String)variable.getByteArrayValueId()).isNotNull();
        Assertions.assertThat((Double)variable.getDoubleValue()).isNull();
        Assertions.assertThat((Long)variable.getLongValue()).isNull();
        Assertions.assertThat((String)variable.getTextValue()).isNull();
        Assertions.assertThat((String)variable.getTextValue2()).isEqualTo((Object)"java.lang.String");
        this.runtimeService.setVariable(processInstance.getId(), "variableA", (Object)43);
        variable = (VariableInstanceEntity)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()}).singleResult();
        Assertions.assertThat((byte[])variable.getByteArrayValue()).isNull();
        Assertions.assertThat((String)variable.getByteArrayValueId()).isNull();
        Assertions.assertThat((Double)variable.getDoubleValue()).isNull();
        Assertions.assertThat((Long)variable.getLongValue()).isEqualTo(43L);
        Assertions.assertThat((String)variable.getTextValue()).isEqualTo((Object)"43");
        Assertions.assertThat((String)variable.getTextValue2()).isNull();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void shouldUpdateVariableStateOnVariableTypeChangeDoubleToObject() {
        ProcessInstance processInstance = this.startProcessInstanceWithVariable("oneTaskProcess", "variableA", 43.0);
        VariableInstanceEntity variable = (VariableInstanceEntity)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()}).singleResult();
        Assertions.assertThat((Double)variable.getDoubleValue()).isEqualTo(43.0);
        Assertions.assertThat((Long)variable.getLongValue()).isNull();
        Assertions.assertThat((String)variable.getTextValue()).isNull();
        Assertions.assertThat((String)variable.getTextValue2()).isNull();
        Assertions.assertThat((Object)variable.getValue()).isEqualTo((Object)43.0);
        Assertions.assertThat((byte[])variable.getByteArrayValue()).isNull();
        Assertions.assertThat((String)variable.getByteArrayValueId()).isNull();
        this.setVariableWithObjectValue(processInstance.getId(), "variableA", "43.0");
        variable = (VariableInstanceEntity)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()}).singleResult();
        Assertions.assertThat((byte[])variable.getByteArrayValue()).isNotNull();
        Assertions.assertThat((String)variable.getByteArrayValueId()).isNotNull();
        Assertions.assertThat((Double)variable.getDoubleValue()).isNull();
        Assertions.assertThat((Long)variable.getLongValue()).isNull();
        Assertions.assertThat((String)variable.getTextValue()).isNull();
        Assertions.assertThat((String)variable.getTextValue2()).isEqualTo((Object)"java.lang.String");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void shouldUpdateVariableStateOnVariableTypeChangeStringToObject() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "variableA", Map.of("variableA", "This is a string value"));
        VariableInstanceEntity variable = (VariableInstanceEntity)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()}).singleResult();
        Assertions.assertThat((Double)variable.getDoubleValue()).isNull();
        Assertions.assertThat((Long)variable.getLongValue()).isNull();
        Assertions.assertThat((String)variable.getTextValue()).isEqualTo((Object)"This is a string value");
        Assertions.assertThat((String)variable.getTextValue2()).isNull();
        Assertions.assertThat((Object)variable.getValue()).isEqualTo((Object)"This is a string value");
        Assertions.assertThat((byte[])variable.getByteArrayValue()).isNull();
        Assertions.assertThat((String)variable.getByteArrayValueId()).isNull();
        this.setVariableWithObjectValue(processInstance.getId(), "variableA", "43.0");
        variable = (VariableInstanceEntity)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()}).singleResult();
        Assertions.assertThat((byte[])variable.getByteArrayValue()).isNotNull();
        Assertions.assertThat((String)variable.getByteArrayValueId()).isNotNull();
        Assertions.assertThat((Double)variable.getDoubleValue()).isNull();
        Assertions.assertThat((Long)variable.getLongValue()).isNull();
        Assertions.assertThat((String)variable.getTextValue()).isNull();
        Assertions.assertThat((String)variable.getTextValue2()).isEqualTo((Object)"java.lang.String");
    }

    @Test
    public void shouldNotDeleteByteArrayWhenTypeDoesNotChange() {
        this.deployProcess(((ScriptTaskBuilder)((ScriptTaskBuilder)((ScriptTaskBuilder)((ScriptTaskBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().camundaAsyncAfter()).scriptTask().scriptFormat("groovy")).scriptText("println 'var ' + myVar")).scriptTask().scriptFormat("groovy")).scriptText("execution.setVariable('myVar', new org.camunda.bpm.engine.test.bpmn.scripttask.MySerializable('updated value'))")).userTask().endEvent().done());
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)Variables.createVariables().putValue("myVar", (Object)new MySerializable("initial value")));
        VariableInstanceEntity variable = (VariableInstanceEntity)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{pi.getId()}).singleResult();
        String byteArrayIdBeforeUpdate = variable.getByteArrayValueId();
        String id = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(id);
        this.testRule.waitForJobExecutorToProcessAllJobs(5000L);
        variable = (VariableInstanceEntity)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{pi.getId()}).singleResult();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)variable.getTextValue2()).withFailMessage("The type of the variable didn't change and should be MySerializable", new Object[0])).isEqualTo((Object)"org.camunda.bpm.engine.test.bpmn.scripttask.MySerializable");
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)((MySerializable)variable.getValue()).getName()).withFailMessage("The variable changed value", new Object[0])).isEqualTo((Object)"updated value");
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)variable.getByteArrayValueId()).withFailMessage("The byte array should not be deleted (id changed) since the type did not change", new Object[0])).isEqualTo((Object)byteArrayIdBeforeUpdate);
    }

    @Test
    public void shouldDeleteByteArrayOnNullifyOfExistingNonNullVariable() {
        this.deployProcess(((ScriptTaskBuilder)((ScriptTaskBuilder)((ScriptTaskBuilder)((ScriptTaskBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().camundaAsyncAfter()).scriptTask().scriptFormat("groovy")).scriptText("println 'var ' + myVar")).scriptTask().scriptFormat("groovy")).scriptText("execution.setVariable('myVar', null)")).userTask().endEvent().done());
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)Variables.createVariables().putValue("myVar", (Object)new MySerializable("not null value")));
        VariableInstanceEntity variable = (VariableInstanceEntity)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{pi.getId()}).singleResult();
        String byteArrayIdBeforeUpdate = variable.getByteArrayValueId();
        Assertions.assertThat((byte[])variable.getByteArrayValue()).isNotNull();
        String id = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(id);
        this.testRule.waitForJobExecutorToProcessAllJobs(5000L);
        variable = (VariableInstanceEntity)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{pi.getId()}).singleResult();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)variable.getTypeName()).withFailMessage("The type of the variable should be null after the update", new Object[0])).isEqualTo((Object)"null");
        ((AbstractObjectAssert)Assertions.assertThat((Object)((MySerializable)variable.getValue())).withFailMessage("The variable changed value to null", new Object[0])).isNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)variable.getByteArrayValueId()).withFailMessage("The byte array should be deleted (id changed) since the type changes when nullifying an existing non-null value", new Object[0])).isNotEqualTo((Object)byteArrayIdBeforeUpdate);
    }

    @Test
    public void shouldDeleteByteArrayOnUpdateOfExistingNullVariable() {
        this.deployProcess(((ScriptTaskBuilder)((ScriptTaskBuilder)((ScriptTaskBuilder)((ScriptTaskBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().camundaAsyncAfter()).scriptTask().scriptFormat("groovy")).scriptText("println 'var ' + myVar")).scriptTask().scriptFormat("groovy")).scriptText("execution.setVariable('myVar', new org.camunda.bpm.engine.test.bpmn.scripttask.MySerializable('non null value'))")).userTask().endEvent().done());
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)Variables.createVariables().putValue("myVar", null));
        VariableInstanceEntity variable = (VariableInstanceEntity)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{pi.getId()}).singleResult();
        Assertions.assertThat((String)variable.getByteArrayValueId()).isNull();
        Assertions.assertThat((byte[])variable.getByteArrayValue()).isNull();
        String id = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(id);
        this.testRule.waitForJobExecutorToProcessAllJobs(5000L);
        variable = (VariableInstanceEntity)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{pi.getId()}).singleResult();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)variable.getTextValue2()).withFailMessage("The type name of the variable should be set on the text value 2 field", new Object[0])).isEqualTo((Object)"org.camunda.bpm.engine.test.bpmn.scripttask.MySerializable");
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)((MySerializable)variable.getValue()).getName()).withFailMessage("The variable changed value", new Object[0])).isEqualTo((Object)"non null value");
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])variable.getByteArrayValue()).withFailMessage("The new byte array value should not be null after the update", new Object[0])).isNotNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)variable.getByteArrayValueId()).withFailMessage("The byte array id should not be null after the update ", new Object[0])).isNotNull();
    }

    private ProcessInstance startProcessInstanceWithVariable(String processDefinitionKey, String variableName, Object variableValue) {
        VariableMap variables = Variables.createVariables().putValue(variableName, variableValue);
        return this.runtimeService.startProcessInstanceByKey(processDefinitionKey, (Map)variables);
    }

    private ProcessInstance startProcessInstanceWithObjectVariable(String processDefinitionKey, String variableName, Object variableValue) {
        ObjectValue value = (ObjectValue)Variables.objectValue((Object)variableValue).serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).create();
        VariableMap variables = Variables.createVariables().putValue(variableName, (Object)value);
        return this.runtimeService.startProcessInstanceByKey(processDefinitionKey, (Map)variables);
    }

    private void setVariableWithObjectValue(String executionId, String variableName, Object variableValue) {
        ObjectValue value = (ObjectValue)Variables.objectValue((Object)variableValue).serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).create();
        this.runtimeService.setVariable(executionId, variableName, (Object)value);
    }

    protected void deployProcess(BpmnModelInstance process) {
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addModelInstance("testProcess.bpmn", process).deploy();
        this.deploymentIds.add(deployment.getId());
    }
}

