/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.message;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.runtime.MessageCorrelationResult;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@RequiredHistoryLevel(value="full")
public class MessageCorrelationUserOperationLogTest {
    private static final String USER_ID = "userId";
    private static final String SINGLE_INTERMEDIATE_MESSAGE_PROCESS = "intermediateMessage";
    private static final String INTERMEDIATE_MESSAGE_NAME = "intermediate";
    private static final String START_MESSAGE_NAME = "start";
    private static final String NUMBER_OF_INSTANCES = "nrOfInstances";
    private static final String NUMBER_OF_VARIABLES = "nrOfVariables";
    private static final String PROCESS_INSTANCE_ID = "processInstanceId";
    private static final String PROCESS_DEFINITION_ID = "processDefinitionId";
    private static final String MESSAGE_NAME = "messageName";
    private static final String PROPERTY = "property";
    private static final String NEW_VALUE = "newValue";
    private static final Long LIMIT_1 = 1L;
    private static final Long LIMIT_3 = 3L;
    private static final Long UNLIMITED = -1L;
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RuntimeService runtimeService;
    protected HistoryService historyService;
    protected IdentityService identityService;
    protected Long defaultLogEntriesPerSyncOperationLimit;

    @Before
    public void setup() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
        this.identityService = this.engineRule.getIdentityService();
        this.defaultLogEntriesPerSyncOperationLimit = this.processEngineConfiguration.getLogEntriesPerSyncOperationLimit();
    }

    @After
    public void tearDown() {
        this.processEngineConfiguration.setLogEntriesPerSyncOperationLimit(this.defaultLogEntriesPerSyncOperationLimit.longValue());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/message/MessageCorrelationUserOperationLogTest.intermediateMessageEvent.bpmn"})
    public void shouldCreateSingleUserOperationLogForMessageCorrelationWithReturnVariables() {
        this.processEngineConfiguration.setLogEntriesPerSyncOperationLimit(LIMIT_1.longValue());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(SINGLE_INTERMEDIATE_MESSAGE_PROCESS, Map.of("foo", "bar"));
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.runtimeService.createMessageCorrelation(INTERMEDIATE_MESSAGE_NAME).correlateAllWithResultAndVariables(false);
        String processInstanceId = processInstance.getId();
        String processDefinitionId = processInstance.getProcessDefinitionId();
        List logs = this.historyService.createUserOperationLogQuery().operationType("CorrelateMessage").list();
        Assertions.assertThat((List)logs).hasSize(2);
        Assertions.assertThat((List)logs).extracting(new String[]{PROPERTY, NEW_VALUE, PROCESS_INSTANCE_ID, PROCESS_DEFINITION_ID}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{MESSAGE_NAME, INTERMEDIATE_MESSAGE_NAME, processInstanceId, processDefinitionId}), Assertions.tuple((Object[])new Object[]{PROCESS_INSTANCE_ID, processInstanceId, processInstanceId, processDefinitionId})});
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/message/MessageCorrelationUserOperationLogTest.intermediateMessageEvent.bpmn"})
    public void shouldCreateSingleUserOperationLogForMessageCorrelationWithVariables() {
        this.processEngineConfiguration.setLogEntriesPerSyncOperationLimit(LIMIT_1.longValue());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(SINGLE_INTERMEDIATE_MESSAGE_PROCESS);
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.runtimeService.createMessageCorrelation(INTERMEDIATE_MESSAGE_NAME).setVariable("foo", (Object)"bar").correlateAll();
        String processInstanceId = processInstance.getId();
        String processDefinitionId = processInstance.getProcessDefinitionId();
        List logs = this.historyService.createUserOperationLogQuery().operationType("CorrelateMessage").list();
        Assertions.assertThat((List)logs).hasSize(3);
        Assertions.assertThat((List)logs).extracting(new String[]{PROPERTY, NEW_VALUE, PROCESS_INSTANCE_ID, PROCESS_DEFINITION_ID}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{MESSAGE_NAME, INTERMEDIATE_MESSAGE_NAME, processInstanceId, processDefinitionId}), Assertions.tuple((Object[])new Object[]{PROCESS_INSTANCE_ID, processInstanceId, processInstanceId, processDefinitionId}), Assertions.tuple((Object[])new Object[]{NUMBER_OF_VARIABLES, "1", processInstanceId, processDefinitionId})});
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/message/MessageCorrelationUserOperationLogTest.intermediateMessageEvent.bpmn"})
    public void shouldCreateSummarizingUserOperationLogForMessageCorrelations() {
        this.processEngineConfiguration.setLogEntriesPerSyncOperationLimit(LIMIT_1.longValue());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(SINGLE_INTERMEDIATE_MESSAGE_PROCESS);
        this.runtimeService.startProcessInstanceByKey(SINGLE_INTERMEDIATE_MESSAGE_PROCESS);
        this.runtimeService.startProcessInstanceByKey(SINGLE_INTERMEDIATE_MESSAGE_PROCESS);
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.runtimeService.createMessageCorrelation(INTERMEDIATE_MESSAGE_NAME).correlateAll();
        String processDefinitionId = processInstance.getProcessDefinitionId();
        List logs = this.historyService.createUserOperationLogQuery().operationType("CorrelateMessage").list();
        Assertions.assertThat((List)logs).hasSize(2);
        Assertions.assertThat((List)logs).extracting(new String[]{PROPERTY, NEW_VALUE, PROCESS_INSTANCE_ID, PROCESS_DEFINITION_ID}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{MESSAGE_NAME, INTERMEDIATE_MESSAGE_NAME, null, processDefinitionId}), Assertions.tuple((Object[])new Object[]{NUMBER_OF_INSTANCES, "3", null, processDefinitionId})});
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/message/MessageCorrelationUserOperationLogTest.intermediateMessageEvent.bpmn"})
    public void shouldCreateDetailedUserOperationLogForMessageCorrelationsWhenOnlyOneCorrelation() {
        this.processEngineConfiguration.setLogEntriesPerSyncOperationLimit(LIMIT_1.longValue());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(SINGLE_INTERMEDIATE_MESSAGE_PROCESS);
        this.identityService.setAuthenticatedUserId(USER_ID);
        List correlationResult = this.runtimeService.createMessageCorrelation(INTERMEDIATE_MESSAGE_NAME).correlateAllWithResult();
        String processInstanceId = processInstance.getId();
        String processDefinitionId = processInstance.getProcessDefinitionId();
        List logs = this.historyService.createUserOperationLogQuery().operationType("CorrelateMessage").list();
        Assertions.assertThat((List)logs).hasSize(2);
        Assertions.assertThat((List)logs).extracting(new String[]{PROPERTY, NEW_VALUE, PROCESS_INSTANCE_ID, PROCESS_DEFINITION_ID}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{MESSAGE_NAME, INTERMEDIATE_MESSAGE_NAME, processInstanceId, processDefinitionId}), Assertions.tuple((Object[])new Object[]{PROCESS_INSTANCE_ID, processInstanceId, processInstanceId, processDefinitionId})});
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/message/MessageCorrelationUserOperationLogTest.intermediateMessageEvent.bpmn"})
    public void shouldCreateUserOperationLogForMessageCorrelations() {
        this.processEngineConfiguration.setLogEntriesPerSyncOperationLimit(LIMIT_3.longValue());
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey(SINGLE_INTERMEDIATE_MESSAGE_PROCESS);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey(SINGLE_INTERMEDIATE_MESSAGE_PROCESS);
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey(SINGLE_INTERMEDIATE_MESSAGE_PROCESS);
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.runtimeService.createMessageCorrelation(INTERMEDIATE_MESSAGE_NAME).correlateAll();
        List logs = this.historyService.createUserOperationLogQuery().operationType("CorrelateMessage").list();
        Assertions.assertThat((List)logs).hasSize(6);
        String processDefinitionId = processInstance1.getProcessDefinitionId();
        String processInstanceId1 = processInstance1.getId();
        List p1Logs = this.historyService.createUserOperationLogQuery().operationType("CorrelateMessage").processInstanceId(processInstanceId1).list();
        Assertions.assertThat((List)p1Logs).extracting(new String[]{PROPERTY, NEW_VALUE, PROCESS_INSTANCE_ID, PROCESS_DEFINITION_ID}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{MESSAGE_NAME, INTERMEDIATE_MESSAGE_NAME, processInstanceId1, processDefinitionId}), Assertions.tuple((Object[])new Object[]{PROCESS_INSTANCE_ID, processInstanceId1, processInstanceId1, processDefinitionId})});
        String processInstanceId2 = processInstance2.getId();
        List p2Logs = this.historyService.createUserOperationLogQuery().operationType("CorrelateMessage").processInstanceId(processInstanceId2).list();
        Assertions.assertThat((List)p2Logs).extracting(new String[]{PROPERTY, NEW_VALUE, PROCESS_INSTANCE_ID, PROCESS_DEFINITION_ID}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{MESSAGE_NAME, INTERMEDIATE_MESSAGE_NAME, processInstanceId2, processDefinitionId}), Assertions.tuple((Object[])new Object[]{PROCESS_INSTANCE_ID, processInstanceId2, processInstanceId2, processDefinitionId})});
        String processInstanceId3 = processInstance3.getId();
        List p3Logs = this.historyService.createUserOperationLogQuery().operationType("CorrelateMessage").processInstanceId(processInstanceId3).list();
        Assertions.assertThat((List)p3Logs).extracting(new String[]{PROPERTY, NEW_VALUE, PROCESS_INSTANCE_ID, PROCESS_DEFINITION_ID}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{MESSAGE_NAME, INTERMEDIATE_MESSAGE_NAME, processInstanceId3, processDefinitionId}), Assertions.tuple((Object[])new Object[]{PROCESS_INSTANCE_ID, processInstanceId3, processInstanceId3, processDefinitionId})});
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/message/MessageCorrelationUserOperationLogTest.intermediateMessageEvent.bpmn"})
    public void shouldThrowExceptionForMessageCorrelationsExceedingLimit() {
        this.processEngineConfiguration.setLogEntriesPerSyncOperationLimit(LIMIT_3.longValue());
        this.runtimeService.startProcessInstanceByKey(SINGLE_INTERMEDIATE_MESSAGE_PROCESS).getId();
        this.runtimeService.startProcessInstanceByKey(SINGLE_INTERMEDIATE_MESSAGE_PROCESS).getId();
        this.runtimeService.startProcessInstanceByKey(SINGLE_INTERMEDIATE_MESSAGE_PROCESS).getId();
        this.runtimeService.startProcessInstanceByKey(SINGLE_INTERMEDIATE_MESSAGE_PROCESS).getId();
        this.identityService.setAuthenticatedUserId(USER_ID);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.createMessageCorrelation(INTERMEDIATE_MESSAGE_NAME).correlateAll()).isInstanceOf(ProcessEngineException.class)).hasMessage("Maximum number of operation log entries for operation type synchronous APIs reached. Configured limit is 3 but 4 entities were affected by API call.");
        List logs = this.historyService.createUserOperationLogQuery().operationType("CorrelateMessage").list();
        Assertions.assertThat((List)logs).isEmpty();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/message/MessageCorrelationUserOperationLogTest.intermediateMessageEvent.bpmn"})
    public void shouldCreateUserOperationLogForMessageCorrelationsWhenUnlimited() {
        this.processEngineConfiguration.setLogEntriesPerSyncOperationLimit(UNLIMITED.longValue());
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey(SINGLE_INTERMEDIATE_MESSAGE_PROCESS);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey(SINGLE_INTERMEDIATE_MESSAGE_PROCESS);
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey(SINGLE_INTERMEDIATE_MESSAGE_PROCESS);
        ProcessInstance processInstance4 = this.runtimeService.startProcessInstanceByKey(SINGLE_INTERMEDIATE_MESSAGE_PROCESS);
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.runtimeService.createMessageCorrelation(INTERMEDIATE_MESSAGE_NAME).correlateAll();
        List logs = this.historyService.createUserOperationLogQuery().operationType("CorrelateMessage").list();
        Assertions.assertThat((List)logs).hasSize(8);
        String processDefinitionId = processInstance1.getProcessDefinitionId();
        String processInstanceId1 = processInstance1.getId();
        List p1Logs = this.historyService.createUserOperationLogQuery().operationType("CorrelateMessage").processInstanceId(processInstanceId1).list();
        Assertions.assertThat((List)p1Logs).extracting(new String[]{PROPERTY, NEW_VALUE, PROCESS_INSTANCE_ID, PROCESS_DEFINITION_ID}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{MESSAGE_NAME, INTERMEDIATE_MESSAGE_NAME, processInstanceId1, processDefinitionId}), Assertions.tuple((Object[])new Object[]{PROCESS_INSTANCE_ID, processInstanceId1, processInstanceId1, processDefinitionId})});
        String processInstanceId2 = processInstance2.getId();
        List p2Logs = this.historyService.createUserOperationLogQuery().operationType("CorrelateMessage").processInstanceId(processInstanceId2).list();
        Assertions.assertThat((List)p2Logs).extracting(new String[]{PROPERTY, NEW_VALUE, PROCESS_INSTANCE_ID, PROCESS_DEFINITION_ID}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{MESSAGE_NAME, INTERMEDIATE_MESSAGE_NAME, processInstanceId2, processDefinitionId}), Assertions.tuple((Object[])new Object[]{PROCESS_INSTANCE_ID, processInstanceId2, processInstanceId2, processDefinitionId})});
        String processInstanceId3 = processInstance3.getId();
        List p3Logs = this.historyService.createUserOperationLogQuery().operationType("CorrelateMessage").processInstanceId(processInstanceId3).list();
        Assertions.assertThat((List)p3Logs).extracting(new String[]{PROPERTY, NEW_VALUE, PROCESS_INSTANCE_ID, PROCESS_DEFINITION_ID}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{MESSAGE_NAME, INTERMEDIATE_MESSAGE_NAME, processInstanceId3, processDefinitionId}), Assertions.tuple((Object[])new Object[]{PROCESS_INSTANCE_ID, processInstanceId3, processInstanceId3, processDefinitionId})});
        String processInstanceId4 = processInstance4.getId();
        List p4Logs = this.historyService.createUserOperationLogQuery().operationType("CorrelateMessage").processInstanceId(processInstanceId4).list();
        Assertions.assertThat((List)p4Logs).extracting(new String[]{PROPERTY, NEW_VALUE, PROCESS_INSTANCE_ID, PROCESS_DEFINITION_ID}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{MESSAGE_NAME, INTERMEDIATE_MESSAGE_NAME, processInstanceId4, processDefinitionId}), Assertions.tuple((Object[])new Object[]{PROCESS_INSTANCE_ID, processInstanceId4, processInstanceId4, processDefinitionId})});
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/message/MessageCorrelationUserOperationLogTest.intermediateMessageEvent.bpmn"})
    public void shouldNotCreateUserOperationLogIfNoCorrelationResult() {
        this.processEngineConfiguration.setLogEntriesPerSyncOperationLimit(LIMIT_1.longValue());
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.runtimeService.createMessageCorrelation(INTERMEDIATE_MESSAGE_NAME).correlateAll();
        List logs = this.historyService.createUserOperationLogQuery().operationType("CorrelateMessage").list();
        Assertions.assertThat((List)logs).isEmpty();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/message/MessageCorrelationUserOperationLogTest.messageStartEvent.bpmn"})
    public void shouldCreateSingleUserOperationLogForMessageCorrelationStart() {
        this.processEngineConfiguration.setLogEntriesPerSyncOperationLimit(LIMIT_1.longValue());
        this.identityService.setAuthenticatedUserId(USER_ID);
        List correlationResult = this.runtimeService.createMessageCorrelation(START_MESSAGE_NAME).correlateAllWithResult();
        Assertions.assertThat((List)correlationResult).hasSize(1);
        List logs = this.historyService.createUserOperationLogQuery().operationType("CorrelateMessage").list();
        Assertions.assertThat((List)logs).hasSize(2);
        ProcessInstance processInstance = ((MessageCorrelationResult)correlationResult.get(0)).getProcessInstance();
        String processInstanceId = processInstance.getId();
        String processDefinitionId = processInstance.getProcessDefinitionId();
        Assertions.assertThat((List)logs).extracting(new String[]{PROPERTY, NEW_VALUE, PROCESS_INSTANCE_ID, PROCESS_DEFINITION_ID}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{MESSAGE_NAME, START_MESSAGE_NAME, processInstanceId, processDefinitionId}), Assertions.tuple((Object[])new Object[]{PROCESS_INSTANCE_ID, processInstanceId, processInstanceId, processDefinitionId})});
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/message/MessageCorrelationUserOperationLogTest.messageStartEvent.bpmn"})
    public void shouldCreateSingleUserOperationLogForMessageCorrelationStartWithinLimit() {
        this.processEngineConfiguration.setLogEntriesPerSyncOperationLimit(LIMIT_3.longValue());
        this.identityService.setAuthenticatedUserId(USER_ID);
        List correlationResult = this.runtimeService.createMessageCorrelation(START_MESSAGE_NAME).correlateAllWithResult();
        Assertions.assertThat((List)correlationResult).hasSize(1);
        List logs = this.historyService.createUserOperationLogQuery().operationType("CorrelateMessage").list();
        Assertions.assertThat((List)logs).hasSize(2);
        ProcessInstance processInstance = ((MessageCorrelationResult)correlationResult.get(0)).getProcessInstance();
        String processInstanceId = processInstance.getId();
        String processDefinitionId = processInstance.getProcessDefinitionId();
        Assertions.assertThat((List)logs).extracting(new String[]{PROPERTY, NEW_VALUE, PROCESS_INSTANCE_ID, PROCESS_DEFINITION_ID}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{MESSAGE_NAME, START_MESSAGE_NAME, processInstanceId, processDefinitionId}), Assertions.tuple((Object[])new Object[]{PROCESS_INSTANCE_ID, processInstanceId, processInstanceId, processDefinitionId})});
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/message/MessageCorrelationUserOperationLogTest.messageStartEvent.bpmn"})
    public void shouldCreateSingleUserOperationLogForMessageCorrelationStartUnlimited() {
        this.processEngineConfiguration.setLogEntriesPerSyncOperationLimit(UNLIMITED.longValue());
        this.identityService.setAuthenticatedUserId(USER_ID);
        List correlationResult = this.runtimeService.createMessageCorrelation(START_MESSAGE_NAME).correlateAllWithResult();
        Assertions.assertThat((List)correlationResult).hasSize(1);
        List logs = this.historyService.createUserOperationLogQuery().operationType("CorrelateMessage").list();
        Assertions.assertThat((List)logs).hasSize(2);
        ProcessInstance processInstance = ((MessageCorrelationResult)correlationResult.get(0)).getProcessInstance();
        String processInstanceId = processInstance.getId();
        String processDefinitionId = processInstance.getProcessDefinitionId();
        Assertions.assertThat((List)logs).extracting(new String[]{PROPERTY, NEW_VALUE, PROCESS_INSTANCE_ID, PROCESS_DEFINITION_ID}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{MESSAGE_NAME, START_MESSAGE_NAME, processInstanceId, processDefinitionId}), Assertions.tuple((Object[])new Object[]{PROCESS_INSTANCE_ID, processInstanceId, processInstanceId, processDefinitionId})});
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/message/MessageCorrelationUserOperationLogTest.messageStartEvent.bpmn"})
    public void shouldCreateSingleUserOperationLogForMessageCorrelationStartWithVariables() {
        this.processEngineConfiguration.setLogEntriesPerSyncOperationLimit(LIMIT_1.longValue());
        this.identityService.setAuthenticatedUserId(USER_ID);
        List correlationResult = this.runtimeService.createMessageCorrelation(START_MESSAGE_NAME).setVariable("foo", (Object)"bar").setVariableLocal("foobar", (Object)"baz").setVariablesToTriggeredScope(Map.of("qux", "bar", "thud", "foo")).correlateAllWithResult();
        Assertions.assertThat((List)correlationResult).hasSize(1);
        List logs = this.historyService.createUserOperationLogQuery().operationType("CorrelateMessage").list();
        Assertions.assertThat((List)logs).hasSize(3);
        ProcessInstance processInstance = ((MessageCorrelationResult)correlationResult.get(0)).getProcessInstance();
        String processInstanceId = processInstance.getId();
        String processDefinitionId = processInstance.getProcessDefinitionId();
        Assertions.assertThat((List)logs).extracting(new String[]{PROPERTY, NEW_VALUE, PROCESS_INSTANCE_ID, PROCESS_DEFINITION_ID}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{MESSAGE_NAME, START_MESSAGE_NAME, processInstanceId, processDefinitionId}), Assertions.tuple((Object[])new Object[]{PROCESS_INSTANCE_ID, processInstanceId, processInstanceId, processDefinitionId}), Assertions.tuple((Object[])new Object[]{NUMBER_OF_VARIABLES, "4", processInstanceId, processDefinitionId})});
    }
}

