/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import ch.qos.logback.classic.Level;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.commons.testing.ProcessEngineLoggingRule;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class JobAcquisitionLoggingTest {
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule().watch("org.camunda.bpm.engine.jobexecutor", Level.DEBUG);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule).around((TestRule)this.loggingRule);
    protected RuntimeService runtimeService;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    public void shouldLogJobsAttemptingToAcquire() {
        for (int i = 0; i < 3; ++i) {
            this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        }
        this.processEngineConfiguration.getJobExecutor().start();
        this.testRule.waitForJobExecutorToProcessAllJobs();
        this.processEngineConfiguration.getJobExecutor().shutdown();
        List filteredLogList = this.loggingRule.getFilteredLog("Attempting to acquire " + this.processEngineConfiguration.getJobExecutor().getMaxJobsPerAcquisition() + " jobs for the process engine '" + this.processEngineConfiguration.getProcessEngineName() + "'");
        Assertions.assertThat((int)filteredLogList.size()).isGreaterThanOrEqualTo(1);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    public void shouldLogFailedAcquisitionLocks() {
        for (int i = 0; i < 3; ++i) {
            this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        }
        this.processEngineConfiguration.getJobExecutor().start();
        this.testRule.waitForJobExecutorToProcessAllJobs();
        this.processEngineConfiguration.getJobExecutor().shutdown();
        List filteredLogList = this.loggingRule.getFilteredLog("Jobs failed to Lock during Acquisition of jobs for the process engine '" + this.processEngineConfiguration.getProcessEngineName() + "' : ");
        Assertions.assertThat((int)filteredLogList.size()).isGreaterThanOrEqualTo(1);
    }
}

