/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.externaltask;

import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.util.SingleConsumerCondition;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class ExternalTaskConditionsTest {
    @Rule
    public ProcessEngineRule rule = new ProvidedProcessEngineRule();
    @Mock
    public SingleConsumerCondition condition;
    private String deploymentId;
    private final BpmnModelInstance testProcess = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"theProcess").startEvent().serviceTask("theTask").camundaExternalTask("theTopic")).done();

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        ProcessEngineImpl.EXT_TASK_CONDITIONS.addConsumer(this.condition);
        this.deploymentId = this.rule.getRepositoryService().createDeployment().addModelInstance("process.bpmn", this.testProcess).deploy().getId();
    }

    @After
    public void tearDown() {
        ProcessEngineImpl.EXT_TASK_CONDITIONS.removeConsumer(this.condition);
        if (this.deploymentId != null) {
            this.rule.getRepositoryService().deleteDeployment(this.deploymentId, true);
        }
    }

    @Test
    public void shouldSignalConditionOnTaskCreate() {
        this.rule.getRuntimeService().startProcessInstanceByKey("theProcess");
        ((SingleConsumerCondition)Mockito.verify((Object)this.condition, (VerificationMode)Mockito.times((int)1))).signal();
    }

    @Test
    public void shouldSignalConditionOnTaskCreateMultipleTimes() {
        this.rule.getRuntimeService().startProcessInstanceByKey("theProcess");
        this.rule.getRuntimeService().startProcessInstanceByKey("theProcess");
        ((SingleConsumerCondition)Mockito.verify((Object)this.condition, (VerificationMode)Mockito.times((int)2))).signal();
    }

    @Test
    public void shouldSignalConditionOnUnlock() {
        this.rule.getRuntimeService().startProcessInstanceByKey("theProcess");
        Mockito.reset((Object[])new SingleConsumerCondition[]{this.condition});
        LockedExternalTask lockedTask = (LockedExternalTask)this.rule.getExternalTaskService().fetchAndLock(1, "theWorker").topic("theTopic", 10000L).execute().get(0);
        this.rule.getExternalTaskService().unlock(lockedTask.getId());
        ((SingleConsumerCondition)Mockito.verify((Object)this.condition, (VerificationMode)Mockito.times((int)1))).signal();
    }
}

