/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history;

import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class HistoryCleanupTaskMetricsTest {
    private static final String DEFAULT_TTL_DAYS = "P5D";
    private static final BpmnModelInstance PROCESS = ((UserTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaHistoryTimeToLive(Integer.valueOf(180))).startEvent("start").userTask("userTask1").sequenceFlowId("seq")).userTask("userTask2").endEvent("end").done();
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> configuration.setTaskMetricsEnabled(true).setHistoryCleanupDegreeOfParallelism(3));
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected HistoryService historyService;
    protected RuntimeService runtimeService;
    protected ManagementService managementService;
    protected TaskService taskService;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    @Before
    public void init() {
        this.historyService = this.engineRule.getHistoryService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.taskService = this.engineRule.getTaskService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.processEngineConfiguration.setHistoryCleanupStrategy("endTimeBased");
    }

    @After
    public void clearDatabase() {
        this.testRule.deleteHistoryCleanupJobs();
        this.managementService.deleteTaskMetrics(null);
        this.managementService.deleteMetrics(null);
    }

    @After
    public void resetConfiguration() {
        this.processEngineConfiguration.setHistoryCleanupStrategy("removalTimeBased");
        this.processEngineConfiguration.setTaskMetricsTimeToLive(null);
    }

    @Test
    public void shouldCleanupTaskMetrics() {
        this.initTaskMetricHistoryTimeToLive(DEFAULT_TTL_DAYS);
        int daysInThePast = -11;
        this.prepareTaskMetrics(3, daysInThePast);
        Assertions.assertThat((long)this.managementService.getUniqueTaskWorkerCount(null, null)).isEqualTo(3L);
        this.runHistoryCleanup();
        Assertions.assertThat((long)this.managementService.getUniqueTaskWorkerCount(null, null)).isZero();
    }

    @Test
    public void shouldProvideCleanupMetricsForTaskMetrics() {
        this.initTaskMetricHistoryTimeToLive(DEFAULT_TTL_DAYS);
        int daysInThePast = -11;
        int metricsCount = 5;
        this.prepareTaskMetrics(metricsCount, daysInThePast);
        this.runHistoryCleanup();
        long removedMetrics = this.managementService.createMetricsQuery().name("history-cleanup-removed-task-metrics").sum();
        Assertions.assertThat((long)removedMetrics).isEqualTo((long)metricsCount);
    }

    @Test
    public void shouldFailWithInvalidConfiguration() {
        this.processEngineConfiguration.setTaskMetricsTimeToLive("PD");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.processEngineConfiguration.initHistoryCleanup()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid value");
    }

    @Test
    public void shouldFailWithInvalidConfigurationNegativeTTL() {
        this.processEngineConfiguration.setTaskMetricsTimeToLive("P-1D");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.processEngineConfiguration.initHistoryCleanup()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid value");
    }

    private void initTaskMetricHistoryTimeToLive(String days) {
        this.processEngineConfiguration.setTaskMetricsTimeToLive(days);
        this.processEngineConfiguration.initHistoryCleanup();
    }

    private void prepareTaskMetrics(int taskMetricsCount, int daysInThePast) {
        Date startDate = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)daysInThePast));
        this.testRule.deploy(PROCESS);
        this.runtimeService.startProcessInstanceByKey("process");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        for (int i = 0; i < taskMetricsCount; ++i) {
            this.taskService.setAssignee(taskId, "kermit" + i);
        }
        ClockUtil.reset();
    }

    private void runHistoryCleanup() {
        this.historyService.cleanUpHistoryAsync(true);
        List historyCleanupJobs = this.historyService.findHistoryCleanupJobs();
        for (Job historyCleanupJob : historyCleanupJobs) {
            this.managementService.executeJob(historyCleanupJob.getId());
        }
    }
}

