/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.timer;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.impl.cmd.DeleteJobsCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.runtime.ExecutionQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.event.timer.DummyServiceTask;
import org.camunda.bpm.engine.test.bpmn.event.timer.MyCycleTimerBean;
import org.camunda.bpm.engine.test.mock.Mocks;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.joda.time.LocalDateTime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class StartTimerEventTest
extends PluggableProcessEngineTest {
    protected static final long ONE_HOUR = TimeUnit.HOURS.toMillis(1L);
    protected static final long TWO_HOURS = TimeUnit.HOURS.toMillis(2L);
    private static final Date START_DATE = new GregorianCalendar(2023, 7, 18, 8, 0, 0).getTime();
    protected boolean reevaluateTimeCycleWhenDue;

    @Before
    public void setUp() {
        this.reevaluateTimeCycleWhenDue = this.processEngineConfiguration.isReevaluateTimeCycleWhenDue();
    }

    @After
    public void tearDown() {
        this.processEngineConfiguration.getBeans().remove("myCycleTimerBean");
        this.processEngineConfiguration.setReevaluateTimeCycleWhenDue(this.reevaluateTimeCycleWhenDue);
    }

    @Deployment
    @Test
    public void testDurationStartTimerEvent() throws Exception {
        Date startTime = new Date();
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        ClockUtil.setCurrentTime((Date)new Date(startTime.getTime() + 3005000L));
        this.executeAllJobs();
        this.executeAllJobs();
        List pi = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("startTimerEventExample").list();
        Assert.assertEquals((long)1L, (long)pi.size());
        Assert.assertEquals((Object)"startTimerEventExample", (Object)((ProcessInstance)pi.get(0)).getProcessDefinitionKey());
        Assert.assertEquals((long)0L, (long)jobQuery.count());
    }

    @Deployment
    @Test
    public void testFixedDateStartTimerEvent() throws Exception {
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        ClockUtil.setCurrentTime((Date)new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").parse("15/11/2036 11:12:30"));
        this.executeAllJobs();
        List pi = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("startTimerEventExample").list();
        Assert.assertEquals((long)1L, (long)pi.size());
        Assert.assertEquals((long)0L, (long)jobQuery.count());
    }

    @Deployment
    @Ignore
    @Test
    public void testCycleDateStartTimerEvent() throws Exception {
        ClockUtil.setCurrentTime((Date)new Date());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        ProcessInstanceQuery piq = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("startTimerEventExample");
        Assert.assertEquals((long)0L, (long)piq.count());
        this.moveByMinutes(5);
        this.executeAllJobs();
        Assert.assertEquals((long)1L, (long)piq.count());
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        this.moveByMinutes(5);
        this.executeAllJobs();
        Assert.assertEquals((long)1L, (long)piq.count());
        Assert.assertEquals((long)1L, (long)jobQuery.count());
    }

    private void moveByMinutes(int minutes) throws Exception {
        ClockUtil.setCurrentTime((Date)new Date(ClockUtil.getCurrentTime().getTime() + (long)(minutes * 60 * 1000 + 5000)));
    }

    @Deployment
    @Test
    public void testCycleWithLimitStartTimerEvent() throws Exception {
        ClockUtil.setCurrentTime((Date)new Date());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Job job = (Job)jobQuery.singleResult();
        Assert.assertNotNull((Object)job.getDeploymentId());
        ProcessInstanceQuery piq = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("startTimerEventExampleCycle");
        Assert.assertEquals((long)0L, (long)piq.count());
        this.moveByMinutes(5);
        this.executeAllJobs();
        Assert.assertEquals((long)1L, (long)piq.count());
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        job = (Job)jobQuery.singleResult();
        Assert.assertNotNull((Object)job.getDeploymentId());
        this.moveByMinutes(5);
        this.executeAllJobs();
        Assert.assertEquals((long)2L, (long)piq.count());
        Assert.assertEquals((long)0L, (long)jobQuery.count());
    }

    @Deployment
    @Test
    public void testPriorityInTimerCycleEvent() throws Exception {
        ClockUtil.setCurrentTime((Date)new Date());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Job job = (Job)jobQuery.singleResult();
        Assert.assertNotNull((Object)job.getDeploymentId());
        Assert.assertEquals((long)9999L, (long)job.getPriority());
        ProcessInstanceQuery piq = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("startTimerEventExampleCycle");
        Assert.assertEquals((long)0L, (long)piq.count());
        this.moveByMinutes(5);
        this.executeAllJobs();
        Assert.assertEquals((long)1L, (long)piq.count());
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        job = (Job)jobQuery.singleResult();
        Assert.assertNotNull((Object)job.getDeploymentId());
        Assert.assertEquals((long)9999L, (long)job.getPriority());
    }

    @Deployment
    @Test
    public void testExpressionStartTimerEvent() throws Exception {
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        ClockUtil.setCurrentTime((Date)new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").parse("15/11/2036 11:12:30"));
        this.executeAllJobs();
        List pi = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("startTimerEventExample").list();
        Assert.assertEquals((long)1L, (long)pi.size());
        Assert.assertEquals((long)0L, (long)jobQuery.count());
    }

    @Deployment
    @Test
    public void testRecalculateExpressionStartTimerEvent() throws Exception {
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("startTimerEventExample");
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Assert.assertEquals((long)0L, (long)processInstanceQuery.count());
        Job job = (Job)jobQuery.singleResult();
        Date oldDate = job.getDuedate();
        this.moveByMinutes(2);
        Date currentTime = ClockUtil.getCurrentTime();
        this.managementService.recalculateJobDuedate(job.getId(), false);
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Assert.assertEquals((long)0L, (long)processInstanceQuery.count());
        Date newDate = ((Job)jobQuery.singleResult()).getDuedate();
        Assert.assertNotEquals((Object)oldDate, (Object)newDate);
        Assert.assertTrue((boolean)oldDate.before(newDate));
        Date expectedDate = LocalDateTime.fromDateFields((Date)currentTime).plusHours(2).toDate();
        Assertions.assertThat((Date)newDate).isCloseTo(expectedDate, 1000L);
        this.moveByMinutes(122);
        this.executeAllJobs();
        List pi = processInstanceQuery.list();
        Assert.assertEquals((long)1L, (long)pi.size());
        Assert.assertEquals((long)0L, (long)jobQuery.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/timer/StartTimerEventTest.testRecalculateExpressionStartTimerEvent.bpmn20.xml"})
    @Test
    public void testRecalculateUnchangedExpressionStartTimerEventCreationDateBased() throws Exception {
        JobQuery jobQuery = this.managementService.createJobQuery();
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("startTimerEventExample");
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Assert.assertEquals((long)0L, (long)processInstanceQuery.count());
        this.moveByMinutes(1);
        this.managementService.recalculateJobDuedate(((Job)jobQuery.singleResult()).getId(), true);
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Assert.assertEquals((long)0L, (long)processInstanceQuery.count());
        Job jobUpdated = (Job)jobQuery.singleResult();
        Date expectedDate = LocalDateTime.fromDateFields((Date)jobUpdated.getCreateTime()).plusHours(2).toDate();
        Assert.assertEquals((Object)expectedDate, (Object)jobUpdated.getDuedate());
        this.moveByMinutes(121);
        this.executeAllJobs();
        List pi = processInstanceQuery.list();
        Assert.assertEquals((long)1L, (long)pi.size());
        Assert.assertEquals((long)0L, (long)jobQuery.count());
    }

    @Deployment
    @Test
    public void testVersionUpgradeShouldCancelJobs() throws Exception {
        ClockUtil.setCurrentTime((Date)new Date());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        InputStream in = this.getClass().getResourceAsStream("StartTimerEventTest.testVersionUpgradeShouldCancelJobs.bpmn20.xml");
        String process = new String(IoUtil.readInputStream((InputStream)in, (String)"")).replaceAll("beforeChange", "changed");
        IoUtil.closeSilently((Closeable)in);
        in = new ByteArrayInputStream(process.getBytes());
        String id = this.repositoryService.createDeployment().addInputStream("StartTimerEventTest.testVersionUpgradeShouldCancelJobs.bpmn20.xml", in).deploy().getId();
        IoUtil.closeSilently((Closeable)in);
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        this.moveByMinutes(5);
        this.executeAllJobs();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("startTimerEventExample").singleResult();
        String pi = processInstance.getProcessInstanceId();
        Assert.assertEquals((Object)"changed", this.runtimeService.getActiveActivityIds(pi).get(0));
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        this.repositoryService.deleteDeployment(id, true);
    }

    @Deployment
    @Test
    public void testTimerShouldNotBeRecreatedOnDeploymentCacheReboot() {
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        this.processEngineConfiguration.getDeploymentCache().discardProcessDefinitionCache();
        this.runtimeService.startProcessInstanceByKey("startTimer");
        Assert.assertEquals((long)1L, (long)jobQuery.count());
    }

    @Test
    public void testTimerShouldNotBeRemovedWhenUndeployingOldVersion() throws Exception {
        InputStream in = this.getClass().getResourceAsStream("StartTimerEventTest.testTimerShouldNotBeRemovedWhenUndeployingOldVersion.bpmn20.xml");
        String process = new String(IoUtil.readInputStream((InputStream)in, (String)""));
        IoUtil.closeSilently((Closeable)in);
        in = new ByteArrayInputStream(process.getBytes());
        String firstDeploymentId = this.repositoryService.createDeployment().addInputStream("StartTimerEventTest.testVersionUpgradeShouldCancelJobs.bpmn20.xml", in).deploy().getId();
        IoUtil.closeSilently((Closeable)in);
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        String processChanged = process.replaceAll("beforeChange", "changed");
        in = new ByteArrayInputStream(processChanged.getBytes());
        String secondDeploymentId = this.repositoryService.createDeployment().addInputStream("StartTimerEventTest.testVersionUpgradeShouldCancelJobs.bpmn20.xml", in).deploy().getId();
        IoUtil.closeSilently((Closeable)in);
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        this.repositoryService.deleteDeployment(firstDeploymentId, true);
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        this.cleanDB();
        this.repositoryService.deleteDeployment(secondDeploymentId, true);
    }

    @Deployment
    @Test
    public void testStartTimerEventInEventSubProcess() {
        DummyServiceTask.wasExecuted = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("startTimerEventInEventSubProcess");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        this.managementService.executeJob(((Job)this.managementService.createJobQuery().list().get(0)).getId());
        Assert.assertEquals((long)0L, (long)jobQuery.count());
        Assert.assertEquals((Object)true, (Object)DummyServiceTask.wasExecuted);
        Assert.assertEquals((long)0L, (long)taskQuery.count());
        Assert.assertEquals((long)0L, (long)executionQuery.count());
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)0L, (long)processInstanceQuery.count());
    }

    @Test
    @Deployment
    public void shouldEvaluateExpressionStartTimerEventInEventSubprocess() {
        ProcessInstantiationBuilder builder = (ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("shouldEvaluateExpressionStartTimerEventInEventSubprocess").setVariable("duration", (Object)"PT5M");
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)builder.startBeforeActivity("processUserTask")).execute();
        ProcessInstance startedProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assertions.assertThat((String)processInstance.getId()).isEqualTo((Object)startedProcessInstance.getId());
    }

    @Deployment
    @Test
    public void testNonInterruptingStartTimerEventInEventSubProcess() {
        DummyServiceTask.wasExecuted = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nonInterruptingStartTimerEventInEventSubProcess");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        this.managementService.executeJob(((Job)this.managementService.createJobQuery().list().get(0)).getId());
        Assert.assertEquals((long)0L, (long)jobQuery.count());
        Assert.assertEquals((Object)true, (Object)DummyServiceTask.wasExecuted);
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        Assert.assertEquals((long)1L, (long)executionQuery.count());
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)processInstanceQuery.count());
    }

    @Deployment
    @Test
    public void testStartTimerEventSubProcessInSubProcess() {
        DummyServiceTask.wasExecuted = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("startTimerEventSubProcessInSubProcess");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)2L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        this.managementService.executeJob(((Job)this.managementService.createJobQuery().list().get(0)).getId());
        Assert.assertEquals((long)0L, (long)jobQuery.count());
        Assert.assertEquals((Object)true, (Object)DummyServiceTask.wasExecuted);
        Assert.assertEquals((long)0L, (long)taskQuery.count());
        Assert.assertEquals((long)0L, (long)executionQuery.count());
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)0L, (long)processInstanceQuery.count());
    }

    @Deployment
    @Test
    public void testNonInterruptingStartTimerEventSubProcessInSubProcess() {
        DummyServiceTask.wasExecuted = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nonInterruptingStartTimerEventSubProcessInSubProcess");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)2L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        this.managementService.executeJob(((Job)jobQuery.list().get(0)).getId());
        Assert.assertEquals((long)0L, (long)jobQuery.count());
        Assert.assertEquals((Object)true, (Object)DummyServiceTask.wasExecuted);
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        Assert.assertEquals((long)2L, (long)executionQuery.count());
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)processInstanceQuery.count());
    }

    @Deployment
    @Test
    public void testStartTimerEventWithTwoEventSubProcesses() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("startTimerEventWithTwoEventSubProcesses");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)2L, (long)jobQuery.count());
        List orderedJobList = ((JobQuery)jobQuery.orderByJobDuedate().asc()).list();
        this.managementService.executeJob(((Job)orderedJobList.get(0)).getId());
        Assert.assertEquals((long)0L, (long)jobQuery.count());
        Assert.assertEquals((long)0L, (long)taskQuery.count());
        Assert.assertEquals((long)0L, (long)executionQuery.count());
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)0L, (long)processInstanceQuery.count());
    }

    @Deployment
    @Test
    public void testNonInterruptingStartTimerEventWithTwoEventSubProcesses() {
        DummyServiceTask.wasExecuted = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nonInterruptingStartTimerEventWithTwoEventSubProcesses");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)2L, (long)jobQuery.count());
        List orderedJobList = ((JobQuery)jobQuery.orderByJobDuedate().asc()).list();
        this.managementService.executeJob(((Job)orderedJobList.get(0)).getId());
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Assert.assertEquals((Object)true, (Object)DummyServiceTask.wasExecuted);
        DummyServiceTask.wasExecuted = false;
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        Assert.assertEquals((long)1L, (long)executionQuery.count());
        this.managementService.executeJob(((Job)orderedJobList.get(1)).getId());
        Assert.assertEquals((long)0L, (long)jobQuery.count());
        Assert.assertEquals((Object)true, (Object)DummyServiceTask.wasExecuted);
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        Assert.assertEquals((long)1L, (long)executionQuery.count());
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)processInstanceQuery.count());
    }

    @Deployment
    @Test
    public void testStartTimerEventSubProcessWithUserTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("startTimerEventSubProcessWithUserTask");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)2L, (long)jobQuery.count());
        List orderedJobList = ((JobQuery)jobQuery.orderByJobDuedate().asc()).list();
        this.managementService.executeJob(((Job)orderedJobList.get(0)).getId());
        Assert.assertEquals((long)0L, (long)jobQuery.count());
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        Assert.assertEquals((Object)"subprocessUserTask", (Object)((Task)taskQuery.list().get(0)).getTaskDefinitionKey());
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)processInstanceQuery.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/timer/simpleProcessWithCallActivity.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/timer/StartTimerEventTest.testStartTimerEventWithTwoEventSubProcesses.bpmn20.xml"})
    @Test
    public void testStartTimerEventSubProcessCalledFromCallActivity() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("calledProcess", "startTimerEventWithTwoEventSubProcesses");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("simpleCallActivityProcess", variables);
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)2L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)2L, (long)jobQuery.count());
        List orderedJobList = ((JobQuery)jobQuery.orderByJobDuedate().asc()).list();
        this.managementService.executeJob(((Job)orderedJobList.get(0)).getId());
        Assert.assertEquals((long)0L, (long)jobQuery.count());
        Assert.assertEquals((long)0L, (long)taskQuery.count());
        Assert.assertEquals((long)0L, (long)executionQuery.count());
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)0L, (long)processInstanceQuery.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/timer/simpleProcessWithCallActivity.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/timer/StartTimerEventTest.testNonInterruptingStartTimerEventWithTwoEventSubProcesses.bpmn20.xml"})
    @Test
    public void testNonInterruptingStartTimerEventSubProcessesCalledFromCallActivity() {
        DummyServiceTask.wasExecuted = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nonInterruptingStartTimerEventWithTwoEventSubProcesses");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)2L, (long)jobQuery.count());
        List orderedJobList = ((JobQuery)jobQuery.orderByJobDuedate().asc()).list();
        this.managementService.executeJob(((Job)orderedJobList.get(0)).getId());
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Assert.assertEquals((Object)true, (Object)DummyServiceTask.wasExecuted);
        DummyServiceTask.wasExecuted = false;
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        Assert.assertEquals((long)1L, (long)executionQuery.count());
        this.managementService.executeJob(((Job)orderedJobList.get(1)).getId());
        Assert.assertEquals((long)0L, (long)jobQuery.count());
        Assert.assertEquals((Object)true, (Object)DummyServiceTask.wasExecuted);
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        Assert.assertEquals((long)1L, (long)executionQuery.count());
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)processInstanceQuery.count());
    }

    @Deployment
    @Test
    public void testStartTimerEventSubProcessInMultiInstanceSubProcess() {
        DummyServiceTask.wasExecuted = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("startTimerEventSubProcessInMultiInstanceSubProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        String jobIdFirstLoop = ((Job)jobQuery.list().get(0)).getId();
        this.managementService.executeJob(jobIdFirstLoop);
        Assert.assertEquals((Object)true, (Object)DummyServiceTask.wasExecuted);
        DummyServiceTask.wasExecuted = false;
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        String jobIdSecondLoop = ((Job)jobQuery.list().get(0)).getId();
        Assert.assertNotSame((Object)jobIdFirstLoop, (Object)jobIdSecondLoop);
        this.managementService.executeJob(jobIdSecondLoop);
        Assert.assertEquals((Object)true, (Object)DummyServiceTask.wasExecuted);
        Assert.assertEquals((long)0L, (long)jobQuery.count());
        Assert.assertEquals((long)0L, (long)taskQuery.count());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    @Test
    public void testNonInterruptingStartTimerEventInMultiInstanceEventSubProcess() {
        DummyServiceTask.wasExecuted = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nonInterruptingStartTimerEventInMultiInstanceEventSubProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        String jobIdFirstLoop = ((Job)jobQuery.list().get(0)).getId();
        this.managementService.executeJob(jobIdFirstLoop);
        Assert.assertEquals((Object)true, (Object)DummyServiceTask.wasExecuted);
        DummyServiceTask.wasExecuted = false;
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        this.taskService.complete(((Task)taskQuery.list().get(0)).getId());
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        String jobIdSecondLoop = ((Job)jobQuery.list().get(0)).getId();
        Assert.assertNotSame((Object)jobIdFirstLoop, (Object)jobIdSecondLoop);
        this.managementService.executeJob(jobIdSecondLoop);
        Assert.assertEquals((Object)true, (Object)DummyServiceTask.wasExecuted);
        Assert.assertEquals((long)0L, (long)jobQuery.count());
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)processInstanceQuery.count());
    }

    @Deployment
    @Test
    public void testStartTimerEventSubProcessInParallelMultiInstanceSubProcess() {
        DummyServiceTask.wasExecuted = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("startTimerEventSubProcessInParallelMultiInstanceSubProcess");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)6L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Assert.assertEquals((long)2L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)2L, (long)jobQuery.count());
        for (Job job : jobQuery.list()) {
            this.managementService.executeJob(job.getId());
            Assert.assertEquals((Object)true, (Object)DummyServiceTask.wasExecuted);
            DummyServiceTask.wasExecuted = false;
        }
        Assert.assertEquals((long)0L, (long)taskQuery.count());
        Assert.assertEquals((long)0L, (long)executionQuery.count());
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)0L, (long)processInstanceQuery.count());
    }

    @Deployment
    @Test
    public void testNonInterruptingStartTimerEventSubProcessWithParallelMultiInstance() {
        DummyServiceTask.wasExecuted = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nonInterruptingParallelMultiInstance");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)6L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Assert.assertEquals((long)2L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)2L, (long)jobQuery.count());
        for (Job job : jobQuery.list()) {
            this.managementService.executeJob(job.getId());
            Assert.assertEquals((Object)true, (Object)DummyServiceTask.wasExecuted);
            DummyServiceTask.wasExecuted = false;
        }
        Assert.assertEquals((long)0L, (long)jobQuery.count());
        Assert.assertEquals((long)2L, (long)taskQuery.count());
        Assert.assertEquals((long)6L, (long)executionQuery.count());
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)processInstanceQuery.count());
    }

    @Deployment
    @Test
    public void testStartTimerEventSubProcessInMultiInstanceSubProcessWithNonInterruptingBoundaryTimerEvent() {
        DummyServiceTask.wasExecuted = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)2L, (long)jobQuery.count());
        this.managementService.executeJob(((Job)((JobQuery)jobQuery.orderByJobDuedate().asc()).list().get(1)).getId());
        Assert.assertEquals((Object)true, (Object)DummyServiceTask.wasExecuted);
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        Assert.assertEquals((long)2L, (long)jobQuery.count());
        this.managementService.executeJob(((Job)((JobQuery)jobQuery.orderByJobDuedate().asc()).list().get(0)).getId());
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)processInstanceQuery.count());
    }

    @Deployment
    @Test
    public void testStartTimerEventSubProcessInMultiInstanceSubProcessWithInterruptingBoundaryTimerEvent() {
        DummyServiceTask.wasExecuted = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)2L, (long)jobQuery.count());
        this.managementService.executeJob(((Job)((JobQuery)jobQuery.orderByJobDuedate().asc()).list().get(1)).getId());
        Assert.assertEquals((Object)true, (Object)DummyServiceTask.wasExecuted);
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        Assert.assertEquals((long)2L, (long)jobQuery.count());
        this.managementService.executeJob(((Job)((JobQuery)jobQuery.orderByJobDuedate().asc()).list().get(0)).getId());
        Assert.assertEquals((long)0L, (long)jobQuery.count());
        Assert.assertEquals((long)0L, (long)taskQuery.count());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    @Test
    public void testNonInterruptingStartTimerEventSubProcessInMultiInstanceSubProcessWithInterruptingBoundaryTimerEvent() {
        DummyServiceTask.wasExecuted = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)3L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)2L, (long)jobQuery.count());
        this.managementService.executeJob(((Job)((JobQuery)jobQuery.orderByJobDuedate().asc()).list().get(1)).getId());
        Assert.assertEquals((Object)true, (Object)DummyServiceTask.wasExecuted);
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        this.taskService.complete(((Task)taskQuery.list().get(0)).getId());
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        Assert.assertEquals((long)2L, (long)jobQuery.count());
        this.managementService.executeJob(((Job)((JobQuery)jobQuery.orderByJobDuedate().asc()).list().get(0)).getId());
        Assert.assertEquals((long)0L, (long)jobQuery.count());
        Assert.assertEquals((long)0L, (long)taskQuery.count());
        Assert.assertEquals((long)0L, (long)executionQuery.count());
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)0L, (long)processInstanceQuery.count());
    }

    @Deployment
    @Test
    public void testStartTimerEventSubProcessInParallelMultiInstanceSubProcessWithNonInterruptingBoundaryTimerEvent() {
        DummyServiceTask.wasExecuted = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)6L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Assert.assertEquals((long)2L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)3L, (long)jobQuery.count());
        this.managementService.executeJob(((Job)((JobQuery)jobQuery.orderByJobDuedate().asc()).list().get(1)).getId());
        Assert.assertEquals((Object)true, (Object)DummyServiceTask.wasExecuted);
        Assert.assertEquals((long)2L, (long)jobQuery.count());
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        Assert.assertEquals((long)5L, (long)executionQuery.count());
        this.managementService.executeJob(((Job)((JobQuery)jobQuery.orderByJobDuedate().asc()).list().get(0)).getId());
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        Assert.assertEquals((long)5L, (long)executionQuery.count());
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)processInstanceQuery.count());
    }

    @Deployment
    @Test
    public void testStartTimerEventSubProcessInParallelMultiInstanceSubProcessWithInterruptingBoundaryTimerEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)6L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Assert.assertEquals((long)2L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)3L, (long)jobQuery.count());
        this.managementService.executeJob(((Job)((JobQuery)jobQuery.orderByJobDuedate().asc()).list().get(1)).getId());
        Assert.assertEquals((long)2L, (long)jobQuery.count());
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        Assert.assertEquals((long)5L, (long)executionQuery.count());
        this.managementService.executeJob(((Job)((JobQuery)jobQuery.orderByJobDuedate().asc()).list().get(0)).getId());
        Assert.assertEquals((long)0L, (long)jobQuery.count());
        Assert.assertEquals((long)0L, (long)taskQuery.count());
        Assert.assertEquals((long)0L, (long)executionQuery.count());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    @Test
    public void testNonInterruptingStartTimerEventSubProcessInParallelMiSubProcessWithInterruptingBoundaryTimerEvent() {
        DummyServiceTask.wasExecuted = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        Assert.assertEquals((long)6L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Assert.assertEquals((long)2L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)3L, (long)jobQuery.count());
        this.managementService.executeJob(((Job)((JobQuery)jobQuery.orderByJobDuedate().asc()).list().get(1)).getId());
        Assert.assertEquals((Object)true, (Object)DummyServiceTask.wasExecuted);
        Assert.assertEquals((long)2L, (long)jobQuery.count());
        Assert.assertEquals((long)2L, (long)taskQuery.count());
        Assert.assertEquals((long)6L, (long)executionQuery.count());
        this.managementService.executeJob(((Job)((JobQuery)jobQuery.orderByJobDuedate().asc()).list().get(0)).getId());
        Assert.assertEquals((long)0L, (long)jobQuery.count());
        Assert.assertEquals((long)0L, (long)taskQuery.count());
        Assert.assertEquals((long)0L, (long)executionQuery.count());
        this.testRule.assertProcessEnded(processInstance.getId());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)3L, (long)jobQuery.count());
        Assert.assertEquals((long)2L, (long)taskQuery.count());
        for (Task task : taskQuery.list()) {
            this.taskService.complete(task.getId());
        }
        Assert.assertEquals((long)0L, (long)jobQuery.count());
        Assert.assertEquals((long)0L, (long)taskQuery.count());
        Assert.assertEquals((long)0L, (long)executionQuery.count());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    @Test
    public void testTimeCycle() {
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        String jobId = ((Job)jobQuery.singleResult()).getId();
        this.managementService.executeJob(jobId);
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        String anotherJobId = ((Job)jobQuery.singleResult()).getId();
        Assert.assertFalse((boolean)jobId.equals(anotherJobId));
    }

    @Test
    public void testRecalculateTimeCycleExpressionCurrentDateBased() throws Exception {
        Mocks.register((String)"cycle", (Object)"R/PT15M");
        ProcessBuilder processBuilder = Bpmn.createExecutableProcess((String)"process");
        BpmnModelInstance modelInstance = ((StartEventBuilder)processBuilder.startEvent().timerWithCycle("${cycle}")).userTask("aTaskName").endEvent().done();
        this.testRule.deploy(this.repositoryService.createDeployment().addModelInstance("process.bpmn", modelInstance));
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Job job = (Job)jobQuery.singleResult();
        String jobId = job.getId();
        Date oldDuedate = job.getDuedate();
        this.moveByMinutes(1);
        this.managementService.recalculateJobDuedate(jobId, false);
        Job jobUpdated = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)jobId, (Object)jobUpdated.getId());
        Assert.assertNotEquals((Object)oldDuedate, (Object)jobUpdated.getDuedate());
        Assert.assertTrue((boolean)oldDuedate.before(jobUpdated.getDuedate()));
        Mocks.register((String)"cycle", (Object)"R/PT10M");
        this.managementService.recalculateJobDuedate(jobId, false);
        jobUpdated = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)jobId, (Object)jobUpdated.getId());
        Assert.assertNotEquals((Object)oldDuedate, (Object)jobUpdated.getDuedate());
        Assert.assertTrue((boolean)oldDuedate.after(jobUpdated.getDuedate()));
        Mocks.reset();
    }

    @Test
    public void testRecalculateTimeCycleExpressionCreationDateBased() throws Exception {
        Mocks.register((String)"cycle", (Object)"R/PT15M");
        ProcessBuilder processBuilder = Bpmn.createExecutableProcess((String)"process");
        BpmnModelInstance modelInstance = ((StartEventBuilder)processBuilder.startEvent().timerWithCycle("${cycle}")).userTask("aTaskName").endEvent().done();
        this.testRule.deploy(this.repositoryService.createDeployment().addModelInstance("process.bpmn", modelInstance));
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Job job = (Job)jobQuery.singleResult();
        String jobId = job.getId();
        Date oldDuedate = job.getDuedate();
        this.moveByMinutes(1);
        this.managementService.recalculateJobDuedate(jobId, true);
        Job jobUpdated = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)jobId, (Object)jobUpdated.getId());
        Date expectedDate = LocalDateTime.fromDateFields((Date)jobUpdated.getCreateTime()).plusMinutes(15).toDate();
        Assert.assertEquals((Object)expectedDate, (Object)jobUpdated.getDuedate());
        Mocks.register((String)"cycle", (Object)"R/PT10M");
        this.managementService.recalculateJobDuedate(jobId, true);
        jobUpdated = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)jobId, (Object)jobUpdated.getId());
        Assert.assertNotEquals((Object)oldDuedate, (Object)jobUpdated.getDuedate());
        Assert.assertTrue((boolean)oldDuedate.after(jobUpdated.getDuedate()));
        expectedDate = LocalDateTime.fromDateFields((Date)jobUpdated.getCreateTime()).plusMinutes(10).toDate();
        Assert.assertEquals((Object)expectedDate, (Object)jobUpdated.getDuedate());
        Mocks.reset();
    }

    @Deployment
    @Test
    public void testFailingTimeCycle() throws Exception {
        JobQuery query = this.managementService.createJobQuery();
        JobQuery failedJobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)query.count());
        String jobId = ((Job)query.singleResult()).getId();
        failedJobQuery.jobId(jobId);
        this.moveByMinutes(5);
        try {
            this.managementService.executeJob(jobId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Job failedJob = (Job)failedJobQuery.singleResult();
        Assert.assertEquals((long)2L, (long)failedJob.getRetries());
        Assert.assertEquals((long)2L, (long)query.count());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        Assert.assertEquals((long)2L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
        try {
            this.managementService.executeJob(jobId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        failedJob = (Job)failedJobQuery.singleResult();
        Assert.assertEquals((long)1L, (long)failedJob.getRetries());
        Assert.assertEquals((long)2L, (long)query.count());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        Assert.assertEquals((long)2L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
    }

    @Deployment
    @Test
    public void testNonInterruptingTimeCycleInEventSubProcess() {
        this.runtimeService.startProcessInstanceByKey("process");
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        String jobId = ((Job)jobQuery.singleResult()).getId();
        this.managementService.executeJob(jobId);
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        String anotherJobId = ((Job)jobQuery.singleResult()).getId();
        Assert.assertFalse((boolean)jobId.equals(anotherJobId));
    }

    @Test
    public void testInterruptingWithDurationExpression() {
        Mocks.register((String)"duration", (Object)"PT60S");
        ProcessBuilder processBuilder = Bpmn.createExecutableProcess((String)"process");
        BpmnModelInstance modelInstance = ((StartEventBuilder)processBuilder.startEvent().timerWithDuration("${duration}")).userTask("aTaskName").endEvent().done();
        this.testRule.deploy(this.repositoryService.createDeployment().addModelInstance("process.bpmn", modelInstance));
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("aTaskName").list().size());
        Mocks.reset();
    }

    @Test
    public void testInterruptingWithDurationExpressionInEventSubprocess() {
        ProcessBuilder processBuilder = Bpmn.createExecutableProcess((String)"process");
        BpmnModelInstance modelInstance = processBuilder.startEvent().userTask().endEvent().done();
        ((StartEventBuilder)processBuilder.eventSubProcess().startEvent().timerWithDuration("${duration}")).userTask("taskInSubprocess").endEvent();
        this.testRule.deploy(this.repositoryService.createDeployment().addModelInstance("process.bpmn", modelInstance));
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("duration", (Object)"PT60S"));
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("taskInSubprocess").list().size());
    }

    @Test
    public void testNonInterruptingWithDurationExpressionInEventSubprocess() {
        ProcessBuilder processBuilder = Bpmn.createExecutableProcess((String)"process");
        BpmnModelInstance modelInstance = processBuilder.startEvent().userTask().endEvent().done();
        ((StartEventBuilder)((StartEventBuilder)processBuilder.eventSubProcess().startEvent().interrupting(false)).timerWithDuration("${duration}")).userTask("taskInSubprocess").endEvent();
        this.testRule.deploy(this.repositoryService.createDeployment().addModelInstance("process.bpmn", modelInstance));
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("duration", (Object)"PT60S"));
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("taskInSubprocess").list().size());
    }

    @Test
    public void testRecalculateNonInterruptingWithUnchangedDurationExpressionInEventSubprocessCurrentDateBased() throws Exception {
        ProcessBuilder processBuilder = Bpmn.createExecutableProcess((String)"process");
        BpmnModelInstance modelInstance = processBuilder.startEvent().userTask().endEvent().done();
        ((StartEventBuilder)((StartEventBuilder)processBuilder.eventSubProcess().startEvent().interrupting(false)).timerWithDuration("${duration}")).userTask("taskInSubprocess").endEvent();
        this.testRule.deploy(this.repositoryService.createDeployment().addModelInstance("process.bpmn", modelInstance));
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("duration", (Object)"PT70S"));
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job job = (Job)jobQuery.singleResult();
        String jobId = job.getId();
        Date oldDueDate = job.getDuedate();
        this.moveByMinutes(2);
        Date currentTime = ClockUtil.getCurrentTime();
        this.managementService.recalculateJobDuedate(jobId, false);
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Date newDuedate = ((Job)jobQuery.singleResult()).getDuedate();
        Assert.assertNotEquals((Object)oldDueDate, (Object)newDuedate);
        Assert.assertTrue((boolean)oldDueDate.before(newDuedate));
        Date expectedDate = LocalDateTime.fromDateFields((Date)currentTime).plusSeconds(70).toDate();
        Assertions.assertThat((Date)newDuedate).isCloseTo(expectedDate, 1000L);
        this.managementService.executeJob(jobId);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("taskInSubprocess").list().size());
    }

    @Test
    public void testRecalculateNonInterruptingWithChangedDurationExpressionInEventSubprocessCreationDateBased() throws Exception {
        ProcessBuilder processBuilder = Bpmn.createExecutableProcess((String)"process");
        BpmnModelInstance modelInstance = processBuilder.startEvent().userTask().endEvent().done();
        ((StartEventBuilder)((StartEventBuilder)processBuilder.eventSubProcess().startEvent().interrupting(false)).timerWithDuration("${duration}")).userTask("taskInSubprocess").endEvent();
        this.testRule.deploy(this.repositoryService.createDeployment().addModelInstance("process.bpmn", modelInstance));
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("duration", (Object)"PT60S"));
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job job = (Job)jobQuery.singleResult();
        String jobId = job.getId();
        Date oldDueDate = job.getDuedate();
        this.runtimeService.setVariable(pi.getId(), "duration", (Object)"PT2M");
        this.managementService.recalculateJobDuedate(jobId, true);
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Date newDuedate = ((Job)jobQuery.singleResult()).getDuedate();
        Date expectedDate = LocalDateTime.fromDateFields((Date)((Job)jobQuery.singleResult()).getCreateTime()).plusMinutes(2).toDate();
        Assert.assertTrue((boolean)oldDueDate.before(newDuedate));
        Assert.assertTrue((boolean)expectedDate.equals(newDuedate));
        this.managementService.executeJob(jobId);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("taskInSubprocess").list().size());
    }

    @Deployment
    @Test
    public void testNonInterruptingFailingTimeCycleInEventSubProcess() {
        this.runtimeService.startProcessInstanceByKey("process");
        JobQuery failedJobQuery = this.managementService.createJobQuery();
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        String jobId = ((Job)jobQuery.singleResult()).getId();
        failedJobQuery.jobId(jobId);
        try {
            this.managementService.executeJob(jobId);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Job failedJob = (Job)failedJobQuery.singleResult();
        Assert.assertEquals((long)2L, (long)failedJob.getRetries());
        Assert.assertEquals((long)2L, (long)jobQuery.count());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        Assert.assertEquals((long)2L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
        try {
            this.managementService.executeJob(jobId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        failedJob = (Job)failedJobQuery.singleResult();
        Assert.assertEquals((long)1L, (long)failedJob.getRetries());
        Assert.assertEquals((long)2L, (long)jobQuery.count());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        Assert.assertEquals((long)2L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
    }

    @Test
    public void shouldReevaluateTimerCycleWhenDue() throws Exception {
        MyCycleTimerBean myCycleTimerBean = new MyCycleTimerBean("R2/PT1H");
        this.processEngineConfiguration.getBeans().put("myCycleTimerBean", myCycleTimerBean);
        this.processEngineConfiguration.setReevaluateTimeCycleWhenDue(true);
        this.createAndDeployProcessWithStartTimer();
        this.moveByHours(1);
        myCycleTimerBean.setCycle("R2/PT2H");
        this.moveByHours(1);
        Date duedate = ((Job)this.managementService.createJobQuery().singleResult()).getDuedate();
        Assertions.assertThat((Date)duedate).isEqualToIgnoringMinutes(new Date(ClockUtil.getCurrentTime().getTime() + TWO_HOURS));
    }

    @Test
    public void shouldNotReevaluateTimerCycle() throws Exception {
        MyCycleTimerBean myCycleTimerBean = new MyCycleTimerBean("R2/PT1H");
        this.processEngineConfiguration.getBeans().put("myCycleTimerBean", myCycleTimerBean);
        this.processEngineConfiguration.setReevaluateTimeCycleWhenDue(true);
        this.createAndDeployProcessWithStartTimer();
        this.moveByHours(1);
        this.moveByHours(1);
        Assertions.assertThat((Object)((Job)this.managementService.createJobQuery().singleResult())).isNull();
    }

    @Test
    public void shouldNotReevaluateTimerCycleWhenFeatureDisabled() throws Exception {
        MyCycleTimerBean myCycleTimerBean = new MyCycleTimerBean("R2/PT1H");
        this.processEngineConfiguration.getBeans().put("myCycleTimerBean", myCycleTimerBean);
        this.processEngineConfiguration.setReevaluateTimeCycleWhenDue(false);
        this.createAndDeployProcessWithStartTimer();
        TaskQuery taskQuery = this.taskService.createTaskQuery().taskDefinitionKey("aTaskName");
        Assert.assertEquals((long)0L, (long)taskQuery.count());
        this.moveByHours(1);
        Assert.assertEquals((long)1L, (long)taskQuery.count());
        myCycleTimerBean.setCycle("R2/PT2H");
        this.moveByHours(1);
        Assertions.assertThat((Object)((Job)this.managementService.createJobQuery().singleResult())).isNull();
        Assert.assertEquals((long)2L, (long)taskQuery.count());
    }

    @Test
    public void shouldReevaluateCronTimerCycleWhenDue() throws Exception {
        ClockUtil.setCurrentTime((Date)START_DATE);
        MyCycleTimerBean myCycleTimerBean = new MyCycleTimerBean("0 0 * ? * * *");
        this.processEngineConfiguration.getBeans().put("myCycleTimerBean", myCycleTimerBean);
        this.processEngineConfiguration.setReevaluateTimeCycleWhenDue(true);
        this.createAndDeployProcessWithStartTimer();
        this.moveByHours(1);
        myCycleTimerBean.setCycle("0 0 0/2 ? * * *");
        this.moveByHours(1);
        Date duedate = ((Job)this.managementService.createJobQuery().singleResult()).getDuedate();
        Assertions.assertThat((Date)duedate).isEqualToIgnoringMinutes(new Date(ClockUtil.getCurrentTime().getTime() + TWO_HOURS));
    }

    @Test
    public void shouldReevaluateRepeatingToCronTimerCycle() throws Exception {
        ClockUtil.setCurrentTime((Date)START_DATE);
        MyCycleTimerBean myCycleTimerBean = new MyCycleTimerBean("R2/PT1H");
        this.processEngineConfiguration.getBeans().put("myCycleTimerBean", myCycleTimerBean);
        this.processEngineConfiguration.setReevaluateTimeCycleWhenDue(true);
        this.createAndDeployProcessWithStartTimer();
        this.moveByHours(1);
        myCycleTimerBean.setCycle("0 0 0/2 ? * * *");
        this.moveByHours(1);
        Date duedate = ((Job)this.managementService.createJobQuery().singleResult()).getDuedate();
        Assertions.assertThat((Date)duedate).isEqualToIgnoringMinutes(new Date(ClockUtil.getCurrentTime().getTime() + TWO_HOURS));
    }

    @Test
    public void shouldReevaluateCronToRepeatingTimerCycle() throws Exception {
        ClockUtil.setCurrentTime((Date)START_DATE);
        MyCycleTimerBean myCycleTimerBean = new MyCycleTimerBean("0 0 * ? * * *");
        this.processEngineConfiguration.getBeans().put("myCycleTimerBean", myCycleTimerBean);
        this.processEngineConfiguration.setReevaluateTimeCycleWhenDue(true);
        this.createAndDeployProcessWithStartTimer();
        this.moveByHours(1);
        myCycleTimerBean.setCycle("R2/PT2H");
        this.moveByHours(1);
        JobQuery jobQuery = this.managementService.createJobQuery();
        Date duedate = ((Job)jobQuery.singleResult()).getDuedate();
        Assertions.assertThat((Date)duedate).isEqualToIgnoringMinutes(new Date(ClockUtil.getCurrentTime().getTime() + TWO_HOURS));
        this.moveByHours(2);
        duedate = ((Job)jobQuery.singleResult()).getDuedate();
        Assertions.assertThat((Date)duedate).isEqualToIgnoringMinutes(new Date(ClockUtil.getCurrentTime().getTime() + TWO_HOURS));
        this.moveByHours(2);
        Assertions.assertThat((Object)((Job)jobQuery.singleResult())).isNull();
    }

    @Test
    public void shouldReevaluateCronToRepeatingTimerCycleWithDate() throws Exception {
        ClockUtil.setCurrentTime((Date)START_DATE);
        MyCycleTimerBean myCycleTimerBean = new MyCycleTimerBean("0 0 * ? * * *");
        this.processEngineConfiguration.getBeans().put("myCycleTimerBean", myCycleTimerBean);
        this.processEngineConfiguration.setReevaluateTimeCycleWhenDue(true);
        this.createAndDeployProcessWithStartTimer();
        this.moveByHours(1);
        myCycleTimerBean.setCycle("R2/2023-08-18T14:00/PT30M");
        this.moveByHours(1);
        JobQuery jobQuery = this.managementService.createJobQuery();
        Date duedate = ((Job)jobQuery.singleResult()).getDuedate();
        Assertions.assertThat((Date)duedate).isEqualToIgnoringMinutes(new Date(ClockUtil.getCurrentTime().getTime() + TimeUnit.HOURS.toMillis(4L)));
        this.moveByHours(4);
        duedate = ((Job)jobQuery.singleResult()).getDuedate();
        Assertions.assertThat((Date)duedate).isEqualToIgnoringMinutes(new Date(ClockUtil.getCurrentTime().getTime() + TimeUnit.MINUTES.toMillis(30L)));
        this.moveByHours(1);
        Assertions.assertThat((Object)((Job)jobQuery.singleResult())).isNull();
    }

    @Test
    public void shouldReevaluateRepeatingTimerCycleWithDate() throws Exception {
        ClockUtil.setCurrentTime((Date)START_DATE);
        MyCycleTimerBean myCycleTimerBean = new MyCycleTimerBean("R3/2023-08-18T8:00/PT1H");
        this.processEngineConfiguration.getBeans().put("myCycleTimerBean", myCycleTimerBean);
        this.processEngineConfiguration.setReevaluateTimeCycleWhenDue(true);
        this.createAndDeployProcessWithStartTimer();
        this.moveByHours(1);
        myCycleTimerBean.setCycle("R2/PT2H");
        this.moveByHours(1);
        JobQuery jobQuery = this.managementService.createJobQuery();
        Date duedate = ((Job)jobQuery.singleResult()).getDuedate();
        Assertions.assertThat((Date)duedate).isEqualToIgnoringMinutes(new Date(ClockUtil.getCurrentTime().getTime() + TWO_HOURS));
        this.moveByHours(2);
        duedate = ((Job)jobQuery.singleResult()).getDuedate();
        Assertions.assertThat((Date)duedate).isEqualToIgnoringMinutes(new Date(ClockUtil.getCurrentTime().getTime() + TWO_HOURS));
        this.moveByHours(2);
        Assertions.assertThat((Object)((Job)jobQuery.singleResult())).isNull();
    }

    @Test
    public void shouldReevaluateRepeatingTimerCycleToTimerCycleWithDate() throws Exception {
        ClockUtil.setCurrentTime((Date)START_DATE);
        MyCycleTimerBean myCycleTimerBean = new MyCycleTimerBean("R3/PT1H");
        this.processEngineConfiguration.getBeans().put("myCycleTimerBean", myCycleTimerBean);
        this.processEngineConfiguration.setReevaluateTimeCycleWhenDue(true);
        this.createAndDeployProcessWithStartTimer();
        this.moveByHours(1);
        myCycleTimerBean.setCycle("R2/2023-08-18T10:00/PT2H");
        this.moveByHours(1);
        JobQuery jobQuery = this.managementService.createJobQuery();
        Date duedate = ((Job)jobQuery.singleResult()).getDuedate();
        Assertions.assertThat((Date)duedate).isEqualToIgnoringMinutes(new Date(ClockUtil.getCurrentTime().getTime() + TWO_HOURS));
        this.moveByHours(2);
        duedate = ((Job)jobQuery.singleResult()).getDuedate();
        Assertions.assertThat((Date)duedate).isEqualToIgnoringMinutes(new Date(ClockUtil.getCurrentTime().getTime() + TWO_HOURS));
        this.moveByHours(2);
        Assertions.assertThat((Object)((Job)jobQuery.singleResult())).isNull();
    }

    protected void executeAllJobs() {
        String nextJobId = this.getNextExecutableJobId();
        while (nextJobId != null) {
            try {
                this.managementService.executeJob(nextJobId);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            nextJobId = this.getNextExecutableJobId();
        }
    }

    protected void moveByHours(int hours) {
        ClockUtil.setCurrentTime((Date)new Date(ClockUtil.getCurrentTime().getTime() + (TimeUnit.HOURS.toMillis(hours) + 5000L)));
        this.testRule.executeAvailableJobs(false);
    }

    protected String getNextExecutableJobId() {
        List jobs = this.managementService.createJobQuery().executable().listPage(0, 1);
        if (jobs.size() == 1) {
            return ((Job)jobs.get(0)).getId();
        }
        return null;
    }

    private void cleanDB() {
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new DeleteJobsCmd(jobId, true));
    }

    protected void createAndDeployProcessWithStartTimer() {
        this.testRule.deploy(((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().timerWithCycle("#{myCycleTimerBean.getCycle()}")).userTask("aTaskName").endEvent().done());
    }
}

