/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.DateUtils;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.event.HistoricProcessInstanceEventEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.CallActivityModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.CompensationModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.api.runtime.util.ChangeVariablesDelegate;
import org.camunda.bpm.engine.test.jobexecutor.FailingDelegate;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.EndEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.SubProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="audit")
public class HistoricProcessInstanceTest {
    public static final BpmnModelInstance FORK_JOIN_SUB_PROCESS_MODEL = ((UserTaskBuilder)ProcessModels.newModel().startEvent().subProcess("subProcess").embeddedSubProcess().startEvent().parallelGateway("fork").userTask("userTask1").name("completeMe")).parallelGateway("join").endEvent().moveToNode("fork").userTask("userTask2").connectTo("join").subProcessDone().endEvent().done();
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected ManagementService managementService;
    protected HistoryService historyService;
    protected TaskService taskService;
    protected CaseService caseService;

    @Before
    public void initServices() {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.historyService = this.engineRule.getHistoryService();
        this.taskService = this.engineRule.getTaskService();
        this.caseService = this.engineRule.getCaseService();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricDataCreatedForProcessExecution() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(1, 2010);
        calendar.set(2, 8);
        calendar.set(5, 30);
        calendar.set(11, 12);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date noon = calendar.getTime();
        ClockUtil.setCurrentTime((Date)noon);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "myBusinessKey");
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().unfinished().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finished().count());
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)historicProcessInstance);
        Assert.assertEquals((Object)processInstance.getId(), (Object)historicProcessInstance.getId());
        Assert.assertEquals((Object)processInstance.getBusinessKey(), (Object)historicProcessInstance.getBusinessKey());
        Assert.assertEquals((Object)processInstance.getProcessDefinitionId(), (Object)historicProcessInstance.getProcessDefinitionId());
        Assert.assertEquals((Object)noon, (Object)historicProcessInstance.getStartTime());
        Assert.assertNull((Object)historicProcessInstance.getEndTime());
        Assert.assertNull((Object)historicProcessInstance.getDurationInMillis());
        Assert.assertNull((Object)historicProcessInstance.getCaseInstanceId());
        List tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Date twentyFiveSecsAfterNoon = new Date(noon.getTime() + 25000L);
        ClockUtil.setCurrentTime((Date)twentyFiveSecsAfterNoon);
        this.taskService.complete(((Task)tasks.get(0)).getId());
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)historicProcessInstance);
        Assert.assertEquals((Object)processInstance.getId(), (Object)historicProcessInstance.getId());
        Assert.assertEquals((Object)processInstance.getProcessDefinitionId(), (Object)historicProcessInstance.getProcessDefinitionId());
        Assert.assertEquals((Object)noon, (Object)historicProcessInstance.getStartTime());
        Assert.assertEquals((Object)twentyFiveSecsAfterNoon, (Object)historicProcessInstance.getEndTime());
        Assert.assertEquals((Object)25000L, (Object)historicProcessInstance.getDurationInMillis());
        Assert.assertTrue((((HistoricProcessInstanceEventEntity)historicProcessInstance).getDurationRaw() >= 25000L ? 1 : 0) != 0);
        Assert.assertNull((Object)historicProcessInstance.getCaseInstanceId());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().unfinished().count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finished().count());
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "myBusinessKey");
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finished().count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().unfinished().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finished().unfinished().count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testLongRunningHistoricDataCreatedForProcessExecution() {
        long ONE_YEAR = 1471228928L;
        Calendar cal = Calendar.getInstance();
        cal.set(13, 0);
        cal.set(14, 0);
        Date now = cal.getTime();
        ClockUtil.setCurrentTime((Date)now);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "myBusinessKey");
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().unfinished().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finished().count());
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertEquals((Object)now, (Object)historicProcessInstance.getStartTime());
        List tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        cal.add(1, 1);
        Date oneYearLater = cal.getTime();
        ClockUtil.setCurrentTime((Date)oneYearLater);
        this.taskService.complete(((Task)tasks.get(0)).getId());
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertEquals((Object)now, (Object)historicProcessInstance.getStartTime());
        Assert.assertEquals((Object)oneYearLater, (Object)historicProcessInstance.getEndTime());
        Assert.assertTrue((historicProcessInstance.getDurationInMillis() >= 1471228928L ? 1 : 0) != 0);
        Assert.assertTrue((((HistoricProcessInstanceEventEntity)historicProcessInstance).getDurationRaw() >= 1471228928L ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().unfinished().count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finished().count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testDeleteProcessInstanceHistoryCreated() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Assert.assertNotNull((Object)processInstance);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "cancel");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)historicProcessInstance.getEndTime());
    }

    @Test
    public void testDeleteProcessInstanceWithoutSubprocessInstances() {
        BpmnModelInstance calling = ((CallActivityBuilder)Bpmn.createExecutableProcess((String)"calling").startEvent().callActivity().calledElement("called")).endEvent("endA").done();
        BpmnModelInstance called = Bpmn.createExecutableProcess((String)"called").startEvent().userTask("Task1").endEvent().done();
        this.deployment(calling, called);
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("calling");
        String id = instance.getId();
        this.runtimeService.deleteProcessInstance(id, "test_purposes", false, true, false, true);
        List historicSubprocessList = this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("called").list();
        for (HistoricProcessInstance historicProcessInstance : historicSubprocessList) {
            Assert.assertNull((Object)historicProcessInstance.getSuperProcessInstanceId());
        }
    }

    @Test
    public void testDeleteProcessInstanceWithSubprocessInstances() {
        BpmnModelInstance calling = ((CallActivityBuilder)Bpmn.createExecutableProcess((String)"calling").startEvent().callActivity().calledElement("called")).endEvent("endA").done();
        BpmnModelInstance called = Bpmn.createExecutableProcess((String)"called").startEvent().userTask("Task1").endEvent().done();
        this.deployment(calling, called);
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("calling");
        String id = instance.getId();
        this.runtimeService.deleteProcessInstance(id, "test_purposes", false, true, false, false);
        List historicSubprocessList = this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("called").list();
        for (HistoricProcessInstance historicProcessInstance : historicSubprocessList) {
            Assert.assertNotNull((Object)historicProcessInstance.getSuperProcessInstanceId());
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceStartDate() {
        ClockUtil.setCurrentTime((Date)new Date());
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Date date = ClockUtil.getCurrentTime();
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().startDateOn(date).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().startDateBy(date).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().startDateBy(DateUtils.addDays((Date)date, (int)-1)).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().startDateBy(DateUtils.addDays((Date)date, (int)1)).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().startDateOn(DateUtils.addDays((Date)date, (int)-1)).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().startDateOn(DateUtils.addDays((Date)date, (int)1)).count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceFinishDateUnfinished() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Date date = new Date();
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateOn(date).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateBy(date).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateBy(DateUtils.addDays((Date)date, (int)1)).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateBy(DateUtils.addDays((Date)date, (int)-1)).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateOn(DateUtils.addDays((Date)date, (int)-1)).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateOn(DateUtils.addDays((Date)date, (int)1)).count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceFinishDateFinished() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Date date = new Date();
        this.runtimeService.deleteProcessInstance(pi.getId(), "cancel");
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateOn(date).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateBy(date).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateBy(DateUtils.addDays((Date)date, (int)1)).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateBy(DateUtils.addDays((Date)date, (int)-1)).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateOn(DateUtils.addDays((Date)date, (int)-1)).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishDateOn(DateUtils.addDays((Date)date, (int)1)).count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceDelete() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.deleteProcessInstance(pi.getId(), "cancel");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assert.assertNotNull((Object)historicProcessInstance.getDeleteReason());
        Assert.assertEquals((Object)"cancel", (Object)historicProcessInstance.getDeleteReason());
        Assert.assertNotNull((Object)historicProcessInstance.getEndTime());
    }

    @Test
    @Deployment
    public void testHistoricProcessInstanceDeleteAsync() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failing");
        this.runtimeService.deleteProcessInstance(pi.getId(), "cancel");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assert.assertNotNull((Object)historicProcessInstance.getDeleteReason());
        Assert.assertEquals((Object)"cancel", (Object)historicProcessInstance.getDeleteReason());
        Assert.assertNotNull((Object)historicProcessInstance.getEndTime());
    }

    @Test
    @Deployment
    @RequiredHistoryLevel(value="full")
    public void testHistoricProcessInstanceQueryWithIncidents() {
        this.runtimeService.startProcessInstanceByKey("Process_1");
        this.testHelper.executeAvailableJobs();
        this.runtimeService.startProcessInstanceByKey("Process_1");
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricProcessInstanceQuery().count());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricProcessInstanceQuery().list().size());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().withIncidents().count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().withIncidents().list().size());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentMessageLike("Unknown property used%\\_Tr%").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentMessageLike("Unknown property used%\\_Tr%").list().size());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentMessageLike("Unknown message%").count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentMessageLike("Unknown message%").list().size());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentMessage("Unknown property used in expression: ${incidentTrigger1}. Cause: Cannot resolve identifier 'incidentTrigger1'").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentMessage("Unknown property used in expression: ${incidentTrigger1}. Cause: Cannot resolve identifier 'incidentTrigger1'").list().size());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentMessage("Unknown property used in expression: ${incident_Trigger2}. Cause: Cannot resolve identifier 'incident_Trigger2'").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentMessage("Unknown property used in expression: ${incident_Trigger2}. Cause: Cannot resolve identifier 'incident_Trigger2'").list().size());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentMessage("Unknown message").count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentMessage("Unknown message").list().size());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentType("failedJob").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentType("failedJob").list().size());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().withRootIncidents().count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().withRootIncidents().list().size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/IncidentTest.testShouldDeleteIncidentAfterJobWasSuccessfully.bpmn"})
    @RequiredHistoryLevel(value="full")
    public void testHistoricProcessInstanceQueryIncidentStatusOpen() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        this.runtimeService.startProcessInstanceByKey("failingProcessWithUserTask", parameters);
        this.testHelper.executeAvailableJobs();
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentStatus("open").count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/IncidentTest.testShouldDeleteIncidentAfterJobWasSuccessfully.bpmn"})
    @RequiredHistoryLevel(value="full")
    public void testHistoricProcessInstanceQueryIncidentStatusResolved() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        ProcessInstance pi1 = this.runtimeService.startProcessInstanceByKey("failingProcessWithUserTask", parameters);
        this.testHelper.executeAvailableJobs();
        this.runtimeService.setVariable(pi1.getId(), "fail", (Object)false);
        Job jobToResolve = (Job)this.managementService.createJobQuery().processInstanceId(pi1.getId()).singleResult();
        this.managementService.setJobRetries(jobToResolve.getId(), 1);
        this.testHelper.executeAvailableJobs();
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentStatus("resolved").count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/IncidentTest.testShouldDeleteIncidentAfterJobWasSuccessfully.bpmn"})
    @RequiredHistoryLevel(value="full")
    public void testHistoricProcessInstanceQueryIncidentStatusOpenWithTwoProcesses() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        ProcessInstance pi1 = this.runtimeService.startProcessInstanceByKey("failingProcessWithUserTask", parameters);
        this.runtimeService.startProcessInstanceByKey("failingProcessWithUserTask", parameters);
        this.testHelper.executeAvailableJobs();
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentStatus("open").count());
        this.runtimeService.setVariable(pi1.getId(), "fail", (Object)false);
        Job jobToResolve = (Job)this.managementService.createJobQuery().processInstanceId(pi1.getId()).singleResult();
        this.managementService.setJobRetries(jobToResolve.getId(), 1);
        this.testHelper.executeAvailableJobs();
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentStatus("open").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentStatus("resolved").count());
    }

    @Test
    public void testHistoricProcessInstanceQueryWithIncidentMessageNull() {
        try {
            this.historyService.createHistoricProcessInstanceQuery().incidentMessage(null).count();
            Assert.fail((String)"incidentMessage with null value is not allowed");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void testHistoricProcessInstanceQueryWithIncidentMessageLikeNull() {
        try {
            this.historyService.createHistoricProcessInstanceQuery().incidentMessageLike(null).count();
            Assert.fail((String)"incidentMessageLike with null value is not allowed");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/history/testInstancesWithJobsRetrying.bpmn20.xml"})
    public void testHistoricProcessInstanceQueryWithJobsRetrying() {
        HistoricProcessInstanceQuery queryWithJobsRetrying = this.historyService.createHistoricProcessInstanceQuery().withJobsRetrying();
        ProcessInstance instanceWithRetryingJob = this.runtimeService.startProcessInstanceByKey("processWithJobsRetrying");
        this.runtimeService.startProcessInstanceByKey("processWithJobsRetrying");
        Assertions.assertThat((long)queryWithJobsRetrying.count()).isZero();
        Assertions.assertThat((List)queryWithJobsRetrying.list()).isEmpty();
        Job suceedingJob = (Job)this.managementService.createJobQuery().processInstanceId(instanceWithRetryingJob.getId()).singleResult();
        this.managementService.executeJob(suceedingJob.getId());
        Job failingJob = (Job)this.managementService.createJobQuery().processInstanceId(instanceWithRetryingJob.getId()).singleResult();
        this.executeFailingJob(failingJob);
        Assertions.assertThat((long)queryWithJobsRetrying.count()).isEqualTo(1L);
        Assertions.assertThat((List)queryWithJobsRetrying.list()).hasSize(1);
        Assertions.assertThat((String)instanceWithRetryingJob.getId()).isEqualTo((Object)((HistoricProcessInstance)queryWithJobsRetrying.singleResult()).getId());
        this.executeFailingJob(failingJob);
        this.executeFailingJob(failingJob);
        Assertions.assertThat((long)queryWithJobsRetrying.count()).isZero();
        Assertions.assertThat((List)queryWithJobsRetrying.list()).isEmpty();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneAsyncTaskProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceQuery() {
        Calendar startTime = Calendar.getInstance();
        ClockUtil.setCurrentTime((Date)startTime.getTime());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "businessKey_123");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        Calendar hourAgo = Calendar.getInstance();
        hourAgo.add(11, -1);
        Calendar hourFromNow = Calendar.getInstance();
        hourFromNow.add(11, 1);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedBefore(hourAgo.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedBefore(hourFromNow.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedAfter(hourAgo.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedAfter(hourFromNow.getTime()).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().startedBefore(hourFromNow.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().startedBefore(hourAgo.getTime()).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().startedAfter(hourAgo.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().startedAfter(hourFromNow.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().startedAfter(hourFromNow.getTime()).startedBefore(hourAgo.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finished().count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionId(processInstance.getProcessDefinitionId()).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey("businessKey_123").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKeyLike("business%").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKeyLike("%sinessKey\\_123").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKeyLike("%siness%").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionName("The One Task_Process").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionNameLike("The One Task%").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionNameLike("%One Task\\_Process").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionNameLike("%One Task%").count());
        ArrayList<String> exludeIds = new ArrayList<String>();
        exludeIds.add("unexistingProcessDefinition");
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKeyNotIn(exludeIds).count());
        exludeIds.add("oneTaskProcess");
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("oneTaskProcess").processDefinitionKeyNotIn(exludeIds).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKeyNotIn(exludeIds).count());
        try {
            this.historyService.createHistoricProcessInstanceQuery().processDefinitionKeyNotIn(Arrays.asList(""));
            Assert.fail((String)"Exception expected");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
        this.taskService.complete(((Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult()).getId());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finished().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedBefore(hourAgo.getTime()).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedBefore(hourFromNow.getTime()).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedAfter(hourAgo.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedAfter(hourFromNow.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().finishedAfter(hourFromNow.getTime()).finishedBefore(hourAgo.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().withIncidents().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentMessageLike("Unknown property used%").count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().incidentMessage("Unknown property used in expression: #{failing}. Cause: Cannot resolve identifier 'failing'").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().executedActivityAfter(hourAgo.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().executedActivityBefore(hourAgo.getTime()).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().executedActivityBefore(hourFromNow.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().executedActivityAfter(hourFromNow.getTime()).count());
        if (this.engineRule.getProcessEngineConfiguration().getHistoryLevel().equals(HistoryLevel.HISTORY_LEVEL_FULL)) {
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().executedJobAfter(hourAgo.getTime()).count());
            Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().executedActivityBefore(hourAgo.getTime()).count());
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().executedActivityBefore(hourFromNow.getTime()).count());
            Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().executedActivityAfter(hourFromNow.getTime()).count());
        }
    }

    @Test
    public void testHistoricProcessInstanceSorting() {
        this.deployment("org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml");
        this.deployment("org/camunda/bpm/engine/test/history/HistoricActivityInstanceTest.testSorting.bpmn20.xml");
        this.deployment("org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml");
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("oneTaskProcess").list();
        for (ProcessDefinition processDefinition : processDefinitions) {
            this.runtimeService.startProcessInstanceById(processDefinition.getId());
        }
        this.runtimeService.startProcessInstanceByKey("process");
        List processInstances = ((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceId().asc()).list();
        Assert.assertEquals((long)3L, (long)processInstances.size());
        TestOrderingUtil.verifySorting(processInstances, TestOrderingUtil.historicProcessInstanceByProcessInstanceId());
        Assert.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceStartTime().asc()).list().size());
        Assert.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceEndTime().asc()).list().size());
        Assert.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceDuration().asc()).list().size());
        processInstances = ((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessDefinitionId().asc()).list();
        Assert.assertEquals((long)3L, (long)processInstances.size());
        TestOrderingUtil.verifySorting(processInstances, TestOrderingUtil.historicProcessInstanceByProcessDefinitionId());
        processInstances = ((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessDefinitionKey().asc()).list();
        Assert.assertEquals((long)3L, (long)processInstances.size());
        TestOrderingUtil.verifySorting(processInstances, TestOrderingUtil.historicProcessInstanceByProcessDefinitionKey());
        processInstances = ((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessDefinitionName().asc()).list();
        Assert.assertEquals((long)3L, (long)processInstances.size());
        TestOrderingUtil.verifySorting(processInstances, TestOrderingUtil.historicProcessInstanceByProcessDefinitionName());
        processInstances = ((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessDefinitionVersion().asc()).list();
        Assert.assertEquals((long)3L, (long)processInstances.size());
        TestOrderingUtil.verifySorting(processInstances, TestOrderingUtil.historicProcessInstanceByProcessDefinitionVersion());
        Assert.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceBusinessKey().asc()).list().size());
        Assert.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceId().desc()).list().size());
        Assert.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceStartTime().desc()).list().size());
        Assert.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceEndTime().desc()).list().size());
        Assert.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceDuration().desc()).list().size());
        Assert.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessDefinitionId().desc()).list().size());
        Assert.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceBusinessKey().desc()).list().size());
        Assert.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceId().asc()).count());
        Assert.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceStartTime().asc()).count());
        Assert.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceEndTime().asc()).count());
        Assert.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceDuration().asc()).count());
        Assert.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessDefinitionId().asc()).count());
        Assert.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceBusinessKey().asc()).count());
        Assert.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceId().desc()).count());
        Assert.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceStartTime().desc()).count());
        Assert.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceEndTime().desc()).count());
        Assert.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceDuration().desc()).count());
        Assert.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessDefinitionId().desc()).count());
        Assert.assertEquals((long)3L, (long)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceBusinessKey().desc()).count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceSubProcess() {
        ProcessInstance superPi = this.runtimeService.startProcessInstanceByKey("subProcessQueryTest");
        ProcessInstance subPi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(superPi.getProcessInstanceId()).singleResult();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().subProcessInstanceId(subPi.getProcessInstanceId()).singleResult();
        Assert.assertNotNull((Object)historicProcessInstance);
        Assert.assertEquals((Object)historicProcessInstance.getId(), (Object)superPi.getId());
    }

    @Test
    public void testInvalidSorting() {
        try {
            this.historyService.createHistoricProcessInstanceQuery().asc();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricProcessInstanceQuery().desc();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceId().list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testDeleteReason() {
        if (!"none".equals(this.engineRule.getProcessEngineConfiguration().getHistory())) {
            String deleteReason = "some delete reason";
            ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
            this.runtimeService.deleteProcessInstance(pi.getId(), "some delete reason");
            HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(pi.getId()).singleResult();
            Assert.assertEquals((Object)"some delete reason", (Object)hpi.getDeleteReason());
        }
    }

    @Test
    @Deployment
    public void testLongProcessDefinitionKey() {
        String PROCESS_DEFINITION_KEY = "myrealrealrealrealrealrealrealrealrealrealreallongprocessdefinitionkeyawesome";
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("myrealrealrealrealrealrealrealrealrealrealreallongprocessdefinitionkeyawesome").singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)hpi);
        this.testHelper.assertProcessEnded(hpi.getId());
        HistoricProcessInstance hpi2 = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("myrealrealrealrealrealrealrealrealrealrealreallongprocessdefinitionkeyawesome").singleResult();
        Assert.assertNotNull((Object)hpi2);
        this.testHelper.assertProcessEnded(hpi2.getId());
        Assert.assertEquals((Object)hpi.getId(), (Object)hpi2.getId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testQueryByCaseInstanceId.cmmn", "org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testQueryByCaseInstanceId.bpmn20.xml"})
    public void testQueryByCaseInstanceId() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        query.caseInstanceId(caseInstanceId);
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)query.list().size());
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)query.singleResult();
        Assert.assertNotNull((Object)historicProcessInstance);
        Assert.assertNull((Object)historicProcessInstance.getEndTime());
        Assert.assertEquals((Object)caseInstanceId, (Object)historicProcessInstance.getCaseInstanceId());
        String taskId = ((Task)this.taskService.createTaskQuery().caseInstanceId(caseInstanceId).singleResult()).getId();
        this.taskService.complete(taskId);
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)query.list().size());
        historicProcessInstance = (HistoricProcessInstance)query.singleResult();
        Assert.assertNotNull((Object)historicProcessInstance);
        Assert.assertNotNull((Object)historicProcessInstance.getEndTime());
        Assert.assertEquals((Object)caseInstanceId, (Object)historicProcessInstance.getCaseInstanceId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testQueryByCaseInstanceId.cmmn", "org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testQueryByCaseInstanceIdHierarchy-super.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testQueryByCaseInstanceIdHierarchy-sub.bpmn20.xml"})
    public void testQueryByCaseInstanceIdHierarchy() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        query.caseInstanceId(caseInstanceId);
        Assert.assertEquals((long)2L, (long)query.count());
        Assert.assertEquals((long)2L, (long)query.list().size());
        for (HistoricProcessInstance hpi : query.list()) {
            Assert.assertEquals((Object)caseInstanceId, (Object)hpi.getCaseInstanceId());
        }
        String taskId = ((Task)this.taskService.createTaskQuery().caseInstanceId(caseInstanceId).singleResult()).getId();
        this.taskService.complete(taskId);
        Assert.assertEquals((long)2L, (long)query.count());
        Assert.assertEquals((long)2L, (long)query.list().size());
        for (HistoricProcessInstance hpi : query.list()) {
            Assert.assertEquals((Object)caseInstanceId, (Object)hpi.getCaseInstanceId());
        }
    }

    @Test
    public void testQueryByInvalidCaseInstanceId() {
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        query.caseInstanceId("invalid");
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
        query.caseInstanceId(null);
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testBusinessKey.cmmn", "org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testBusinessKey.bpmn20.xml"})
    public void testBusinessKey() {
        String businessKey = "aBusinessKey";
        this.caseService.withCaseDefinitionByKey("case").businessKey(businessKey).create().getId();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        query.processInstanceBusinessKey(businessKey);
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)query.list().size());
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)query.singleResult();
        Assert.assertNotNull((Object)historicProcessInstance);
        Assert.assertEquals((Object)businessKey, (Object)historicProcessInstance.getBusinessKey());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testStartActivityId-super.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testStartActivityId-sub.bpmn20.xml"})
    public void testStartActivityId() {
        this.runtimeService.startProcessInstanceByKey("super");
        HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("sub").singleResult();
        Assert.assertEquals((Object)"theSubStart", (Object)hpi.getStartActivityId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testStartActivityId-super.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testAsyncStartActivityId-sub.bpmn20.xml"})
    public void testAsyncStartActivityId() {
        this.runtimeService.startProcessInstanceByKey("super");
        this.testHelper.executeAvailableJobs();
        HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("sub").singleResult();
        Assert.assertEquals((Object)"theSubStart", (Object)hpi.getStartActivityId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testStartByKeyWithCaseInstanceId() {
        String caseInstanceId = "aCaseInstanceId";
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", null, caseInstanceId).getId();
        HistoricProcessInstance firstInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        Assert.assertNotNull((Object)firstInstance);
        Assert.assertEquals((Object)caseInstanceId, (Object)firstInstance.getCaseInstanceId());
        processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", null, caseInstanceId, null).getId();
        HistoricProcessInstance secondInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        Assert.assertNotNull((Object)secondInstance);
        Assert.assertEquals((Object)caseInstanceId, (Object)secondInstance.getCaseInstanceId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testStartByIdWithCaseInstanceId() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("oneTaskProcess").singleResult()).getId();
        String caseInstanceId = "aCaseInstanceId";
        String processInstanceId = this.runtimeService.startProcessInstanceById(processDefinitionId, null, caseInstanceId).getId();
        HistoricProcessInstance firstInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        Assert.assertNotNull((Object)firstInstance);
        Assert.assertEquals((Object)caseInstanceId, (Object)firstInstance.getCaseInstanceId());
        processInstanceId = this.runtimeService.startProcessInstanceById(processDefinitionId, null, caseInstanceId, null).getId();
        HistoricProcessInstance secondInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        Assert.assertNotNull((Object)secondInstance);
        Assert.assertEquals((Object)caseInstanceId, (Object)secondInstance.getCaseInstanceId());
    }

    @Test
    @Deployment
    public void testEndTimeAndEndActivity() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        String taskId = ((Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask2").singleResult()).getId();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.taskService.complete(taskId);
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)query.singleResult();
        Assert.assertNull((Object)historicProcessInstance.getEndActivityId());
        Assert.assertNull((Object)historicProcessInstance.getEndTime());
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        historicProcessInstance = (HistoricProcessInstance)query.singleResult();
        Assert.assertNull((Object)historicProcessInstance.getEndActivityId());
        Assert.assertNotNull((Object)historicProcessInstance.getEndTime());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryBySuperCaseInstanceId() {
        String superCaseInstanceId = this.caseService.createCaseInstanceByKey("oneProcessTaskCase").getId();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().superCaseInstanceId(superCaseInstanceId);
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
        HistoricProcessInstance subProcessInstance = (HistoricProcessInstance)query.singleResult();
        Assert.assertNotNull((Object)subProcessInstance);
        Assert.assertEquals((Object)superCaseInstanceId, (Object)subProcessInstance.getSuperCaseInstanceId());
        Assert.assertNull((Object)subProcessInstance.getSuperProcessInstanceId());
    }

    @Test
    public void testQueryByInvalidSuperCaseInstanceId() {
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        query.superCaseInstanceId("invalid");
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
        query.caseInstanceId(null);
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superProcessWithCaseCallActivity.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryBySubCaseInstanceId() {
        String superProcessInstanceId = this.runtimeService.startProcessInstanceByKey("subProcessQueryTest").getId();
        String subCaseInstanceId = ((CaseInstance)this.caseService.createCaseInstanceQuery().superProcessInstanceId(superProcessInstanceId).singleResult()).getId();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().subCaseInstanceId(subCaseInstanceId);
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
        HistoricProcessInstance superProcessInstance = (HistoricProcessInstance)query.singleResult();
        Assert.assertNotNull((Object)superProcessInstance);
        Assert.assertEquals((Object)superProcessInstanceId, (Object)superProcessInstance.getId());
        Assert.assertNull((Object)superProcessInstance.getSuperCaseInstanceId());
        Assert.assertNull((Object)superProcessInstance.getSuperProcessInstanceId());
    }

    @Test
    public void testQueryByInvalidSubCaseInstanceId() {
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        query.subCaseInstanceId("invalid");
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
        query.caseInstanceId(null);
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testSuperCaseInstanceIdProperty() {
        String superCaseInstanceId = this.caseService.createCaseInstanceByKey("oneProcessTaskCase").getId();
        ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_ProcessTask_1").singleResult()).getId();
        HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((Object)superCaseInstanceId, (Object)instance.getSuperCaseInstanceId());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((Object)superCaseInstanceId, (Object)instance.getSuperCaseInstanceId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessDefinitionKeyProperty() {
        String key = "oneTaskProcess";
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(key).getId();
        HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        Assert.assertNotNull((Object)instance.getProcessDefinitionKey());
        Assert.assertEquals((Object)key, (Object)instance.getProcessDefinitionKey());
    }

    @Test
    @Deployment
    public void testProcessInstanceShouldBeActive() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        Assert.assertNull((Object)historicProcessInstance.getEndTime());
        Assert.assertNull((Object)historicProcessInstance.getDurationInMillis());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testRetrieveProcessDefinitionName() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        Assert.assertEquals((Object)"The One Task Process", (Object)historicProcessInstance.getProcessDefinitionName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testRetrieveProcessDefinitionVersion() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        Assert.assertEquals((long)1L, (long)historicProcessInstance.getProcessDefinitionVersion().intValue());
    }

    @Test
    public void testHistoricProcInstExecutedActivityInInterval() {
        Calendar now = Calendar.getInstance();
        ClockUtil.setCurrentTime((Date)now.getTime());
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)"proc").startEvent().userTask().endEvent().done();
        this.deployment(model);
        Calendar hourFromNow = (Calendar)now.clone();
        hourFromNow.add(11, 1);
        this.runtimeService.startProcessInstanceByKey("proc");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().executedActivityAfter(now.getTime()).executedActivityBefore(hourFromNow.getTime()).singleResult();
        Assert.assertNotNull((Object)historicProcessInstance);
        Calendar sixHoursFromNow = (Calendar)now.clone();
        sixHoursFromNow.add(11, 6);
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().executedActivityAfter(hourFromNow.getTime()).executedActivityBefore(sixHoursFromNow.getTime()).singleResult();
        Assert.assertNull((Object)historicProcessInstance);
    }

    @Test
    public void testHistoricProcInstExecutedActivityAfter() {
        Calendar now = Calendar.getInstance();
        ClockUtil.setCurrentTime((Date)now.getTime());
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)"proc").startEvent().endEvent().done();
        this.deployment(model);
        Calendar hourFromNow = (Calendar)now.clone();
        hourFromNow.add(11, 1);
        this.runtimeService.startProcessInstanceByKey("proc");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().executedActivityAfter(now.getTime()).singleResult();
        Assert.assertNotNull((Object)historicProcessInstance);
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().executedActivityAfter(hourFromNow.getTime()).singleResult();
        Assert.assertNull((Object)historicProcessInstance);
    }

    @Test
    public void testHistoricProcInstExecutedActivityBefore() {
        Calendar now = Calendar.getInstance();
        ClockUtil.setCurrentTime((Date)now.getTime());
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)"proc").startEvent().endEvent().done();
        this.deployment(model);
        Calendar hourBeforeNow = (Calendar)now.clone();
        hourBeforeNow.add(10, -1);
        this.runtimeService.startProcessInstanceByKey("proc");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().executedActivityBefore(now.getTime()).singleResult();
        Assert.assertNotNull((Object)historicProcessInstance);
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().executedActivityBefore(hourBeforeNow.getTime()).singleResult();
        Assert.assertNull((Object)historicProcessInstance);
    }

    @Test
    public void testHistoricProcInstExecutedActivityWithTwoProcInsts() {
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)"proc").startEvent().endEvent().done();
        this.deployment(model);
        Calendar now = Calendar.getInstance();
        Calendar hourBeforeNow = (Calendar)now.clone();
        hourBeforeNow.add(10, -1);
        ClockUtil.setCurrentTime((Date)hourBeforeNow.getTime());
        this.runtimeService.startProcessInstanceByKey("proc");
        ClockUtil.setCurrentTime((Date)now.getTime());
        this.runtimeService.startProcessInstanceByKey("proc");
        List list = this.historyService.createHistoricProcessInstanceQuery().executedActivityAfter(hourBeforeNow.getTime()).executedActivityBefore(now.getTime()).list();
        Assert.assertEquals((long)2L, (long)list.size());
        Calendar halfHour = (Calendar)now.clone();
        halfHour.add(12, -30);
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().executedActivityAfter(halfHour.getTime()).singleResult();
        Assert.assertNotNull((Object)historicProcessInstance);
    }

    @Test
    public void testHistoricProcInstExecutedActivityWithEmptyInterval() {
        Calendar now = Calendar.getInstance();
        ClockUtil.setCurrentTime((Date)now.getTime());
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)"proc").startEvent().endEvent().done();
        this.deployment(model);
        Calendar hourBeforeNow = (Calendar)now.clone();
        hourBeforeNow.add(10, -1);
        this.runtimeService.startProcessInstanceByKey("proc");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().executedActivityBefore(hourBeforeNow.getTime()).executedActivityAfter(hourBeforeNow.getTime()).singleResult();
        Assert.assertNull((Object)historicProcessInstance);
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testHistoricProcInstExecutedJobAfter() {
        BpmnModelInstance asyncModel = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"async").startEvent().camundaAsyncBefore()).endEvent().done();
        this.deployment(asyncModel);
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)"proc").startEvent().endEvent().done();
        this.deployment(model);
        Calendar now = Calendar.getInstance();
        ClockUtil.setCurrentTime((Date)now.getTime());
        Calendar hourFromNow = (Calendar)now.clone();
        hourFromNow.add(11, 1);
        this.runtimeService.startProcessInstanceByKey("async");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        this.runtimeService.startProcessInstanceByKey("proc");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().executedJobAfter(now.getTime()).singleResult();
        Assert.assertNotNull((Object)historicProcessInstance);
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().executedJobAfter(hourFromNow.getTime()).singleResult();
        Assert.assertNull((Object)historicProcessInstance);
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testHistoricProcInstExecutedJobBefore() {
        BpmnModelInstance asyncModel = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"async").startEvent().camundaAsyncBefore()).endEvent().done();
        this.deployment(asyncModel);
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)"proc").startEvent().endEvent().done();
        this.deployment(model);
        Calendar now = Calendar.getInstance();
        ClockUtil.setCurrentTime((Date)now.getTime());
        Calendar hourBeforeNow = (Calendar)now.clone();
        hourBeforeNow.add(11, -1);
        this.runtimeService.startProcessInstanceByKey("async");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        this.runtimeService.startProcessInstanceByKey("proc");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().executedJobBefore(now.getTime()).singleResult();
        Assert.assertNotNull((Object)historicProcessInstance);
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().executedJobBefore(hourBeforeNow.getTime()).singleResult();
        Assert.assertNull((Object)historicProcessInstance);
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testHistoricProcInstExecutedJobWithTwoProcInsts() {
        BpmnModelInstance asyncModel = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"async").startEvent().camundaAsyncBefore()).endEvent().done();
        this.deployment(asyncModel);
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)"proc").startEvent().endEvent().done();
        this.deployment(model);
        Calendar now = Calendar.getInstance();
        ClockUtil.setCurrentTime((Date)now.getTime());
        Calendar hourBeforeNow = (Calendar)now.clone();
        hourBeforeNow.add(11, -1);
        ClockUtil.setCurrentTime((Date)hourBeforeNow.getTime());
        this.runtimeService.startProcessInstanceByKey("async");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        ClockUtil.setCurrentTime((Date)now.getTime());
        this.runtimeService.startProcessInstanceByKey("async");
        this.runtimeService.startProcessInstanceByKey("proc");
        List list = this.historyService.createHistoricProcessInstanceQuery().executedJobAfter(hourBeforeNow.getTime()).executedJobBefore(now.getTime()).list();
        Assert.assertEquals((long)2L, (long)list.size());
        Calendar halfHour = (Calendar)now.clone();
        halfHour.add(12, -30);
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().executedJobAfter(halfHour.getTime()).singleResult();
        Assert.assertNotNull((Object)historicProcessInstance);
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testHistoricProcInstExecutedJobWithEmptyInterval() {
        BpmnModelInstance asyncModel = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"async").startEvent().camundaAsyncBefore()).endEvent().done();
        this.deployment(asyncModel);
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)"proc").startEvent().endEvent().done();
        this.deployment(model);
        Calendar now = Calendar.getInstance();
        ClockUtil.setCurrentTime((Date)now.getTime());
        Calendar hourBeforeNow = (Calendar)now.clone();
        hourBeforeNow.add(11, -1);
        this.runtimeService.startProcessInstanceByKey("async");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        this.runtimeService.startProcessInstanceByKey("proc");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().executedJobBefore(hourBeforeNow.getTime()).executedJobAfter(hourBeforeNow.getTime()).singleResult();
        Assert.assertNull((Object)historicProcessInstance);
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testHistoricProcInstQueryWithExecutedActivityIds() {
        this.deployment(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        Task task = (Task)this.taskService.createTaskQuery().active().singleResult();
        this.taskService.complete(task.getId());
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getId()).activityId("userTask1").singleResult();
        Assert.assertNotNull((Object)historicActivityInstance);
        List result = this.historyService.createHistoricProcessInstanceQuery().executedActivityIdIn(new String[]{historicActivityInstance.getActivityId()}).list();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)((HistoricProcessInstance)result.get(0)).getId(), (Object)processInstance.getId());
    }

    @Test
    public void testHistoricProcInstQueryWithExecutedActivityIdsNull() {
        try {
            this.historyService.createHistoricProcessInstanceQuery().executedActivityIdIn((String[])null).list();
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"activity ids is null"});
        }
    }

    @Test
    public void testHistoricProcInstQueryWithExecutedActivityIdsContainNull() {
        try {
            this.historyService.createHistoricProcessInstanceQuery().executedActivityIdIn(new String[]{null, "1"}).list();
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"activity ids contains null"});
        }
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testHistoricProcInstQueryWithActiveActivityIds() {
        this.deployment(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("userTask1").singleResult();
        Assert.assertNotNull((Object)historicActivityInstance);
        List result = this.historyService.createHistoricProcessInstanceQuery().activeActivityIdIn(new String[]{historicActivityInstance.getActivityId()}).list();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)((HistoricProcessInstance)result.get(0)).getId(), (Object)processInstance.getId());
    }

    @Test
    public void shouldFailWhenQueryByNullActivityId() {
        try {
            this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{null});
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"activity ids contains null value"});
        }
    }

    @Test
    public void shouldFailWhenQueryByNullActivityIds() {
        try {
            this.historyService.createHistoricProcessInstanceQuery().activityIdIn((String[])null);
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"activity ids is null"});
        }
    }

    @Test
    public void shouldReturnEmptyWhenQueryByUnknownActivityId() {
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"unknown"});
        Assertions.assertThat((List)query.list()).isEmpty();
    }

    @Test
    public void shouldQueryByLeafActivityId() {
        ProcessDefinition oneTaskDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition gatewaySubProcessDefinition = this.testHelper.deployAndGetDefinition(FORK_JOIN_SUB_PROCESS_MODEL);
        String oneTaskPiOne = this.runtimeService.startProcessInstanceById(oneTaskDefinition.getId()).getId();
        String oneTaskPiTwo = this.runtimeService.startProcessInstanceById(oneTaskDefinition.getId()).getId();
        String gatewaySubProcessPiOne = this.runtimeService.startProcessInstanceById(gatewaySubProcessDefinition.getId()).getId();
        String gatewaySubProcessPiTwo = this.runtimeService.startProcessInstanceById(gatewaySubProcessDefinition.getId()).getId();
        Task task = (Task)this.engineRule.getTaskService().createTaskQuery().processInstanceId(gatewaySubProcessPiTwo).taskName("completeMe").singleResult();
        this.engineRule.getTaskService().complete(task.getId());
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"userTask"});
        Assertions.assertThat((List)query.list()).extracting("id").containsExactlyInAnyOrder(new Object[]{oneTaskPiOne, oneTaskPiTwo});
        query = this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"userTask1", "userTask2"});
        Assertions.assertThat((List)query.list()).extracting("id").containsExactlyInAnyOrder(new Object[]{gatewaySubProcessPiOne, gatewaySubProcessPiTwo});
        query = this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"userTask", "userTask1"});
        Assertions.assertThat((List)query.list()).extracting("id").containsExactlyInAnyOrder(new Object[]{oneTaskPiOne, oneTaskPiTwo, gatewaySubProcessPiOne});
        query = this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"userTask", "userTask1", "userTask2"});
        Assertions.assertThat((List)query.list()).extracting("id").containsExactlyInAnyOrder(new Object[]{oneTaskPiOne, oneTaskPiTwo, gatewaySubProcessPiOne, gatewaySubProcessPiTwo});
        query = this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"join"});
        Assertions.assertThat((List)query.list()).extracting("id").containsExactlyInAnyOrder(new Object[]{gatewaySubProcessPiTwo});
    }

    @Test
    public void shouldReturnEmptyWhenQueryByNonLeafActivityId() {
        ProcessDefinition processDefinition = this.testHelper.deployAndGetDefinition(FORK_JOIN_SUB_PROCESS_MODEL);
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"subProcess", "fork"});
        Assertions.assertThat((List)query.list()).isEmpty();
    }

    @Test
    public void shouldQueryByAsyncBeforeActivityId() {
        ProcessDefinition testProcess = this.testHelper.deployAndGetDefinition(((EndEventBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((SubProcessBuilder)((StartEventBuilder)ProcessModels.newModel().startEvent("start").camundaAsyncBefore()).subProcess("subProcess").camundaAsyncBefore()).embeddedSubProcess().startEvent().serviceTask("task").camundaAsyncBefore()).camundaExpression("${true}")).endEvent().subProcessDone().endEvent("end").camundaAsyncBefore()).done());
        String instanceBeforeStart = this.runtimeService.startProcessInstanceById(testProcess.getId()).getId();
        String instanceBeforeSubProcess = this.runtimeService.startProcessInstanceById(testProcess.getId()).getId();
        this.executeJobForProcessInstance(instanceBeforeSubProcess);
        String instanceBeforeTask = this.runtimeService.startProcessInstanceById(testProcess.getId()).getId();
        this.executeJobForProcessInstance(instanceBeforeTask);
        this.executeJobForProcessInstance(instanceBeforeTask);
        String instanceBeforeEnd = this.runtimeService.startProcessInstanceById(testProcess.getId()).getId();
        this.executeJobForProcessInstance(instanceBeforeEnd);
        this.executeJobForProcessInstance(instanceBeforeEnd);
        this.executeJobForProcessInstance(instanceBeforeEnd);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"start"});
        Assertions.assertThat((Object)((HistoricProcessInstance)query.singleResult())).extracting(new String[]{"id"}).containsExactlyInAnyOrder(new Object[]{instanceBeforeStart});
        query = this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"subProcess"});
        Assertions.assertThat((Object)((HistoricProcessInstance)query.singleResult())).extracting(new String[]{"id"}).containsExactlyInAnyOrder(new Object[]{instanceBeforeSubProcess});
        query = this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"task"});
        Assertions.assertThat((Object)((HistoricProcessInstance)query.singleResult())).extracting(new String[]{"id"}).containsExactlyInAnyOrder(new Object[]{instanceBeforeTask});
        query = this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"end"});
        Assertions.assertThat((Object)((HistoricProcessInstance)query.singleResult())).extracting(new String[]{"id"}).containsExactlyInAnyOrder(new Object[]{instanceBeforeEnd});
    }

    @Test
    public void shouldQueryByAsyncAfterActivityId() {
        ProcessDefinition testProcess = this.testHelper.deployAndGetDefinition(((EndEventBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((SubProcessBuilder)((StartEventBuilder)ProcessModels.newModel().startEvent("start").camundaAsyncAfter()).subProcess("subProcess").camundaAsyncAfter()).embeddedSubProcess().startEvent().serviceTask("task").camundaAsyncAfter()).camundaExpression("${true}")).endEvent().subProcessDone().endEvent("end").camundaAsyncAfter()).done());
        String instanceAfterStart = this.runtimeService.startProcessInstanceById(testProcess.getId()).getId();
        String instanceAfterTask = this.runtimeService.startProcessInstanceById(testProcess.getId()).getId();
        this.executeJobForProcessInstance(instanceAfterTask);
        String instanceAfterSubProcess = this.runtimeService.startProcessInstanceById(testProcess.getId()).getId();
        this.executeJobForProcessInstance(instanceAfterSubProcess);
        this.executeJobForProcessInstance(instanceAfterSubProcess);
        String instanceAfterEnd = this.runtimeService.startProcessInstanceById(testProcess.getId()).getId();
        this.executeJobForProcessInstance(instanceAfterEnd);
        this.executeJobForProcessInstance(instanceAfterEnd);
        this.executeJobForProcessInstance(instanceAfterEnd);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"start"});
        Assertions.assertThat((Object)((HistoricProcessInstance)query.singleResult())).extracting(new String[]{"id"}).containsExactlyInAnyOrder(new Object[]{instanceAfterStart});
        query = this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"task"});
        Assertions.assertThat((Object)((HistoricProcessInstance)query.singleResult())).extracting(new String[]{"id"}).containsExactlyInAnyOrder(new Object[]{instanceAfterTask});
        query = this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"subProcess"});
        Assertions.assertThat((Object)((HistoricProcessInstance)query.singleResult())).extracting(new String[]{"id"}).containsExactlyInAnyOrder(new Object[]{instanceAfterSubProcess});
        query = this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"end"});
        Assertions.assertThat((Object)((HistoricProcessInstance)query.singleResult())).extracting(new String[]{"id"}).containsExactlyInAnyOrder(new Object[]{instanceAfterEnd});
    }

    @Test
    public void shouldReturnEmptyWhenQueryByActivityIdBeforeCompensation() {
        ProcessDefinition testProcess = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        this.runtimeService.startProcessInstanceById(testProcess.getId());
        this.testHelper.completeTask("userTask1");
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"subProcess"});
        Assertions.assertThat((List)query.list()).isEmpty();
    }

    @Test
    public void shouldQueryByActivityIdDuringCompensation() {
        ProcessDefinition testProcess = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(testProcess.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.completeTask("userTask2");
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"subProcess"});
        Assertions.assertThat((Object)((HistoricProcessInstance)query.singleResult())).extracting(new String[]{"id"}).containsExactlyInAnyOrder(new Object[]{processInstance.getId()});
        query = this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"compensationEvent"});
        Assertions.assertThat((Object)((HistoricProcessInstance)query.singleResult())).extracting(new String[]{"id"}).containsExactlyInAnyOrder(new Object[]{processInstance.getId()});
        query = this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"compensationHandler"});
        Assertions.assertThat((Object)((HistoricProcessInstance)query.singleResult())).extracting(new String[]{"id"}).containsExactlyInAnyOrder(new Object[]{processInstance.getId()});
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldQueryWithActivityIdsWithOneId() {
        String USER_TASK_1 = "userTask1";
        this.deployment(ProcessModels.TWO_TASKS_PROCESS);
        this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.startProcessInstanceByKey("Process");
        List tasks = this.taskService.createTaskQuery().list();
        Assertions.assertThat((List)tasks).hasSize(2);
        this.taskService.complete(((Task)tasks.get(0)).getId());
        List result = this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{USER_TASK_1}).list();
        Assertions.assertThat((List)result).extracting("id").containsExactlyInAnyOrder(new Object[]{((Task)tasks.get(1)).getProcessInstanceId()});
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldQueryWithActivityIdsWithMultipleIds() {
        String USER_TASK_1 = "userTask1";
        String USER_TASK_2 = "userTask2";
        this.deployment(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("Process");
        List tasks = this.taskService.createTaskQuery().list();
        Assertions.assertThat((List)tasks).hasSize(2);
        this.taskService.complete(((Task)tasks.get(0)).getId());
        List result = this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{USER_TASK_1, USER_TASK_2}).list();
        Assertions.assertThat((List)result).extracting("id").containsExactlyInAnyOrder(new Object[]{processInstance.getId(), processInstance2.getId()});
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldQueryWithActivityIdsWhenDeletedCompetedInstancesExist() {
        String USER_TASK_1 = "userTask1";
        String USER_TASK_2 = "userTask2";
        this.deployment(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("Process");
        List tasks = this.taskService.createTaskQuery().list();
        Assertions.assertThat((List)tasks).hasSize(2);
        this.taskService.complete(((Task)tasks.get(0)).getId());
        ProcessInstance completedProcessInstance = this.runtimeService.startProcessInstanceByKey("Process");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(completedProcessInstance.getId()).singleResult();
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().processInstanceId(completedProcessInstance.getId()).singleResult();
        this.taskService.complete(task.getId());
        ProcessInstance deletedProcessInstance = this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.deleteProcessInstance(deletedProcessInstance.getId(), "Testing");
        List result = this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{USER_TASK_1, USER_TASK_2}).list();
        Assertions.assertThat((List)result).extracting("id").containsExactlyInAnyOrder(new Object[]{processInstance.getId(), processInstance2.getId()});
    }

    @Test
    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testHistoricProcessInstanceQueryActivityIdInWithIncident.bpmn"})
    public void shouldQueryQueryWithActivityIdsWithFailingActivity() {
        String piOne = this.runtimeService.startProcessInstanceByKey("failingProcess").getId();
        this.testHelper.executeAvailableJobs();
        String piTwo = this.runtimeService.startProcessInstanceByKey("failingProcess").getId();
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricProcessInstanceQuery().count());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricProcessInstanceQuery().list().size());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().withIncidents().count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().withIncidents().list().size());
        List result = this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"serviceTask"}).list();
        Assertions.assertThat((List)result).extracting("id").containsExactlyInAnyOrder(new Object[]{piOne, piTwo});
    }

    @Test
    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/failingSubProcessCreateOneIncident.bpmn20.xml"})
    public void shouldNotRetrieveInstanceWhenQueryByActivityIdInWithFailingSubprocess() {
        this.runtimeService.startProcessInstanceByKey("failingSubProcess");
        this.testHelper.executeAvailableJobs();
        HistoricProcessInstance historicPI = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"subProcess"}).singleResult();
        Assertions.assertThat((Object)historicPI).isNull();
    }

    @Test
    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/failingSubProcessCreateOneIncident.bpmn20.xml"})
    public void shouldQueryByActivityIdInWithFailingSubServiceTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingSubProcess");
        this.testHelper.executeAvailableJobs();
        HistoricProcessInstance historicPI = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"serviceTask"}).singleResult();
        Assertions.assertThat((Object)historicPI).isNotNull();
        Assertions.assertThat((String)historicPI.getId()).isEqualTo((Object)processInstance.getId());
    }

    @Test
    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.subprocess.bpmn20.xml"})
    public void shouldNotReturnInstanceWhenQueryByActivityIdInWithSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subprocess");
        TaskService taskService = this.engineRule.getTaskService();
        Task task = (Task)taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)task);
        taskService.complete(task.getId());
        HistoricProcessInstance historicPI = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"subProcess"}).singleResult();
        Assertions.assertThat((Object)historicPI).isNull();
    }

    @Test
    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.subprocess.bpmn20.xml"})
    public void shouldQueryByActivityIdInWithActivityIdOfSubServiceTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subprocess");
        TaskService taskService = this.engineRule.getTaskService();
        Task task = (Task)taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assertions.assertThat((Object)task).isNotNull();
        taskService.complete(task.getId());
        HistoricProcessInstance historicPI = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"innerTask"}).singleResult();
        Assertions.assertThat((Object)historicPI).isNotNull();
        Assertions.assertThat((String)historicPI.getId()).isEqualTo((Object)processInstance.getId());
    }

    @Test
    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.failingSubprocessWithAsyncBeforeTask.bpmn20.xml"})
    public void shouldQueryByActivityIdInWithMultipleScopeAndIncident() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingSubProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("failingSubProcess");
        TaskService taskService = this.engineRule.getTaskService();
        Task task = (Task)taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        taskService.complete(task.getId());
        this.testHelper.executeAvailableJobs();
        List queryByInnerServiceActivityId = this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"innerServiceTask"}).list();
        List queryBySubProcessActivityId = this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"subProcess"}).list();
        List queryByOuterProcessActivityId = this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"outerTask"}).list();
        List queryByOuterAndInnedActivityId = this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"innerServiceTask", "outerTask"}).list();
        Assertions.assertThat((List)queryByInnerServiceActivityId).extracting("id").containsExactlyInAnyOrder(new Object[]{processInstance.getId()});
        Assertions.assertThat((List)queryBySubProcessActivityId).hasSize(0);
        Assertions.assertThat((List)queryByOuterProcessActivityId).extracting("id").containsExactlyInAnyOrder(new Object[]{processInstance2.getId()});
        Assertions.assertThat((List)queryByOuterAndInnedActivityId).extracting("id").containsExactlyInAnyOrder(new Object[]{processInstance.getId(), processInstance2.getId()});
    }

    @Test
    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.subprocessWithAsyncBeforeTask.bpmn20.xml"})
    public void shouldQueryByActivityIdInWithMultipleScope() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingSubProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("failingSubProcess");
        TaskService taskService = this.engineRule.getTaskService();
        Task task = (Task)taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        taskService.complete(task.getId());
        List queryByInnerServiceActivityId = this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"innerTask"}).list();
        List queryBySubProcessActivityId = this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"subProcess"}).list();
        List queryByOuterProcessActivityId = this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"outerTask"}).list();
        List queryByOuterAndInnedActivityId = this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"innerTask", "outerTask"}).list();
        Assertions.assertThat((List)queryByInnerServiceActivityId).extracting("id").containsExactlyInAnyOrder(new Object[]{processInstance.getId()});
        Assertions.assertThat((List)queryBySubProcessActivityId).hasSize(0);
        Assertions.assertThat((List)queryByOuterProcessActivityId).extracting("id").containsExactlyInAnyOrder(new Object[]{processInstance2.getId()});
        Assertions.assertThat((List)queryByOuterAndInnedActivityId).extracting("id").containsExactlyInAnyOrder(new Object[]{processInstance.getId(), processInstance2.getId()});
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldQueryByActivityIdWhereIncidentOccurred() {
        this.testHelper.deploy(((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("theTask").camundaAsyncBefore()).camundaClass(ChangeVariablesDelegate.class)).serviceTask("theTask2").camundaClass(ChangeVariablesDelegate.class)).serviceTask("theTask3").camundaClass(FailingDelegate.class)).endEvent().done());
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("fail", (Object)true));
        JobEntity job = (JobEntity)this.managementService.createJobQuery().singleResult();
        for (int i = 0; i < 3; ++i) {
            try {
                this.managementService.executeJob(job.getId());
                Assert.fail((String)"Exception expected");
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        HistoricProcessInstance theTask = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"theTask"}).singleResult();
        Assertions.assertThat((Object)theTask).isNotNull();
        HistoricProcessInstance theTask3 = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().activityIdIn(new String[]{"theTask3"}).singleResult();
        Assertions.assertThat((Object)theTask3).isNull();
    }

    @Test
    public void testHistoricProcInstQueryWithActiveActivityIdsNull() {
        try {
            this.historyService.createHistoricProcessInstanceQuery().activeActivityIdIn((String[])null).list();
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"activity ids is null"});
        }
    }

    @Test
    public void testHistoricProcInstQueryWithActiveActivityIdsContainNull() {
        try {
            this.historyService.createHistoricProcessInstanceQuery().activeActivityIdIn(new String[]{null, "1"}).list();
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"activity ids contains null"});
        }
    }

    @Test
    public void testQueryByActiveActivityIdInAndProcessDefinitionKey() {
        this.deployment(ProcessModels.ONE_TASK_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("Process").activeActivityIdIn(new String[]{"userTask"}).singleResult();
        Assert.assertNotNull((Object)historicProcessInstance);
        Assert.assertEquals((Object)processInstance.getId(), (Object)historicProcessInstance.getId());
    }

    @Test
    public void testQueryByExecutedActivityIdInAndProcessDefinitionKey() {
        this.deployment(ProcessModels.ONE_TASK_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("Process").executedActivityIdIn(new String[]{"userTask"}).singleResult();
        Assert.assertNotNull((Object)historicProcessInstance);
        Assert.assertEquals((Object)processInstance.getId(), (Object)historicProcessInstance.getId());
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testQueryWithRootIncidents() {
        this.deployment("org/camunda/bpm/engine/test/history/HistoricProcessInstanceTest.testQueryWithRootIncidents.bpmn20.xml");
        this.deployment(CallActivityModels.oneBpmnCallActivityProcess("Process_1"));
        this.runtimeService.startProcessInstanceByKey("Process");
        ProcessInstance calledProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("Process_1").singleResult();
        this.testHelper.executeAvailableJobs();
        List historicProcInstances = this.historyService.createHistoricProcessInstanceQuery().withRootIncidents().list();
        Assert.assertNotNull((Object)calledProcessInstance);
        Assert.assertEquals((long)1L, (long)historicProcInstances.size());
        Assert.assertEquals((Object)calledProcessInstance.getId(), (Object)((HistoricProcessInstance)historicProcInstances.get(0)).getId());
    }

    @Test
    public void testQueryWithProcessDefinitionKeyIn() {
        this.deployment(ProcessModels.ONE_TASK_PROCESS);
        this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.startProcessInstanceByKey("Process");
        this.deployment(ModifiableBpmnModelInstance.modify(ProcessModels.TWO_TASKS_PROCESS).changeElementId("Process", "ONE_TASKS_PROCESS"));
        this.runtimeService.startProcessInstanceByKey("ONE_TASKS_PROCESS");
        this.runtimeService.startProcessInstanceByKey("ONE_TASKS_PROCESS");
        this.deployment(ModifiableBpmnModelInstance.modify(ProcessModels.TWO_TASKS_PROCESS).changeElementId("Process", "TWO_TASKS_PROCESS"));
        this.runtimeService.startProcessInstanceByKey("TWO_TASKS_PROCESS");
        this.runtimeService.startProcessInstanceByKey("TWO_TASKS_PROCESS");
        this.runtimeService.startProcessInstanceByKey("TWO_TASKS_PROCESS");
        this.runtimeService.startProcessInstanceByKey("TWO_TASKS_PROCESS");
        Assertions.assertThat((long)this.historyService.createHistoricProcessInstanceQuery().count()).isEqualTo(9L);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().processDefinitionKeyIn(new String[]{"ONE_TASKS_PROCESS", "TWO_TASKS_PROCESS"});
        Assertions.assertThat((long)query.count()).isEqualTo(6L);
        Assertions.assertThat((int)query.list().size()).isEqualTo(6);
    }

    @Test
    public void testQueryByNonExistingProcessDefinitionKeyIn() {
        this.deployment(ProcessModels.ONE_TASK_PROCESS);
        this.runtimeService.startProcessInstanceByKey("Process");
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().processDefinitionKeyIn(new String[]{"not-existing-key"});
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
        Assertions.assertThat((int)query.list().size()).isEqualTo(0);
    }

    @Test
    public void testQueryByOneInvalidProcessDefinitionKeyIn() {
        try {
            this.historyService.createHistoricProcessInstanceQuery().processDefinitionKeyIn(new String[]{null});
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByMultipleInvalidProcessDefinitionKeyIn() {
        try {
            this.historyService.createHistoricProcessInstanceQuery().processDefinitionKeyIn(new String[]{"Process", null});
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/failingProcessCreateOneIncident.bpmn20.xml"})
    public void shouldQueryProcessInstancesWithIncidentIdIn() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.runtimeService.startProcessInstanceByKey("failingProcess");
        List<String> queriedProcessInstances = Arrays.asList(processInstance.getId(), processInstance2.getId());
        this.testHelper.executeAvailableJobs();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(queriedProcessInstances.get(0)).singleResult();
        Incident incident2 = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(queriedProcessInstances.get(1)).singleResult();
        List processInstanceList = this.historyService.createHistoricProcessInstanceQuery().incidentIdIn(new String[]{incident.getId(), incident2.getId()}).list();
        Assert.assertEquals((long)2L, (long)processInstanceList.size());
        Assertions.assertThat(queriedProcessInstances).containsExactlyInAnyOrderElementsOf((Iterable)processInstanceList.stream().map(HistoricProcessInstance::getId).collect(Collectors.toList()));
    }

    @Test
    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/failingProcessAfterUserTaskCreateOneIncident.bpmn20.xml"})
    public void shouldOnlyQueryProcessInstancesWithIncidentIdIn() {
        ProcessInstance processWithIncident1 = this.runtimeService.startProcessInstanceByKey("failingProcess");
        ProcessInstance processWithIncident2 = this.runtimeService.startProcessInstanceByKey("failingProcess");
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        ProcessInstance processWithoutIncident = this.runtimeService.startProcessInstanceByKey("failingProcess");
        List<String> queriedProcessInstances = Arrays.asList(processWithIncident1.getId(), processWithIncident2.getId());
        this.testHelper.executeAvailableJobs();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(queriedProcessInstances.get(0)).singleResult();
        Incident incident2 = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(queriedProcessInstances.get(1)).singleResult();
        List processInstanceList = this.historyService.createHistoricProcessInstanceQuery().incidentIdIn(new String[]{incident.getId(), incident2.getId()}).list();
        Assert.assertEquals((long)2L, (long)processInstanceList.size());
        Assertions.assertThat(queriedProcessInstances).containsExactlyInAnyOrderElementsOf((Iterable)processInstanceList.stream().map(HistoricProcessInstance::getId).collect(Collectors.toList()));
    }

    @Test
    public void shouldFailWhenQueryWithNullIncidentIdIn() {
        try {
            this.historyService.createHistoricProcessInstanceQuery().incidentIdIn(null).list();
            Assert.fail((String)"incidentMessage with null value is not allowed");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/failingSubProcessCreateOneIncident.bpmn20.xml"})
    public void shouldQueryByIncidentIdInSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingSubProcess");
        this.testHelper.executeAvailableJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        Assert.assertEquals((long)1L, (long)incidentList.size());
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        HistoricProcessInstance historicPI = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().incidentIdIn(new String[]{incident.getId()}).singleResult();
        Assertions.assertThat((Object)historicPI).isNotNull();
        Assertions.assertThat((String)historicPI.getId()).isEqualTo((Object)processInstance.getId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneAsyncTaskProcess.bpmn20.xml"})
    public void testShouldStoreHistoricProcessInstanceVariableOnAsyncBefore() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("foo", (Object)"bar"));
        HistoricVariableInstance historicVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("foo").singleResult();
        Assert.assertNotNull((Object)historicVariable);
        Assert.assertEquals((Object)"bar", (Object)historicVariable.getValue());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneAsyncTaskProcess.bpmn20.xml"})
    public void testShouldStoreInitialHistoricProcessInstanceVariableOnAsyncBefore() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("foo", (Object)"bar"));
        this.runtimeService.setVariable(processInstance.getId(), "goo", (Object)"car");
        this.executeJob((Job)this.managementService.createJobQuery().singleResult());
        HistoricVariableInstance historicVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("foo").singleResult();
        Assert.assertNotNull((Object)historicVariable);
        Assert.assertEquals((Object)"bar", (Object)historicVariable.getValue());
        historicVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("goo").singleResult();
        Assert.assertNotNull((Object)historicVariable);
        Assert.assertEquals((Object)"car", (Object)historicVariable.getValue());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneAsyncTaskProcess.bpmn20.xml"})
    public void testShouldSetVariableBeforeAsyncBefore() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariable(processInstance.getId(), "goo", (Object)"car");
        this.executeJob((Job)this.managementService.createJobQuery().singleResult());
        HistoricVariableInstance historicVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("goo").singleResult();
        Assert.assertNotNull((Object)historicVariable);
        Assert.assertEquals((Object)"car", (Object)historicVariable.getValue());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void shouldQueryByVariableValue_1() {
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.putValue((String)"foo", (Object)"bar").putValue("bar", (Object)"foo")).getProcessInstanceId();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.putValue((String)"foo", (Object)"bar").putValue("bar", (Object)"foo")).getProcessInstanceId();
        List processInstances = this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("foo", (Object)"bar").variableValueEquals("bar", (Object)"foo").list();
        Assertions.assertThat((List)processInstances).extracting("processInstanceId").containsExactlyInAnyOrder(new Object[]{processInstanceIdOne, processInstanceIdTwo});
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void shouldQueryByVariableValue_2() {
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.putValue((String)"foo", (Object)"bar").putValue("bar", (Object)"foo")).getProcessInstanceId();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.putValue((String)"foo", (Object)"bar").putValue("bar", (Object)"foo")).getProcessInstanceId();
        List processInstances = this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("foo", (Object)"bar").variableValueEquals("foo", (Object)"bar").list();
        Assertions.assertThat((List)processInstances).extracting("processInstanceId").containsExactlyInAnyOrder(new Object[]{processInstanceIdOne, processInstanceIdTwo});
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void shouldQueryByVariableValue_3() {
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.putValue((String)"foo", (Object)"bar").putValue("bar", (Object)"foo")).getProcessInstanceId();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.putValue((String)"foo", (Object)"bar").putValue("bar", (Object)"foo")).getProcessInstanceId();
        List processInstances = this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("foo", (Object)"bar").list();
        Assertions.assertThat((List)processInstances).extracting("processInstanceId").containsExactlyInAnyOrder(new Object[]{processInstanceIdOne, processInstanceIdTwo});
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void shouldQueryByVariableValue_4() {
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.putValue((String)"foo", (Object)"bar")).getProcessInstanceId();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.putValue((String)"bar", (Object)"foo")).getProcessInstanceId();
        List processInstances = this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("foo", (Object)"bar").list();
        Assertions.assertThat((List)processInstances).extracting("processInstanceId").containsExactlyInAnyOrder(new Object[]{processInstanceIdOne});
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void shouldQueryByVariableValue_5() {
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.putValue((String)"foo", (Object)"bar")).getProcessInstanceId();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.putValue((String)"bar", (Object)"foo")).getProcessInstanceId();
        List processInstances = this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("foo", (Object)"bar").variableValueEquals("foo", (Object)"bar").list();
        Assertions.assertThat((List)processInstances).extracting("processInstanceId").containsExactlyInAnyOrder(new Object[]{processInstanceIdOne});
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void shouldQueryByVariableValue_6() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.putValue((String)"foo", (Object)"bar"));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.putValue((String)"bar", (Object)"foo"));
        List processInstances = this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("foo", (Object)"bar").variableValueEquals("bar", (Object)"foo").list();
        Assertions.assertThat((List)processInstances).extracting("processInstanceId").containsExactlyInAnyOrder(new Object[0]);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void shouldQueryByVariableValue_7() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.putValue((String)"foo", (Object)"foo"));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.putValue((String)"bar", (Object)"foo"));
        List processInstances = this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("foo", (Object)"bar").variableValueEquals("foo", (Object)"foo").list();
        Assertions.assertThat((List)processInstances).extracting("processInstanceId").containsExactlyInAnyOrder(new Object[0]);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void shouldQueryByVariableValue_8() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.putValue((String)"foo", (Object)"foo"));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.putValue((String)"foo", (Object)"bar"));
        List processInstances = this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("foo", (Object)"bar").variableValueEquals("foo", (Object)"foo").list();
        Assertions.assertThat((List)processInstances).extracting("processInstanceId").containsExactlyInAnyOrder(new Object[0]);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void shouldQueryByVariableValue_9() {
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "a-business-key").getProcessInstanceId();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "another-business-key").getProcessInstanceId();
        List processInstances = this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKeyIn(new String[]{"a-business-key", "another-business-key"}).list();
        Assertions.assertThat((List)processInstances).extracting("processInstanceId").containsExactlyInAnyOrder(new Object[]{processInstanceIdOne, processInstanceIdTwo});
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void shouldQueryByVariableValue_10() {
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "a-business-key").getProcessInstanceId();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getProcessInstanceId();
        List processInstances = this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKeyIn(new String[]{"a-business-key", "another-business-key"}).list();
        Assertions.assertThat((List)processInstances).extracting("processInstanceId").containsExactlyInAnyOrder(new Object[]{processInstanceIdOne});
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void shouldQueryByVariableValue_11() {
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "a-business-key").getProcessInstanceId();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "a-business-key").getProcessInstanceId();
        List processInstances = this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKeyIn(new String[]{"a-business-key"}).list();
        Assertions.assertThat((List)processInstances).extracting("processInstanceId").containsExactlyInAnyOrder(new Object[]{processInstanceIdOne, processInstanceIdTwo});
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void shouldQueryByVariableValue_12() {
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "a-business-key").getProcessInstanceId();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "a-business-key").getProcessInstanceId();
        List processInstances = this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKeyIn(new String[]{"a-business-key", "another-business-key"}).list();
        Assertions.assertThat((List)processInstances).extracting("processInstanceId").containsExactlyInAnyOrder(new Object[]{processInstanceIdOne, processInstanceIdTwo});
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void shouldExcludeByProcessInstanceIdNotIn() {
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getProcessInstanceId();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getProcessInstanceId();
        List processInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        List excludedFirst = this.historyService.createHistoricProcessInstanceQuery().processInstanceIdNotIn(new String[]{processInstanceIdOne}).list();
        List excludedAll = this.historyService.createHistoricProcessInstanceQuery().processInstanceIdNotIn(new String[]{processInstanceIdOne, processInstanceIdTwo}).list();
        Assertions.assertThat((List)processInstances).extracting("processInstanceId").containsExactlyInAnyOrder(new Object[]{processInstanceIdOne, processInstanceIdTwo});
        Assertions.assertThat((List)excludedFirst).extracting("processInstanceId").containsExactly(new Object[]{processInstanceIdTwo});
        Assertions.assertThat((List)excludedAll).extracting("processInstanceId").isEmpty();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testWithNonExistentProcessInstanceIdNotIn() {
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getProcessInstanceId();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getProcessInstanceId();
        String nonExistentProcessInstanceId = "ThisIsAFake";
        List processInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        List excludedNonExistent = this.historyService.createHistoricProcessInstanceQuery().processInstanceIdNotIn(new String[]{nonExistentProcessInstanceId}).list();
        Assertions.assertThat((List)processInstances).extracting("processInstanceId").containsExactlyInAnyOrder(new Object[]{processInstanceIdOne, processInstanceIdTwo});
        Assertions.assertThat((List)excludedNonExistent).extracting("processInstanceId").containsExactly(new Object[]{processInstanceIdOne, processInstanceIdTwo});
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryByOneInvalidProcessInstanceIdNotIn() {
        try {
            this.historyService.createHistoricProcessInstanceQuery().processInstanceIdNotIn(new String[]{null});
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testExcludingProcessInstanceAndProcessInstanceIdNotIn() {
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getProcessInstanceId();
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getProcessInstanceId();
        long count = this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceIdOne).processInstanceIdNotIn(new String[]{processInstanceIdOne}).count();
        Assertions.assertThat((long)count).isEqualTo(0L);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testExcludingProcessInstanceIdsAndProcessInstanceIdNotIn() {
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getProcessInstanceId();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getProcessInstanceId();
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getProcessInstanceId();
        long count = this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(new HashSet<String>(Arrays.asList(processInstanceIdOne, processInstanceIdTwo))).processInstanceIdNotIn(new String[]{processInstanceIdOne, processInstanceIdTwo}).count();
        Assertions.assertThat((long)count).isEqualTo(0L);
    }

    protected void deployment(String ... resources) {
        this.testHelper.deploy(resources);
    }

    protected void deployment(BpmnModelInstance ... modelInstances) {
        this.testHelper.deploy(modelInstances);
    }

    protected void executeJob(Job job) {
        while (job != null && job.getRetries() > 0) {
            try {
                this.managementService.executeJob(job.getId());
            }
            catch (Exception exception) {
                // empty catch block
            }
            job = (Job)this.managementService.createJobQuery().jobId(job.getId()).singleResult();
        }
    }

    protected void executeJobForProcessInstance(String processInstanceId) {
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstanceId).singleResult();
        this.managementService.executeJob(job.getId());
    }

    private void executeFailingJob(Job job) {
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

